/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.assembler;

import com.digiwin.athena.abt.application.dto.migration.abt.api.ActivityStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ErrorTableDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ImportStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.TableDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ActivityStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ErrorTable;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.Table;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class ImportStatisticsAssembler {
    private static final List<ImportStatisticsDTO> emptyImportStatisticsDTOList = Collections.emptyList();

    public static List<ImportStatisticsDTO> importStatisticsListToDTO(List<ImportStatistics> importStatisticsList) {
        if (CollectionUtils.isEmpty(importStatisticsList)) {
            return emptyImportStatisticsDTOList;
        }
        LinkedList<ImportStatisticsDTO> importStatisticsDTOList = new LinkedList<ImportStatisticsDTO>();
        importStatisticsList.forEach(item -> {
            ImportStatisticsDTO importStatisticsDTO = new ImportStatisticsDTO();
            BeanUtils.copyProperties((Object)item, (Object)importStatisticsDTO);
            importStatisticsDTOList.add(importStatisticsDTO);
        });
        return importStatisticsDTOList;
    }

    public static ErrorTableDTO errorTableToDTO(ErrorTable errorTable) {
        ErrorTableDTO errorTableDTO = new ErrorTableDTO();
        errorTableDTO.setData(errorTable.getData());
        errorTableDTO.setHeaders(errorTable.getHeaders());
        errorTableDTO.setErrorNum(errorTable.getErrorNum());
        errorTableDTO.setProcessingNum(errorTable.getProcessingNum());
        errorTableDTO.setSucceededNum(errorTable.getSucceededNum());
        errorTableDTO.setFailedNum(errorTable.getFailedNum());
        errorTableDTO.setActionId(errorTable.getActionId());
        errorTableDTO.setRepublished(errorTable.getRepublished());
        return errorTableDTO;
    }

    public static ImportStatisticsDTO toDTO(ImportStatistics importStatistics) {
        ImportStatisticsDTO importStatisticsDTO = new ImportStatisticsDTO();
        if (null == importStatistics) {
            return importStatisticsDTO;
        }
        BeanUtils.copyProperties((Object)importStatistics, (Object)importStatisticsDTO);
        return importStatisticsDTO;
    }

    public static Table tableToDO(TableDTO tableDTO) {
        Table table = new Table();
        if (null == tableDTO) {
            return table;
        }
        BeanUtils.copyProperties((Object)tableDTO, (Object)table);
        if (table.getHeaders() != null && !table.getHeaders().isEmpty()) {
            table.getHeaders().forEach(map -> {
                if (map.containsKey("headers")) {
                    map.put("key", ExcelUtil.getSheetNameInParens(map.get("key").toString()));
                }
            });
        }
        HashMap<Integer, String> rowDFieldMap = new HashMap<Integer, String>();
        if (table.getData() != null && !table.getData().isEmpty()) {
            for (int i = 0; i < table.getData().size(); ++i) {
                Map map2 = table.getData().get(i);
                for (String key : map2.keySet()) {
                    if (!(map2.get(key) instanceof List)) continue;
                    rowDFieldMap.put(i, key);
                }
            }
        }
        if (rowDFieldMap.size() > 0) {
            rowDFieldMap.forEach((rowIndex, DFieldName) -> {
                Object DFieldValue = table.getData().get((int)rowIndex).remove(DFieldName);
                table.getData().get((int)rowIndex).put(ExcelUtil.getSheetNameInParens(DFieldName), DFieldValue);
            });
        }
        return table;
    }

    public static ActivityStatisticsDTO activityStatisticsToDTO(ActivityStatistics activityStatistics) {
        return (ActivityStatisticsDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)activityStatistics), ActivityStatisticsDTO.class);
    }
}

