/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.bk;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.bk.ActivityBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.bk.ProjectBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmDataConsistencyMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmBackLogMsgDto;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmTaskTimelyMsgDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogRecordDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.ActivityBusinessKeyHandler;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.ProjectBusinessKeyHandler;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqManageMsgService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.ActivityUtils;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessKeyMqService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessKeyMqService.class);
    @Autowired
    private PtmService ptmService;
    @Autowired
    private ProjectBusinessKeyHandler projectBusinessKeyHandler;
    @Autowired
    private ActivityBusinessKeyHandler activityBusinessKeyHandler;
    @Autowired
    private PtmTransformService ptmTransformService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private MqManageMsgService mqManageMsgService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    public void processBkMessage(String data, AuthoredUser user) {
        log.info("BusinessKeyMqService.processBkMessage:{}", (Object)data);
        PtmDataConsistencyMessageDTO messageDTO = ActivityUtils.convertPtmDataConsistencyMsg(data);
        PtmDataConsistencyMessageDTO.MqData mqData = messageDTO.getData();
        PtmDataConsistencyMessageDTO.Project project = mqData.getProject();
        if (project != null) {
            this.processProject(project, user);
        } else {
            List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = mqData.getWorkItem();
            if (CollectionUtils.isNotEmpty(workItemList)) {
                AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
                HashMap backLogToWorkItem = Maps.newHashMap();
                for (PtmDataConsistencyMessageDTO.WorkItem workItem : workItemList) {
                    AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
                    this.processWorkItem(workItem, user);
                    List workItems = backLogToWorkItem.computeIfAbsent(workItem.getBacklogId(), e -> new ArrayList());
                    workItems.add(workItem);
                }
                AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
                try {
                    backLogToWorkItem.forEach((k, v) -> {
                        PtmDataConsistencyMessageDTO.WorkItem workItem = (PtmDataConsistencyMessageDTO.WorkItem)v.get(0);
                        String isSend = this.sendBackLogRemindMsg(messageDTO, (PtmDataConsistencyMessageDTO.WorkItem)v.get(0), user);
                        if ("1".equals(isSend)) {
                            log.info("\u53d1\u9001\u50ac\u529e\u6d88\u606f\uff0c\u4ee3\u529eid:{},\u4e8b\u9879id:{}", (Object)workItem.getBacklogId(), (Object)workItem.getId());
                            this.sendTaskTimelyRemindMsg(messageDTO, workItem, user);
                        }
                    });
                }
                catch (Exception ex) {
                    log.warn("\u53d1\u9001\u5f31\u63d0\u9192\u5931\u8d25:{}", (Object)ex.getMessage(), (Object)ex);
                }
                AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            }
        }
    }

    private String sendBackLogRemindMsg(PtmDataConsistencyMessageDTO messageDTO, PtmDataConsistencyMessageDTO.WorkItem workItem, AuthoredUser user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)workItem.getTaskId());
        boolean canCreateTaskTeam = this.ptmBacklogMapper.selectCount((Wrapper)queryWrapper) <= 1L;
        PtmBacklogRecordDTO backlogRecord = this.ptmService.getBacklogRecord(workItem.getBacklogId());
        log.info("\u67e5\u8be2backlogRecord\u7ed3\u679c\uff1a{}", (Object)backlogRecord);
        PtmBacklogMessageDTO.Backlog backlog = new PtmBacklogMessageDTO.Backlog();
        backlog.setBacklogId(workItem.getBacklogId());
        backlog.setProjectId(workItem.getProjectId());
        backlog.setProjectCardId(workItem.getProjectCardId());
        backlog.setTaskId(workItem.getTaskId());
        backlog.setName(backlogRecord.getName());
        backlog.setPerformerId(backlogRecord.getPerformerId());
        backlog.setPerformerName(backlogRecord.getPerformerName());
        PtmBackLogMsgDto ptmBackLogMsgDto = PtmBackLogMsgDto.builder().authoredUser(user).operation(messageDTO.getOperation()).backlog(backlog).canCreateTaskTeam(canCreateTaskTeam).minSplit(BooleanUtils.isTrue((Boolean)backlogRecord.getCreatedFlag())).messageType("1").workItemId(workItem.getId()).build();
        if (backlogRecord.getHidden().booleanValue() || !backlogRecord.getWorkItemId().equals(workItem.getId())) {
            ptmBackLogMsgDto.setMessageType("2");
            return "2";
        }
        this.mqManageMsgService.excutesendBackLogRemindMsg(ptmBackLogMsgDto);
        return "1";
    }

    private void sendTaskTimelyRemindMsg(PtmDataConsistencyMessageDTO messageDTO, PtmDataConsistencyMessageDTO.WorkItem workItem, AuthoredUser user) {
        Task task = this.ptmTransformService.translateProjectOrProjectCard(workItem.getProjectId());
        Backlog backlog = this.commonPtmTransformService.translateBacklogById(workItem.getBacklogId());
        log.info("\u3010dataConsistencyMessage-timely-remind\u3011\uff1atask\uff1a{}\uff0cbacklog\uff1a{}", (Object)task, (Object)backlog);
        PtmTaskTimelyMsgDto ptmTaskTimelyMsgDto = new PtmTaskTimelyMsgDto();
        ptmTaskTimelyMsgDto.setTask(task);
        ptmTaskTimelyMsgDto.setBacklog(backlog);
        ptmTaskTimelyMsgDto.setOperation(messageDTO.getOperation());
        ptmTaskTimelyMsgDto.setAuthoredUser(user);
        this.mqManageMsgService.excuteSendTaskTimelyRemindMsg(ptmTaskTimelyMsgDto);
    }

    public void processProject(PtmDataConsistencyMessageDTO.Project project, AuthoredUser user) {
        PtmProjectRecordBO ptmProjectRecordBO = this.ptmService.getProjectRecord(project.getId());
        ProjectBusinessKeyDTO projectBusinessKeyDTO = new ProjectBusinessKeyDTO();
        projectBusinessKeyDTO.setId(project.getId());
        projectBusinessKeyDTO.setTenantId(ptmProjectRecordBO.getTenantId());
        projectBusinessKeyDTO.setTmTaskId(ptmProjectRecordBO.getProjectDefCode());
        projectBusinessKeyDTO.setState(ptmProjectRecordBO.getState());
        projectBusinessKeyDTO.setSourceIds(ptmProjectRecordBO.getSourceIds());
        projectBusinessKeyDTO.setBusinessUnit(JSONObject.fromObject((Object)ptmProjectRecordBO.getBusinessUnit()));
        projectBusinessKeyDTO.setData(JSONObject.fromObject((Object)ptmProjectRecordBO.getData()));
        projectBusinessKeyDTO.setAuthoredUser(user);
        this.projectBusinessKeyHandler.process(projectBusinessKeyDTO);
    }

    private void processWorkItem(PtmDataConsistencyMessageDTO.WorkItem workItem, AuthoredUser user) {
        PtmTaskRecordBO ptmTaskRecordBO = this.ptmService.getTaskRecord(workItem.getTaskId(), workItem.getId());
        PtmActivityRecordDTO ptmActivityRecordDTO = this.ptmService.getActivityRecord(workItem.getActivityId());
        PtmProjectRecordBO ptmProjectRecordBO = this.ptmService.getProjectRecord(workItem.getProjectId());
        ActivityBusinessKeyDTO activityBusinessKeyDTO = new ActivityBusinessKeyDTO();
        activityBusinessKeyDTO.setSubTaskId(ptmProjectRecordBO.getId());
        activityBusinessKeyDTO.setTenantId(ptmProjectRecordBO.getTenantId());
        activityBusinessKeyDTO.setTmTaskId(ptmProjectRecordBO.getProjectDefCode());
        activityBusinessKeyDTO.setState(ptmActivityRecordDTO.getState());
        activityBusinessKeyDTO.setActivityId(workItem.getActivityId());
        activityBusinessKeyDTO.setBusinessUnit(JSONObject.fromObject((Object)ptmTaskRecordBO.getBusinessUnit()));
        activityBusinessKeyDTO.setData(JSONObject.fromObject((Object)ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setTmActivityId(ptmTaskRecordBO.getTaskDefCode());
        activityBusinessKeyDTO.setBpmData(JSONObject.fromObject((Object)ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setWorkitemId(workItem.getId());
        activityBusinessKeyDTO.setClosed(ptmActivityRecordDTO.getState() >= 3);
        activityBusinessKeyDTO.setAuthoredUser(user);
        this.activityBusinessKeyHandler.process(activityBusinessKeyDTO);
    }

    public void processFlowProjectBk(String data, AuthoredUser user) {
        ProjectBusinessKeyDTO projectBusinessKeyDTO = (ProjectBusinessKeyDTO)JsonUtils.jsonToObject((String)data, ProjectBusinessKeyDTO.class);
        projectBusinessKeyDTO.setAuthoredUser(user);
        this.projectBusinessKeyHandler.process(projectBusinessKeyDTO);
    }

    public void processFlowBacklogBk(String data, AuthoredUser user) {
        ActivityBusinessKeyDTO activityBusinessKeyDTO = (ActivityBusinessKeyDTO)JsonUtils.jsonToObject((String)data, ActivityBusinessKeyDTO.class);
        activityBusinessKeyDTO.setAuthoredUser(user);
        this.activityBusinessKeyHandler.process(activityBusinessKeyDTO);
    }
}

