/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.bk;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.bk.BusinessKeyMqService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

@Service
public class EventBkMessageModel
extends EventBaseService
implements EventInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBkMessageModel.class);
    @Autowired
    private BusinessKeyMqService businessKeyMqService;

    @Override
    public String modelType() {
        return "businessKeyModel";
    }

    @Override
    public void distributeMessages(String data) {
        this.rabbitTemplate.convertAndSend("athena.event.message", "athena.event.business.key", (Object)data);
    }

    @Override
    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.business.key", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.business.key"})}, concurrency="#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('athena.event.business.key')}")
    @RabbitRetry(beforeHandler="ptmMqBeforeHandler", successHander="ptmMqSuccessHandler", failureHandler="ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="retry-count", required=false) Integer retryCount) {
        super.receiveOrder(data, "athena.event.business.key", channel, tag, retryCount);
    }

    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        AuthoredUser user = super.getUser(mqMessageDTO);
        if (EventMqTypeEnum.dataConsistency.equals((Object)mqMessageDTO.getType())) {
            this.businessKeyMqService.processBkMessage(data, user);
        } else if (EventMqTypeEnum.flowProject.equals((Object)mqMessageDTO.getType())) {
            this.businessKeyMqService.processFlowProjectBk(data, user);
        } else if (EventMqTypeEnum.flowWorkItem.equals((Object)mqMessageDTO.getType())) {
            this.businessKeyMqService.processFlowBacklogBk(data, user);
        }
    }
}

