/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.bk;

import com.digiwin.athena.abt.application.dto.migration.abt.bk.ActivityBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.excel.CsvFile;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmDataConsistencyMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.mongodb.MongodbService;
import com.digiwin.athena.abt.application.service.abt.migration.bk.BusinessKeyMqService;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.ActivityBusinessKeyHandler;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.CsvUtils;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RefreshBkService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshBkService.class);
    @Autowired
    private MongodbService mongodbService;
    @Autowired
    private BusinessKeyMqService businessKeyMqService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private ActivityBusinessKeyHandler activityBusinessKeyHandler;

    public List<Long> refreshProjectBk(List<Long> projectIdList, String tenantId, AuthoredUser user) {
        if (CollectionUtils.isEmpty(projectIdList) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tenantId)) {
            throw BusinessException.create((String)"projectIdList\u6216tenantId\u4e3a\u7a7a\uff01");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"task").and("cardId").in(projectIdList));
        List<Map> existBkList = this.mongodbService.query(tenantId, query);
        ArrayList<Long> lackProjectIds = new ArrayList();
        if (CollectionUtils.isNotEmpty(existBkList)) {
            List existProjectIdList = existBkList.stream().map(x -> Long.valueOf(String.valueOf(x.get("cardId")))).collect(Collectors.toList());
            lackProjectIds = projectIdList.stream().filter(x -> !existProjectIdList.contains(x)).collect(Collectors.toList());
        } else {
            lackProjectIds = projectIdList;
        }
        log.info("lackProjectIds:{}", (Object)JsonUtils.objectToString(lackProjectIds));
        if (CollectionUtils.isEmpty(lackProjectIds)) {
            return lackProjectIds;
        }
        for (Long projectId : lackProjectIds) {
            PtmDataConsistencyMessageDTO.Project project = PtmDataConsistencyMessageDTO.Project.builder().id(projectId).build();
            this.businessKeyMqService.processProject(project, user);
        }
        return lackProjectIds;
    }

    public List<Long> refreshTaskBk(List<PtmDataConsistencyMessageDTO.WorkItem> workItemList, String tenantId, AuthoredUser user) {
        if (CollectionUtils.isEmpty(workItemList) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tenantId)) {
            throw BusinessException.create((String)"workItemList\u6216tenantId\u4e3a\u7a7a\uff01");
        }
        List<Long> workitemIdList = workItemList.stream().map(PtmDataConsistencyMessageDTO.WorkItem::getId).distinct().collect(Collectors.toList());
        Map workItemRel = workItemList.stream().collect(Collectors.toMap(PtmDataConsistencyMessageDTO.WorkItem::getId, Function.identity()));
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").in(workitemIdList));
        List<Map> existBkList = this.mongodbService.query(tenantId, query);
        List<Object> lackworkItemIds = new ArrayList();
        if (CollectionUtils.isNotEmpty(existBkList)) {
            List existWorkItemList = existBkList.stream().map(x -> Long.valueOf(String.valueOf(x.get("cardId")))).collect(Collectors.toList());
            lackworkItemIds = workitemIdList.stream().filter(x -> !existWorkItemList.contains(x)).collect(Collectors.toList());
        } else {
            lackworkItemIds = workitemIdList;
        }
        log.info("lackworkItemIds:{}", (Object)JsonUtils.objectToString(lackworkItemIds));
        if (CollectionUtils.isEmpty(lackworkItemIds)) {
            return lackworkItemIds;
        }
        log.info("[repairTaskBk start  tenant_id = {}, lackworkItemIds = {}] ", (Object)tenantId, lackworkItemIds);
        for (Long workitemId : lackworkItemIds) {
            this.processWorkItem((PtmDataConsistencyMessageDTO.WorkItem)workItemRel.get(workitemId), user);
        }
        return workitemIdList;
    }

    public void processWorkItem(PtmDataConsistencyMessageDTO.WorkItem workItem, AuthoredUser user) {
        PtmTaskRecordBO ptmTaskRecordBO = this.ptmService.getTaskRecord(workItem.getTaskId(), workItem.getId());
        PtmActivityRecordDTO ptmActivityRecordDTO = this.ptmService.getActivityRecord(workItem.getActivityId());
        PtmProjectRecordBO ptmProjectRecordBO = this.ptmService.getProjectRecord(workItem.getProjectId());
        ActivityBusinessKeyDTO activityBusinessKeyDTO = new ActivityBusinessKeyDTO();
        activityBusinessKeyDTO.setSubTaskId(ptmProjectRecordBO.getId());
        activityBusinessKeyDTO.setTenantId(ptmProjectRecordBO.getTenantId());
        activityBusinessKeyDTO.setTmTaskId(ptmProjectRecordBO.getProjectDefCode());
        activityBusinessKeyDTO.setState(ptmActivityRecordDTO.getState());
        activityBusinessKeyDTO.setActivityId(workItem.getActivityId());
        activityBusinessKeyDTO.setBusinessUnit(JSONObject.fromObject((Object)ptmTaskRecordBO.getBusinessUnit()));
        activityBusinessKeyDTO.setData(JSONObject.fromObject((Object)ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setTmActivityId(ptmTaskRecordBO.getTaskDefCode());
        activityBusinessKeyDTO.setBpmData(JSONObject.fromObject((Object)ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setWorkitemId(workItem.getId());
        activityBusinessKeyDTO.setClosed(false);
        activityBusinessKeyDTO.setAuthoredUser(user);
        this.activityBusinessKeyHandler.processEventForRepair(activityBusinessKeyDTO);
    }

    public void upload(MultipartFile file, AuthoredUser user) {
        if (null == file || file.isEmpty() || StringUtils.isEmpty((String)file.getOriginalFilename())) {
            throw BusinessException.create((String)"500", (String)MessageUtil.getMessage("delivery.fileEmpty", new Object[0]));
        }
        List<CsvFile> csvData = CsvUtils.getCsvDataMethod1(file);
        if (CollectionUtils.isEmpty(csvData)) {
            return;
        }
        Map<String, List<CsvFile>> csvDataRel = csvData.stream().collect(Collectors.groupingBy(CsvFile::getTenantId));
        csvDataRel.remove("tenant_id");
        for (Map.Entry<String, List<CsvFile>> entry : csvDataRel.entrySet()) {
            this.processMap(entry.getKey(), entry.getValue(), user);
        }
    }

    public void processMap(String tenantId, List<CsvFile> csvFiles, AuthoredUser user) {
        ArrayList<PtmDataConsistencyMessageDTO.WorkItem> workItemList = new ArrayList<PtmDataConsistencyMessageDTO.WorkItem>();
        for (CsvFile csvFile : csvFiles) {
            PtmDataConsistencyMessageDTO.WorkItem workItem = PtmDataConsistencyMessageDTO.WorkItem.builder().id(Long.valueOf(csvFile.getWorkItemId())).taskId(Long.valueOf(csvFile.getTaskId())).activityId(Long.valueOf(csvFile.getActivityId())).projectId(Long.valueOf(csvFile.getProjectId())).build();
            workItemList.add(workItem);
        }
        this.refreshTaskBk(workItemList, tenantId, user);
    }

    public List<Long> checkProjectBKExist(List<Long> projectIds, String tenantId, AuthoredUser user) {
        if (CollectionUtils.isEmpty(projectIds) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tenantId)) {
            throw BusinessException.create((String)"projectIds\u6216tenantId\u4e3a\u7a7a\uff01");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"task").and("cardId").in(projectIds));
        List<Map> existBkList = this.mongodbService.query(tenantId, query);
        List<Long> lackProjectIds = null;
        if (CollectionUtils.isNotEmpty(existBkList)) {
            List existProjectIdList = existBkList.stream().map(x -> Long.valueOf(String.valueOf(x.get("cardId")))).collect(Collectors.toList());
            lackProjectIds = projectIds.stream().filter(x -> !existProjectIdList.contains(x)).collect(Collectors.toList());
        } else {
            lackProjectIds = projectIds;
        }
        return lackProjectIds;
    }

    public List<Map> queryBkByWorkItemId(String tenantId, List<Long> workItemIdList, AuthoredUser user) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").in(workItemIdList));
        List<Map> existBkList = this.mongodbService.query(tenantId, query);
        return existBkList;
    }

    public List<Long> checkNeedRepair(String tenantId, List<Long> workItemIdList, AuthoredUser user) {
        ArrayList<Long> workItemIds = new ArrayList<Long>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tenantId) || CollectionUtils.isEmpty(workItemIdList)) {
            return workItemIds;
        }
        for (Long workItemId : workItemIdList) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").is((Object)workItemId));
            List<Map> bkMap = this.mongodbService.query(tenantId, query);
            if (!CollectionUtils.isEmpty(bkMap)) continue;
            workItemIds.add(workItemId);
        }
        return workItemIds;
    }
}

