/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.esp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ActionInfoDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspBody;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ChainInfoUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.exception.MDCInvocationException;
import com.digiwin.athena.esp.sdk.exception.ProductUIDNotFoundException;
import com.digiwin.athena.esp.sdk.exception.TargetInvocationException;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EspServiceImpl
implements EspService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EspServiceImpl.class);
    @Autowired
    private MetaDataService metaDataService;

    @Override
    public EspResponse sendByBatch(DataEntryTask dataEntryTask, GetActionLocaleResponseDTO metaData, List<Map> convertedTable, String productName) {
        String activityId;
        DWSecurityToken dwSecurityToken;
        String targetFieldName = Optional.ofNullable(dataEntryTask.getActionInfo()).map(ActionInfoDTO::getTargetField).orElse("");
        String tableKey = this.metaDataService.getMainRequestMetadataField(metaData.getRequest(), targetFieldName).getData_name();
        log.info("produceName: {}, tableKey: {}", (Object)productName, (Object)tableKey);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(1);
        requestMap.put(tableKey, convertedTable);
        if (null != dataEntryTask.getActionInfo() && !CollectionUtils.isEmpty(dataEntryTask.getActionInfo().getActionParas())) {
            requestMap.putAll(dataEntryTask.getActionInfo().getActionParas());
        }
        String dataJson = JSON.toJSONString(requestMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        String body = "{\"std_data\":{\"parameter\":" + dataJson + "}}";
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage(dataEntryTask.getLocale());
        requestModel.setTenantId(dataEntryTask.getTenantId());
        requestModel.setServiceProd(productName);
        String actionId = dataEntryTask.getActionId();
        requestModel.setServiceName(actionId.substring(actionId.contains("esp_") ? 4 : 0));
        requestModel.setBodyJsonString(body);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)dataEntryTask.getUserToken());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)dataEntryTask.getUserToken());
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0071.getErrCode(), (String)"\u89e3\u6790token\u5931\u8d25", (Throwable)e);
        }
        headerMap.put("token", dwSecurityToken.getContext().getUserToken());
        headerMap.put("security-token", dataEntryTask.getUserToken());
        headerMap.put("locale", dataEntryTask.getLocale());
        this.addChainInfoToHeader(headerMap);
        requestModel.setHeaderMap(headerMap);
        HashMap<String, String> dataKeyMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)dataEntryTask.getApplication())) {
            dataKeyMap.put("appCode", dataEntryTask.getApplication());
        }
        if ("0".equals(dataEntryTask.getType()) && StringUtils.isNotBlank((String)(activityId = dataEntryTask.getActivityId()))) {
            dataKeyMap.put("taskType", "DATA_ENTRY");
            dataKeyMap.put("taskCode", activityId);
        }
        if (MapUtils.isNotEmpty(dataKeyMap)) {
            requestModel.setDatakeyMap(dataKeyMap);
        }
        try {
            ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            String response = responseModel.getBodyJsonString();
            EspBody espBody = (EspBody)JsonUtils.jsonToObject((String)response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if ("0".equals(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                return espResponse;
            }
            this.throwEspError(requestModel.getServiceName(), responseModel, requestModel);
            espResponse.setData(espBody);
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        catch (InvocationException | MDCInvocationException | ProductUIDNotFoundException | TargetInvocationException | TenantInfoNotFoundException e) {
            log.error("error request esp", e);
        }
        catch (Exception e) {
            log.error("error request esp", (Throwable)e);
            EspResponse espResponse = new EspResponse();
            espResponse.setData(null);
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        return null;
    }

    @Override
    public EspResponse getBaseData(Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String userToken) {
        String taskCode;
        String body = "{\"std_data\":{\"parameter\":" + JsonUtils.objectToString(requestParam) + "}}";
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage(exportFileMsg.getLocale());
        requestModel.setTenantId(exportFileMsg.getTenantId());
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(exportFileMsg.getActionId().substring(exportFileMsg.getActionId().contains("esp_") ? 4 : 0));
        requestModel.setBodyJsonString(body);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)userToken)) {
            headerMap.put("token", exportFileMsg.getUserToken());
        } else {
            headerMap.put("security-token", exportFileMsg.getUserToken());
            headerMap.put("token", userToken);
        }
        headerMap.put("locale", exportFileMsg.getLocale());
        this.addChainInfoToHeader(headerMap);
        requestModel.setHeaderMap(headerMap);
        HashMap<String, String> dataKeyMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)exportFileMsg.getApplication())) {
            dataKeyMap.put("appCode", exportFileMsg.getApplication());
        }
        if ("0".equals(exportFileMsg.getType()) && StringUtils.isNotBlank((String)(taskCode = (String)Optional.ofNullable(exportFileMsg.getDownloadBaseDataParamDTO()).map(DownloadBaseDataParamDTO::getActionInfo).map(ActionInfoDTO::getCode).orElse(null)))) {
            dataKeyMap.put("taskType", "DATA_ENTRY");
            dataKeyMap.put("taskCode", taskCode);
        }
        if (MapUtils.isNotEmpty(dataKeyMap)) {
            requestModel.setDatakeyMap(dataKeyMap);
        }
        try {
            ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            String response = responseModel.getBodyJsonString();
            EspBody espBody = (EspBody)JsonUtils.jsonToObject((String)response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if ("0".equals(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            }
            espResponse.setData(espBody);
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        catch (MDCInvocationException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (ProductUIDNotFoundException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (InvocationException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (TargetInvocationException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (TenantInfoNotFoundException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (Exception e) {
            log.error("error request esp", (Throwable)e);
            EspResponse espResponse = new EspResponse();
            espResponse.setData(null);
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        return null;
    }

    private void addChainInfoToHeader(Map<String, String> headers) {
        try {
            if (!headers.containsKey("digi-dap-service-chain-info")) {
                headers.put("digi-dap-service-chain-info", ChainInfoUtil.genInvokeChainInfo((String)MDC.get((String)"digi-dap-service-chain-info")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void throwEspError(String serviceId, ResponseModel responseModel, RequestModel requestModel) {
        try {
            String serviceProd = requestModel.getServiceProd();
            String apiIdentifier = String.format("\u8c03\u7528%s\u5e94\u7528\uff0capi:%s", serviceProd, serviceId);
            if (this.isEspError(responseModel)) {
                log.error("{}\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f: {}", (Object)apiIdentifier, (Object)responseModel.getEspMessage());
                return;
            }
            String bodyJson = responseModel.getBodyJsonString();
            if (StringUtils.isEmpty((String)bodyJson)) {
                log.error("{}\u5f02\u5e38\uff0c\u8fd4\u56de\u7a7a", (Object)apiIdentifier);
                return;
            }
            Map<String, Object> espResponse = this.parseAndCheckError(apiIdentifier, bodyJson);
            if (espResponse == null) {
                return;
            }
            Map<String, Object> stdDataMap = this.getAndCheckStdData(apiIdentifier, espResponse, bodyJson);
            if (stdDataMap == null) {
                return;
            }
            Map<String, Object> execution = this.getAndCheckExecution(apiIdentifier, stdDataMap, bodyJson);
            if (execution == null) {
                return;
            }
            if (!"000".equals(responseModel.getSrvCode())) {
                String description = String.valueOf(execution.getOrDefault("description", ""));
                log.error("\u4e1a\u52a1\u5f02\u5e38: {}", (Object)description);
                log.error("{}\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c: {}", (Object)apiIdentifier, (Object)bodyJson);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8c03\u7528esp\u5f02\u5e38\u62a5\u9519", (Throwable)e);
        }
    }

    private boolean isEspError(ResponseModel responseModel) {
        return responseModel.getEspCode() != null && !responseModel.getEspCode().startsWith("0");
    }

    private Map<String, Object> parseAndCheckError(String apiIdentifier, String bodyJson) {
        try {
            Map espResponse = (Map)JsonUtils.jsonToObject((String)bodyJson, HashMap.class);
            if (espResponse.containsKey("error")) {
                log.error("{}\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f: {}", (Object)apiIdentifier, espResponse.get("error"));
                return null;
            }
            return espResponse;
        }
        catch (Exception e) {
            log.error("{}\u5f02\u5e38\uff0cJSON\u89e3\u6790\u5931\u8d25: {}", new Object[]{apiIdentifier, bodyJson, e});
            return null;
        }
    }

    private Map<String, Object> getAndCheckStdData(String apiIdentifier, Map<String, Object> espResponse, String bodyJson) {
        Map stdDataMap = this.safeCast(espResponse.get("std_data"), Map.class);
        if (stdDataMap == null) {
            log.error("{}\u5f02\u5e38\uff0c\u7ed3\u679c\u7f3a\u5931std_data\uff0c\u8fd4\u56de\u7ed3\u679c: {}", (Object)apiIdentifier, (Object)bodyJson);
            return null;
        }
        return stdDataMap;
    }

    private Map<String, Object> getAndCheckExecution(String apiIdentifier, Map<String, Object> stdDataMap, String bodyJson) {
        Map execution = this.safeCast(stdDataMap.get("execution"), Map.class);
        if (execution == null) {
            log.error("{}\u5f02\u5e38\uff0c\u7ed3\u679c\u7f3a\u5931execution\uff0c\u8fd4\u56de\u7ed3\u679c: {}", (Object)apiIdentifier, (Object)bodyJson);
            return null;
        }
        return execution;
    }

    private <T> T safeCast(Object obj, Class<T> clazz) {
        return clazz.isInstance(obj) ? (T)clazz.cast(obj) : null;
    }
}

