/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

@Service
public class EventBaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBaseService.class);
    @Autowired
    protected RabbitTemplate rabbitTemplate;
    @Autowired
    protected EnvProperties envProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveOrder(String data, String queueName, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="retry-count", required=false) Integer retryCount) {
        log.info("[athena.event.message.abt-data]: queueName = {} , processMessage data = {}", (Object)queueName, (Object)data);
        try {
            if ("TRADITIONAL_CHINESE".equals(this.envProperties.getDefaultLanguage())) {
                LocaleContextHolder.setLocale((Locale)Locale.TRADITIONAL_CHINESE);
            } else {
                LocaleContextHolder.setLocale((Locale)Locale.SIMPLIFIED_CHINESE);
            }
            EventListenerDTO eventListenerDTO = (EventListenerDTO)JsonUtils.jsonToObject((String)data, EventListenerDTO.class);
            this.getUser(eventListenerDTO);
            this.processMessage(data, eventListenerDTO);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    public void processMessage(String data, EventListenerDTO eventListenerDTO) {
    }

    public AuthoredUser getUser(EventListenerDTO mqMessageDTO) {
        if (null == mqMessageDTO.getUser() && null == mqMessageDTO.getFlowUser()) {
            return null;
        }
        AuthoredUser user = new AuthoredUser();
        if (null != mqMessageDTO.getUser()) {
            user.setSid(mqMessageDTO.getUser().getUserSid().longValue());
            user.setUserId(mqMessageDTO.getUser().getUserId());
            user.setUserName(mqMessageDTO.getUser().getUserName());
            user.setTenantSid(mqMessageDTO.getUser().getTenantSid().longValue());
            user.setTenantId(mqMessageDTO.getUser().getTenantId());
            user.setTenantName(mqMessageDTO.getUser().getTenantName());
            user.setToken(mqMessageDTO.getUser().getToken());
        } else {
            user = mqMessageDTO.getFlowUser();
        }
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        return user;
    }
}

