/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventModelService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventListenerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventListenerService.class);
    @Autowired
    private EventModelService eventModelService;

    public void processMsg(String data, EventListenerDTO eventListenerDTO) {
        ArrayList<String> eventModelTypeList = new ArrayList<String>();
        switch (eventListenerDTO.getType()) {
            case backlog: {
                if (PtmMqOperation.OVERDUE.equals((Object)eventListenerDTO.getOperation())) {
                    eventModelTypeList.add("taskOperateSendMsgModel");
                }
            }
            case projectCard: {
                eventModelTypeList.add("cardMqttModel");
            }
            case flowProjectCard: {
                eventModelTypeList.add("groupTeamModel");
                if (!PtmMqOperation.ADD.equals((Object)eventListenerDTO.getOperation())) break;
                eventModelTypeList.add("businessMessageModel");
                break;
            }
            case dataConsistency: {
                if (PtmMqOperation.ADD.equals((Object)eventListenerDTO.getOperation())) {
                    eventModelTypeList.add("taskOperateSendMsgModel");
                }
            }
            case flowWorkItem: {
                eventModelTypeList.add("businessKeyModel");
                if (!PtmMqOperation.ADD.equals((Object)eventListenerDTO.getOperation())) break;
                eventModelTypeList.add("businessMessageModel");
                break;
            }
            case task: 
            case project: 
            case flowBacklog: {
                eventModelTypeList.add("groupTeamModel");
                break;
            }
            case flowProject: {
                eventModelTypeList.add("businessKeyModel");
                eventModelTypeList.add("groupTeamModel");
                break;
            }
        }
        log.info("[athena.event.message.abt-data]: processMessage eventModelTypeList = {}", (Object)JsonUtils.objectToString(eventModelTypeList));
        for (String eventModelType : eventModelTypeList) {
            this.eventModelService.getTargetModel(eventModelType).distributeMessages(data);
        }
    }
}

