/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event;

import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class EventModelService
implements ApplicationContextAware {
    private Map<String, EventInterface> modelMap = new ConcurrentHashMap<String, EventInterface>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map tempMap = applicationContext.getBeansOfType(EventInterface.class);
        tempMap.values().forEach(source -> this.modelMap.put(source.modelType(), (EventInterface)source));
    }

    public EventInterface getTargetModel(String modelType) {
        return Optional.ofNullable(this.modelMap.get(modelType)).orElseThrow(() -> new IllegalArgumentException("Event model acquisition failed"));
    }
}

