/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event;

import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ImportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.MessageFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.PersonalCenterMessage;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventPublisher.class);
    @Resource
    RestTemplate amiRestTemplate;
    @Autowired
    AimService aimService;
    @Value(value="${aim.uri}")
    private String aimUrl;
    @Value(value="${athena.auth.appToken}")
    private String appToken;
    private final String aimSendUrl = "/api/aim/v1/message";

    public void publish(ImportSuccessEvent event) {
        try {
            this.pushToMessageCenter(event);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u4e2a\u4eba\u4e2d\u5fc3\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
        try {
            MessageDO messageDO = (MessageDO)JsonUtils.jsonToObject((String)event.getUserJson(), MessageDO.class);
            messageDO.setContent(event);
            messageDO.setCategory("ATHENA_REMIND");
            messageDO.setSendDate(LocalDateTime.now());
            messageDO.setGid(event.getId());
            messageDO.setType("baseDataEntry");
            messageDO.setSubType("Import");
            String token = this.getSecurityToken(event.getUserToken());
            this.aimService.sendMessageToClient(token, messageDO.getTenantId(), Arrays.asList(messageDO.getUserId()), messageDO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u63a8\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void publish(ExportSuccessEvent event) {
        try {
            MessageDO messageDO = (MessageDO)JsonUtils.jsonToObject((String)event.getUserJson(), MessageDO.class);
            messageDO.setContent(event);
            messageDO.setCategory("ATHENA_REMIND");
            messageDO.setSendDate(LocalDateTime.now());
            messageDO.setGid(event.getId());
            messageDO.setType("baseDataEntry");
            messageDO.setSubType("Export");
            String token = this.getSecurityToken(event.getUserToken());
            this.aimService.sendMessageToClient(token, messageDO.getTenantId(), Arrays.asList(messageDO.getUserId()), messageDO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u63a8\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private void pushToMessageCenter(ImportSuccessEvent event) {
        DWSecurityToken dwSecurityToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)event.getUserToken());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)event.getUserToken());
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0072.getErrCode(), (String)"\u89e3\u6790token\u5931\u8d25", (Throwable)e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
        headers.add("digi-middleware-auth-user", dwSecurityContext.getUserToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        PersonalCenterMessage webSocketMessage = MessageFactory.producePcMsgByImportSuccessEvent(event);
        HttpEntity httpEntity = new HttpEntity((Object)webSocketMessage, (MultiValueMap)headers);
        String url = this.aimUrl + "/api/aim/v1/message";
        ResponseEntity responseEntity = this.amiRestTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            String code;
            HashMap result = (HashMap)responseEntity.getBody();
            if (result.get("status") != null && !"200".equals(code = result.get("status").toString())) {
                log.error("\u53d1\u9001\u6d88\u606f\u63a8\u9001\u5931\u8d25");
            }
        } else {
            log.error("\u53d1\u9001\u6d88\u606f\u63a8\u9001\u5931\u8d25");
        }
    }

    private String getSecurityToken(String token) throws Exception {
        try {
            DWSecurityToken dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)token);
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
            return dwSecurityContext.getUserToken();
        }
        catch (Exception e) {
            log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)token);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0072.getErrCode(), (String)"\u89e3\u6790token\u5931\u8d25", (Throwable)e);
        }
    }

    private void pushToMessageCenter(ExportSuccessEvent event) {
        DWSecurityToken dwSecurityToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)event.getUserToken());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)event.getUserToken());
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0072.getErrCode(), (String)"\u89e3\u6790token\u5931\u8d25", (Throwable)e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
        headers.add("digi-middleware-auth-user", dwSecurityContext.getUserToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        PersonalCenterMessage webSocketMessage = MessageFactory.producePcMsgByExportSuccessEvent(event);
        HttpEntity httpEntity = new HttpEntity((Object)webSocketMessage, (MultiValueMap)headers);
        String url = this.aimUrl + "/api/aim/v1/message";
        ResponseEntity responseEntity = this.amiRestTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            String code;
            HashMap result = (HashMap)responseEntity.getBody();
            if (result.get("status") != null && !"200".equals(code = result.get("status").toString())) {
                log.error("\u53d1\u9001\u6d88\u606f\u63a8\u9001\u5931\u8d25");
            }
        } else {
            log.error("\u53d1\u9001\u6d88\u606f\u63a8\u9001\u5931\u8d25");
        }
    }
}

