/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.bk.ActivityBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.TaskEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.ActivityUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.DataUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BkTaskActivityService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IParser;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityBusinessKeyHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActivityBusinessKeyHandler.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessKeyService businessKeySercvice;
    @Autowired
    private IParser iParser;
    @Autowired
    private BkTaskActivityService bkTaskActivityService;
    private final String TASK_QUEUE = "DC_TASK_QUEUE";
    private final String TASK_EXCHANGE = "DC_TASK_EXCHANGE";
    private final String TASK_ROUTER_KEY = "DC_TASK_ROUTER_KEY";

    public void process(ActivityBusinessKeyDTO event) {
        try {
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(ActivityBusinessKeyDTO businessKeyDTO) {
        AuthoredUser authoredUser = businessKeyDTO.getAuthoredUser();
        if (null != authoredUser) {
            AppAuthContext appAuthContext = new AppAuthContext();
            appAuthContext.setAuthoredUser(authoredUser);
            AppAuthContextHolder.setContext((AppAuthContext)appAuthContext);
        }
        ActivityUniformityMqDTO activityDataUniformityMqDTO = this.senMqToSd(businessKeyDTO);
        if (!businessKeyDTO.getClosed().booleanValue()) {
            this.dealDataUniformity(businessKeyDTO, authoredUser, activityDataUniformityMqDTO);
        }
    }

    public void processEventForRepair(ActivityBusinessKeyDTO businessKeyDTO) {
        AuthoredUser authoredUser = businessKeyDTO.getAuthoredUser();
        if (null != authoredUser) {
            AppAuthContext appAuthContext = new AppAuthContext();
            appAuthContext.setAuthoredUser(authoredUser);
            AppAuthContextHolder.setContext((AppAuthContext)appAuthContext);
        }
        ActivityUniformityMqDTO activityDataUniformityMqDTO = this.senMqToSd(businessKeyDTO);
        if (!businessKeyDTO.getClosed().booleanValue()) {
            this.dealDataUniformity(businessKeyDTO, authoredUser, activityDataUniformityMqDTO);
        }
    }

    private ActivityUniformityMqDTO senMqToSd(ActivityBusinessKeyDTO businessKeyDTO) {
        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
        dataUniformityMqDTO.setBusinessUnit(businessKeyDTO.getBusinessUnit());
        dataUniformityMqDTO.setProcessVar(businessKeyDTO.getData());
        ActivityUniformityMqDTO activityDataUniformityMqDTO = ActivityUniformityMqDTO.builder().tenantId(businessKeyDTO.getTenantId()).state(businessKeyDTO.getState()).activityId(businessKeyDTO.getActivityId().toString()).activityTemplateId(businessKeyDTO.getTmActivityId()).subTaskTemplateId(businessKeyDTO.getTmTaskId()).subTaskId(businessKeyDTO.getSubTaskId().toString()).type("activity").messageData(dataUniformityMqDTO).build();
        this.rabbitTemplate.convertAndSend("DC_TASK_EXCHANGE", "DC_TASK_ROUTER_KEY", (Object)JsonUtils.objectToString((Object)activityDataUniformityMqDTO));
        log.info("\u4efb\u52a1\u6d88\u606f\u961f\u5217\uff1a{}", (Object)JsonUtils.objectToString((Object)activityDataUniformityMqDTO));
        return activityDataUniformityMqDTO;
    }

    private List<JSONObject> dealDataUniformity(ActivityBusinessKeyDTO businessKeyDTO, AuthoredUser authoredUser, ActivityUniformityMqDTO activityDataUniformityMqDTO) {
        boolean hasDataUniformityBk = false;
        ArrayList<JSONObject> bkList = new ArrayList<JSONObject>();
        try {
            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject((Object)activityDataUniformityMqDTO));
            List<ParserBo> parserBoList = this.iParser.parse(taskEvent, authoredUser);
            if (!CollectionUtils.isEmpty(parserBoList)) {
                hasDataUniformityBk = true;
                for (ParserBo parserBo : parserBoList) {
                    bkList.add(parserBo.getBkInfo());
                }
                this.businessKeySercvice.insertBkTaskActivity(parserBoList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
            }
        }
        catch (Exception e) {
            log.warn("\u3010\u83b7\u53d6\u6570\u636e\u4e00\u81f4\u6027bk\u5931\u8d25\u3011\uff1a{}, {}", (Object)businessKeyDTO.getWorkitemId(), (Object)e);
        }
        if (!hasDataUniformityBk) {
            Map<String, Object> bkMap = this.bkTaskActivityService.getTmBusinessKeyNew(businessKeyDTO.getTmTaskId(), businessKeyDTO.getTmActivityId(), businessKeyDTO.getBpmData());
            JSONArray bkValueList = new ArrayList();
            if (bkMap.containsKey("complex")) {
                bkValueList = JSONArray.fromObject((Object)bkMap.get("complex"));
            }
            JSONArray bkObjectValueList = new ArrayList();
            if (bkMap.containsKey("simple")) {
                bkObjectValueList = JSONArray.fromObject((Object)bkMap.get("simple"));
            }
            this.bkTaskActivityService.insertOriBk((List<JSONObject>)bkValueList, (List<Object>)bkObjectValueList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
        }
        return bkList;
    }
}

