/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.bk.ProjectBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.TaskEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.DataUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.TaskUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IParser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectBusinessKeyHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectBusinessKeyHandler.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessKeyService businessKeyService;
    @Autowired
    private IParser iParser;
    private final String TASK_QUEUE = "DC_TASK_QUEUE";
    private final String TASK_EXCHANGE = "DC_TASK_EXCHANGE";
    private final String TASK_ROUTER_KEY = "DC_TASK_ROUTER_KEY";

    public void process(ProjectBusinessKeyDTO event) {
        try {
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private void processEvent(ProjectBusinessKeyDTO businessKeyDTO) {
        TaskUniformityMqDTO taskDataUniformityMqDTO = new TaskUniformityMqDTO();
        taskDataUniformityMqDTO.setTenantId(businessKeyDTO.getTenantId());
        taskDataUniformityMqDTO.setState(businessKeyDTO.getState());
        taskDataUniformityMqDTO.setSubTaskTemplateId(businessKeyDTO.getTmTaskId());
        taskDataUniformityMqDTO.setSubTaskId(businessKeyDTO.getId().toString());
        taskDataUniformityMqDTO.setType("task");
        taskDataUniformityMqDTO.setSourceIds(businessKeyDTO.getSourceIds());
        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
        dataUniformityMqDTO.setBusinessUnit(businessKeyDTO.getBusinessUnit());
        dataUniformityMqDTO.setProcessVar(businessKeyDTO.getData());
        taskDataUniformityMqDTO.setMessageData(dataUniformityMqDTO);
        this.rabbitTemplate.convertAndSend("DC_TASK_EXCHANGE", "DC_TASK_ROUTER_KEY", (Object)JsonUtils.objectToString((Object)taskDataUniformityMqDTO));
        log.info("\u9879\u76ee\u6d88\u606f\u961f\u5217\uff1a{}", (Object)JsonUtils.objectToString((Object)taskDataUniformityMqDTO));
        try {
            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject((Object)taskDataUniformityMqDTO));
            List<ParserBo> parserBoList = this.iParser.parse(taskEvent, businessKeyDTO.getAuthoredUser());
            ArrayList<JSONObject> bkList = new ArrayList<JSONObject>();
            if (CollectionUtils.isNotEmpty(parserBoList)) {
                for (ParserBo parserBo : parserBoList) {
                    bkList.add(parserBo.getBkInfo());
                }
                this.businessKeyService.insertBkTaskActivity(parserBoList, businessKeyDTO.getId(), businessKeyDTO.getTenantId(), "task");
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u9879\u76eebk\u5931\u8d25,businessKeyDTO:{},{}:", (Object)JsonUtils.objectToString((Object)businessKeyDTO), (Object)e);
        }
    }
}

