/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmBacklogCreateGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.im.ImBpmActivityTeamDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardDetailDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmTaskCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PtmBacklogCreateGroupHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmBacklogCreateGroupHandler.class);
    @Autowired
    private TeamMemberService teamMemberService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private UserService userService;

    public void process(PtmBacklogCreateGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn("PTM \u521b\u5efa\u6216\u66f4\u65b0 IM\u4efb\u52a1\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), event});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(PtmBacklogCreateGroupDTO backlog) {
        AuthoredUser authoredUser = backlog.getAuthoredUser();
        log.info("\u3010PtmBacklogCreateGroupSubscriber-event\u3011\uff1a{}", (Object)backlog);
        if (authoredUser == null) {
            return;
        }
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        String userLangName = this.userService.getUserLangNameByUserId(authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());
        Locale locale = LocaleUtils.toLocale((String)userLangName);
        LocaleContextHolder.setLocale((Locale)locale);
        if (PtmMqOperation.ADD.equals((Object)backlog.getOperation()) && Objects.equals(backlog.getCanCreateTaskTeam(), true)) {
            PtmProjectCardDetailDTO projectCard = this.ptmService.getProjectCardDetail(backlog.getProjectCardId());
            TmActivityResponseDTO tmActivityResponseDTO = this.themeMapService.getActivityAction(projectCard.getProjectDefCode(), backlog.getTaskDefCode(), TmPageName.TASK_CARD_NAME.getValue());
            log.info("\u3010PtmBacklogCreateGroupSubscriber-tmActivityResponseDTO\u3011\uff1a{}", (Object)tmActivityResponseDTO);
            if (!tmActivityResponseDTO.createImGroup()) {
                return;
            }
            List<String> relatedUserList = null;
            int isExternal = 0;
            String plan = null;
            String businessKey = null;
            List<PtmTaskCardDataDTO> taskCardDataList = this.ptmService.getTaskDataByBacklogId(backlog.getBacklogId(), "data");
            if (CollectionUtils.isNotEmpty(taskCardDataList)) {
                businessKey = MapUtils.getString((Map)taskCardDataList.get(0).getData(), (Object)"imBusinessKey");
            }
            ArrayList<ImBpmActivityTeamDTO.Performer> performerList = new ArrayList<ImBpmActivityTeamDTO.Performer>();
            ImBpmActivityTeamDTO.Performer performer = ImBpmActivityTeamDTO.Performer.builder().performerId(backlog.getPerformerId()).performerName(backlog.getPerformerName()).build();
            performerList.add(performer);
            ImBpmActivityTeamDTO teamDTO = ImBpmActivityTeamDTO.builder().bpmActivityId(backlog.getTaskId()).tmActivityName(StringUtils.isEmpty((String)backlog.getTaskName()) ? backlog.getTaskDefName() : backlog.getTaskName()).bpmActivityPlanEndTime(backlog.getPlanEndTime()).performerList(performerList).relatedUserList(relatedUserList).isExternal(isExternal).plan(plan).tenantSid(String.valueOf(authoredUser.getTenantSid())).tenantName(authoredUser.getTenantName()).imBusinessKey(businessKey).mainTaskId(backlog.getProjectCardId()).mainTaskPersonInCharge(projectCard.getPersonInCharge()).mainTaskPersonInChargeName(projectCard.getPersonInChargeName()).build();
            log.info("\u3010PtmBacklogCreateGroupSubscriber-createTeam-teamDTO\u3011\uff1a{}", (Object)teamDTO);
            this.teamMemberService.createBpmActivityTeam(teamDTO, authoredUser);
        } else {
            ArrayList<String> addMemberList = new ArrayList<String>();
            addMemberList.add(backlog.getPerformerId());
            log.info("\u3010PtmBacklogCreateGroupSubscriber-addTeamMember\u3011backlog\uff1a{}\uff0caddMemberList\uff1a{}", (Object)backlog, addMemberList);
            this.teamMemberService.addBpmActivityTeamMember(authoredUser, backlog.getTaskId(), addMemberList);
        }
    }
}

