/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectCardGroupDTO;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmProjectCardCreateGroupHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmProjectCardCreateGroupHandler.class);
    @Autowired
    private TeamMemberService teamMemberService;

    public void process(PtmProjectCardGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn("PTM\u65b0\u5efa\u9879\u76ee\u5361\u65f6\u521b\u5efaIM\u9879\u76ee\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), event});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(PtmProjectCardGroupDTO content) {
        AuthoredUser authoredUser = content.getAuthoredUser();
        if (authoredUser == null || !PtmMqOperation.ADD.equals((Object)content.getOperation())) {
            return;
        }
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        Task task = Task.builder().id(content.getId()).mainTaskId(content.getId()).name(content.getProjectName()).startTime(content.getStartTime()).endTime(content.getEndTime()).personInCharge(content.getPersonInCharge()).build();
        List<String> relatedUsers = content.getRelatedUsers();
        String businessKey = "";
        if (StringUtils.isNotEmpty((String)content.getImBusinessKey())) {
            businessKey = content.getImBusinessKey();
        }
        this.teamMemberService.createTaskTeam(task, authoredUser, relatedUsers, businessKey);
    }
}

