/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectCardGroupDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmProjectCardDeleteGroupHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmProjectCardDeleteGroupHandler.class);
    @Autowired
    private ImService imService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    public void process(PtmProjectCardGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn("PTM\u9879\u76ee\u5361\u7ed3\u675f\u65f6\u89e3\u6563IM\u9879\u76ee\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), event});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(PtmProjectCardGroupDTO content) {
        AuthoredUser authoredUser = content.getAuthoredUser();
        if (authoredUser == null || !PtmMqOperation.CLOSE.equals((Object)content.getOperation())) {
            return;
        }
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        Task task = Task.builder().id(content.getId()).mainTaskId(content.getId()).name(content.getProjectName()).startTime(content.getStartTime()).endTime(content.getEndTime()).personInCharge(content.getPersonInCharge()).build();
        this.imService.removeTeam(task.getMainTaskId().toString(), 1, authoredUser);
        List backlogList = this.ptmBacklogMapper.selectTaskIdsByProjectCard(content.getId());
        if (CollectionUtils.isNotEmpty((Collection)backlogList)) {
            backlogList.forEach(bl -> this.imService.removeTeam(bl.getTaskId().toString(), ImTeamType.TaskTeam.getValue(), authoredUser));
        }
    }
}

