/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectGroupDTO;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmProjectUpdateImHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmProjectUpdateImHandler.class);
    @Autowired
    private TeamMemberService teamMemberService;

    public void process(PtmProjectGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn("PTM\u65b0\u5efa\u9879\u76ee\u65f6\u66f4\u65b0IM\u9879\u76ee\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), event});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(PtmProjectGroupDTO event) {
        if (event == null || event.getAuthoredUser() == null || event.getProject() == null) {
            return;
        }
        log.info("\u3010PtmProjectGroupDTO\u3011\uff1a{}", (Object)event);
        AuthoredUser authoredUser = event.getAuthoredUser();
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        if (PtmMqOperation.ADD.equals((Object)event.getOperation()) || PtmMqOperation.CHANGE.equals((Object)event.getOperation())) {
            Task task = Task.builder().id(event.getProject().getProjectCardId()).mainTaskId(event.getProject().getProjectCardId()).personInCharge(event.getProject().getPersonInCharge()).build();
            List<String> relatedUsers = event.getRelatedUsers();
            this.teamMemberService.updateTeamMemberByFlow(task, authoredUser, relatedUsers);
        }
    }
}

