/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmTaskDeleteGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmTaskDeleteGroupHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmTaskDeleteGroupHandler.class);
    @Autowired
    private ImService imService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private ThemeMapService themeMapService;

    public void process(PtmTaskDeleteGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn("PTM \u89e3\u6563IM\u4efb\u52a1\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), event});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(PtmTaskDeleteGroupDTO content) {
        AuthoredUser authoredUser = content.getAuthoredUser();
        if (authoredUser == null || !PtmMqOperation.CLOSE.equals((Object)content.getOperation())) {
            return;
        }
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        PtmProjectCardRecordDTO ptmProjectCardRecordDTO = this.ptmService.getProjectCardRecord(content.getProjectCardId());
        TmActivityResponseDTO tmActivityResponseDTO = this.themeMapService.getActivityAction(ptmProjectCardRecordDTO.getProjectDefCode(), content.getTaskDefCode(), TmPageName.TASK_CARD_NAME.getValue());
        if (!tmActivityResponseDTO.createImGroup()) {
            return;
        }
        this.imService.removeTeam(content.getId().toString(), ImTeamType.TaskTeam.getValue(), authoredUser);
    }
}

