/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.TaskOperateSendMsgDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.AimEventDO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskOperateSendMsgHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskOperateSendMsgHandler.class);
    @Autowired
    private AimService aimService;

    public void process(TaskOperateSendMsgDTO event) {
        try {
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(TaskOperateSendMsgDTO backlogOverdueSendMsgNotice) {
        AuthoredUser user = backlogOverdueSendMsgNotice.getAuthoredUser();
        AimEventDO aimEvent = new AimEventDO();
        aimEvent.setGid(UUID.randomUUID().toString());
        aimEvent.setUserId(user.getUserId());
        aimEvent.setUserName(user.getUserName());
        aimEvent.setTenantId(user.getTenantId());
        aimEvent.setSendDate(LocalDateTime.now());
        aimEvent.setType(backlogOverdueSendMsgNotice.getType());
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("backlogId", backlogOverdueSendMsgNotice.getBacklogId());
        eventMap.put("workItemId", backlogOverdueSendMsgNotice.getWorkItemId());
        eventMap.put("taskName", backlogOverdueSendMsgNotice.getTaskName());
        eventMap.put("performerId", backlogOverdueSendMsgNotice.getPerformerId());
        eventMap.put("performerName", backlogOverdueSendMsgNotice.getPerformerName());
        aimEvent.setEvent(eventMap);
        log.info("[taskOperateSendMsg] send message, message = {}", (Object)JsonUtils.objectToString((Object)aimEvent));
        this.aimService.sendUrageDealNotice(user, aimEvent);
    }
}

