/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardJob;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.TaskWorkItemMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityPageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmScheduleConfig;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageConverter;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BpmCommonBacklogAbstractService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.CommonBacklogAbstractService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.BpmCommonProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.CommonProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.CommonUtils;
import com.digiwin.athena.abt.core.meta.enums.CardTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskWorkitemMessageMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskWorkitemMessage;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class TaskWorkitemMessageHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskWorkitemMessageHandler.class);
    @Autowired
    private TaskWorkitemMessageMapper taskWorkitemMessageMapper;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    private RefreshCardMessageService refreshCardMessageService;
    @Autowired
    private RefreshCardMessageConverter refreshCardMessageConverter;
    @Autowired
    private CommonBacklogAbstractService backlogHandleService;
    @Autowired
    private BpmCommonBacklogAbstractService bpmBacklogHandleService;
    @Autowired
    private CommonProjectHandleService commonProjectHandleService;
    @Autowired
    private BpmCommonProjectHandleService bpmCommonProjectHandleService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private RedissonClient redissonClient;
    public static final String ADD = "add";
    public static final String UPDATE = "update";
    public static final String PTM_BACKLOG = "ptmBacklog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TaskWorkItemMessageDTO event) {
        String lockKey = "redisson:lock:message:" + event.getCardType() + ":" + event.getCardId();
        long timestamp = System.currentTimeMillis();
        RLock lock = this.redissonClient.getLock(lockKey);
        log.info(lockKey + "\u83b7\u53d6\u5230\u9501");
        try {
            log.info(lockKey + "\u5c1d\u8bd5\u52a0\u9501\uff0c\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName());
            lock.lock();
            log.info(lockKey + "\u5df2\u52a0\u9501\uff0c\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName());
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            AppAuthContextHolder.clearContext();
            LocaleContextHolder.resetLocaleContext();
            try {
                this.releaseLockTransAction(lock, lockKey, timestamp);
            }
            catch (Exception e) {
                log.error("\u91ca\u653e\u9501\u5f02\u5e38\uff0ckey\uff1a{}\uff0c\u52a0\u9501\u603b\u8017\u65f6\uff1a{}", (Object)lockKey, (Object)(System.currentTimeMillis() - timestamp));
                log.error("this transaction has exception!", (Throwable)e);
            }
        }
    }

    private void processEvent(TaskWorkItemMessageDTO taskWorkItemMessageModel) {
        log.info("TaskWorkitemMessageSubscriber-event:{}", (Object)taskWorkItemMessageModel);
        AuthoredUser authoredUser = taskWorkItemMessageModel.getAuthoredUser();
        if (authoredUser == null) {
            return;
        }
        AppAuthContext appAuthContext = new AppAuthContext();
        appAuthContext.setAuthoredUser(authoredUser);
        AppAuthContextHolder.setContext((AppAuthContext)appAuthContext);
        String cardType = taskWorkItemMessageModel.getCardType();
        Long cardId = taskWorkItemMessageModel.getCardId();
        String tenantId = StringUtils.isNotEmpty((String)taskWorkItemMessageModel.getTenantId()) ? taskWorkItemMessageModel.getTenantId() : authoredUser.getTenantId();
        String optType = this.getOptType(taskWorkItemMessageModel.getOptType(), cardId, tenantId, cardType);
        log.info("TaskWorkitemMessageSubscriber-cardId\uff1a" + cardId + "\uff1bworkItemId\uff1a" + taskWorkItemMessageModel.getWorkItemId() + "\u7684optType\uff1a" + optType);
        String summary = "";
        String historyMessage = "";
        String searchMessage = "";
        Map summaryMap = null;
        if ("task".equals(cardType)) {
            summaryMap = this.bpmCommonProjectHandleService.getProjectCardSelfAbstract(authoredUser, cardId, true);
        } else if ("ptmProject".equals(cardType)) {
            summaryMap = this.commonProjectHandleService.getProjectCardSelfAbstract(authoredUser, cardId, new CardAbstractDTO().setCardId(cardId).setNeedHistoryInfo(true).setNeedBusinessMessage(true).setBusinessMessageSourceType("api"));
        } else if (PTM_BACKLOG.equals(cardType)) {
            summaryMap = this.backlogHandleService.getBacklogCardAbstractById(taskWorkItemMessageModel.getWorkItemId(), authoredUser, new CardAbstractDTO().setCardId(cardId).setNeedHistoryInfo(true).setNeedBusinessMessage(false).setWorkItemIds(taskWorkItemMessageModel.getWorkItemIds()).setBusinessMessageSourceType("bpm"), null);
            this.backlogHandleService.saveTaskSaveBusinessMessage(authoredUser, new CardAbstractDTO().setCardId(cardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType("bpm"));
        } else {
            summaryMap = this.bpmBacklogHandleService.getBacklogCardAbstractById(taskWorkItemMessageModel.getWorkItemId(), authoredUser, true);
        }
        log.info("TaskWorkitemMessageSubscriber-summaryMap:{}", (Object)summaryMap);
        if (summaryMap != null) {
            summary = summaryMap.get("summaryLayout") != null ? summaryMap.get("summaryLayout").toString() : "";
            historyMessage = summaryMap.get("historyMessage") != null ? summaryMap.get("historyMessage").toString() : "";
            String string = searchMessage = summaryMap.get("searchMessage") != null ? summaryMap.get("searchMessage").toString() : "";
        }
        if (UPDATE.equals(optType) && ("workitem".equals(cardType) || PTM_BACKLOG.equals(cardType))) {
            this.updatePtmBacklogOrWorkItemMessage(authoredUser, cardId, taskWorkItemMessageModel.getActivityId(), cardType, summary, historyMessage, searchMessage);
        } else {
            TaskWorkitemMessage taskWorkitemMessage = new TaskWorkitemMessage();
            taskWorkitemMessage.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            taskWorkitemMessage.setTenantId(tenantId);
            taskWorkitemMessage.setCardId(taskWorkItemMessageModel.getCardId());
            taskWorkitemMessage.setCreateDate(LocalDateTime.now());
            taskWorkitemMessage.setModifyDate(LocalDateTime.now());
            taskWorkitemMessage.setSummary(summary);
            taskWorkitemMessage.setHistoryMessage(historyMessage);
            taskWorkitemMessage.setSearchMessage(searchMessage);
            taskWorkitemMessage.setCardType(cardType);
            log.info("taskWorkitemMessage:{}", (Object)JsonUtils.objectToString((Object)taskWorkitemMessage));
            this.taskWorkitemMessageMapper.insertOrUpdateMessage(taskWorkitemMessage);
            LogDto logDto = new LogDto("\u3010TaskWorkitemMessageHandler\u3011\u4efb\u52a1\u6458\u8981\u3001\u8d44\u8baf\u548c\u641c\u7d22\u6570\u636e\u5165\u5e93\u6210\u529f\uff0c\u5361\u7247id\uff1a" + taskWorkItemMessageModel.getCardId(), authoredUser.getTenantId() + ";" + taskWorkItemMessageModel.getCardId() + ",\u6d3b\u52a8id:" + taskWorkItemMessageModel.getActivityId());
            log.info(logDto.toString());
            if (PTM_BACKLOG.equals(cardType)) {
                this.createRefreshTaskCardMessageJobIfAbsent(taskWorkItemMessageModel.getWorkItemId(), taskWorkitemMessage.getCardId(), taskWorkitemMessage.getTenantId());
            } else if ("ptmProject".equals(cardType) && MapUtil.getBool((Map)summaryMap, (Object)"scheduleRefreshCardMessage", (Boolean)Boolean.FALSE).booleanValue()) {
                this.createRefreshProjectCardMessageJobIfAbsent(taskWorkitemMessage.getCardId(), MapUtils.getString((Map)summaryMap, (Object)"scheduleRefreshCardType"), taskWorkitemMessage.getTenantId());
            }
            if ("ptmProject".equals(cardType)) {
                this.createNewProjectSchedule(MapUtils.getString((Map)summaryMap, (Object)"tmTaskId"), tenantId);
            }
        }
    }

    private void updatePtmBacklogOrWorkItemMessage(AuthoredUser authoredUser, Long cardId, Long activityId, String cardType, String summary, String historyMessage, String searchMessage) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("card_id", cardId);
        List taskWorkitemMessageList = this.taskWorkitemMessageMapper.selectByMap(paramMap);
        if (CollectionUtils.isEmpty((Collection)taskWorkitemMessageList)) {
            return;
        }
        TaskWorkitemMessage taskWorkitemMessage = (TaskWorkitemMessage)taskWorkitemMessageList.get(0);
        taskWorkitemMessage.setSummary(this.mergeMessage(taskWorkitemMessage.getSummary(), summary));
        taskWorkitemMessage.setHistoryMessage(this.mergeMessage(taskWorkitemMessage.getHistoryMessage(), historyMessage));
        taskWorkitemMessage.setSearchMessage(this.mergeMessage(taskWorkitemMessage.getSearchMessage(), searchMessage));
        taskWorkitemMessage.setModifyDate(LocalDateTime.now());
        boolean isPtmBacklog = PTM_BACKLOG.equals(cardType);
        if (isPtmBacklog) {
            String activityMessageStr = CommonUtils.getActivityMessageStr(taskWorkitemMessage.getActivityMessage(), activityId, CommonUtils.getCardMap(summary, historyMessage, searchMessage));
            taskWorkitemMessage.setActivityMessage(activityMessageStr);
        }
        this.taskWorkitemMessageMapper.updateById((Object)taskWorkitemMessage);
        LogDto logDto = new LogDto("\u3010TaskWorkitemMessageHandler\u3011\u4efb\u52a1\u6458\u8981\u3001\u8d44\u8baf\u548c\u641c\u7d22\u6570\u636e\u66f4\u65b0\u6210\u529f\uff0c\u5361\u7247id\uff1a" + cardId, authoredUser.getTenantId() + ";" + cardId);
        log.info(logDto.toString());
        if (isPtmBacklog) {
            PtmBacklog ptmBacklog = (PtmBacklog)this.ptmBacklogMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(PtmBacklog::getBacklogId, (Object)cardId));
            if (null == ptmBacklog) {
                return;
            }
            List backlogList = this.ptmBacklogMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PtmBacklog::getWorkItemId, (Object)ptmBacklog.getWorkItemId()));
            if (CollectionUtils.size((Object)backlogList) > 1) {
                for (PtmBacklog backlog : backlogList) {
                    if (null == backlog || cardId.equals(backlog.getBacklogId())) continue;
                    LogDto tmpLog = new LogDto("\u3010TaskWorkitemMessageHandler\u3011\u4efb\u52a1\u6458\u8981\u3001\u8d44\u8baf\u548c\u641c\u7d22\u6570\u636e\u66f4\u65b0\u6210\u529f\uff0c\u5361\u7247id\uff1a" + backlog.getBacklogId(), authoredUser.getTenantId() + ";" + cardId);
                    log.info(tmpLog.toString());
                    this.taskWorkitemMessageMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TaskWorkitemMessage::getCardId, (Object)backlog.getBacklogId())).set(TaskWorkitemMessage::getSummary, (Object)taskWorkitemMessage.getSummary())).set(TaskWorkitemMessage::getHistoryMessage, (Object)taskWorkitemMessage.getHistoryMessage())).set(TaskWorkitemMessage::getSearchMessage, (Object)taskWorkitemMessage.getSearchMessage()));
                }
            }
        }
    }

    public void createRefreshProjectCardMessageJobIfAbsent(Long projectCardId, String refreshCardType, String tenantId) {
        this.invokeAbtCreateRefreshCardMessageJob(projectCardId, refreshCardType, CardTypeEnum.PROJECT_CARD.getType(), tenantId);
    }

    public void createRefreshTaskCardMessageJobIfAbsent(Long workItemId, Long taskCardId, String tenantId) {
        TmActivityResponseDTO tmActivity = this.backlogHandleService.getTaskCardPageDefineByWorkItemId(workItemId);
        if (tmActivity == null) {
            return;
        }
        TmActivityPageDTO pages = tmActivity.getPages();
        if (pages == null) {
            return;
        }
        Boolean scheduleRefreshCardMessage = pages.getScheduleRefreshCardMessage();
        if (BooleanUtil.isTrue((Boolean)scheduleRefreshCardMessage)) {
            this.invokeAbtCreateRefreshCardMessageJob(taskCardId, pages.getScheduleRefreshCardType(), CardTypeEnum.TASK_CARD.getType(), tenantId);
        }
        this.createJob(pages.getScheduleConfig(), tmActivity.getActivityId(), TmPageName.TASK_CARD_NAME.getValue(), tenantId);
    }

    public void createNewProjectSchedule(String tmTaskId, String tenantId) {
        if (StringUtils.isNotBlank((String)tmTaskId)) {
            try {
                Map pages;
                TmTaskDefineResponseDTO projectDefine = this.themeMapService.getTask(tmTaskId);
                if (projectDefine != null && (pages = projectDefine.getPages()) != null) {
                    Object o = pages.get(TmPageName.PROJECT_CARD_NAME.getValue());
                    if (o == null) {
                        return;
                    }
                    TmActivityPageDTO tmActivityPageDTO = (TmActivityPageDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(o), TmActivityPageDTO.class);
                    this.createJob(tmActivityPageDTO.getScheduleConfig(), tmTaskId, TmPageName.PROJECT_CARD_NAME.getValue(), tenantId);
                }
            }
            catch (Exception e) {
                log.error("\u573a\u666f\u65b0\u9879\u76ee\u5361\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25,taskId:{},\u9519\u8bef\u4fe1\u606f:{}", new Object[]{tmTaskId, e.getMessage(), e});
            }
        }
    }

    private void createJob(TmScheduleConfig scheduleConfig, String code, String pageCode, String tenantId) {
        if (scheduleConfig != null) {
            CardJob job = new CardJob();
            job.setEnable(scheduleConfig.getEnable());
            job.setRefreshCardType(scheduleConfig.getRefreshCardType());
            job.setCode(code);
            job.setTenantId(tenantId);
            job.setPagCode(pageCode);
            this.refreshCardMessageService.createOrUpdateCardJob(job);
        }
    }

    private void invokeAbtCreateRefreshCardMessageJob(Long cardId, String refreshCardType, int cardType, String tenantId) {
        RefreshCardMessageDTO refreshCardMessageDTO = new RefreshCardMessageDTO();
        refreshCardMessageDTO.setId(cardId);
        refreshCardMessageDTO.setCardType(cardType);
        refreshCardMessageDTO.setTenantId(tenantId);
        refreshCardMessageDTO.setRefreshCardType(refreshCardType);
        try {
            RefreshCardMessageDTO refreshCardMessageDO = this.refreshCardMessageConverter.to(refreshCardMessageDTO);
            this.refreshCardMessageService.createRefreshCardMessageJobIfAbsent(refreshCardMessageDO);
        }
        catch (Exception ex) {
            log.warn("create refresh card message job{}.{}.{} failed, error: {}", new Object[]{cardId, tenantId, cardType, ex.getMessage(), ex});
        }
    }

    public String mergeMessage(String message, String subMessage) {
        if (StringUtils.isBlank((String)message)) {
            return subMessage;
        }
        if (StringUtils.equals((String)message, (String)subMessage) || StringUtils.isBlank((String)subMessage)) {
            return message;
        }
        return message + "<br>" + subMessage;
    }

    private String getOptType(String optType, Long backlogId, String tenantId, String cardType) {
        if (StringUtils.isNotBlank((String)optType)) {
            return optType;
        }
        List<TaskWorkitemMessage> taskWorkitemMessages = this.findMessage(backlogId, tenantId, cardType);
        return CollectionUtils.isEmpty(taskWorkitemMessages) ? ADD : UPDATE;
    }

    private List<TaskWorkitemMessage> findMessage(Long backlogId, String tenantId, String cardType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"card_id", (Object)backlogId);
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"card_type", (Object)cardType);
        return this.taskWorkitemMessageMapper.selectList((Wrapper)queryWrapper);
    }

    private void releaseLockTransAction(final RLock lock, final String lockKey, final long timestamp) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    log.info("\u5f02\u6b65\u4e8b\u52a1\u4e2d\u5f00\u59cb\u91ca\u653e\u9501\uff0ckey\uff1a{}\uff0c\u52a0\u9501\u603b\u8017\u65f6\uff1a{}", (Object)lockKey, (Object)(System.currentTimeMillis() - timestamp));
                    long startReleaseLockTimestamp = System.currentTimeMillis();
                    TaskWorkitemMessageHandler.this.releaseLock(lock, lockKey);
                    log.info("\u5f02\u6b65\u4e8b\u52a1\u4e2d\u91ca\u653e\u9501\u7ed3\u675f\uff0ckey\uff1a{}\uff0c\u52a0\u9501\u603b\u8017\u65f6\uff1a{}, \u91ca\u653e\u9501\u603b\u8017\u65f6\uff1a{}", new Object[]{lockKey, System.currentTimeMillis() - timestamp, System.currentTimeMillis() - startReleaseLockTimestamp});
                }
            });
        } else {
            log.info("\u5f00\u59cb\u91ca\u653e\u9501\uff0ckey\uff1a{}\uff0c\u52a0\u9501\u603b\u8017\u65f6\uff1a{}", (Object)lockKey, (Object)(System.currentTimeMillis() - timestamp));
            long startReleaseLockTimestamp = System.currentTimeMillis();
            this.releaseLock(lock, lockKey);
            log.info("\u91ca\u653e\u9501\u7ed3\u675f\uff0ckey\uff1a{}\uff0c\u52a0\u9501\u603b\u8017\u65f6\uff1a{}, \u91ca\u653e\u9501\u603b\u8017\u65f6\uff1a{}", new Object[]{lockKey, System.currentTimeMillis() - timestamp, System.currentTimeMillis() - startReleaseLockTimestamp});
        }
    }

    private void releaseLock(RLock lock, String lockKey) {
        log.info(lockKey + "isHeldByCurrentThread = " + lock.isHeldByCurrentThread() + "\uff0c\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName());
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
            log.info(lockKey + "\u91ca\u653e\u9501\uff0c\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName());
        }
    }
}

