/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.groupteam;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmMqGroupTeamService;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

@Service
public class EventGroupTeamMessageModel
extends EventBaseService
implements EventInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventGroupTeamMessageModel.class);
    @Autowired
    private PtmMqGroupTeamService ptmMqGroupTeamService;

    @Override
    public String modelType() {
        return "groupTeamModel";
    }

    @Override
    public void distributeMessages(String data) {
        this.rabbitTemplate.convertAndSend("athena.event.message", "athena.event.group.team", (Object)data);
    }

    @Override
    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.group.team", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.group.team"})}, concurrency="#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('athena.event.group.team')}")
    @RabbitRetry(beforeHandler="ptmMqBeforeHandler", successHander="ptmMqSuccessHandler", failureHandler="ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="retry-count", required=false) Integer retryCount) {
        super.receiveOrder(data, "athena.event.group.team", channel, tag, retryCount);
    }

    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        AuthoredUser user = super.getUser(mqMessageDTO);
        LogDto logDto = new LogDto("\u3010EventGroupTeamMessageModel\u3011\u5904\u7406\u7fa4\u804a\u6d88\u606f\uff0c\u6d88\u606f\u7c7b\u578b\uff1a" + mqMessageDTO.getType().getValue(), user.getTenantId() + ";" + mqMessageDTO.getType().getValue());
        log.info(logDto.toString());
        if (EventMqTypeEnum.backlog.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqGroupTeamService.processTaskCreateGroupMessage(data, user);
        } else if (EventMqTypeEnum.task.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqGroupTeamService.processTaskDeleteGroupMessage(data, user);
        } else if (EventMqTypeEnum.projectCard.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqGroupTeamService.processProjectCardGroupMessage(data, user);
        } else if (EventMqTypeEnum.project.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqGroupTeamService.processProjectGroupMessage(data, user);
        } else if (EventMqTypeEnum.flowProjectCard.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqGroupTeamService.processFlowProjectCardGroupMessage(data, mqMessageDTO.getFlowUser());
        } else if (EventMqTypeEnum.flowProject.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqGroupTeamService.processFlowProjectGroupMessage(data, mqMessageDTO.getFlowUser());
        } else if (EventMqTypeEnum.flowBacklog.equals((Object)mqMessageDTO.getType())) {
            this.ptmMqGroupTeamService.processFlowBacklogGroupMessage(data, mqMessageDTO.getFlowUser());
        }
    }
}

