/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.groupteam;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.im.ImBpmActivityTeamDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.im.ImTeamDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivity;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TeamMemberService {
    @Autowired
    EnvProperties envProperties;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private EocService eocService;
    @Autowired
    private ImService imService;
    private static final Logger logger = LoggerFactory.getLogger(TeamMemberService.class);

    private boolean disableIM() {
        return StringUtils.isBlank((String)this.envProperties.getImUri());
    }

    public void createTaskTeam(Task task, AuthoredUser user, List<String> relatedUserList, String businessKey) {
        String proxyUser;
        if (this.disableIM()) {
            return;
        }
        if (task == null) {
            return;
        }
        String owner = this.eocService.getEocEmpInfo(task.getPersonInCharge(), user);
        String taskName = MessageUtils.getMessageByCurrentLanguage((Object)task.getName());
        if (StringUtils.isEmpty((String)taskName)) {
            taskName = MessageUtils.getMessageByCurrentLanguage((Object)task.getProjectName());
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("MM/dd");
        String startTime = df.format(task.getStartTime());
        String endTime = df.format(task.getEndTime());
        String teamName = startTime + "-" + endTime + taskName;
        String bizId = task.getMainTaskId().toString();
        int type = 1;
        int ifMaster = 1;
        int visiable = 0;
        ArrayList<String> userList = new ArrayList<String>();
        if (relatedUserList != null && relatedUserList.size() > 0) {
            userList.addAll(relatedUserList);
        }
        if (StringUtils.isNotEmpty((String)(proxyUser = this.getPorxyUser(user, task.getPersonInCharge())))) {
            userList.add(proxyUser);
        }
        List<String> memberList = this.userService.getEmployee(userList, user);
        this.imService.createTeam(user, owner, teamName, bizId, type, ifMaster, visiable, memberList, "", null, null, businessKey);
        LogDto logDto = new LogDto("\u521b\u5efa\u9879\u76ee\u5361\u65f6\u521b\u5efa\u9879\u76ee\u7fa4\u6210\u529f\uff0c\u9879\u76eeid\uff1a" + task.getMainTaskId(), user.getTenantId() + ";" + task.getMainTaskId());
        logger.info(logDto.toString());
    }

    public void updateTeamMemberByFlow(Task task, AuthoredUser user, List<String> relatedUserList) {
        if (this.disableIM()) {
            return;
        }
        String bizId = task.getMainTaskId().toString();
        int type = 1;
        ArrayList<String> userList = new ArrayList<String>();
        String proxyUser = this.getPorxyUser(user, task.getPersonInCharge());
        if (StringUtils.isNotEmpty((String)proxyUser)) {
            userList.add(proxyUser);
        }
        if (relatedUserList != null && relatedUserList.size() > 0) {
            userList.addAll(relatedUserList);
        }
        List<String> memberList = this.userService.getEmployee(userList, user);
        LogDto logDto = new LogDto("\u9879\u76ee\u5361\u65b0\u589e\u5b50\u6d41\u7a0b\u65f6\u5411\u9879\u76ee\u7fa4\u5185\u6dfb\u52a0\u6210\u5458\u6210\u529f\uff0c\u6dfb\u52a0\u7684\u7fa4\u6210\u5458\uff1a" + JsonUtils.objectToString(userList), user.getTenantId() + ";" + task.getMainTaskId());
        logger.info(logDto.toString());
        this.addTeamMembers(user, bizId, type, memberList);
    }

    public void createBpmActivityTeam(BpmActivity bpmActivity, Boolean isBpmActivityStepEmpty, List<BpmActivityWorkitem> workitemList, AuthoredUser user, List<String> relatedUserList, int isExternal, String plan, String tenantSid, String tenantName, String businessKey) {
        Map teamMap;
        if (this.disableIM()) {
            return;
        }
        if (bpmActivity == null || isBpmActivityStepEmpty.booleanValue() || CollectionUtils.isEmpty(workitemList)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)businessKey) && (teamMap = this.imService.getTeamInfo(user, businessKey, ImTeamType.TaskTeam.getValue(), "pcc")) != null) {
            String cardIds = "";
            cardIds = teamMap.get("cardIds") != null ? bpmActivity.getId().toString() + "," + teamMap.get("cardIds") : bpmActivity.getId().toString();
            this.imService.updateTeamInfo(user, teamMap.get("tId").toString(), cardIds);
            return;
        }
        Task mainTask = this.taskMapper.getPartialMainProjectByBpmActivitySqlId(bpmActivity.getId());
        if (mainTask == null) {
            return;
        }
        ArrayList<ImBpmActivityTeamDTO.Performer> performerList = new ArrayList<ImBpmActivityTeamDTO.Performer>();
        workitemList.forEach(wi -> {
            ImBpmActivityTeamDTO.Performer performer = ImBpmActivityTeamDTO.Performer.builder().performerId(wi.getPerformerId()).performerName(wi.getPerformerName()).build();
            performerList.add(performer);
        });
        ImBpmActivityTeamDTO bpmActivityTeamDTO = ImBpmActivityTeamDTO.builder().bpmActivityId(bpmActivity.getId()).tmActivityName(bpmActivity.getTmActivityName()).bpmActivityPlanEndTime(bpmActivity.getPlanEndTime()).performerList(performerList).relatedUserList(relatedUserList).isExternal(isExternal).plan(plan).tenantSid(tenantSid).tenantName(tenantName).imBusinessKey(businessKey).mainTaskId(mainTask.getId()).mainTaskPersonInCharge(mainTask.getPersonInCharge()).mainTaskPersonInChargeName(mainTask.getPersonInChargeName()).build();
        this.createBpmActivityTeam(bpmActivityTeamDTO, user);
        LogDto logDto = new LogDto("\u521b\u5efabpm\u4efb\u52a1\u7fa4\u6210\u529f\uff0cbpmActivityId\uff1a" + bpmActivity.getId(), user.getTenantId() + ";" + bpmActivity.getId());
        logger.info(logDto.toString());
    }

    public void createBpmActivityTeam(ImBpmActivityTeamDTO bpmActivityTeamDTO, AuthoredUser user) {
        Map teamMap;
        if (this.disableIM()) {
            return;
        }
        if (bpmActivityTeamDTO == null || CollectionUtils.isEmpty(bpmActivityTeamDTO.getPerformerList())) {
            return;
        }
        if (StringUtils.isNotEmpty((String)bpmActivityTeamDTO.getImBusinessKey()) && (teamMap = this.imService.getTeamInfo(user, bpmActivityTeamDTO.getImBusinessKey(), ImTeamType.TaskTeam.getValue(), "pcc")) != null) {
            String cardIds = "";
            cardIds = teamMap.get("cardIds") != null ? bpmActivityTeamDTO.getBpmActivityId().toString() + "," + teamMap.get("cardIds") : bpmActivityTeamDTO.getBpmActivityId().toString();
            this.imService.updateTeamInfo(user, teamMap.get("tId").toString(), cardIds);
            return;
        }
        ImTeamDTO teamDTO = new ImTeamDTO();
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        String activityName = MessageUtils.getMessageByCurrentLanguage((Object)bpmActivityTeamDTO.getTmActivityName());
        teamDTO.setTeamName(String.format(this.messageUtils.getMessageByLangName("msg.record.backlog.performer.notice.msg", langName), TimeUtils.format((LocalDateTime)bpmActivityTeamDTO.getBpmActivityPlanEndTime(), (String)"MM/dd"), activityName));
        teamDTO.setBizId(bpmActivityTeamDTO.getBpmActivityId().toString());
        teamDTO.setTeamType(ImTeamType.TaskTeam);
        teamDTO.setIfMaster(1);
        teamDTO.setVisiable(0);
        teamDTO.setPId(bpmActivityTeamDTO.getMainTaskId().toString());
        ArrayList<String> userList = new ArrayList<String>();
        ArrayList<String> proxyUserList = new ArrayList<String>();
        for (ImBpmActivityTeamDTO.Performer workitem : bpmActivityTeamDTO.getPerformerList()) {
            String proxyUser = this.getPorxyUser(user, workitem.getPerformerId());
            if (!StringUtils.isNotEmpty((String)proxyUser)) continue;
            proxyUserList.add(proxyUser);
        }
        userList.addAll(proxyUserList);
        if (bpmActivityTeamDTO.getRelatedUserList() != null && bpmActivityTeamDTO.getRelatedUserList().size() > 0) {
            userList.addAll(bpmActivityTeamDTO.getRelatedUserList());
        }
        teamDTO.setExternalEocMembers(new ArrayList<Map>());
        teamDTO.setExternalAccounts(new ArrayList<Map>());
        if (bpmActivityTeamDTO.getIsExternal() == 1) {
            teamDTO.setOwner(this.eocService.getEocEmpInfo(bpmActivityTeamDTO.getMainTaskPersonInCharge(), user));
            if ("email".equals(bpmActivityTeamDTO.getPlan())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("uniqueId", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId());
                map.put("userName", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerName());
                map.put("tenantName", "\u4f01\u4e1a\u7528\u6237");
                teamDTO.getExternalAccounts().add(map);
            } else if ("card".equals(bpmActivityTeamDTO.getPlan())) {
                HashMap<String, Object> map;
                String eocUserId = this.eocService.getEocByTenantAndUser(user, bpmActivityTeamDTO.getTenantSid(), bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId());
                if (StringUtils.isNotEmpty((String)eocUserId)) {
                    map = new HashMap();
                    map.put("tenantId", Long.valueOf(bpmActivityTeamDTO.getTenantSid()));
                    map.put("eocId", eocUserId);
                    map.put("tenantName", bpmActivityTeamDTO.getTenantName());
                    teamDTO.getExternalEocMembers().add(map);
                } else {
                    map = new HashMap<String, Object>();
                    map.put("uniqueId", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId());
                    map.put("userName", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerName());
                    map.put("tenantName", "\u4f01\u4e1a\u7528\u6237");
                    teamDTO.getExternalAccounts().add(map);
                }
            }
        } else {
            teamDTO.setOwner(this.eocService.getEocEmpInfo(bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId(), user));
            userList.add(bpmActivityTeamDTO.getMainTaskPersonInCharge());
            ArrayList<String> taskUserList = new ArrayList<String>();
            for (ImBpmActivityTeamDTO.Performer workitem : bpmActivityTeamDTO.getPerformerList()) {
                taskUserList.add(workitem.getPerformerId());
            }
            if (!CollectionUtils.isEmpty(proxyUserList)) {
                taskUserList.addAll(proxyUserList);
            }
            List<String> taskMemberList = this.userService.getEmployee(taskUserList, user);
            this.addTeamMembers(user, teamDTO.getPId(), ImTeamType.ProjectTeam.getValue(), taskMemberList);
        }
        teamDTO.setMemberList(this.userService.getEmployee(userList, user));
        this.imService.createTeam(user, teamDTO.getOwner(), teamDTO.getTeamName(), teamDTO.getBizId(), teamDTO.getTeamType().getValue(), teamDTO.getIfMaster(), teamDTO.getVisiable(), teamDTO.getMemberList(), teamDTO.getPId(), teamDTO.getExternalAccounts(), teamDTO.getExternalEocMembers(), "");
        LogDto logDto = new LogDto("\u521b\u5efabpm\u4efb\u52a1\u7fa4\u6210\u529f\uff0cbpmActivityId\uff1a" + bpmActivityTeamDTO.getBpmActivityId(), user.getTenantId() + ";" + bpmActivityTeamDTO.getBpmActivityId());
        logger.info(logDto.toString());
        this.createTeamByAccount(user, bpmActivityTeamDTO.getRelatedUserList(), teamDTO.getOwner(), teamDTO.getBizId(), teamDTO.getPId(), teamDTO.getTeamType().getValue(), teamDTO.getTeamName());
        LogDto logDtoOuter = new LogDto("\u521b\u5efa\u5916\u90e8\u4eba\u5458\u79c1\u804a\u6210\u529f\uff0cbpmActivityId\uff1a" + bpmActivityTeamDTO.getBpmActivityId(), user.getTenantId() + ";" + bpmActivityTeamDTO.getBpmActivityId());
        logger.info(logDtoOuter.toString());
    }

    public void transferTaskMemeber(AuthoredUser user, Task task, List<String> userIdList) {
        if (this.disableIM()) {
            return;
        }
        if (task != null && CollUtil.isNotEmpty(userIdList)) {
            List<String> memberList = this.userService.getEmployee(userIdList, user);
            this.addTeamMembers(user, task.getId().toString(), 1, memberList);
            LogDto logDto = new LogDto("\u6dfb\u52a0\u9879\u76ee\u7fa4\u6210\u5458\u6210\u529f\uff0c\u4efb\u52a1id\uff1a" + task.getId(), user.getTenantId() + ";" + task.getId());
            logger.info(logDto.toString());
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("task_id", task.getId());
            List backlogList = this.backlogMapper.selectByMap(paramMap);
            if (backlogList == null || backlogList.isEmpty()) {
                return;
            }
            for (Backlog backlog : backlogList) {
                this.addTeamMembers(user, backlog.getId().toString(), 2, memberList);
                LogDto logDtBacklog = new LogDto("\u6dfb\u52a0\u4efb\u52a1\u7fa4\u6210\u5458\u6210\u529f\uff0c\u4efb\u52a1id\uff1a" + backlog.getId(), user.getTenantId() + ";" + backlog.getId());
                logger.info(logDtBacklog.toString());
            }
        }
    }

    public void addBpmActivityTeamMember(AuthoredUser user, Long bpmActivitySqlId, List<String> userIdList) {
        if (this.disableIM()) {
            return;
        }
        if (bpmActivitySqlId == null || Objects.equals(bpmActivitySqlId, 0) || CollectionUtils.isEmpty(userIdList)) {
            return;
        }
        List<String> memberList = this.userService.getEmployee(userIdList, user);
        this.addTeamMembers(user, bpmActivitySqlId.toString(), ImTeamType.TaskTeam.getValue(), memberList);
        LogDto logDtBacklog = new LogDto("\u6dfb\u52a0\u4efb\u52a1\u7fa4\u6210\u5458\u6210\u529f\uff0cbpmActivitySqlId\uff1a" + bpmActivitySqlId, user.getTenantId() + ";" + bpmActivitySqlId);
        logger.info(logDtBacklog.toString());
        Task mainTask = this.taskMapper.getPartialMainProjectByBpmActivitySqlId(bpmActivitySqlId);
        if (mainTask != null) {
            this.addTeamMembers(user, mainTask.getId().toString(), ImTeamType.ProjectTeam.getValue(), memberList);
            LogDto logDto = new LogDto("\u6dfb\u52a0\u9879\u76ee\u7fa4\u6210\u5458\u6210\u529f\uff0c\u4efb\u52a1id\uff1a" + mainTask.getId(), user.getTenantId() + ";" + bpmActivitySqlId);
            logger.info(logDto.toString());
        }
    }

    private String getPorxyUser(AuthoredUser user, String userId) {
        String proxyUser = "";
        UserDTO userDTO = this.userService.getTargetUser(userId, user.getToken());
        if (userDTO != null && StringUtils.isNotEmpty((String)userDTO.getId()) && !userId.equals(userDTO.getId())) {
            proxyUser = userDTO.getId();
        }
        return proxyUser;
    }

    private void createTeamByAccount(AuthoredUser user, List<String> relatedUserList, String owner, String bizId, String pId, int type, String teamName) {
        if (relatedUserList == null || relatedUserList.size() == 0) {
            return;
        }
        for (String userId : relatedUserList) {
            String eocId = this.eocService.getEocEmpInfo(userId, user);
            if (StringUtils.isNotEmpty((String)eocId)) continue;
            UserDTO userDTO = this.userService.query(userId);
            if (userDTO == null) {
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("uniqueId", userId);
            map.put("userName", userDTO.getName());
            map.put("tenantName", "\u4f01\u4e1a\u7528\u6237");
            ArrayList<Map> externalAccounts = new ArrayList<Map>();
            externalAccounts.add(map);
            this.imService.createTeam(user, owner, teamName, bizId, type, 0, 0, null, pId, externalAccounts, null, "");
            LogDto logDto = new LogDto("\u521b\u5efa\u4efb\u52a1\u6267\u884c\u4eba\u548c\u5916\u90e8\u5173\u8054\u7684\u79c1\u804a\u7fa4\u6210\u529f\uff0cuserId\uff1a" + userId, user.getTenantId() + ";" + userId);
            logger.info(logDto.toString());
        }
    }

    private void addTeamMembers(AuthoredUser user, String bizId, int type, List<String> memberList) {
        List<String> list = memberList.stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollUtil.isEmpty(list)) {
            return;
        }
        this.imService.addTeamMembers(user, bizId, type, list);
    }
}

