/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.helpler;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmAppDTO;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.cac.CacService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.cac.sdk.meta.dto.response.UserAppDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AppPermissionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppPermissionUtil.class);
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    @Qualifier(value="abtCacServiceImpl")
    private CacService cacService;

    public List<String> handleAppPermission(List<String> activityCodeList) {
        if (CollectionUtil.isEmpty(activityCodeList)) {
            return activityCodeList;
        }
        List<UserAppDTO> userAppDTOS = this.cacService.qryUserApp();
        if (CollectionUtil.isEmpty(userAppDTOS)) {
            return new ArrayList<String>();
        }
        List userAppCodeList = userAppDTOS.stream().map(UserAppDTO::getId).distinct().collect(Collectors.toList());
        List<TmAppDTO> tmAppDTOS = this.themeMapService.getAppInfoByCodeAndType("task", activityCodeList);
        Map<String, List<TmAppDTO>> codeAppRel = tmAppDTOS.stream().collect(Collectors.groupingBy(TmAppDTO::getCode));
        ArrayList<String> hasPermissionActivityCodeList = new ArrayList<String>();
        activityCodeList.forEach(activityCode -> {
            if (this.hasAppPermission((List)codeAppRel.get(activityCode), userAppCodeList)) {
                hasPermissionActivityCodeList.add((String)activityCode);
            }
        });
        return hasPermissionActivityCodeList;
    }

    private boolean hasAppPermission(List<TmAppDTO> tmAppList, List<String> appCodeList) {
        if (CollectionUtils.isEmpty(tmAppList)) {
            return false;
        }
        List appCodes = tmAppList.stream().map(TmAppDTO::getAppCode).distinct().collect(Collectors.toList());
        return CollectionUtil.containsAny(appCodeList, appCodes);
    }
}

