/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.helpler;

import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.utils.ExcelHellper;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.application.utils.MyCollectionUtils;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.jugg.agile.framework.core.config.JaProperty;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExcelHelperV2
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelHelperV2.class);
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    static final String POIFILES = "poifiles";
    private final String EXCEL_SUFFIX = ".xlsx";
    public static final String HEADER_KEY = "key";
    private static final String HEADER_NAME = "name";
    public static final String HEADER_CHILDREN = "headers";
    public static final String ERROR_FIELD_SUFFIX = "_error_msg";
    private static final String DATA_TYPE = "dataType";
    private static final String OPTIONS = "options";
    private static final String TITLE = "title";
    private static final String VALUE = "value";

    public List<Map> readData(Sheet sheet) {
        Map<String, Integer[]> map = ExcelUtil.getMergedRegionMap(sheet);
        Sheet sheetExcepNullRow = ExcelUtil.getAccuracyContextNum(sheet, map);
        LinkedList<String> headerKeys = new LinkedList<String>();
        Row headRow2 = sheetExcepNullRow.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow2.getCell(cellStartIdx)) {
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            headerKeys.add(key);
            ++cellStartIdx;
        }
        LinkedList<Map> data = new LinkedList<Map>();
        int rowStartIdx = 2;
        while (null != sheetExcepNullRow.getRow(rowStartIdx)) {
            HashMap<Object, Object> rowData = new HashMap<Object, Object>();
            for (int i = 0; i < headerKeys.size(); ++i) {
                CellType cellType = sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getCellTypeEnum();
                switch (cellType) {
                    case STRING: {
                        rowData.put(headerKeys.get(i), sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getStringCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        rowData.put(headerKeys.get(i), sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getBooleanCellValue());
                        break;
                    }
                    case NUMERIC: {
                        rowData.put(headerKeys.get(i), sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getNumericCellValue());
                        break;
                    }
                    default: {
                        rowData.put(headerKeys.get(i), "");
                    }
                }
                if (null == sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getCellComment()) continue;
                String cellComment = sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getCellComment().getString().getString();
                rowData.put((String)headerKeys.get(i) + ERROR_FIELD_SUFFIX, cellComment);
            }
            data.add(rowData);
            ++rowStartIdx;
        }
        return data;
    }

    public List<Map> readData(Sheet sheet, List<String> headerKeys) {
        LinkedList<Map> data = new LinkedList<Map>();
        int rowStartIdx = 2;
        while (null != sheet.getRow(rowStartIdx)) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            for (int i = 0; i < headerKeys.size(); ++i) {
                CellType cellType = sheet.getRow(rowStartIdx).getCell(i).getCellTypeEnum();
                switch (cellType) {
                    case STRING: {
                        rowData.put(headerKeys.get(i), sheet.getRow(rowStartIdx).getCell(i).getStringCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        rowData.put(headerKeys.get(i), sheet.getRow(rowStartIdx).getCell(i).getBooleanCellValue());
                        break;
                    }
                    case NUMERIC: {
                        rowData.put(headerKeys.get(i), sheet.getRow(rowStartIdx).getCell(i).getNumericCellValue());
                        break;
                    }
                    default: {
                        rowData.put(headerKeys.get(i), "");
                    }
                }
                if (null == sheet.getRow(rowStartIdx).getCell(i).getCellComment()) continue;
                String cellComment = sheet.getRow(rowStartIdx).getCell(i).getCellComment().getString().getString();
                rowData.put(headerKeys.get(i) + ERROR_FIELD_SUFFIX, cellComment);
            }
            data.add(rowData);
            ++rowStartIdx;
        }
        return data;
    }

    public List<Map> readData(Workbook wb, List<String> headerKeys, List<String> mainKeys) {
        int sheetNum = wb.getNumberOfSheets();
        HashMap<String, Map<String, List<Map>>> bodyDataMap = new HashMap<String, Map<String, List<Map>>>();
        if (this.hasBody(sheetNum)) {
            for (int i = 1; i < sheetNum; ++i) {
                Sheet bodySheet = wb.getSheetAt(i);
                String sheetName = bodySheet.getSheetName();
                List<Map> readData = this.readData(bodySheet);
                Map<String, List<Map>> groupedMap = MyCollectionUtils.groupingBy(readData, MyCollectionUtils.formMapGroupFunctions(mainKeys));
                bodyDataMap.put(sheetName, groupedMap);
            }
        }
        Sheet sheet = wb.getSheetAt(0);
        LinkedList<Map> data = new LinkedList<Map>();
        int rowStartIdx = 2;
        while (null != sheet.getRow(rowStartIdx)) {
            int i;
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            String joinedKey = "";
            for (i = 0; i < headerKeys.size(); ++i) {
                String keyCode = headerKeys.get(i);
                CellType cellType = sheet.getRow(rowStartIdx).getCell(i).getCellTypeEnum();
                switch (cellType) {
                    case STRING: {
                        rowData.put(keyCode, sheet.getRow(rowStartIdx).getCell(i).getStringCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        rowData.put(keyCode, sheet.getRow(rowStartIdx).getCell(i).getBooleanCellValue());
                        break;
                    }
                    case NUMERIC: {
                        rowData.put(keyCode, sheet.getRow(rowStartIdx).getCell(i).getNumericCellValue());
                        break;
                    }
                    default: {
                        rowData.put(keyCode, "");
                    }
                }
                if (mainKeys.contains(keyCode)) {
                    joinedKey = joinedKey + (StringUtils.isEmpty((Object)joinedKey) ? "" : "&&") + sheet.getRow(rowStartIdx).getCell(i).getStringCellValue();
                }
                if (null == sheet.getRow(rowStartIdx).getCell(i).getCellComment()) continue;
                String cellComment = sheet.getRow(rowStartIdx).getCell(i).getCellComment().getString().getString();
                rowData.put(headerKeys.get(i) + ERROR_FIELD_SUFFIX, cellComment);
            }
            if (this.hasBody(sheetNum)) {
                for (i = 1; i < sheetNum; ++i) {
                    Sheet bodySheet = wb.getSheetAt(i);
                    String sheetName = bodySheet.getSheetName();
                    List bodyList = ((Map)bodyDataMap.get(sheetName)).get(joinedKey) == null ? Collections.EMPTY_LIST : (List)((Map)bodyDataMap.get(sheetName)).get(joinedKey);
                    this.removeBodyBusinessKey(bodyList, mainKeys);
                    rowData.put(ExcelUtil.getSheetNameInParens(sheetName), bodyList);
                }
            }
            data.add(rowData);
            ++rowStartIdx;
        }
        return data;
    }

    public List<Map> readRootData(Workbook wb, String mainKeyName, Map<String, CellTypeContainer> cellTypeContainerMap) {
        CellTypeContainer rootTypeContainerMap = new CellTypeContainer();
        rootTypeContainerMap.setKeyName(mainKeyName);
        rootTypeContainerMap.setProtoType(MetaDataType.OBJECT);
        rootTypeContainerMap.setChildren(new ArrayList());
        rootTypeContainerMap.getChildren().addAll(cellTypeContainerMap.values());
        Map<String, List<Map>> sheetDataMap = this.readExcelData(wb, mainKeyName);
        List<Map> data = this.readEntityData(rootTypeContainerMap, sheetDataMap, null);
        return data;
    }

    public Map<String, List<String>> readExcelHeaders(Workbook wb, String mainKey) {
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        try {
            int sheetNum = wb.getNumberOfSheets();
            for (int i = 0; i < sheetNum; ++i) {
                Sheet bodySheet = wb.getSheetAt(i);
                List<String> headers = this.doreadExcelHeaders(bodySheet);
                String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
                if ("sheet1".equals(sheetName)) {
                    data.put(mainKey, headers);
                    continue;
                }
                data.put(sheetName, headers);
            }
        }
        catch (Exception e) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0116.getErrCode(), (String)MessageUtil.getMessageByLocale("upload.template.error", LocaleContextHolder.getLocale().toString(), new Object[0]));
        }
        return data;
    }

    public List<String> doreadExcelHeaders(Sheet sheet) {
        LinkedList<String> headerKeys = new LinkedList<String>();
        Row headRow2 = sheet.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow2.getCell(cellStartIdx)) {
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            headerKeys.add(key);
            ++cellStartIdx;
        }
        return headerKeys;
    }

    public Map<String, List<Map>> readExcelData(Workbook wb, String mainKey) {
        HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
        int sheetNum = wb.getNumberOfSheets();
        for (int i = 0; i < sheetNum; ++i) {
            Sheet bodySheet = wb.getSheetAt(i);
            List<Map> readData = this.readData(bodySheet);
            String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
            if ("sheet1".equals(sheetName)) {
                data.put(mainKey, readData);
                continue;
            }
            data.put(sheetName, readData);
        }
        return data;
    }

    public Map<String, List<ApiDataFieldLocaleMetadataDTO>> getSheetMetadataMap(Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetMetadataMap, String sheetName, int sheetNo, ApiDataFieldLocaleMetadataDTO mainMetadata, UploadParamDTO uploadParam) {
        if (null == mainMetadata || CollectionUtils.isEmpty(mainMetadata.getField())) {
            log.error("getActionLocaleResponseDTO is null!");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0092.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
        }
        Map<String, Set<String>> sheetRequiredFiledMap = uploadParam.getActionInfo().getSheetRequiredFiled();
        HashMap<String, List<ApiDataFieldLocaleMetadataDTO>> sheetBkMap = new HashMap<String, List<ApiDataFieldLocaleMetadataDTO>>();
        HashMap<String, Set<String>> sheetBkRequiredFiled = new HashMap<String, Set<String>>();
        if (sheetNo == 0) {
            List fieldLocaleMetadataDTOS = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(mainMetadata.getField()), ApiDataFieldLocaleMetadataDTO.class);
            this.getBkMetadataMap(sheetBkMap, fieldLocaleMetadataDTOS, sheetBkRequiredFiled, uploadParam.getRequiredFields());
            sheetMetadataMap.put(sheetName, fieldLocaleMetadataDTOS);
            sheetRequiredFiledMap.put(sheetName, uploadParam.getRequiredFields());
        } else {
            Iterator<Map.Entry<String, List<ApiDataFieldLocaleMetadataDTO>>> iterator = sheetMetadataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                List<ApiDataFieldLocaleMetadataDTO> metadataDTOS = iterator.next().getValue();
                Optional<ApiDataFieldLocaleMetadataDTO> optional = metadataDTOS.stream().filter(metadataDTO -> metadataDTO.getData_name().equals(sheetName)).findFirst();
                if (!optional.isPresent()) continue;
                ApiDataFieldLocaleMetadataDTO metadataDTO2 = optional.get();
                HashSet<String> addRequiredFields = new HashSet();
                addRequiredFields = this.reBuildRequiredFields(metadataDTO2.getField(), sheetBkRequiredFiled, sheetName);
                sheetRequiredFiledMap.put(sheetName, addRequiredFields);
                this.getBkMetadataMap(sheetBkMap, metadataDTO2.getField(), sheetBkRequiredFiled, addRequiredFields);
                sheetMetadataMap.put(sheetName, metadataDTO2.getField());
                if (CollectionUtils.isEmpty(sheetBkMap) || CollectionUtils.isEmpty((Collection)((Collection)sheetBkMap.get(sheetName)))) break;
                sheetMetadataMap.get(sheetName).addAll((Collection)sheetBkMap.get(sheetName));
                break;
            }
        }
        return sheetMetadataMap;
    }

    private Set<String> reBuildRequiredFields(List<ApiDataFieldLocaleMetadataDTO> field, Map<String, Set<String>> sheetBkRequiredFiled, String sheetName) {
        Set<String> requiredFields = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)sheetBkRequiredFiled.get(sheetName))) {
            requiredFields = sheetBkRequiredFiled.get(sheetName);
        }
        if (CollectionUtils.isEmpty(field)) {
            return requiredFields;
        }
        HashSet<String> resultFields = new HashSet<String>(requiredFields);
        for (ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO : field) {
            if (!"true".equals(apiDataFieldLocaleMetadataDTO.getRequired())) continue;
            resultFields.add(apiDataFieldLocaleMetadataDTO.getData_name());
        }
        return resultFields;
    }

    public void getBkMetadataMap(Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetBkMap, List<ApiDataFieldLocaleMetadataDTO> fieldLocaleMetadataDTOS, Map<String, Set<String>> sheetBkRequiredFiled, Set<String> requiredFields) {
        List bks = fieldLocaleMetadataDTOS.stream().filter(metadataDTO -> metadataDTO.getIs_businesskey()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bks)) {
            return;
        }
        List<ApiDataFieldLocaleMetadataDTO> arrayFields = fieldLocaleMetadataDTOS.stream().filter(metadataDTO -> metadataDTO.getIs_array()).collect(Collectors.toList());
        arrayFields.forEach(arrayField -> {
            sheetBkMap.put(arrayField.getData_name(), bks);
            sheetBkRequiredFiled.put(arrayField.getData_name(), requiredFields);
        });
    }

    public Map<String, List<Map>> readExcelDataForImport(Workbook wb, String mainKey, Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetMetadataMap) {
        HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
        int sheetNum = wb.getNumberOfSheets();
        for (int i = 0; i < sheetNum; ++i) {
            Sheet bodySheet = wb.getSheetAt(i);
            String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
            List<ApiDataFieldLocaleMetadataDTO> metadataDTOS = sheetMetadataMap.get(sheetName);
            List<Object> readData = new ArrayList();
            readData = ExcelUtil.readDataForImport(bodySheet, metadataDTOS);
            if ("sheet1".equals(sheetName)) {
                data.put(mainKey, readData);
                continue;
            }
            data.put(sheetName, readData);
        }
        return data;
    }

    private List<Map> readEntityData(CellTypeContainer cellTypeContainer, Map<String, List<Map>> sheetDataMap, Map parentBKMap) {
        ArrayList<Map> data = new ArrayList<Map>();
        List<Map> sheetData = sheetDataMap.get(cellTypeContainer.getKeyName());
        List<String> businessKeys = this.getKeys(cellTypeContainer.getChildren());
        if (MapUtils.isEmpty((Map)parentBKMap)) {
            parentBKMap = new HashMap();
        }
        if (CollectionUtils.isEmpty(sheetData)) {
            return new ArrayList<Map>();
        }
        for (Map rowData : sheetData) {
            if (MapUtils.isEmpty(parentBKMap)) {
                data.add(rowData);
            } else {
                if (!this.compareBusinessKey(rowData, parentBKMap).booleanValue()) continue;
                data.add(rowData);
            }
            HashMap businessKeyMap = new HashMap();
            if (MapUtils.isEmpty(parentBKMap)) {
                businessKeyMap.putAll(parentBKMap);
            }
            for (String bk : businessKeys) {
                businessKeyMap.put(bk, rowData.get(bk));
            }
            if (CollectionUtils.isEmpty((Collection)cellTypeContainer.getChildren())) continue;
            for (CellTypeContainer child : cellTypeContainer.getChildren()) {
                if (child.getProtoType() != MetaDataType.OBJECT) continue;
                List<Map> childList = this.readEntityData(child, sheetDataMap, businessKeyMap);
                rowData.put(child.getKeyName(), childList);
            }
        }
        return data;
    }

    public Boolean compareBusinessKey(Map rowData, Map businessKeyMap) {
        Object[] businessKeys;
        for (Object businessKey : businessKeys = businessKeyMap.keySet().toArray()) {
            if (!rowData.containsKey(businessKey)) {
                return false;
            }
            if (Objects.equals(rowData.get(businessKey), businessKeyMap.get(businessKey))) continue;
            return false;
        }
        return true;
    }

    private List<String> getKeys(List<CellTypeContainer> cellTypes) {
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtils.isEmpty(cellTypes)) {
            return keys;
        }
        for (CellTypeContainer cellType : cellTypes) {
            if (!cellType.getBusinessKey().booleanValue()) continue;
            keys.add(cellType.getKeyName());
        }
        return keys;
    }

    private void removeBodyBusinessKey(List<Map> bodyList, List<String> mainKeys) {
        if (!CollectionUtils.isEmpty(bodyList)) {
            bodyList.forEach(map -> {
                Set set = map.keySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!mainKeys.contains(key)) continue;
                    it.remove();
                }
            });
        }
    }

    private boolean hasBody(int sheetNum) {
        return sheetNum > 1;
    }

    public List<Map> readHeaders(Workbook wb, Map<String, CellTypeContainer> cellTypeContainerMap, List<String> headerKeys, List<String> mainKeys) {
        Sheet sheet = wb.getSheetAt(0);
        int sheetTotalNum = wb.getNumberOfSheets();
        LinkedList<Map> headers = new LinkedList<Map>();
        Row headRow1 = sheet.getRow(0);
        Row headRow2 = sheet.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow1.getCell(cellStartIdx)) {
            String val = headRow1.getCell(cellStartIdx).getStringCellValue();
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            HashMap<String, Object> cell = new HashMap<String, Object>();
            cell.put(HEADER_KEY, key);
            cell.put(HEADER_NAME, val);
            this.setDict(key, cell, cellTypeContainerMap);
            headerKeys.add(key);
            headers.add(cell);
            ++cellStartIdx;
        }
        if (this.hasBody(sheetTotalNum)) {
            for (int i = 1; i < sheetTotalNum; ++i) {
                Map<String, Object> cell = this.readBodyHeaders(i, wb, cellTypeContainerMap, mainKeys);
                if (CollectionUtils.isEmpty(cell)) continue;
                headers.add(cell);
            }
        }
        return headers;
    }

    private Map<String, Object> readBodyHeaders(int sheetNum, Workbook wb, Map<String, CellTypeContainer> cellTypeContainerMap, List<String> mainKeys) {
        if (sheetNum >= wb.getNumberOfSheets()) {
            return null;
        }
        Sheet bodySheet = wb.getSheetAt(sheetNum);
        String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
        CellTypeContainer cellTypeContainer = cellTypeContainerMap.get(sheetName);
        if (null == cellTypeContainer) {
            return null;
        }
        HashMap<String, CellTypeContainer> cellTypeChildMap = new HashMap();
        if (cellTypeContainer.getArray().booleanValue() && !CollectionUtils.isEmpty((Collection)cellTypeContainer.getChildren())) {
            cellTypeChildMap = cellTypeContainer.getChildren().stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, Function.identity()));
        }
        LinkedList<Map<Object, Object>> bodyHeaders = new LinkedList<Map<Object, Object>>();
        Row bodyHeadRow1 = bodySheet.getRow(0);
        Row bodyHeadRow2 = bodySheet.getRow(1);
        int bodyCellStartIdx = 0;
        while (null != bodyHeadRow1.getCell(bodyCellStartIdx)) {
            String val = bodyHeadRow1.getCell(bodyCellStartIdx).getStringCellValue();
            String string = bodyHeadRow2.getCell(bodyCellStartIdx).getStringCellValue();
            List<String> needRemoveBkList = this.getNeedRemoveBkList(mainKeys, cellTypeChildMap);
            if (!needRemoveBkList.contains(string)) {
                HashMap<String, Object> cell = new HashMap<String, Object>();
                cell.put(HEADER_KEY, string);
                cell.put(HEADER_NAME, val);
                bodyHeaders.add(cell);
            }
            ++bodyCellStartIdx;
        }
        if (!CollectionUtils.isEmpty(cellTypeChildMap)) {
            Map<String, Object> map;
            for (Map map2 : bodyHeaders) {
                String key = (String)map2.get(HEADER_KEY);
                this.setDict(key, map2, cellTypeChildMap);
            }
            List<String> parentBks = ExcelUtil.getBusinessKeyList(cellTypeContainer.getChildren());
            if (!CollectionUtils.isEmpty(map = this.readBodyHeaders(++sheetNum, wb, cellTypeChildMap, parentBks))) {
                bodyHeaders.add(map);
            }
        }
        HashMap<String, Object> cell = new HashMap<String, Object>(4);
        cell.put(HEADER_KEY, sheetName);
        cell.put(HEADER_NAME, cellTypeContainer.getKeyDescription());
        cell.put(HEADER_CHILDREN, bodyHeaders);
        return cell;
    }

    private List<String> getNeedRemoveBkList(List<String> mainKeys, Map<String, CellTypeContainer> cellTypeChildMap) {
        Set<String> keyNameSet = cellTypeChildMap.keySet();
        ArrayList<String> needRemoveBkList = new ArrayList<String>();
        mainKeys.forEach(data -> {
            if (!keyNameSet.contains(data)) {
                needRemoveBkList.add((String)data);
            }
        });
        return needRemoveBkList;
    }

    private void setDict(String key, Map<String, Object> cell, Map<String, CellTypeContainer> cellTypeContainerMap) {
        CellTypeContainer cellTypeContainer = cellTypeContainerMap.get(key);
        if (null == cellTypeContainer) {
            return;
        }
        if (null != cellTypeContainer.getCellType()) {
            cell.put(DATA_TYPE, cellTypeContainer.getProtoType().name().toLowerCase());
        }
        if (!CollectionUtils.isEmpty((Collection)cellTypeContainer.getDictionaries())) {
            ArrayList options = new ArrayList();
            cell.put(OPTIONS, options);
            cellTypeContainer.getDictionaries().forEach(dictionary -> {
                HashMap<String, String> option = new HashMap<String, String>();
                option.put(VALUE, dictionary.getCode());
                option.put(TITLE, dictionary.getValue());
                options.add(option);
            });
        }
    }

    public List<Map> readHeaders(Sheet sheet, List<String> headerKeys) {
        LinkedList<Map> headers = new LinkedList<Map>();
        Row headRow1 = sheet.getRow(0);
        Row headRow2 = sheet.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow1.getCell(cellStartIdx)) {
            String val = headRow1.getCell(cellStartIdx).getStringCellValue();
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            HashMap<String, String> cell = new HashMap<String, String>(3);
            cell.put(HEADER_KEY, key);
            cell.put(HEADER_NAME, val);
            headerKeys.add(key);
            headers.add(cell);
            ++cellStartIdx;
        }
        return headers;
    }

    /*
     * Unable to fully structure code
     */
    public void createDataExcel(String SHEET_NAME, String locale, int rowIndex, List<String> keyList, Map<String, CellTypeContainer> cellTypeContainerMap, Map<String, String> headers, List<Map<String, Object>> dataTable, Workbook wb, List<CellTypeContainer> businessKeyContainer, int parentIdSize, CellTypeContainer cellTypeContainerMain, List<CellTypeContainer> cellTypesList, Set<String> arrayField) {
        sheet = wb.getSheet(SHEET_NAME);
        if (null == sheet) {
            sheet = wb.createSheet(SHEET_NAME);
        }
        if ((lastRowNum = sheet.getLastRowNum()) <= 0) {
            headRow1 = sheet.createRow(0);
            headRow2 = sheet.createRow(1);
            colIndex = 0;
            for (i = 0; i < keyList.size(); ++i) {
                if (arrayField.contains(keyList.get(i))) continue;
                cell1 = headRow1.createCell(colIndex);
                cell2 = headRow2.createCell(colIndex);
                cell1.setCellValue(headers.get(keyList.get(i)));
                cell2.setCellValue(keyList.get(i));
                ++colIndex;
            }
        }
        fmt = wb.createDataFormat();
        colIndex = 0;
        block11: for (i = 0; i < keyList.size(); ++i) {
            if (!cellTypeContainerMap.containsKey(keyList.get(i))) {
                ExcelHelperV2.log.error("\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a {}", (Object)keyList.get(i));
            }
            metaDataType = cellTypeContainerMap.get(keyList.get(i)).getProtoType();
            cellTypeContainer = cellTypeContainerMap.get(keyList.get(i));
            if (cellTypeContainer.getKeyName().contains("_error_msg")) continue;
            cellStyle = wb.createCellStyle();
            cellTypeContainer.setCellStyle(cellStyle);
            switch (1.$SwitchMap$com$digiwin$athena$abt$core$meta$enums$MetaDataType[metaDataType.ordinal()]) {
                case 1: {
                    if (null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0) {
                        ExcelUtil.excelRuleStringLength(locale, sheet, 0, cellTypeContainer.getPrecision()[0], 2, 65536, colIndex, colIndex);
                    }
                    cellStyle.setDataFormat(fmt.getFormat("@"));
                    sheet.setDefaultColumnStyle(colIndex, cellStyle);
                    ** GOTO lbl90
                }
                case 2: {
                    ExcelUtil.excelRuleIsNumber(locale, sheet, 2, 65536, colIndex, colIndex);
                    ** GOTO lbl90
                }
                case 3: {
                    cellStyle.setDataFormat(fmt.getFormat(cellTypeContainer.getDateFormat()));
                    sheet.setDefaultColumnStyle(colIndex, cellStyle);
                    ExcelUtil.excelRuleDateFormat(locale, sheet, "1720-01-01", "", cellTypeContainer.getDateFormat(), 2, 65536, colIndex, colIndex);
                    ** GOTO lbl90
                }
                case 4: {
                    if (cellTypeContainer.getArray().booleanValue() && null != businessKeyContainer) {
                        childSheetName = ExcelHelperV2.getSheetName(cellTypeContainer.getKeyName(), cellTypeContainer.getKeyDescription(), false);
                        cellTypes = cellTypeContainer.getChildren();
                        childBusinessKeyContainer = this.getBusinessKeyContainer(cellTypes);
                        this.addBkContainer(cellTypes, businessKeyContainer);
                        parentIdSizeForChild = businessKeyContainer.size();
                        childKeyList = new ArrayList<String>();
                        childHeaders = new HashMap<String, String>();
                        for (CellTypeContainer item : cellTypes) {
                            if (item.getKeyName().contains("_error_msg")) continue;
                            childKeyList.add(item.getKeyName());
                            childHeaders.put(item.getKeyName(), item.getKeyDescription());
                        }
                        chiledCellTypeContainerMap = cellTypes.stream().collect(Collectors.toMap((Function<CellTypeContainer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKeyName(), (Lcom/digiwin/athena/abt/core/meta/dto/CellTypeContainer;)Ljava/lang/String;)(), Function.identity()));
                        bodyDataList = new ArrayList<Map<String, Object>>();
                        for (Map<String, Object> map : dataTable) {
                            keyName = cellTypeContainer.getKeyName();
                            content = map.get(keyName);
                            try {
                                if (null == content || content instanceof List && CollectionUtils.isEmpty((Collection)((List)content)) || !(content instanceof List)) continue;
                                bodyData = (List)content;
                                for (Map bodyDataMap : bodyData) {
                                    for (j = 0; j < parentIdSizeForChild; ++j) {
                                        bkCellTypeContainer = businessKeyContainer.get(j);
                                        bkValue = map.get(bkCellTypeContainer.getKeyName());
                                        bodyDataMap.put(bkCellTypeContainer.getKeyName(), bkValue);
                                    }
                                }
                                bodyDataList.addAll(bodyData);
                            }
                            catch (Exception e) {
                                ExcelHelperV2.log.error("parse body error:{}", content);
                            }
                        }
                        this.createDataExcel(childSheetName, locale, rowIndex, childKeyList, chiledCellTypeContainerMap, childHeaders, bodyDataList, wb, childBusinessKeyContainer, parentIdSizeForChild, cellTypeContainerMain, cellTypes, arrayField);
                        continue block11;
                    }
                    if (null != cellTypeContainer.getListEnum() && cellTypeContainer.getListEnum().length != 0) {
                        ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, colIndex, colIndex);
                    }
                    ** GOTO lbl90
                }
                case 5: {
                    ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, colIndex, colIndex);
                    ** GOTO lbl90
                }
                case 6: {
                    if (null != cellTypeContainer.getListEnum() && cellTypeContainer.getListEnum().length != 0) {
                        ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, colIndex, colIndex);
                    }
                }
lbl90:
                // 9 sources

                default: {
                    ++colIndex;
                }
            }
        }
        if (CollectionUtils.isEmpty(dataTable)) {
            return;
        }
        if (null == cellTypeContainerMain) {
            for (i = 0; i < dataTable.size(); ++i) {
                row = null;
                row = lastRowNum <= 0 ? sheet.createRow(rowIndex++) : sheet.createRow(lastRowNum + 1 + i);
                rowMap = dataTable.get(i);
                cellIndex = 0;
                for (j = 0; j < keyList.size(); ++j) {
                    if (arrayField.contains(keyList.get(j)) || (cellTypeContainer = cellTypeContainerMap.get(keyList.get(j))).getKeyName().contains("_error_msg")) continue;
                    value = rowMap.get(keyList.get(j));
                    this.fillData(row, cellIndex, cellTypeContainer, value, rowMap);
                    ++cellIndex;
                }
            }
        } else {
            if (lastRowNum > 0) {
                rowIndex = lastRowNum + 1;
            }
            this.fillSheetData(sheet, rowIndex, parentIdSize, cellTypeContainerMain, cellTypesList, dataTable);
        }
    }

    public List<CellTypeContainer> getArrayKeyContainer(ArrayList<CellTypeContainer> cellTypes) {
        LinkedList<CellTypeContainer> cellTypeContainers = new LinkedList<CellTypeContainer>();
        for (CellTypeContainer cellType : cellTypes) {
            if (!cellType.getArray().booleanValue()) continue;
            cellTypeContainers.add(cellType);
        }
        return cellTypeContainers;
    }

    private void fillSheetData(Sheet sheet, int rowIndex, int parentIdSize, CellTypeContainer cellTypeContainerMain, List<CellTypeContainer> cellTypes, List<Map<String, Object>> errorTable) {
        for (Map<String, Object> map : errorTable) {
            List bodyData;
            String keyName = cellTypeContainerMain.getKeyName();
            Object content = map.get(keyName);
            try {
                if (null == content || content instanceof List && CollectionUtils.isEmpty((Collection)((List)content)) || !(content instanceof List)) continue;
                bodyData = JsonUtils.jsonToListObject((String)JsonUtils.objectToString((Object)content), Map.class);
            }
            catch (Exception e) {
                log.error("parse body error:{}", content);
                continue;
            }
            for (Map bodyDataMap : bodyData) {
                Row row = sheet.createRow(rowIndex);
                for (int i = 0; i < parentIdSize; ++i) {
                    CellTypeContainer cellTypeContainer = cellTypes.get(i);
                    Object value = map.get(cellTypeContainer.getKeyName());
                    this.fillData(row, i, cellTypeContainer, value, map);
                }
                int fillColIndex = parentIdSize;
                for (int i = parentIdSize; i < cellTypes.size(); ++i) {
                    CellTypeContainer cellTypeContainer = cellTypes.get(i);
                    if (cellTypeContainer.getKeyName().contains(ERROR_FIELD_SUFFIX)) continue;
                    Object value = bodyDataMap.get(cellTypeContainer.getKeyName());
                    Object valueComment = bodyDataMap.get(cellTypeContainer.getKeyName() + ERROR_FIELD_SUFFIX);
                    this.fillData(row, fillColIndex, cellTypeContainer, value, map);
                    if (!this.isEmpty(valueComment)) {
                        ExcelHellper.addComment(row.getCell(fillColIndex), String.valueOf(valueComment), ".xlsx");
                    }
                    ++fillColIndex;
                }
                ++rowIndex;
            }
        }
    }

    private boolean isEmpty(Object value) {
        return null == value || StringUtils.isEmpty((Object)StringUtils.isEmpty((Object)value));
    }

    private void fillData(Row row, int column, CellTypeContainer cellTypeContainer, Object value, Map rowMap) {
        Cell cell = row.createCell(column);
        cell.setCellStyle(cellTypeContainer.getCellStyle());
        switch (cellTypeContainer.getCellType()) {
            case STRING: {
                if (cellTypeContainer.getProtoType() == MetaDataType.ENUM) {
                    if (StringUtils.isEmpty((Object)value)) {
                        cell.setCellValue("");
                        break;
                    }
                    cell.setCellValue(value + "." + (String)cellTypeContainer.getDictMap().get(String.valueOf(value)));
                    break;
                }
                if (value instanceof Double) {
                    cell.setCellValue(((Double)value).doubleValue());
                    break;
                }
                if (value instanceof Integer) {
                    cell.setCellValue((double)((Integer)value).intValue());
                    break;
                }
                if (value instanceof BigDecimal) {
                    cell.setCellValue(((BigDecimal)value).doubleValue());
                    break;
                }
                if (value instanceof String) {
                    cell.setCellValue((String)value);
                    break;
                }
                if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                    break;
                }
                cell.setCellValue(value == null ? "" : value.toString());
                break;
            }
            case BOOLEAN: {
                if (cellTypeContainer.getProtoType() == MetaDataType.ENUM) {
                    if (StringUtils.isEmpty((Object)value)) {
                        cell.setCellValue("");
                        break;
                    }
                    cell.setCellValue(value + "." + (String)cellTypeContainer.getDictMap().get(String.valueOf(value)));
                    break;
                }
                if (value instanceof Boolean) {
                    cell.setCellValue(String.valueOf(value).toUpperCase());
                    break;
                }
                if (null != value) break;
                cell.setCellValue("");
                break;
            }
            case NUMERIC: {
                if (cellTypeContainer.getProtoType() == MetaDataType.ENUM) {
                    if (StringUtils.isEmpty((Object)value)) {
                        cell.setCellValue("");
                        break;
                    }
                    cell.setCellValue(value + "." + (String)cellTypeContainer.getDictMap().get(String.valueOf(value)));
                    break;
                }
                if (value instanceof Double) {
                    cell.setCellValue(((Double)value).doubleValue());
                    break;
                }
                if (value instanceof Integer) {
                    cell.setCellValue((double)((Integer)value).intValue());
                    break;
                }
                if (value instanceof BigDecimal) {
                    cell.setCellValue(((BigDecimal)value).doubleValue());
                    break;
                }
                if (null == value) {
                    cell.setCellValue("");
                    break;
                }
                if (!(value instanceof String)) break;
                cell.setCellValue((String)value);
                break;
            }
            case BLANK: {
                cell.setCellValue(String.valueOf(value));
                break;
            }
            default: {
                cell.setCellValue(String.valueOf(value));
            }
        }
        if (null != rowMap.get(cellTypeContainer.getKeyName() + ERROR_FIELD_SUFFIX)) {
            ExcelHellper.addComment(cell, String.valueOf(rowMap.get(cellTypeContainer.getKeyName() + ERROR_FIELD_SUFFIX)), ".xlsx");
        }
    }

    public List<CellTypeContainer> getBusinessKeyContainer(List<CellTypeContainer> cellTypes) {
        LinkedList<CellTypeContainer> cellTypeContainers = new LinkedList<CellTypeContainer>();
        for (CellTypeContainer cellType : cellTypes) {
            if (!cellType.getBusinessKey().booleanValue()) continue;
            cellTypeContainers.add(cellType);
        }
        return cellTypeContainers;
    }

    private void createChildSheet(Workbook wb, int rowIndex, List<CellTypeContainer> businessKeyContainer, CellTypeContainer cellTypeContainerMain, String locale, List<Map<String, Object>> errorTable) {
        String sheetName = ExcelHelperV2.getSheetName(cellTypeContainerMain.getKeyName(), cellTypeContainerMain.getKeyDescription(), false);
        Sheet sheet = wb.createSheet(sheetName);
        List cellTypes = cellTypeContainerMain.getChildren();
        this.addBkContainer(cellTypes, businessKeyContainer);
        int parentIdSize = businessKeyContainer.size();
        this.createSheetHeader(wb, sheet, cellTypes, locale, null);
        this.fillSheetData(sheet, rowIndex, parentIdSize, cellTypeContainerMain, cellTypes, errorTable);
    }

    public void addBkContainer(List<CellTypeContainer> cellTypes, List<CellTypeContainer> businessKeyContainer) {
        Iterator<CellTypeContainer> cellTypeIterator = cellTypes.iterator();
        while (cellTypeIterator.hasNext()) {
            CellTypeContainer cellType = cellTypeIterator.next();
            for (CellTypeContainer bkType : businessKeyContainer) {
                if (!cellType.getKeyName().equals(bkType.getKeyName())) continue;
                cellTypeIterator.remove();
            }
        }
        cellTypes.addAll(0, businessKeyContainer);
    }

    private void createSheetHeader(Workbook wb, Sheet sheet, List<CellTypeContainer> cellTypes, String locale, Set<String> requiredFields) {
        DataFormat fmt = wb.createDataFormat();
        int index = 0;
        for (int i = 0; i < cellTypes.size(); ++i) {
            MetaDataType metaDataType = cellTypes.get(i).getProtoType();
            CellTypeContainer cellTypeContainer = cellTypes.get(i);
            if (cellTypeContainer.getKeyName().contains(ERROR_FIELD_SUFFIX)) continue;
            CellStyle cellStyle = wb.createCellStyle();
            cellTypeContainer.setCellStyle(cellStyle);
            switch (metaDataType) {
                case STRING: {
                    if (null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0) {
                        ExcelUtil.excelRuleStringLength(locale, sheet, 0, cellTypeContainer.getPrecision()[0], 2, 65536, index, index);
                    }
                    cellStyle.setDataFormat(fmt.getFormat("@"));
                    sheet.setDefaultColumnStyle(index, cellStyle);
                    break;
                }
                case NUMBER: {
                    ExcelUtil.excelRuleIsNumber(locale, sheet, 2, 65536, index, index);
                    break;
                }
                case DATE: {
                    cellStyle.setDataFormat(fmt.getFormat(cellTypeContainer.getDateFormat()));
                    sheet.setDefaultColumnStyle(index, cellStyle);
                    ExcelUtil.excelRuleDateFormat(locale, sheet, "1720-01-01", "", cellTypeContainer.getDateFormat(), 2, 65536, index, index);
                    break;
                }
                case OBJECT: {
                    if (null == cellTypeContainer.getListEnum() || cellTypeContainer.getListEnum().length == 0) break;
                    ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index);
                    break;
                }
                case BOOLEAN: {
                    ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index);
                    break;
                }
                case ENUM: {
                    if (null == cellTypeContainer.getListEnum() || cellTypeContainer.getListEnum().length == 0) break;
                    ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index);
                    break;
                }
            }
            ++index;
        }
        Row headRow1 = sheet.createRow(0);
        Row headRow2 = sheet.createRow(1);
        index = 0;
        for (int i = 0; i < cellTypes.size(); ++i) {
            if (cellTypes.get(i).getKeyName().contains(ERROR_FIELD_SUFFIX) || cellTypes.get(i).getArray().booleanValue()) continue;
            Cell cell1 = headRow1.createCell(index);
            Cell cell2 = headRow2.createCell(index);
            if (!CollectionUtils.isEmpty(requiredFields) && requiredFields.contains(cellTypes.get(i).getKeyName())) {
                cell1.setCellValue((RichTextString)ExcelUtil.addRequiredMark((XSSFWorkbook)wb, cellTypes.get(i).getKeyDescription(), wb.getFontAt(cell1.getCellStyle().getFontIndex())));
                cell2.setCellValue(cellTypes.get(i).getKeyName());
            } else {
                cell1.setCellValue(cellTypes.get(i).getKeyDescription());
                cell2.setCellValue(cellTypes.get(i).getKeyName());
            }
            ++index;
        }
    }

    public static String getSheetName(String nameEN, String nameZH, Boolean header) {
        int sizeZH = nameZH.length();
        int sizeEN = nameEN.length();
        if (sizeEN > 31) {
            if (header.booleanValue()) {
                return "sheet1";
            }
            return ExcelHelperV2.replaceIllegalSheetName(nameEN);
        }
        if (sizeEN == 31 || sizeEN == 30) {
            return ExcelHelperV2.replaceIllegalSheetName(nameEN);
        }
        StringBuilder sb = new StringBuilder();
        if (nameZH == null || nameZH.isEmpty()) {
            sb.append("(").append(nameEN).append(")");
            return ExcelHelperV2.replaceIllegalSheetName(sb.toString());
        }
        if (sizeEN + sizeZH + 2 > 31) {
            int offset = 31 - sizeEN - 5;
            if (offset <= 0) {
                nameZH = "";
            } else {
                nameZH = nameZH.substring(0, offset);
                nameZH = nameZH + "...";
            }
        }
        sb.append(nameZH).append("(").append(nameEN).append(")");
        return ExcelHelperV2.replaceIllegalSheetName(sb.toString());
    }

    private static String replaceIllegalSheetName(String sheetName) {
        return sheetName.replaceAll("[:\\\\/\\?\\*\\[\\]]", "_");
    }

    private static String replaceIllegalSheetName(String sheetName, String replaceCharacter) {
        String illegalCharacters = "[:]\\/?*";
        if (replaceCharacter.length() > 1 || illegalCharacters.contains(replaceCharacter)) {
            return ExcelHelperV2.replaceIllegalSheetName(sheetName);
        }
        return sheetName.replaceAll("[:\\\\/\\?\\*\\[\\]]", replaceCharacter);
    }

    public static void main(String[] args) {
        System.out.println(ExcelHelperV2.replaceIllegalSheetName("abbddddf?e", "-"));
        System.out.println(ExcelHelperV2.replaceIllegalSheetName("abbddddf?e", "]"));
        System.out.println(ExcelHelperV2.replaceIllegalSheetName("abbddddf?e", "]]]]"));
        System.out.println("\u539f\u672c\uff1a  BOM\u4fe1\u606f\u7ef4\u62a4(DataEntry_tbds_bom_maintenance)");
        System.out.println("\u82f1\u6587\u957f\u5ea6:" + "DataEntry:tbds?bom[maintenancei".length() + "  " + ExcelHelperV2.getSheetName("DataEntry:tbds?bom[maintenancei", "BOM\u4fe1\u606f\u7ef4\u62a4", true) + " size:" + ExcelHelperV2.getSheetName("DataEntry:tbds?bom[maintenancei", "BOM\u4fe1\u606f\u7ef4\u62a4", true).length());
        System.out.println("\u82f1\u6587\u957f\u5ea6:" + "DataEntry:tbds?bom[maintenance".length() + "  " + ExcelHelperV2.getSheetName("DataEntry:tbds?bom[maintenance", "BOM\u4fe1\u606f\u7ef4\u62a4", true) + " size:" + ExcelHelperV2.getSheetName("DataEntry:tbds?bom[maintenance", "BOM\u4fe1\u606f\u7ef4\u62a4", true).length());
        System.out.println("\u82f1\u6587\u957f\u5ea6:" + "DataEntry:tbds?bom[maintenanc".length() + "  " + ExcelHelperV2.getSheetName("DataEntry:tbds?bom[maintenanc", "BOM\u4fe1\u606f\u7ef4\u62a4", true) + " size:" + ExcelHelperV2.getSheetName("DataEntry:tbds?bom[maintenanc", "BOM\u4fe1\u606f\u7ef4\u62a4", true).length());
        System.out.println("\u82f1\u6587\u957f\u5ea6:" + "DataEntry_tbds_bom_mainte".length() + " " + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_mainte", "BOM\u4fe1\u606f\u7ef4\u62a4", true) + " size:" + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_mainte", "BOM\u4fe1\u606f\u7ef4\u62a4", true).length());
        System.out.println("\u82f1\u6587\u957f\u5ea6:" + "DataEntry_tbds_bom_m".length() + " " + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_m", "BOM\u4fe1\u606f\u7ef4\u62a4", true) + " size:" + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_m", "BOM\u4fe1\u606f\u7ef4\u62a4", true).length());
        System.out.println("\u82f1\u6587\u957f\u5ea6:" + "DataEntry_tbds_bom_main".length() + " " + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_main", "BOM\u4fe1\u606f\u7ef4\u62a4", true) + " size:" + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_main", "BOM\u4fe1\u606f\u7ef4\u62a4", true).length());
        System.out.println("\u82f1\u6587\u957f\u5ea6\uff1a" + "DataEntry_tbds_bom_mainten".length() + " " + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_mainten", "BOM\u4fe1\u606f\u7ef4\u62a4", true) + " size:" + ExcelHelperV2.getSheetName("DataEntry_tbds_bom_mainten", "BOM\u4fe1\u606f\u7ef4\u62a4", true).length());
    }

    public SXSSFWorkbook createSXSSFWorkbook() {
        XSSFWorkbook xssfwb = new XSSFWorkbook();
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            xssfwb.write((OutputStream)bos);
        }
        catch (IOException e) {
            log.error("\u8f6c\u6362multipartfile\u5931\u8d25:{}", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"\u8f6c\u6362multipartFile\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error("Exception occurred", (Throwable)e);
                }
            }
        }
        SXSSFWorkbook sxssfwb = new SXSSFWorkbook(xssfwb, JaProperty.getInteger((String)"athena.export.redis-queue.memory-size", (Integer)100).intValue());
        return sxssfwb;
    }

    public void afterPropertiesSet() throws Exception {
        boolean dirExists;
        String tmpDir = System.getProperty(JAVA_IO_TMPDIR);
        if (tmpDir == null) {
            throw new IOException("Systems temporary directory not defined - set the -Djava.io.tmpdir jvm property!");
        }
        File dir = new File(tmpDir, POIFILES);
        boolean bl = dirExists = dir.exists() || dir.mkdirs();
        if (!dirExists) {
            throw new IOException("Could not create temporary directory '" + dir + "'");
        }
        if (!dir.isDirectory()) {
            throw new IOException("Could not create temporary directory. '" + dir + "' exists but is not a directory.");
        }
    }

    public boolean isWorkbookEmpty(SXSSFWorkbook sxssfwb) {
        for (int i = 0; i < sxssfwb.getNumberOfSheets(); ++i) {
            SXSSFSheet sheet = sxssfwb.getSheetAt(i);
            if (sheet.getLastRowNum() <= 1) continue;
            return false;
        }
        return true;
    }

    public static int cloneSheet(SXSSFWorkbook sourceWorkbook, SXSSFWorkbook targetWorkbook, String sheetName) {
        SXSSFSheet sourceSheet = sourceWorkbook.getSheet(sheetName);
        if (sourceSheet == null) {
            throw new IllegalArgumentException("\u6e90Sheet\u4e0d\u5b58\u5728: " + sheetName);
        }
        if (targetWorkbook.getSheet(sheetName) != null) {
            throw new IllegalArgumentException("\u76ee\u6807Workbook\u4e2d\u5df2\u5b58\u5728\u540c\u540dSheet: " + sheetName);
        }
        SXSSFSheet targetSheet = targetWorkbook.createSheet(sheetName);
        IdentityHashMap<CellStyle, CellStyle> styleMap = new IdentityHashMap<CellStyle, CellStyle>();
        int lastRowNum = sourceSheet.getLastRowNum();
        for (int i = 0; i <= lastRowNum; ++i) {
            SXSSFRow sourceRow = sourceSheet.getRow(i);
            SXSSFRow targetRow = targetSheet.createRow(i);
            if (sourceRow == null) continue;
            targetRow.setHeight(sourceRow.getHeight());
            for (Cell sourceCell : sourceRow) {
                Cell targetCell = targetRow.createCell(sourceCell.getColumnIndex());
                ExcelHelperV2.cloneCell(sourceCell, targetCell, targetWorkbook, styleMap);
            }
        }
        SXSSFRow firstRow = sourceSheet.getRow(sourceSheet.getFirstRowNum());
        if (firstRow != null && firstRow.getLastCellNum() > 0) {
            for (int i = 0; i < firstRow.getLastCellNum(); ++i) {
                targetSheet.setColumnWidth(i, sourceSheet.getColumnWidth(i));
            }
        }
        for (int i = 0; i < sourceSheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sourceSheet.getMergedRegion(i);
            boolean exists = false;
            for (int j = 0; j < targetSheet.getNumMergedRegions(); ++j) {
                if (!targetSheet.getMergedRegion(j).equals((Object)region)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            targetSheet.addMergedRegion(region);
        }
        return lastRowNum;
    }

    private static void cloneCell(Cell sourceCell, Cell targetCell, SXSSFWorkbook targetWorkbook, Map<CellStyle, CellStyle> styleMap) {
        switch (sourceCell.getCellTypeEnum()) {
            case STRING: {
                targetCell.setCellValue(sourceCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                targetCell.setCellValue(sourceCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                targetCell.setCellValue(sourceCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                targetCell.setCellFormula(sourceCell.getCellFormula());
                break;
            }
            case BLANK: {
                targetCell.setCellType(CellType.BLANK);
                break;
            }
        }
        if (sourceCell.getCellStyle() != null) {
            CellStyle sourceStyle = sourceCell.getCellStyle();
            CellStyle targetStyle = styleMap.computeIfAbsent(sourceStyle, s -> ExcelHelperV2.createMatchingCellStyle(s, targetWorkbook));
            targetCell.setCellStyle(targetStyle);
        }
        if (sourceCell.getCellComment() != null) {
            targetCell.setCellComment(sourceCell.getCellComment());
        }
        if (sourceCell.getHyperlink() != null) {
            targetCell.setHyperlink(sourceCell.getHyperlink());
        }
    }

    private static CellStyle createMatchingCellStyle(CellStyle sourceStyle, SXSSFWorkbook targetWorkbook) {
        CellStyle targetStyle = targetWorkbook.createCellStyle();
        targetStyle.cloneStyleFrom(sourceStyle);
        return targetStyle;
    }
}

