/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.helpler.validation;

import com.digiwin.athena.abt.application.service.abt.migration.helpler.validation.DataValidationAbstract;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.excel.convert.StringConversionUtils;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DataFormatDataValidation
extends DataValidationAbstract {
    @Override
    public String getType() {
        return "dataFormat";
    }

    @Override
    public String validate(Object rule, Object data, String locale) {
        String errorMsg = super.validate(rule, data, locale);
        CellTypeContainer cellTypeContainer = (CellTypeContainer)rule;
        Map.Entry cellEntry = (Map.Entry)data;
        if (null == cellTypeContainer) {
            return errorMsg;
        }
        Object cellValue = cellEntry.getValue();
        if (null == cellValue || cellValue instanceof String && ((String)cellValue).isEmpty()) {
            return errorMsg;
        }
        MetaDataType metaDataType = cellTypeContainer.getProtoType();
        switch (metaDataType) {
            case STRING: {
                int max;
                if (null == cellTypeContainer.getPrecision() || cellTypeContainer.getPrecision().length == 0) break;
                int n = max = null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0 ? cellTypeContainer.getPrecision()[0] : Integer.MAX_VALUE;
                if (cellValue.toString().length() <= max) break;
                errorMsg = MessageUtil.getMessageByLocale("excel.string.content.length", locale, max);
                break;
            }
            case NUMBER: {
                if (cellValue instanceof Number) break;
                errorMsg = MessageUtil.getMessageByLocale("excel.number.content.isNumber", locale, new Object[0]);
                break;
            }
            case NUMERIC: {
                String stringValue;
                if (!(cellValue instanceof String) || StringConversionUtils.isNumericBigDecimal((String)(stringValue = (String)cellValue))) break;
                errorMsg = MessageUtil.getMessageByLocale("excel.number.content.isNumber", locale, new Object[0]);
                break;
            }
            case TIME: 
            case DATETIME: 
            case DATE: {
                if (ExcelUtil.isValidDate(cellValue.toString(), cellTypeContainer.getDateFormat())) break;
                errorMsg = MessageUtil.getMessageByLocale("excel.date.content.enterCorrect", locale, cellTypeContainer.getDateFormat());
                break;
            }
            case BOOLEAN: {
                List<String> enumList;
                if (cellValue instanceof Boolean || (enumList = Arrays.asList(cellTypeContainer.getListEnum())).contains(cellValue)) break;
                errorMsg = MessageUtil.getMessageByLocale("excel.select.content.selectCorrect", locale, enumList.toString());
                break;
            }
            case ENUM: {
                List<String> enumList;
                List<String> enumCodes;
                if (null == cellTypeContainer.getListEnum() || cellTypeContainer.getListEnum().length == 0 || (enumCodes = this.getEnumCodes(enumList = Arrays.asList(cellTypeContainer.getListEnum()))).contains(cellValue)) break;
                errorMsg = MessageUtil.getMessageByLocale("excel.select.content.selectCorrect", locale, enumList.toString());
                break;
            }
        }
        return errorMsg;
    }

    private List<String> getEnumCodes(List<String> enumList) {
        ArrayList<String> enumCodes = new ArrayList<String>();
        for (String enumStr : enumList) {
            int index = enumStr.lastIndexOf(".");
            String code = index > 0 ? enumStr.substring(0, index) : enumStr;
            enumCodes.add(code);
        }
        return enumCodes;
    }
}

