/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import cn.hutool.core.convert.Convert;
import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ActionInfoDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadTemplateParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ExportHeaderRespDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ExportStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetRecordsParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.PageInfo;
import com.digiwin.athena.abt.application.dto.migration.abt.api.TableDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspBody;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.excel.ExcelParserBean;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ActivityStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ErrorTable;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.UserStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.Table;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.dto.response.BatchImportListRespDTO;
import com.digiwin.athena.abt.application.dto.response.ExportBasicDataRespDTO;
import com.digiwin.athena.abt.application.service.abt.migration.assembler.ImportStatisticsAssembler;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.esp.InitEspProperties;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.AppPermissionUtil;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ErrorHandlerService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportBatchRecordService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportConfigMapper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.TemplateConfigMapper;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.abt.application.service.abt.migration.worker.DataEntryTaskFactory;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.LockPoolDataEntryHelper;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.application.utils.MyCollectionUtils;
import com.digiwin.athena.abt.core.meta.constants.EntryConstant;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportStatisticsMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ImportStatisticsMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportStatisticsPO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportStatisticsPO;
import com.digiwin.athena.aim.sdk.manager.AudcManager;
import com.digiwin.athena.aim.sdk.meta.dto.request.AccessibleReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.AccessibleRespDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.ActivityAccessible;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.knowledgegraph.sdk.manager.KnowledgegraphManager;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.BaseItemRespDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.ImportAndExportConfigRespDTO;
import com.digiwin.athena.smartdata.sdk.util.JsonUtil;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.meta.adapter.JaI18nAdapter;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

@Service
public class BaseDataEntryApplicationServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDataEntryApplicationServiceImpl.class);
    public static final String APP_CODE_PUBLIC_BASIC_DATA = "PBD";
    public static final String APP_NAME_KEY_PUBLIC_BASIC_DATA = "public.basic.data";
    public static final String ACCESS_NO_BUY = "NOBUY";
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    DataEntryTaskFactory dataEntryTaskFactory;
    @Autowired
    ImportStatisticsDomainService importStatisticsDomainService;
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EspService espService;
    @Autowired
    @Qualifier(value="rabbitErrorHandlerServiceImpl")
    ErrorHandlerService errorHandlerService;
    @Autowired
    private InitEspProperties espConfig;
    @Autowired
    LockPool lockPool;
    @Value(value="${data-entry.business.send.retry-times:3}")
    private int maxRetryTimes;
    @Autowired
    private AppPermissionUtil appPermissionUtil;
    @Autowired
    ExcelHelper excelHelper;
    @Autowired
    ImportStatisticsMapper importStatisticsMapper;
    @Autowired
    ImportConfigMapper importConfigMapper;
    @Autowired
    TemplateConfigMapper templateConfigMapper;
    @Autowired
    ExportStatisticsMapper exportStatisticsMapper;
    @Autowired
    ThemeMapService themeMapService;
    @Autowired
    private ExportBatchRecordService exportBatchRecordService;

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void upload(UploadParamDTO uploadParam, ExcelParserBean parser) {
        Date now = new Date();
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        GetActionLocaleResponseDTO getActionLocaleResponseDTO = this.metaDataService.getActionMetaData(uploadParam.getActionId(), athenaUser == null ? uploadParam.getAuthoredUser().getToken() : athenaUser.getToken(), LocaleContextHolder.getLocale().toString());
        ExcelUtil.setDefaultExcelType(parser);
        Workbook workbook = ExcelUtil.createWorkbook(parser);
        ApiDataFieldLocaleMetadataDTO mainMetadata = this.metaDataService.getMainMetadata(getActionLocaleResponseDTO, uploadParam.getActionInfo());
        String mainKey = mainMetadata.getData_name();
        HashMap<String, Set<String>> sheetRequiredFiled = new HashMap<String, Set<String>>();
        if (null == uploadParam.getActionInfo()) {
            uploadParam.setActionInfo(new ActionInfoDTO());
        }
        uploadParam.getActionInfo().setSheetRequiredFiled(sheetRequiredFiled);
        Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetMetadataMap = this.excelHelper.getSheetMetadataMap(workbook, mainMetadata, uploadParam);
        log.info("\u6807\u9898\u96c6\u5408\u5904\u7406");
        Map<String, List<String>> sheetHeaderMap = this.excelHelper.readExcelHeaders(workbook, mainKey);
        log.info("\u6570\u636e\u96c6\u5408\u5904\u7406");
        Map<String, List<Map>> sheetDataMap = this.excelHelper.readExcelDataForImport(workbook, mainKey, sheetMetadataMap);
        log.info("\u51c6\u5907\u53d1\u9001\u6570\u636e");
        this.handleUploadNew(uploadParam, sheetHeaderMap, sheetDataMap, mainMetadata, now);
    }

    public void uploadAsync(List<UploadParamDTO> uploadParams) {
        uploadParams.forEach(e -> {
            e.setAuthoredUser(AppAuthContextHolder.getContext().getAuthoredUser());
            e.setSecurityToken(AppAuthContextHolder.getContext().getSecurityToken());
            try {
                this.rabbitTemplate.convertAndSend("AsyncImportFileExchange", DirectRabbitConfig.ROUTING_NAME, (Object)JsonUtils.objectToString((Object)e));
                log.info("Message sent: {}", e);
            }
            catch (Exception exception) {
                log.error("Failed to send message:{}", (Object)exception.getMessage());
                throw new RuntimeException(exception);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void republish(UploadParamDTO uploadParamDTO) {
        Date now = new Date();
        String masterId = uploadParamDTO.getMasterId();
        this.importStatisticsDomainService.setRepublishedFlag(masterId);
        ImportStatistics importStatistics = this.importStatisticsDomainService.getByMasterId(masterId);
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaData(importStatistics.getActionId(), athenaUser.getToken(), importStatistics.getLocale());
        ApiDataFieldLocaleMetadataDTO mainMetadata = this.metaDataService.getMainMetadata(metadataDTO, uploadParamDTO.getActionInfo());
        String mainKey = mainMetadata.getData_name();
        TableDTO tableDTO = uploadParamDTO.getTableDTO();
        Table table = ImportStatisticsAssembler.tableToDO(tableDTO);
        Map<String, List<String>> sheetHeaderMap = this.getSheetHeaderMap(mainKey, table.getHeaders());
        Map<String, List<Map>> sheetDataMap = this.getSheetDataMap(mainKey, table.getData());
        this.handleUploadNew(uploadParamDTO, sheetHeaderMap, sheetDataMap, mainMetadata, now);
    }

    @Transactional(rollbackFor={Exception.class})
    public void republishById(UploadParamDTO uploadParamDTO) {
        Date now = new Date();
        String masterId = uploadParamDTO.getMasterId();
        this.importStatisticsDomainService.setRepublishedFlag(masterId);
        ImportStatistics importStatistics = this.importStatisticsDomainService.getByMasterId(masterId);
        this.buildParam(importStatistics, uploadParamDTO);
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaData(importStatistics.getActionId(), athenaUser.getToken(), importStatistics.getLocale());
        ApiDataFieldLocaleMetadataDTO mainMetadata = this.metaDataService.getMainMetadata(metadataDTO, uploadParamDTO.getActionInfo());
        String mainKey = mainMetadata.getData_name();
        TableDTO tableDTO = uploadParamDTO.getTableDTO();
        Table table = ImportStatisticsAssembler.tableToDO(tableDTO);
        Map<String, List<String>> sheetHeaderMap = this.getSheetHeaderMap(mainKey, table.getHeaders());
        Map<String, List<Map>> sheetDataMap = this.getSheetDataMap(mainKey, table.getData());
        this.handleUploadNew(uploadParamDTO, sheetHeaderMap, sheetDataMap, mainMetadata, now);
    }

    private void buildParam(ImportStatistics importStatistics, UploadParamDTO uploadParamDTO) {
        uploadParamDTO.setActionId(importStatistics.getActionId());
        uploadParamDTO.setActionInfo((ActionInfoDTO)JsonUtils.jsonToObject((String)importStatistics.getActionInfo(), ActionInfoDTO.class));
        uploadParamDTO.setImportModel(importStatistics.getImportModel());
        uploadParamDTO.setActivityId(importStatistics.getActivityId());
    }

    private Map<String, List<Map>> getSheetDataMap(String sheetName, List<Map> dataMapList) {
        HashMap<String, List<Map>> sheetDataMap = new HashMap<String, List<Map>>();
        LinkedList datas = new LinkedList();
        for (Map dataMap : dataMapList) {
            HashMap sheetData = new HashMap();
            for (Map.Entry dataEntry : dataMap.entrySet()) {
                if (dataEntry == null || dataEntry.getValue() == null || ((String)dataEntry.getKey()).contains("_error_msg")) continue;
                if (dataEntry.getValue() instanceof List) {
                    Map<String, List<Map>> DFieldSheetData = this.getSheetDataMap((String)dataEntry.getKey(), (List)dataEntry.getValue());
                    DFieldSheetData.forEach((DFieldName, DFieldValues) -> {
                        List allDFieldValues = sheetDataMap.computeIfAbsent((String)DFieldName, key -> new ArrayList());
                        allDFieldValues.addAll(DFieldValues);
                    });
                    continue;
                }
                sheetData.put(dataEntry.getKey(), dataEntry.getValue());
            }
            datas.add(sheetData);
        }
        sheetDataMap.put(sheetName, datas);
        return sheetDataMap;
    }

    private Map<String, List<String>> getSheetHeaderMap(String sheetName, List<Map> headerMapList) {
        HashMap<String, List<String>> sheetHeaderMap = new HashMap<String, List<String>>();
        LinkedList<String> headers = new LinkedList<String>();
        for (Map headerMap : headerMapList) {
            if (headerMap.containsKey("headers")) {
                sheetHeaderMap.putAll(this.getSheetHeaderMap((String)headerMap.get("key"), (List)headerMap.get("headers")));
                continue;
            }
            headers.add((String)headerMap.get("key"));
        }
        sheetHeaderMap.put(sheetName, headers);
        return sheetHeaderMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatch(String uuid, List<DataEntryTask> productBatch) {
        log.info("enter send batch");
        ImportStatistics importStatistics = this.importStatisticsDomainService.getByMasterId(uuid);
        int lockId = LockPoolDataEntryHelper.getIdByUUID(uuid, this.lockPool.getPoolSize());
        ReentrantLock lock = this.lockPool.getLockById(lockId);
        if (CollectionUtils.isEmpty(productBatch)) {
            return;
        }
        lock.lock();
        try (Channel channel = this.rabbitTemplate.getConnectionFactory().createConnection().createChannel(false);){
            int batch = 0;
            block18: for (DataEntryTask item : productBatch) {
                ++batch;
                int retryTimes = 0;
                while (true) {
                    try {
                        log.info("\u7b2c{}\u6279\u6b21 try send msg {} time", (Object)batch, (Object)(retryTimes + 1));
                        channel.confirmSelect();
                        Message message = this.rabbitTemplate.getMessageConverter().toMessage((Object)JsonUtil.toString((Object)((Object)item)), new MessageProperties());
                        AMQP.BasicProperties convertedMessageProperties = new DefaultMessagePropertiesConverter().fromMessageProperties(message.getMessageProperties(), "UTF-8");
                        channel.basicPublish("AbtImportDataEntryExchange", DirectRabbitConfig.ROUTING_NAME, true, convertedMessageProperties, message.getBody());
                        log.info("sendBatch before confirm");
                        boolean flag = channel.waitForConfirms();
                        log.info("sendBatch after confirm,flag:{}", (Object)flag);
                        if (flag) continue block18;
                        log.error("ERROR SEND MESSAGE FOR EXCHANGE:[{}] ROUTING_NAME:[{}]", (Object)"AbtImportDataEntryExchange", (Object)DirectRabbitConfig.ROUTING_NAME);
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0051.getErrCode(), (String)"error send msg");
                    }
                    catch (Exception e) {
                        log.error("sendBatch has an exception", (Throwable)e);
                        if (retryTimes + 1 <= this.maxRetryTimes) continue;
                        log.error("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                        log.error("error Items:{}", (Object)item);
                        ImportBatchRecord importBatchRecord = this.importStatisticsDomainService.getBatchRecordByPIdAndSeq(item.getMasterId(), item.getBatchNum());
                        this.importStatisticsFactory.calByTotalAndFailNum(item.getDataList().size(), item.getDataList().size(), importStatistics, importBatchRecord);
                        this.importStatisticsDomainService.updateThisAndBatchRecordsById(importStatistics);
                        log.error("\u8bf7\u6c42\u9000\u51fa\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                        if (retryTimes++ <= this.maxRetryTimes) continue;
                        continue block18;
                    }
                    break;
                }
            }
        }
        catch (TimeoutException e) {
            log.error("send msg TimeoutException:{}", (Throwable)e);
        }
        catch (IOException e) {
            log.error("send msg IOException:{}", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean sendExportFileMQ(ExportStatistics exportStatistics, ExportFileMsg exportFileMsg, String exchangeName) {
        Boolean result;
        log.info("enter sendExportFileMQ");
        int lockId = LockPoolDataEntryHelper.getIdByUUID(exportStatistics.getMasterId(), this.lockPool.getPoolSize());
        ReentrantLock lock = this.lockPool.getLockById(lockId);
        if (Objects.isNull((Object)exportFileMsg)) {
            log.error("exportFileMsg is null");
            return false;
        }
        lock.lock();
        try (Channel channel = this.rabbitTemplate.getConnectionFactory().createConnection().createChannel(false);){
            int retryTimes = 0;
            while (true) {
                try {
                    log.info("try send msg {} time", (Object)(retryTimes + 1));
                    channel.confirmSelect();
                    Message message = this.rabbitTemplate.getMessageConverter().toMessage((Object)JsonUtils.objectToString((Object)((Object)exportFileMsg)), new MessageProperties());
                    AMQP.BasicProperties convertedMessageProperties = new DefaultMessagePropertiesConverter().fromMessageProperties(message.getMessageProperties(), "UTF-8");
                    channel.basicPublish(exchangeName, DirectRabbitConfig.ROUTING_NAME, true, convertedMessageProperties, message.getBody());
                    log.info("waitForConfirms before");
                    boolean flag = channel.waitForConfirms();
                    log.info("waitForConfirms after");
                    if (!flag) {
                        log.error("ERROR SEND MESSAGE FOR EXCHANGE:[{}] ROUTING_NAME:[{}]", (Object)"AbtExportFileExchange", (Object)DirectRabbitConfig.ROUTING_NAME);
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0051.getErrCode(), (String)"error send msg");
                    }
                }
                catch (Exception e) {
                    if (retryTimes + 1 <= this.maxRetryTimes) continue;
                    log.error("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    log.error("error exportFileMsg:{}", (Object)exportFileMsg);
                    exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
                    this.exportStatisticsDomainService.updateById(exportStatistics);
                    log.error("\u8bf7\u6c42\u9000\u51fa\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                    if (retryTimes++ <= this.maxRetryTimes) continue;
                }
                break;
            }
            result = true;
        }
        catch (Exception e) {
            log.error("send msg TimeoutException:{}", (Throwable)e);
            result = false;
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean sendExportFileMQNew(ExportStatistics exportStatistics, ExportFileMsg exportFileMsg, String exchangeName) {
        Boolean result;
        log.info("enter sendExportFileMQ");
        int lockId = LockPoolDataEntryHelper.getIdByUUID(exportStatistics.getMasterId(), this.lockPool.getPoolSize());
        ReentrantLock lock = this.lockPool.getLockById(lockId);
        if (Objects.isNull((Object)exportFileMsg)) {
            log.error("exportFileMsg is null");
            return false;
        }
        lock.lock();
        try {
            this.rabbitTemplate.convertAndSend(exchangeName, DirectRabbitConfig.ROUTING_NAME, (Object)JsonUtils.objectToString((Object)((Object)exportFileMsg)));
            result = true;
        }
        catch (Exception e) {
            log.error("send msg TimeoutException:{}", (Throwable)e);
            result = false;
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    @Deprecated
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void handleUpload(String activityId, String actionId, Map<String, List<List<Object>>> mapData, GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        if (mapData.size() <= 0) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0052.getErrCode(), (String)MessageUtil.getMessage("delivery.uploadError", new Object[0]));
        }
        Map metadataMap = this.getMetadataMap(getActionLocaleResponseDTO);
        List<List<Object>> data = mapData.get(metadataMap.get(this.importStatisticsDomainService.SHEET_NAME));
        if (CollectionUtils.isEmpty(data)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0116.getErrCode(), (String)MessageUtil.getMessageByLocale("upload.template.error", LocaleContextHolder.getLocale().toString(), new Object[0]));
        }
        if (data.size() <= 2) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0052.getErrCode(), (String)MessageUtil.getMessage("delivery.uploadError", new Object[0]));
        }
        LinkedList<String> keyList = new LinkedList<String>();
        LinkedList<List> errorListHolder = new LinkedList<List>();
        if (!this.metaDataService.validate(getActionLocaleResponseDTO, data, keyList, errorListHolder)) {
            log.error("\u672a\u5339\u914d\u7684\u5217:errorList:{}", errorListHolder.get(0));
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0053.getErrCode(), (String)MessageUtil.getMessage("delivery.verifyTableError", new Object[0]));
        }
        String tableKey = this.metaDataService.getTableKey(getActionLocaleResponseDTO);
        HashMap<String, MetaDataType> enumMap = new HashMap<String, MetaDataType>();
        HashMap<String, MetaDataType> nonEnumMap = new HashMap<String, MetaDataType>();
        this.metaDataService.getMetaDataTypeMap(enumMap, nonEnumMap, getActionLocaleResponseDTO, tableKey);
        this.handleEnumColumn(data, enumMap, keyList);
        this.handleNonEnumColumn(data, nonEnumMap, keyList);
        String activityName = this.metaDataService.getActivityNameByActivityId(activityId, null);
        String masterId = UUID.randomUUID().toString();
        this.removeHeaders(data);
        if (mapData.size() > 1) {
            mapData.remove(metadataMap.get(this.importStatisticsDomainService.SHEET_NAME));
            this.dealBody(getActionLocaleResponseDTO, mapData, data, tableKey, keyList, errorListHolder);
        }
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        final List<DataEntryTask> productBatch = this.dataEntryTaskFactory.produce(actionId, athenaUser, tableKey, masterId, keyList, data, DirectRabbitConfig.QUEUE_NAME, this.espConfig.getToken());
        List<ImportBatchRecord> importBatchRecords = this.importStatisticsFactory.produce(productBatch);
        this.importStatisticsDomainService.insertByMasterId(activityId, activityName, actionId, athenaUser, masterId, data.size(), importBatchRecords);
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    log.error("transaction commit over ,sendBatch message");
                    BaseDataEntryApplicationServiceImpl.this.sendBatch(((DataEntryTask)((Object)productBatch.get(0))).getMasterId(), productBatch);
                }
            });
        } else {
            this.sendBatch(productBatch.get(0).getMasterId(), productBatch);
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void handleUploadNew(UploadParamDTO uploadParam, Map<String, List<String>> sheetHeaderMap, Map<String, List<Map>> sheetDataMap, ApiDataFieldLocaleMetadataDTO mainMetadata, Date now) {
        List<Map> data;
        if (CollectionUtils.isEmpty(sheetDataMap)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0052.getErrCode(), (String)MessageUtil.getMessage("delivery.uploadError", new Object[0]));
        }
        Map metadataMap = this.getMetadataMap(mainMetadata);
        String tableKey = (String)metadataMap.get(this.importStatisticsDomainService.SHEET_NAME);
        List<String> keyList = mainMetadata.getField().stream().map(item -> item.getData_name()).collect(Collectors.toList());
        if (null == uploadParam.getActionInfo()) {
            uploadParam.setActionInfo(new ActionInfoDTO());
        }
        if (CollectionUtils.isEmpty(data = this.dealData(mainMetadata, sheetHeaderMap, sheetDataMap, null, null, uploadParam.getActionInfo().getSheetRequiredFiled()))) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0052.getErrCode(), (String)MessageUtil.getMessage("delivery.uploadError", new Object[0]));
        }
        log.info("{}, \u5f85\u5bfc\u5165\u7684\u6570\u636e\u91cf\uff1a{}", (Object)uploadParam.getActionId(), (Object)data.size());
        String activityName = this.metaDataService.getActivityNameByActivityId(uploadParam.getActivityId(), uploadParam.getAuthoredUser() == null ? null : uploadParam.getAuthoredUser().getToken());
        String masterId = UUID.randomUUID().toString();
        uploadParam.setMasterId(masterId);
        final List<DataEntryTask> productBatch = this.dataEntryTaskFactory.produceNew(uploadParam, tableKey, keyList, data);
        log.info("{}, \u6279\u6b21\u603b\u6570\uff1a{}", (Object)uploadParam.getActionId(), (Object)productBatch.size());
        List<ImportBatchRecord> importBatchRecords = this.importStatisticsFactory.produce(productBatch);
        this.importStatisticsDomainService.insertByMasterIdNew(uploadParam, activityName, data.size(), importBatchRecords, now);
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    log.error("transaction commit over ,sendBatch message");
                    BaseDataEntryApplicationServiceImpl.this.sendBatch(((DataEntryTask)((Object)productBatch.get(0))).getMasterId(), productBatch);
                }
            });
        } else {
            this.sendBatch(productBatch.get(0).getMasterId(), productBatch);
        }
    }

    private List<Map> dealData(ApiDataFieldLocaleMetadataDTO metadataDTO, Map<String, List<String>> headerMap, Map<String, List<Map>> sheetDataMap, Map parentBKDataMap, Map parentBKMetadataMap, Map<String, Set<String>> sheetRequiredFiled) {
        if (null == metadataDTO) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0091.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
        }
        ArrayList<Map> dataList = new ArrayList<Map>();
        String sheetName = metadataDTO.getData_name();
        List<Map> sheetDataList = sheetDataMap.get(sheetName);
        HashSet<String> requiredFields = new HashSet();
        if (!CollectionUtils.isEmpty(sheetRequiredFiled)) {
            requiredFields = sheetRequiredFiled.get(sheetName);
        }
        if (CollectionUtils.isEmpty(sheetDataList)) {
            log.error("sheet\u6570\u636e\u4e0d\u5b58\u5728:sheetName:{}", (Object)sheetName);
            return dataList;
        }
        List<String> headerList = headerMap.get(sheetName);
        List<String> businessKeys = this.getBusinessKeys(metadataDTO.getField());
        Map<String, ApiDataFieldLocaleMetadataDTO> bkMetadataMap = this.getBKMetaDataMap(metadataDTO.getField());
        if (MapUtils.isEmpty((Map)parentBKDataMap)) {
            parentBKDataMap = new HashMap();
        }
        LinkedList<String> errorListHolder = new LinkedList<String>();
        ArrayList<String> parentBKList = new ArrayList<String>(parentBKDataMap.keySet());
        if (!this.metaDataService.validateNew(metadataDTO, headerList, parentBKList, errorListHolder)) {
            log.error("\u672a\u5339\u914d\u7684\u5217:errorList:{}", errorListHolder);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0053.getErrCode(), (String)MessageUtil.getMessage("delivery.verifyTableError", new Object[0]));
        }
        HashMap<String, MetaDataType> enumMap = new HashMap<String, MetaDataType>();
        HashMap<String, MetaDataType> nonEnumMap = new HashMap<String, MetaDataType>();
        this.metaDataService.getMetaDataTypeMapNew(enumMap, nonEnumMap, metadataDTO, parentBKMetadataMap);
        for (Map rowData : sheetDataList) {
            this.handleEnumColumnNew(rowData, enumMap, headerList, requiredFields);
            this.handleNonEnumColumnNew(rowData, nonEnumMap, headerList, requiredFields);
            if (MapUtils.isEmpty(parentBKDataMap)) {
                dataList.add(rowData);
            } else {
                if (!this.excelHelper.compareBusinessKey(rowData, parentBKDataMap).booleanValue()) continue;
                dataList.add(rowData);
            }
            HashMap bkDataMap = new HashMap();
            for (String bk : businessKeys) {
                bkDataMap.put(bk, rowData.get(bk));
            }
            if (CollectionUtils.isEmpty(metadataDTO.getField())) continue;
            for (ApiDataFieldLocaleMetadataDTO child : metadataDTO.getField()) {
                if (!child.getIs_array()) continue;
                List<Map> childDataList = this.dealData(child, headerMap, sheetDataMap, bkDataMap, bkMetadataMap, sheetRequiredFiled);
                rowData.put(child.getData_name(), childDataList);
            }
        }
        return dataList;
    }

    private List<String> getBusinessKeys(List<ApiDataFieldLocaleMetadataDTO> cellTypes) {
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtils.isEmpty(cellTypes)) {
            return keys;
        }
        for (ApiDataFieldLocaleMetadataDTO cellType : cellTypes) {
            if (!cellType.getIs_businesskey()) continue;
            keys.add(cellType.getData_name());
        }
        return keys;
    }

    private Map<String, ApiDataFieldLocaleMetadataDTO> getBKMetaDataMap(List<ApiDataFieldLocaleMetadataDTO> cellTypes) {
        HashMap<String, ApiDataFieldLocaleMetadataDTO> bkMetadataMap = new HashMap<String, ApiDataFieldLocaleMetadataDTO>();
        if (CollectionUtils.isEmpty(cellTypes)) {
            return bkMetadataMap;
        }
        for (ApiDataFieldLocaleMetadataDTO cellType : cellTypes) {
            if (!cellType.getIs_businesskey()) continue;
            bkMetadataMap.put(cellType.getData_name(), cellType);
        }
        return bkMetadataMap;
    }

    private void dealBody(GetActionLocaleResponseDTO getActionLocaleResponseDTO, Map<String, List<List<Object>>> mapData, List<List<Object>> data, String tableKey, List<String> keyList, List<List> errorListHolder) {
        if (CollectionUtils.isEmpty(mapData)) {
            log.info("dealBody - mapData is empty!");
            return;
        }
        List businessKeyList = getActionLocaleResponseDTO.getRequest().getParameters().get(0).getField().stream().filter(item -> item.getIs_businesskey()).map(item -> item.getData_name()).collect(Collectors.toList());
        HashSet businessKeySet = new HashSet(businessKeyList);
        HashMap groupedSheetMap = new HashMap();
        mapData.forEach((sheetName, bodyData) -> {
            LinkedList<String> bodyKeyList = new LinkedList<String>();
            if (!this.metaDataService.validateBody((String)sheetName, businessKeySet, getActionLocaleResponseDTO, (List<List<Object>>)bodyData, (List<String>)bodyKeyList, errorListHolder)) {
                log.error("\u672a\u5339\u914d\u7684\u5217:errorList:{}", (Object)errorListHolder);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0056.getErrCode(), (String)MessageUtil.getMessage("delivery.verifyTableError", new Object[0]));
            }
            HashMap<String, MetaDataType> enumMap = new HashMap<String, MetaDataType>();
            HashMap<String, MetaDataType> nonEnumMap = new HashMap<String, MetaDataType>();
            this.metaDataService.getBodyMetaDataTypeMap((Map<String, MetaDataType>)enumMap, (Map<String, MetaDataType>)nonEnumMap, getActionLocaleResponseDTO, (String)sheetName, tableKey);
            this.handleEnumColumn((List<List<Object>>)bodyData, (Map<String, MetaDataType>)enumMap, (List<String>)bodyKeyList);
            this.handleNonEnumColumn((List<List<Object>>)bodyData, (Map<String, MetaDataType>)nonEnumMap, (List<String>)bodyKeyList);
            this.removeHeaders((List<List<Object>>)bodyData);
            List<Map> convertedTable = this.formTable((List<String>)bodyKeyList, (List<List<Object>>)bodyData);
            Map<String, List<Map>> groupedMap = MyCollectionUtils.groupingBy(convertedTable, MyCollectionUtils.formMapGroupFunctions(businessKeyList));
            groupedSheetMap.put(sheetName, groupedMap);
        });
        keyList.addAll(groupedSheetMap.keySet());
        ArrayList<Integer> businessKeyIndexes = new ArrayList<Integer>();
        block0: for (int i = 0; i < businessKeyList.size(); ++i) {
            if (!keyList.contains(businessKeyList.get(i))) continue;
            for (int j = 0; j < keyList.size(); ++j) {
                if (!keyList.get(j).equals(businessKeyList.get(i))) continue;
                businessKeyIndexes.add(j);
                continue block0;
            }
        }
        data.forEach(item -> groupedSheetMap.forEach((sheetName, groupedData) -> {
            Iterator groupedDataIterator = groupedData.entrySet().iterator();
            boolean hitFlag = false;
            while (groupedDataIterator.hasNext()) {
                Map.Entry entry = groupedDataIterator.next();
                if (!((String)entry.getKey()).equals(this.getBusinessGroupValue((List<Object>)item, (List<Integer>)businessKeyIndexes))) continue;
                List currentBody = (List)entry.getValue();
                this.removeBusinessKey(currentBody, businessKeySet);
                item.add(currentBody);
                groupedDataIterator.remove();
                hitFlag = true;
                break;
            }
            if (!hitFlag) {
                item.add(Collections.EMPTY_LIST);
            }
        }));
    }

    private void removeBusinessKey(List<Map> currentBody, Set<String> businessKeySet) {
        if (!CollectionUtils.isEmpty(currentBody)) {
            currentBody.forEach(map -> {
                Set set = map.keySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!businessKeySet.contains(key)) continue;
                    it.remove();
                }
            });
        }
    }

    private String getBusinessGroupValue(List<Object> item, List<Integer> businessKeyIndexes) {
        LinkedList<Object> selectedItem = new LinkedList<Object>();
        for (int i = 0; i < businessKeyIndexes.size(); ++i) {
            selectedItem.add(item.get(businessKeyIndexes.get(i)));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < selectedItem.size(); ++i) {
            if (i != 0) {
                sb.append("&&").append(selectedItem.get(i));
                continue;
            }
            sb.append(selectedItem.get(i));
        }
        return sb.toString();
    }

    private List<Map> formTable(List<String> tableFields, List<List<Object>> table) {
        LinkedList<Map> result = new LinkedList<Map>();
        table.forEach(item -> {
            HashMap entity = new HashMap();
            AtomicInteger idx = new AtomicInteger();
            item.forEach(inner -> {
                entity.put(tableFields.get(idx.get()), inner);
                idx.getAndIncrement();
            });
            result.add(entity);
        });
        return result;
    }

    private void handleEnumColumn(List<List<Object>> data, Map<String, MetaDataType> enumMap, List<String> keyList) {
        for (int i = 0; i < keyList.size(); ++i) {
            MetaDataType metaDataType = enumMap.get(keyList.get(i));
            if (null == metaDataType) continue;
            block14: for (int j = 2; j < data.size(); ++j) {
                String cellData;
                String string = cellData = null == data.get(j).get(i) ? "" : (String)data.get(j).get(i);
                if (StringUtils.isEmpty((String)cellData)) {
                    switch (metaDataType) {
                        case STRING: {
                            data.get(j).set(i, "");
                            break;
                        }
                        case NUMERIC: 
                        case NUMBER: {
                            data.get(j).set(i, EntryConstant.ZERO);
                            break;
                        }
                        case DATE: {
                            data.get(j).set(i, "1900-01-01");
                            break;
                        }
                        case DATETIME: {
                            data.get(j).set(i, "1900-01-01 00:00:00");
                            break;
                        }
                        case TIME: {
                            data.get(j).set(i, "00:00:00");
                            break;
                        }
                        case BOOLEAN: {
                            data.get(j).set(i, EntryConstant.FALSE);
                            break;
                        }
                        default: {
                            data.get(j).set(i, "");
                            break;
                        }
                    }
                    continue;
                }
                int index = cellData.lastIndexOf(".");
                String[] codeValue = cellData.split("[.]");
                if (codeValue.length < 2) {
                    log.error("\u4e0d\u7b26\u5408\u679a\u4e3e\u7c7b\u578brow:{},column:{},cellValue:{}", new Object[]{j + 1, i + 1, cellData});
                    throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0058.getErrCode(), (String)MessageUtil.getMessage("delivery.enumTypeError", new Object[0]));
                }
                String code = cellData.substring(0, index);
                switch (metaDataType) {
                    case NUMERIC: 
                    case NUMBER: {
                        data.get(j).set(i, Integer.parseInt(code));
                        continue block14;
                    }
                    case STRING: {
                        data.get(j).set(i, code);
                        continue block14;
                    }
                    case BOOLEAN: {
                        data.get(j).set(i, Boolean.parseBoolean(code));
                        continue block14;
                    }
                    default: {
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0059.getErrCode(), (String)MessageUtil.getMessage("delivery.enumTypeNotSupport", new Object[0]));
                    }
                }
            }
        }
    }

    private void handleNonEnumColumn(List<List<Object>> data, Map<String, MetaDataType> nonEnumMap, List<String> keyList) {
        for (int i = 0; i < keyList.size(); ++i) {
            MetaDataType metaDataType = nonEnumMap.get(keyList.get(i));
            if (null == metaDataType) continue;
            block9: for (int j = 2; j < data.size(); ++j) {
                String cellData;
                if (null != data.get(j).get(i) && !(data.get(j).get(i) instanceof String)) continue;
                String string = cellData = null == data.get(j).get(i) ? "" : (String)data.get(j).get(i);
                if (!StringUtils.isEmpty((String)cellData)) continue;
                switch (metaDataType) {
                    case STRING: {
                        data.get(j).set(i, "");
                        continue block9;
                    }
                    case NUMERIC: 
                    case NUMBER: {
                        data.get(j).set(i, EntryConstant.ZERO);
                        continue block9;
                    }
                    case DATE: {
                        data.get(j).set(i, "1900-01-01");
                        continue block9;
                    }
                    case DATETIME: {
                        data.get(j).set(i, "1900-01-01 00:00:00");
                        continue block9;
                    }
                    case TIME: {
                        data.get(j).set(i, "00:00:00");
                        continue block9;
                    }
                    case BOOLEAN: {
                        data.get(j).set(i, EntryConstant.FALSE);
                        continue block9;
                    }
                    default: {
                        data.get(j).set(i, "");
                    }
                }
            }
        }
    }

    private void handleEnumColumnNew(Map rowData, Map<String, MetaDataType> enumMap, List<String> keyList, Set<String> requiredFields) {
        if (CollectionUtils.isEmpty(enumMap)) {
            return;
        }
        block13: for (int i = 0; i < keyList.size(); ++i) {
            String cellData;
            String keyName = keyList.get(i);
            MetaDataType metaDataType = enumMap.get(keyList.get(i));
            if (null == metaDataType || null != rowData.get(keyName) && !(rowData.get(keyName) instanceof String)) continue;
            String string = cellData = null == rowData.get(keyName) ? "" : (String)rowData.get(keyName);
            if (StringUtils.isEmpty((String)cellData)) {
                if (!CollectionUtils.isEmpty(requiredFields) && requiredFields.contains(keyName)) continue;
                switch (metaDataType) {
                    case STRING: {
                        rowData.put(keyName, "");
                        break;
                    }
                    case NUMERIC: 
                    case NUMBER: {
                        rowData.put(keyName, EntryConstant.ZERO);
                        break;
                    }
                    case DATE: {
                        rowData.put(keyName, "1900-01-01");
                        break;
                    }
                    case DATETIME: {
                        rowData.put(keyName, "1900-01-01 00:00:00");
                        break;
                    }
                    case TIME: {
                        rowData.put(keyName, "00:00:00");
                        break;
                    }
                    case BOOLEAN: {
                        rowData.put(keyName, EntryConstant.FALSE);
                        break;
                    }
                    default: {
                        rowData.put(keyName, "");
                        break;
                    }
                }
                continue;
            }
            int index = cellData.lastIndexOf(".");
            String code = index > 0 ? cellData.substring(0, index) : cellData;
            switch (metaDataType) {
                case NUMERIC: 
                case NUMBER: {
                    rowData.put(keyName, Integer.parseInt(code));
                    continue block13;
                }
                case STRING: {
                    rowData.put(keyName, code);
                    continue block13;
                }
                case BOOLEAN: {
                    rowData.put(keyName, Boolean.parseBoolean(code));
                    continue block13;
                }
                default: {
                    throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0059.getErrCode(), (String)MessageUtil.getMessage("delivery.enumTypeNotSupport", new Object[0]));
                }
            }
        }
    }

    private void handleNonEnumColumnNew(Map rowData, Map<String, MetaDataType> nonEnumMap, List<String> keyList, Set<String> requiredFields) {
        if (CollectionUtils.isEmpty(nonEnumMap)) {
            return;
        }
        block8: for (int i = 0; i < keyList.size(); ++i) {
            String cellData;
            String keyName = keyList.get(i);
            MetaDataType metaDataType = nonEnumMap.get(keyList.get(i));
            if (null == metaDataType || null != rowData.get(keyName) && !(rowData.get(keyName) instanceof String)) continue;
            String string = cellData = null == rowData.get(keyName) ? "" : (String)rowData.get(keyName);
            if (!StringUtils.isEmpty((String)cellData) || !CollectionUtils.isEmpty(requiredFields) && requiredFields.contains(keyName)) continue;
            switch (metaDataType) {
                case STRING: {
                    rowData.put(keyName, "");
                    continue block8;
                }
                case NUMERIC: 
                case NUMBER: {
                    rowData.put(keyName, EntryConstant.ZERO);
                    continue block8;
                }
                case DATE: {
                    rowData.put(keyName, "1900-01-01");
                    continue block8;
                }
                case DATETIME: {
                    rowData.put(keyName, "1900-01-01 00:00:00");
                    continue block8;
                }
                case TIME: {
                    rowData.put(keyName, "00:00:00");
                    continue block8;
                }
                case BOOLEAN: {
                    rowData.put(keyName, EntryConstant.FALSE);
                    continue block8;
                }
                default: {
                    rowData.put(keyName, "");
                }
            }
        }
    }

    private void removeHeaders(List<List<Object>> data) {
        data.remove(0);
        data.remove(0);
    }

    public List<ImportStatistics> getRecordsByUserId(AuthoredUser user, String locale, Integer getRecordsNum, String activityName, String startTime, String endTime, String type, Integer state, Integer offset) {
        String userId = String.valueOf(user.getSid());
        List<ImportStatistics> importStatisticsList = this.importStatisticsDomainService.getRecordsByUserId(userId, user.getTenantId(), locale, activityName, startTime, endTime, type, state, offset, getRecordsNum);
        if (CollectionUtils.isEmpty(importStatisticsList)) {
            return importStatisticsList;
        }
        if (Objects.nonNull(getRecordsNum) && importStatisticsList.size() > getRecordsNum) {
            importStatisticsList = importStatisticsList.subList(0, getRecordsNum);
        }
        return importStatisticsList;
    }

    private Map<String, Date> getLatestUploadTime(List<String> ids) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List latestUploadRecord = this.importStatisticsMapper.getLatestUploadRecord(ids, String.valueOf(authoredUser.getSid()));
        return latestUploadRecord.stream().collect(Collectors.toMap(ImportStatisticsPO::getActivityId, ImportStatisticsPO::getCreateTime, (oldValue, newValue) -> newValue));
    }

    private Map<String, Date> getLatestExportTime(List<String> ids) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List latestExportRecord = this.exportStatisticsMapper.getLatestExportRecord(ids, String.valueOf(authoredUser.getSid()), authoredUser.getTenantId());
        return latestExportRecord.stream().collect(Collectors.toMap(ExportStatisticsPO::getActivityId, ExportStatisticsPO::getCreateTime, (oldValue, newValue) -> newValue));
    }

    public List<ExportBasicDataRespDTO> getExportBasicDataList() {
        ArrayList<ExportBasicDataRespDTO> result = new ArrayList<ExportBasicDataRespDTO>();
        List iAECRespDTO = (List)KnowledgegraphManager.getImportAndExportConfig().data();
        List respList = (List)KnowledgegraphManager.getActivitiesByPattern().data();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)respList)) {
            return result;
        }
        respList.forEach(this::resetAppDataForPublic);
        Map<String, BaseItemRespDTO> baseItemMap = respList.stream().collect(Collectors.toMap(BaseItemRespDTO::getCode, baseItem -> baseItem, (existing, duplicate) -> existing));
        List<String> codeList = respList.stream().map(BaseItemRespDTO::getCode).distinct().collect(Collectors.toList());
        Map<String, Date> latestUploadTime = this.getLatestExportTime(codeList);
        Map<String, String> accessMap = this.getAccessData(codeList);
        for (ImportAndExportConfigRespDTO importAndExportConfigRespDTO : iAECRespDTO) {
            if (ACCESS_NO_BUY.equals(accessMap.get(importAndExportConfigRespDTO.getCode())) || !"allow".equals(accessMap.get(importAndExportConfigRespDTO.getCode()))) continue;
            ExportBasicDataRespDTO exportBasicDataRespDTO = new ExportBasicDataRespDTO();
            exportBasicDataRespDTO.setActivityId(importAndExportConfigRespDTO.getCode());
            exportBasicDataRespDTO.setName(importAndExportConfigRespDTO.getName());
            exportBasicDataRespDTO.setScene(baseItemMap.get(importAndExportConfigRespDTO.getCode()).getGroupName());
            exportBasicDataRespDTO.setActionId(importAndExportConfigRespDTO.getExportConfig().getActionId());
            exportBasicDataRespDTO.setLatestUploadTime(latestUploadTime.get(importAndExportConfigRespDTO.getCode()));
            exportBasicDataRespDTO.setCategory(baseItemMap.get(importAndExportConfigRespDTO.getCode()).getCategory());
            exportBasicDataRespDTO.setType(baseItemMap.get(importAndExportConfigRespDTO.getCode()).getAppName());
            result.add(exportBasicDataRespDTO);
        }
        return result;
    }

    public List<BatchImportListRespDTO> getBasicDataList(AuthoredUser user) {
        ArrayList<BatchImportListRespDTO> result = new ArrayList<BatchImportListRespDTO>();
        if (user.getTenantSid() == 0L) {
            JaLog.warn((String)"tmDataList-{}:{}:{}:{}: tenantSid is null", (Object[])new Object[]{user.getTenantId(), user.getUserId(), 0, LocaleContextHolder.getLocale()});
            return result;
        }
        List iAECRespDTO = (List)KnowledgegraphManager.getImportAndExportConfig().data();
        List respList = (List)KnowledgegraphManager.getActivitiesByPattern().data();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)respList)) {
            return result;
        }
        respList.forEach(this::resetAppDataForPublic);
        Map<String, BaseItemRespDTO> baseItemMap = respList.stream().collect(Collectors.toMap(BaseItemRespDTO::getCode, baseItem -> baseItem, (existing, duplicate) -> existing));
        List<String> codeList = respList.stream().map(BaseItemRespDTO::getCode).distinct().collect(Collectors.toList());
        Map<String, Date> latestUploadTime = this.getLatestUploadTime(codeList);
        Map<String, String> accessMap = this.getAccessData(codeList);
        for (ImportAndExportConfigRespDTO importAndExportConfigRespDTO : iAECRespDTO) {
            if (ACCESS_NO_BUY.equals(accessMap.get(importAndExportConfigRespDTO.getCode())) || !"allow".equals(accessMap.get(importAndExportConfigRespDTO.getCode()))) continue;
            BatchImportListRespDTO batchImportListRespDTO = new BatchImportListRespDTO();
            batchImportListRespDTO.setActivityId(importAndExportConfigRespDTO.getCode());
            batchImportListRespDTO.setName(importAndExportConfigRespDTO.getName());
            batchImportListRespDTO.setScene(baseItemMap.get(importAndExportConfigRespDTO.getCode()).getGroupName());
            batchImportListRespDTO.setImportAction(this.importConfigMapper.toImportActionList(importAndExportConfigRespDTO.getImportConfig()));
            batchImportListRespDTO.setTemplateAction(this.templateConfigMapper.toImportAction(importAndExportConfigRespDTO.getTemplateConfig()));
            batchImportListRespDTO.setLatestUploadTime(latestUploadTime.get(importAndExportConfigRespDTO.getCode()));
            batchImportListRespDTO.setType(baseItemMap.get(importAndExportConfigRespDTO.getCode()).getAppName());
            result.add(batchImportListRespDTO);
        }
        return result;
    }

    private Map<String, String> getAccessData(List<String> activityId) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(activityId)) {
            return resultMap;
        }
        ArrayList<AccessibleReqDTO> typeActivitiesList = new ArrayList<AccessibleReqDTO>();
        AccessibleReqDTO accessibleReqDTO = new AccessibleReqDTO();
        accessibleReqDTO.setType("0");
        accessibleReqDTO.setTmActivityIdList(activityId);
        typeActivitiesList.add(accessibleReqDTO);
        List activityPermission = (List)AudcManager.checkAccessible(typeActivitiesList).data();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)activityPermission)) {
            return resultMap;
        }
        List activityAccessibleList = ((AccessibleRespDTO)activityPermission.get(0)).getActivityAccessibleList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)activityAccessibleList)) {
            return resultMap;
        }
        for (ActivityAccessible activityAccessible : activityAccessibleList) {
            if (Objects.isNull(activityAccessible)) continue;
            resultMap.put(activityAccessible.getTmActivityId(), activityAccessible.getAccess());
        }
        return resultMap;
    }

    private void resetAppDataForPublic(BaseItemRespDTO baseItemDto) {
        if (baseItemDto.isIfCommon()) {
            baseItemDto.setAppCode(APP_CODE_PUBLIC_BASIC_DATA);
            baseItemDto.setAppName(JaI18nAdapter.getMessage((String)APP_NAME_KEY_PUBLIC_BASIC_DATA, (Object[])new Object[0]));
        }
    }

    public List<ExportStatistics> getExportRecordsByUserId(AuthoredUser user, String locale, GetRecordsParamDTO param) {
        String userId = String.valueOf(user.getSid());
        List<ExportStatistics> exportStatisticsList = this.exportStatisticsDomainService.getRecordsByUserId(userId, user.getTenantId(), locale, param);
        if (CollectionUtils.isEmpty(exportStatisticsList)) {
            return exportStatisticsList;
        }
        if (Objects.nonNull(param.getGetRecordsNum()) && exportStatisticsList.size() > param.getGetRecordsNum()) {
            exportStatisticsList = exportStatisticsList.subList(0, param.getGetRecordsNum());
        }
        return exportStatisticsList;
    }

    public ErrorTable getErrorTableByMasterId(String masterId, String locale) {
        ImportStatistics importStatistics = this.importStatisticsDomainService.getByMasterId(masterId);
        if (null == importStatistics) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage("delivery.dataNotFound", new Object[0]));
        }
        if (0 != importStatistics.getProcessingNum()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0061.getErrCode(), (String)MessageUtil.getMessage("delivery.existRunningData", new Object[0]));
        }
        if (0 == importStatistics.getFailedNum()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0062.getErrCode(), (String)MessageUtil.getMessage("delivery.notFoundErrorData", new Object[0]));
        }
        if (StringUtils.isEmpty((String)importStatistics.getFailedUrl())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0066.getErrCode(), (String)MessageUtil.getMessage("delivery.notFoundErrorExcel", new Object[0]));
        }
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaData(importStatistics.getActionId(), athenaUser.getToken(), locale);
        List<String> BKs = this.metaDataService.getResponseBKList(metadataDTO);
        Map<String, CellTypeContainer> cellTypeContainerMap = this.metaDataService.getResponseCellTypeContainersV2(metadataDTO, athenaUser.getToken(), locale);
        String mainKeyName = metadataDTO.getResponse().getData().getData_name();
        ErrorTable errorTable = this.errorHandlerService.getErrorTableByMasterId(mainKeyName, importStatistics, cellTypeContainerMap, BKs);
        return errorTable;
    }

    public void downloadErrorTable(String masterId, String locale, Set<String> requiredFields, HttpServletResponse response) {
        ImportStatistics importStatistics = this.importStatisticsDomainService.getByMasterId(masterId);
        if (null == importStatistics) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0063.getErrCode(), (String)MessageUtil.getMessage("delivery.dataNotFound", new Object[0]));
        }
        if (0 != importStatistics.getProcessingNum()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0064.getErrCode(), (String)MessageUtil.getMessage("delivery.existRunningData", new Object[0]));
        }
        if (0 == importStatistics.getFailedNum()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0065.getErrCode(), (String)MessageUtil.getMessage("delivery.notFoundErrorData", new Object[0]));
        }
        if (StringUtils.isEmpty((String)importStatistics.getFailedUrl())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0066.getErrCode(), (String)MessageUtil.getMessage("delivery.notFoundErrorExcel", new Object[0]));
        }
        List<Map> headers = this.metaDataService.getHeaders(importStatistics.getActionId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken(), locale);
        this.errorHandlerService.downloadErrorTable(importStatistics, headers, requiredFields, response);
    }

    public void downloadErrorTable(String masterId, String locale, HttpServletResponse response) {
        this.downloadErrorTable(masterId, locale, null, response);
    }

    public byte[] downloadTemplate(DownloadTemplateParamDTO param) {
        return this.metaDataService.downloadTemplate(param.getActionId(), param.getToken(), param.getLocale(), param.getDownloadTemplateDTO());
    }

    public ExportHeaderRespDTO getTableHeaders(String actionId) {
        String locale = JaI18nAdapter.getLocale();
        return this.metaDataService.getTableHeader(actionId, AppAuthContextHolder.getContext().getAuthoredUser().getToken(), locale);
    }

    public UserStatistics getProcessingNum(String userId, String tenantId) {
        return this.importStatisticsDomainService.getProcessingNum(userId, tenantId);
    }

    public UserStatistics getExportingNum(String userId, String tenantId, String type, List<String> types) {
        return this.exportStatisticsDomainService.getProcessingNum(userId, tenantId, type, types);
    }

    public ImportStatistics getImportStatistics(String masterId) {
        return this.importStatisticsDomainService.getByMasterId(masterId);
    }

    private Map<String, List<List<Object>>> transformTableTo2DListMap(String sheetName, Table table, List<String> BKs, List<String> bodyKeys, Map<String, CellTypeContainer> cellTypeContainerMap) {
        String KEY = "key";
        String NAME = "name";
        HashMap<String, List<List<Object>>> mapResult = new HashMap<String, List<List<Object>>>();
        LinkedList result = new LinkedList();
        List<Map> headers = table.getHeaders();
        LinkedList titles = new LinkedList();
        LinkedList keys = new LinkedList();
        headers.forEach(item -> {
            if (!bodyKeys.contains(item.get("key"))) {
                titles.add(item.get("name"));
                keys.add(item.get("key"));
            } else {
                List bodyCellTypeContainers;
                LinkedList body = new LinkedList();
                CellTypeContainer cellTypeContainer = (CellTypeContainer)cellTypeContainerMap.get(item.get("key"));
                if (null == cellTypeContainer) {
                    log.error("no cell type container");
                }
                if (CollectionUtils.isEmpty((Collection)(bodyCellTypeContainers = cellTypeContainer.getChildren()))) {
                    log.error("no container children");
                }
                LinkedList bodyHeaderTitles = new LinkedList();
                LinkedList bodyHeaderKeys = new LinkedList();
                BKs.forEach(bk -> {
                    bodyHeaderTitles.add(((CellTypeContainer)cellTypeContainerMap.get(bk)).getKeyDescription());
                    bodyHeaderKeys.add(((CellTypeContainer)cellTypeContainerMap.get(bk)).getKeyName());
                });
                bodyCellTypeContainers.forEach(cell -> {
                    if (!cell.getKeyName().contains("_error_msg") && !BKs.contains(cell.getKeyName())) {
                        bodyHeaderTitles.add(cell.getKeyDescription());
                        bodyHeaderKeys.add(cell.getKeyName());
                    }
                });
                body.add(bodyHeaderTitles);
                body.add(bodyHeaderKeys);
                mapResult.put(String.valueOf(item.get("key")), body);
            }
        });
        result.add(titles);
        result.add(keys);
        table.getData().forEach(item -> {
            LinkedList line = new LinkedList();
            headers.forEach(header -> {
                if (!bodyKeys.contains(header.get("key"))) {
                    line.add(item.get(header.get("key")));
                } else {
                    List body = (List)mapResult.get(header.get("key"));
                    List bodyData = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(item.get(header.get("key"))), Map.class);
                    if (!CollectionUtils.isEmpty((Collection)bodyData)) {
                        List bodyCellTypeContainers = ((CellTypeContainer)cellTypeContainerMap.get(header.get("key"))).getChildren();
                        bodyData.forEach(bodyLine -> {
                            LinkedList bodyLineData = new LinkedList();
                            Map bodyLineMap = bodyLine;
                            BKs.forEach(bk -> bodyLineData.add(item.get(bk)));
                            bodyCellTypeContainers.forEach(bodyCellTypeContainer -> {
                                if (!bodyCellTypeContainer.getKeyName().contains("_error_msg") && !BKs.contains(bodyCellTypeContainer.getKeyName())) {
                                    bodyLineData.add(bodyLineMap.get(bodyCellTypeContainer.getKeyName()));
                                }
                            });
                            body.add(bodyLineData);
                        });
                        mapResult.put((String)header.get("key"), body);
                    }
                }
            });
            result.add(line);
        });
        mapResult.put(sheetName, result);
        return mapResult;
    }

    private List<List<Object>> transformTableTo2DList(Table table) {
        String KEY = "key";
        String NAME = "name";
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        List<Map> headers = table.getHeaders();
        LinkedList titles = new LinkedList();
        LinkedList keys = new LinkedList();
        headers.forEach(item -> {
            titles.add(item.get("name"));
            keys.add(item.get("key"));
        });
        result.add(titles);
        result.add(keys);
        table.getData().forEach(item -> {
            LinkedList line = new LinkedList();
            headers.forEach(header -> line.add(item.get(header.get("key"))));
            result.add(line);
        });
        return result;
    }

    public ActivityStatistics getActivityStatistics(String activityCode, String userId) {
        return this.importStatisticsDomainService.getActivityStatistics(activityCode, userId);
    }

    public byte[] downloadBaseData(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        byte[] fileBytes = new byte[]{};
        String locale = LocaleContextHolder.getLocale().toString();
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String actionId = downloadBaseDataParamDTO.getActionInfo().getActionId();
        String productName = this.metaDataService.getProductName(athenaUser.getToken(), actionId.substring(actionId.contains("esp_") ? 4 : 0));
        GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaData(actionId, athenaUser.getToken(), locale);
        String mainKey = metadataDTO.getResponse().getData().getData_name();
        String mainKeyDesc = metadataDTO.getResponse().getData().getDescription();
        this.getActionParas(downloadBaseDataParamDTO);
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setLocale(locale);
        exportFileMsg.setTenantId(athenaUser.getTenantId());
        exportFileMsg.setUserToken(athenaUser.getToken());
        exportFileMsg.setActionId(actionId);
        exportFileMsg.setApplication(downloadBaseDataParamDTO.getApplication());
        exportFileMsg.setDownloadBaseDataParamDTO(downloadBaseDataParamDTO);
        exportFileMsg.setType("0");
        EspResponse espResponse = this.espService.getBaseData(downloadBaseDataParamDTO.getActionInfo().getActionParas(), exportFileMsg, productName, null);
        if (!espResponse.isOK()) {
            log.error("downloadBaseData actionId:{},name:{},locale:{},userToken:{}", new Object[]{actionId, downloadBaseDataParamDTO, locale, athenaUser.getToken()});
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0067.getErrCode(), (String)MessageUtil.getMessage("delivery.exportDataError", new Object[0]));
        }
        EspBody espBody = (EspBody)espResponse.getData();
        List<Map<String, Object>> tableList = (List<Map<String, Object>>)espBody.getStd_data().getParameter().get(mainKey);
        Map<String, CellTypeContainer> cellTypeContainerMap = this.metaDataService.getResponseCellTypeContainers(metadataDTO, athenaUser.getToken(), locale);
        ArrayList<String> keyList = new ArrayList<String>();
        Map<String, String> headers = this.metaDataService.getResponseHeaders(metadataDTO, keyList);
        try {
            if (!CollectionUtils.isEmpty((Collection)tableList) && tableList.size() > ImportAndExportStatisticsConstants.EXPORT_LIMIT && "DOUBLE-DOCUMENT".equals(downloadBaseDataParamDTO.getActionInfo().getCategory())) {
                tableList = tableList.subList(0, ImportAndExportStatisticsConstants.EXPORT_LIMIT);
            }
            this.getExportFileds(downloadBaseDataParamDTO.getActionInfo().getSelectField(), keyList, cellTypeContainerMap);
            fileBytes = this.importStatisticsDomainService.handleDownloadBaseData(locale, keyList, headers, cellTypeContainerMap, tableList, ExcelHelper.getSheetName(mainKey, mainKeyDesc, true));
        }
        catch (UnsupportedEncodingException e) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0068.getErrCode(), (String)MessageUtil.getMessage("delivery.downloadError", new Object[0]));
        }
        return fileBytes;
    }

    public ExportStatisticsDTO queryExportStatistics(String masterId) {
        ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(masterId);
        return ExportStatisticsFactory.exportStatisticsToDTO(exportStatistics);
    }

    public Boolean startDownload(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        String type;
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setId(SnowflakeIdWorker.getInstance().newId());
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setExportParams(JsonUtils.objectToString((Object)downloadBaseDataParamDTO));
        exportStatistics.setActivityId(downloadBaseDataParamDTO.getActionInfo().getCode());
        String activityName = null;
        switch (type = Optional.ofNullable(downloadBaseDataParamDTO.getType()).orElse("default")) {
            case "2": {
                activityName = this.themeMapService.getTaskNamesByCodes(exportStatistics.getActivityId());
                exportStatistics.setType("2");
                break;
            }
            case "3": {
                activityName = this.themeMapService.getProjectNamesByCodes(exportStatistics.getActivityId());
                exportStatistics.setType("3");
                break;
            }
            default: {
                activityName = this.metaDataService.getActivityNameByActivityId(exportStatistics.getActivityId(), null);
                exportStatistics.setType("0");
            }
        }
        exportStatistics.setActivityName(activityName);
        exportStatistics.setActionId(downloadBaseDataParamDTO.getActionInfo().getActionId());
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(downloadBaseDataParamDTO.getActionInfo().getFileName());
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        exportStatistics.setExpireTime(DateUtils.addDays((Date)now, (int)ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setActionId(exportStatistics.getActionId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setDownloadBaseDataParamDTO(downloadBaseDataParamDTO);
        Optional.ofNullable(downloadBaseDataParamDTO).map(DownloadBaseDataParamDTO::getActionInfo).map(ActionInfoDTO::getDefence).filter(StringUtils::isNotBlank).ifPresent(exportStatistics::setDefence);
        int insertResult = this.exportStatisticsDomainService.insertByMasterId(exportStatistics);
        if (insertResult == 1) {
            this.exportBatchRecordService.splitBaseDataEntry(downloadBaseDataParamDTO, exportStatistics);
            return this.sendExportFileMQNew(exportStatistics, exportFileMsg, "AbtExportFileExchange");
        }
        return false;
    }

    public void getExportFileds(Map<String, Object> selectField, List<String> keyList, Map<String, CellTypeContainer> cellTypeContainerMap) {
        if (CollectionUtils.isEmpty(selectField)) {
            return;
        }
        Iterator<Map.Entry<String, Object>> selectFieldIterator = selectField.entrySet().iterator();
        while (selectFieldIterator.hasNext()) {
            List exportFileds = (List)selectFieldIterator.next().getValue();
            if (CollectionUtils.isEmpty((Collection)exportFileds)) continue;
            this.filterExportFileds(exportFileds, keyList, cellTypeContainerMap);
        }
    }

    private void filterExportFileds(List<String> exportFileds, List<String> keyList, Map<String, CellTypeContainer> cellTypeContainerMap) {
        Iterator<String> iterator = keyList.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            CellTypeContainer cellTypeContainer = cellTypeContainerMap.get(key);
            Boolean isArray = false;
            if (Objects.nonNull(cellTypeContainer)) {
                isArray = cellTypeContainer.getArray();
            }
            if (exportFileds.contains(key) || !Boolean.FALSE.equals(isArray)) continue;
            iterator.remove();
        }
    }

    public void getActionParas(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        Map<String, Object> paras = downloadBaseDataParamDTO.getActionInfo().getActionParas();
        PageInfo pageInfo = downloadBaseDataParamDTO.getPageInfo();
        List<Map> sortInfo = downloadBaseDataParamDTO.getSortInfo();
        List<Map> searchInfo = downloadBaseDataParamDTO.getSearchInfo();
        if (CollectionUtils.isEmpty(paras)) {
            paras = new HashMap<String, Object>();
            downloadBaseDataParamDTO.getActionInfo().setActionParas(paras);
        }
        if (pageInfo != null && !pageInfo.isNextAllData()) {
            paras.put("use_has_next", true);
            if (pageInfo.getPageSize() != null) {
                paras.put("page_size", pageInfo.getPageSize());
            }
            if (pageInfo.getPageNo() != null) {
                paras.put("page_no", pageInfo.getPageNo());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(sortInfo)) {
            ArrayList newSortInfo = new ArrayList();
            for (Map item : sortInfo) {
                if (!org.springframework.util.StringUtils.hasText((String)item.getOrDefault("sortField", "").toString())) continue;
                if (item.get("sortType") != null && item.get("sortType").toString().toLowerCase().contains("desc")) {
                    item.put("sortType", "desc");
                } else {
                    item.put("sortType", "asc");
                }
                HashMap sortItem = new HashMap();
                sortItem.put("sort_field", item.get("sortField"));
                sortItem.put("sort_type", item.get("sortType"));
                sortItem.put("sort_seq", item.get("sortSeq"));
                newSortInfo.add(sortItem);
            }
            paras.put("sort_info", newSortInfo);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(searchInfo)) {
            paras.put("search_value", "");
            paras.put("search_info", searchInfo);
        }
    }

    private Map getMetadataMap(GetActionLocaleResponseDTO metadata) {
        HashMap<String, String> map = new HashMap<String, String>();
        String mainKey = metadata.getRequest().getParameters().get(0).getData_name();
        String mainKeyDescription = metadata.getRequest().getParameters().get(0).getDescription();
        map.put(this.importStatisticsDomainService.SHEET_NAME, mainKey);
        map.put(mainKey, mainKeyDescription);
        return map;
    }

    private Map getMetadataMap(ApiDataFieldLocaleMetadataDTO mainMetadata) {
        HashMap<String, String> map = new HashMap<String, String>();
        String mainKey = mainMetadata.getData_name();
        String mainKeyDescription = mainMetadata.getDescription();
        map.put(this.importStatisticsDomainService.SHEET_NAME, mainKey);
        map.put(mainKey, mainKeyDescription);
        return map;
    }

    public Boolean historyStartDownload(Map<String, Object> paramMap) {
        String fileName = "";
        Map historydDataInfoMap = MapUtils.getMap(paramMap, (Object)"historydDataInfo", new HashMap());
        String fileNameParam = MapUtils.getString((Map)historydDataInfoMap, (Object)"fileName", (String)"");
        if (StringUtils.isNotEmpty((String)fileNameParam)) {
            fileName = fileNameParam;
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            fileName = "\u5386\u53f2\u9879\u76ee\u4efb\u52a1_" + sdf.format(new Date());
        }
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setId(SnowflakeIdWorker.getInstance().newId());
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setType("1");
        exportStatistics.setActivityName("{\"default\":\"\u5386\u53f2\u9879\u76ee\u4efb\u52a1\",\"zh_TW\":\"\u6b77\u53f2\u9805\u76ee\u4efb\u52d9\",\"en_US\":\"history project|task\",\"zh_CN\":\"\u5386\u53f2\u9879\u76ee\u4efb\u52a1\"}");
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(fileName);
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        exportStatistics.setExpireTime(DateUtils.addDays((Date)now, (int)ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setHistoryDownloadBaseDataParam(paramMap);
        Optional.ofNullable(paramMap).map(t -> t.get("defence")).map(Convert::toStr).filter(StringUtils::isNotBlank).ifPresent(exportStatistics::setDefence);
        int insertResult = this.exportStatisticsDomainService.insertByMasterId(exportStatistics);
        if (insertResult == 1) {
            return this.sendExportFileMQ(exportStatistics, exportFileMsg, "AbtExportHistoryDataFileExchange");
        }
        return false;
    }

    public void updateRetryDownloadState(String masterId) {
        this.exportStatisticsDomainService.updateRetryDownloadState(masterId);
    }
}

