/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ActionInfoDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.dto.request.UploadBatchFileReq;
import com.digiwin.athena.abt.application.dto.request.UploadBatchReq;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BasicDataReadListener;
import com.digiwin.athena.abt.application.service.abt.migration.inout.DmcService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportBatchRecordService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.utils.DataEntryTaskUtils;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.IEService;
import com.digiwin.athena.abt.core.ie.contants.ExeclErrorCodeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportTaskTypeEnum;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainTask;
import com.digiwin.athena.abt.core.ie.excel.model.ExcelReadOptions;
import com.digiwin.athena.abt.core.ie.excel.reader.IEExcelReader;
import com.digiwin.athena.abt.core.ie.excel.reader.IExcelParam;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BaseDataEntryRedisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDataEntryRedisService.class);
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private IEService exportService;
    @Autowired
    private IEExcelReader ieExcelReader;
    @Autowired
    private ImportStatisticsDomainService importStatisticsDomainService;
    @Resource
    private DmcService dmcService;
    @Autowired
    private ExportBatchRecordService exportBatchRecordService;

    public Boolean startDownload(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setId(SnowflakeIdWorker.getInstance().newId());
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setExportParams(JsonUtils.objectToString((Object)downloadBaseDataParamDTO));
        exportStatistics.setActivityId(downloadBaseDataParamDTO.getActionInfo().getCode());
        exportStatistics.setType("0");
        String activityName = this.metaDataService.getActivityNameByActivityId(exportStatistics.getActivityId(), null);
        exportStatistics.setActivityName(activityName);
        exportStatistics.setActionId(downloadBaseDataParamDTO.getActionInfo().getActionId());
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(downloadBaseDataParamDTO.getActionInfo().getFileName());
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        exportStatistics.setExpireTime(DateUtils.addDays((Date)now, (int)ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        exportStatistics.setTotalSize(0);
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setActionId(exportStatistics.getActionId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setDownloadBaseDataParamDTO(downloadBaseDataParamDTO);
        Optional.ofNullable(downloadBaseDataParamDTO).map(DownloadBaseDataParamDTO::getActionInfo).map(ActionInfoDTO::getDefence).filter(StringUtils::isNotBlank).ifPresent(exportStatistics::setDefence);
        int insertResult = this.exportStatisticsDomainService.insertByMasterId(exportStatistics);
        if (insertResult == 1) {
            this.exportBatchRecordService.splitBaseDataEntry(downloadBaseDataParamDTO, exportStatistics);
            return this.sendExportFileMq(exportFileMsg, exportStatistics);
        }
        return false;
    }

    private Boolean sendExportFileMq(ExportFileMsg exportFileMsg, ExportStatistics exportStatistics) {
        log.info("enter sendExportFileMQ");
        if (Objects.isNull((Object)exportFileMsg)) {
            log.error("exportFileMsg is null");
            return Boolean.FALSE;
        }
        String mainTaskId = JaUUID.UUID19();
        try {
            IERedisMainTask mainTask = new IERedisMainTask();
            mainTask.setMainTaskId(mainTaskId);
            mainTask.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            mainTask.setReceiveTime(new Date());
            mainTask.setTimeOut(JaProperty.getInteger((String)"athena.export.redis-queue.base.timeout", (Integer)3600).intValue());
            exportFileMsg.setTenantId(exportFileMsg.getTenantId());
            exportFileMsg.setMainTaskId(mainTaskId);
            exportFileMsg.setSubTaskId(exportFileMsg.getMasterId());
            exportFileMsg.setBusinessType(IEExportBusinessTypeEnum.BASIC.getType());
            exportFileMsg.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            exportFileMsg.setTaskClazz(ExportFileMsg.class.getName());
            exportFileMsg.setReceiveTime(new Date());
            exportFileMsg.setTimeOut(JaProperty.getInteger((String)"athena.export.redis-queue.base.timeout", (Integer)3600));
            mainTask.setSubTaskList((List)Lists.newArrayList((Object[])new ExportFileMsg[]{exportFileMsg}));
            this.exportService.submit(mainTask);
            log.info("send msg success mainTaskId:{},masterId:{}", (Object)mainTaskId, (Object)exportFileMsg.getMasterId());
        }
        catch (Exception e) {
            log.error("send msg Exception mainTaskId:{},masterId:{}", new Object[]{mainTaskId, exportFileMsg.getMasterId(), e});
            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            this.exportStatisticsDomainService.updateById(exportStatistics);
        }
        return Boolean.TRUE;
    }

    public void uploadBatch(UploadBatchReq uploadBatchReq, Map<Integer, UploadBatchFileReq> fileUidMap) {
        UploadParamDTO uploadParam = new UploadParamDTO();
        uploadParam.setActionId(uploadBatchReq.getActionId());
        uploadParam.setActivityId(uploadBatchReq.getActivityId());
        uploadParam.setRequiredFields(uploadBatchReq.getRequiredFields());
        uploadParam.setActionInfo((ActionInfoDTO)JsonUtils.jsonToObject((String)uploadBatchReq.getActionInfo(), ActionInfoDTO.class));
        List<UploadBatchFileReq> files = uploadBatchReq.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            UploadBatchFileReq uploadBatchFileReq = files.get(i);
            uploadParam.setFileName(uploadBatchFileReq.getFileName());
            uploadParam.setFileUid(fileUidMap.get(i).getFileUid());
            ExcelReadOptions options = ExcelReadOptions.builder().headRowNumber(Integer.valueOf(2)).param((IExcelParam)uploadParam).ignoreEmptyRow(Boolean.valueOf(true)).isReadAll(Boolean.valueOf(true)).build();
            BasicDataReadListener read = (BasicDataReadListener)this.ieExcelReader.read(this.dmcService.getExportFileInputStream(uploadBatchFileReq.getFileUrl()), options, "basicDataImport");
            DataEntryTask dataEntryTask = read.getDataEntryTask();
            Date createTime = read.getCreateTime();
            List<ImportBatchRecord> importBatchRecords = DataEntryTaskUtils.processImportBatchRecord(dataEntryTask, createTime);
            if (CollectionUtils.isEmpty(dataEntryTask.getBatchInfos())) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0107.getErrCode(), (String)MessageUtil.getMessage("delivery.handleDataError", new Object[0]));
            }
            this.importStatisticsDomainService.saveImportStatisticsAndRecord((UploadParamDTO)read.getParam(), read.getActivityName(), read.getRecordCounter().intValue(), importBatchRecords, createTime);
            this.sendMsg(read.getMasterId(), dataEntryTask);
        }
    }

    private void sendMsg(String masterId, DataEntryTask dataEntryTask) {
        log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]enter send batch");
        if (null == dataEntryTask || org.apache.commons.collections.CollectionUtils.isEmpty(dataEntryTask.getBatchInfos())) {
            return;
        }
        String mainTaskId = JaUUID.UUID19();
        try {
            IERedisMainTask mainTask = new IERedisMainTask();
            mainTask.setMainTaskId(mainTaskId);
            mainTask.setTaskType(IEExportTaskTypeEnum.IMPORT.getType());
            mainTask.setReceiveTime(new Date());
            mainTask.setTimeOut(JaProperty.getInteger((String)"athena.import.redis-queue.base.timeout", (Integer)3600).intValue());
            dataEntryTask.setTenantId(dataEntryTask.getTenantId());
            dataEntryTask.setMainTaskId(mainTaskId);
            dataEntryTask.setSubTaskId(dataEntryTask.getMasterId());
            dataEntryTask.setBusinessType(IEExportBusinessTypeEnum.BASIC_IMPORT.getType());
            dataEntryTask.setTaskType(IEExportTaskTypeEnum.IMPORT.getType());
            dataEntryTask.setTaskClazz(DataEntryTask.class.getName());
            dataEntryTask.setReceiveTime(new Date());
            dataEntryTask.setTimeOut(JaProperty.getInteger((String)"athena.import.redis-queue.base.timeout", (Integer)3600));
            mainTask.setSubTaskList((List)Lists.newArrayList((Object[])new DataEntryTask[]{dataEntryTask}));
            this.exportService.submit(mainTask);
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]send msg success mainTaskId:{},masterId:{}", (Object)mainTaskId, (Object)dataEntryTask.getMasterId());
        }
        catch (Exception e) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]send msg Exception mainTaskId:{},masterId:{}", new Object[]{mainTaskId, dataEntryTask.getMasterId(), e});
            this.importStatisticsDomainService.updateImportStatisticsAndRecord(masterId, dataEntryTask);
        }
    }

    public void checkUploadParams(UploadBatchReq uploadBatchReq, Map<Integer, UploadBatchFileReq> fileUidMap) {
        if (Objects.equals(1, uploadBatchReq.getIsReImport())) {
            return;
        }
        HashMap<String, ImportStatistics> statsCache = new HashMap<String, ImportStatistics>(fileUidMap.size());
        for (UploadBatchFileReq fileReq : fileUidMap.values()) {
            Integer processingNum;
            String fileUid = fileReq.getFileUid();
            ImportStatistics stat = statsCache.computeIfAbsent(fileUid, uid -> this.importStatisticsDomainService.queryImportStatisticsByFileUid(fileUid));
            if (stat == null || (processingNum = stat.getProcessingNum()) == null || processingNum == 0) continue;
            throw ExeclErrorCodeEnum.CHECK_EXECL_FILE_IMPORTED_PROCESSING.getBusinessExceptionWithArgs(new Object[]{fileReq.getFileName()});
        }
        for (UploadBatchFileReq fileReq : fileUidMap.values()) {
            Integer processingNum;
            ImportStatistics stat = (ImportStatistics)statsCache.get(fileReq.getFileUid());
            if (stat == null || (processingNum = stat.getProcessingNum()) == null || processingNum != 0) continue;
            throw ExeclErrorCodeEnum.CHECK_EXECL_FILE_IMPORTED_SUCCESS.getBusinessExceptionWithArgs(new Object[]{DateUtil.formatDateTime((Date)stat.getUpdateTime()), fileReq.getFileName()});
        }
    }
}

