/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.excel.read.metadata.holder.ReadSheetHolder;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ActionInfoDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.dto.CellPosition;
import com.digiwin.athena.abt.core.ie.excel.convert.ConverterUtils;
import com.digiwin.athena.abt.core.ie.excel.reader.BasetExcelReadListener;
import com.digiwin.athena.abt.core.meta.constants.EntryConstant;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import com.digiwin.athena.abt.core.uiils.MongoCacheUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BasicDataReadListener
extends BasetExcelReadListener<Map<Integer, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicDataReadListener.class);
    private static final String MAIN_SHEET_NAME = "sheet1";
    private static final int BATCH_COUNT = JaProperty.getInteger((String)"athena.import.batch", (Integer)300);
    private static final int FIRST_SHEET_INDEX = 0;
    private static final int FIRST_ROW_INDEX = 0;
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private ExcelHelperV2 excelHelper;
    private final List<Map<String, Object>> cache = new ArrayList<Map<String, Object>>(BATCH_COUNT);
    private final AtomicLong recordCounter = new AtomicLong(0L);
    private final AtomicInteger batchCounter = new AtomicInteger(0);
    private final List<String> originalSheetNames = Lists.newLinkedList();
    private final List<String> normalizedSheetNames = Lists.newLinkedList();
    private final Map<String, List<String>> sheetHeaders = MapUtil.newHashMap((int)2, (boolean)true);
    private final Map<String, List<ApiDataFieldLocaleMetadataDTO>> metadataConfig = MapUtil.newHashMap((int)2, (boolean)true);
    private final Map<String, Map<String, String>> columnTypeMapping = MapUtil.newHashMap((int)2, (boolean)true);
    private List<String> businessKeys = new ArrayList<String>();
    private List<String> parentBusinessKeys = new ArrayList<String>();
    private Map<String, ApiDataFieldLocaleMetadataDTO> parentBKMetadataMap = null;
    private final Map<String, MetaDataType> enumMap = MapUtil.newHashMap((int)2);
    private final Map<String, MetaDataType> nonEnumMap = MapUtil.newHashMap((int)2);
    private ApiDataFieldLocaleMetadataDTO mainMetadata;
    private String mainTableKey;
    private Date createTime = new Date();
    private String childDataSourceName;
    private String activityName;
    private String masterId = UUID.randomUUID().toString();
    private DataEntryTask dataEntryTask;

    protected boolean support(String bizType) {
        return "basicDataImport".equals(bizType);
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        ReadSheetHolder sheetContext = context.readSheetHolder();
        int rowIndex = sheetContext.getRowIndex();
        int sheetNo = sheetContext.getSheetNo();
        String sheetName = sheetContext.getSheetName();
        int headRowNumber = sheetContext.getHeadRowNumber();
        log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]sheetName:[{}],sheetNo:{},rowIndex:{},headRowNumber:{}", new Object[]{sheetName, sheetNo, rowIndex, headRowNumber});
        if (this.isFirstSheetFirstRow(sheetNo, rowIndex)) {
            this.initializeFirstSheet();
        }
        if (this.isHeaderRow(rowIndex, sheetContext)) {
            this.processSheetHeader(headMap, sheetName, sheetNo);
        }
    }

    protected void processRow(Map<Integer, Object> rowData, AnalysisContext context, int index) {
        int sheetNo = context.readSheetHolder().getReadSheet().getSheetNo();
        String normalizedName = this.normalizedSheetNames.get(sheetNo);
        List<String> headerNameList = this.sheetHeaders.get(normalizedName);
        int rowIndex = context.readSheetHolder().getRowIndex() + 1;
        CellPosition cellPosition = CellPosition.builder().execlFileName(((UploadParamDTO)this.getParam()).getFileName()).sheetName(context.readSheetHolder().getSheetName()).rowIndex(rowIndex).build();
        Map<String, Object> processedRow = this.processRowData(cellPosition, rowData, normalizedName, headerNameList);
        this.processBusinessKeys(processedRow, context);
        this.cache.add(processedRow);
        if (this.isMainSheet(normalizedName)) {
            this.recordCounter.incrementAndGet();
        }
        if (this.cache.size() >= BATCH_COUNT) {
            this.persistData(normalizedName);
        }
    }

    public void processAfterAllAnalysed(AnalysisContext context) {
        if (this.recordCounter.get() <= 0L) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0052.getErrCode(), (String)MessageUtil.getMessage("delivery.uploadError", new Object[0]));
        }
        Integer sheetNo = context.readSheetHolder().getReadSheet().getSheetNo();
        String sheetName = context.readSheetHolder().getReadSheet().getSheetName();
        if (sheetNo >= this.normalizedSheetNames.size()) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u5f53\u524dsheet\u6570\u636e\u4e3a\u7a7a:{}", (Object)sheetName);
            return;
        }
        this.persistData(this.normalizedSheetNames.get(sheetNo));
    }

    public void processAfterException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException convertException = (ExcelDataConvertException)exception;
            int rowIndex = convertException.getRowIndex() + 1;
            int columnIndex = convertException.getColumnIndex() + 1;
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]Conversion error at row:{}, column:{}", (Object)rowIndex, (Object)columnIndex);
        }
        throw exception;
    }

    public void processAfterExtra(CellExtra extra, AnalysisContext context) {
    }

    private boolean isFirstSheetFirstRow(int sheetIndex, int rowIndex) {
        return sheetIndex == 0 && rowIndex == 0;
    }

    private boolean isHeaderRow(int rowIndex, ReadSheetHolder context) {
        return rowIndex + 1 == context.getHeadRowNumber();
    }

    private boolean isMainSheet(String sheetName) {
        return sheetName.equals(this.mainMetadata.getData_name());
    }

    private void processSheetHeader(Map<Integer, String> headMap, String sheetName, int sheetNo) {
        this.originalSheetNames.add(sheetName);
        String normalizedName = this.normalizeSheetName(sheetName);
        this.normalizedSheetNames.add(normalizedName);
        List<String> headerKeys = BasicDataReadListener.extractHeaders(headMap);
        this.sheetHeaders.put(normalizedName, headerKeys);
        UploadParamDTO uploadParam = (UploadParamDTO)this.getParam();
        this.excelHelper.getSheetMetadataMap(this.metadataConfig, normalizedName, sheetNo, this.mainMetadata, uploadParam);
        List<ApiDataFieldLocaleMetadataDTO> currentMetadata = this.metadataConfig.get(normalizedName);
        this.validateCurrentMetadata(currentMetadata, normalizedName);
        List<ApiDataFieldLocaleMetadataDTO> currentFields = this.metadataConfig.get(normalizedName);
        this.businessKeys = this.getBusinessKeys(currentFields);
        this.parentBKMetadataMap = this.findParentWithBusinessKey(this.mainMetadata, normalizedName);
        this.parentBusinessKeys = new ArrayList<String>(this.parentBKMetadataMap.keySet());
        LinkedList<String> errorListHolder = new LinkedList<String>();
        if (!this.validateNew(currentFields, headerKeys, this.parentBusinessKeys, errorListHolder)) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u672a\u5339\u914d\u7684\u5217:errorList:{}", errorListHolder);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0053.getErrCode(), (String)MessageUtil.getMessage("delivery.verifyTableError", new Object[0]));
        }
        this.initFieldTypeMap(this.enumMap, this.nonEnumMap, currentFields, this.parentBKMetadataMap);
        this.childDataSourceName = this.findChildrenWithDataName(this.mainMetadata, normalizedName);
        if (JaProperty.getBoolean((String)"athena.import.log.enable", (Boolean)false).booleanValue()) {
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]originalSheetNames     :{}", (Object)JsonUtils.objectToString(this.originalSheetNames));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]normalizedSheetNames   :{}", (Object)JsonUtils.objectToString(this.normalizedSheetNames));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]sheetHeaders           :{}", (Object)JsonUtils.objectToString(this.sheetHeaders));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]metadataConfig         :{}", (Object)JsonUtils.objectToString(this.metadataConfig));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]mainMetadata           :{}", (Object)JsonUtils.objectToString((Object)this.mainMetadata));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]columnTypeMapping      :{}", (Object)JsonUtils.objectToString(this.columnTypeMapping));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]businessKeys           :{}", (Object)JsonUtils.objectToString(this.businessKeys));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]parentBusinessKeys     :{}", (Object)JsonUtils.objectToString(this.parentBusinessKeys));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]recordCounter          :{}", (Object)this.recordCounter);
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]mainTableKey           :{}", (Object)this.mainTableKey);
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]enumMap                :{}", (Object)JsonUtils.objectToString(this.enumMap));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]nonEnumMap             :{}", (Object)JsonUtils.objectToString(this.nonEnumMap));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]parentBKMetadataMap    :{}", (Object)JsonUtils.objectToString(this.parentBKMetadataMap));
            log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]childDataSourceName    :{}", (Object)this.childDataSourceName);
        }
    }

    private void validateCurrentMetadata(List<ApiDataFieldLocaleMetadataDTO> metadata, String normalizedName) {
        if (CollectionUtils.isEmpty(metadata)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0086.getErrCode(), (String)MessageUtil.getMessage("basedata.apiNoDF", new Object[0]));
        }
        Map<String, String> metaMap = metadata.stream().collect(Collectors.toMap(ApiDataFieldLocaleMetadataDTO::getData_name, ApiDataFieldLocaleMetadataDTO::getData_type, (item1, item2) -> item1));
        this.columnTypeMapping.put(normalizedName, metaMap);
        List<String> headers = this.sheetHeaders.get(normalizedName);
        List hasChanges = headers.stream().map(metaMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(hasChanges)) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u89e3\u6790Excel\u7684\u680f\u4f4d\u4e3a\u7a7a\uff01");
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]messages:{},local:{}", (Object)MessageUtil.getMessageByLocale("upload.template.error", LocaleContextHolder.getLocale().toString(), new Object[0]), (Object)LocaleContextHolder.getLocale().toString());
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0116.getErrCode(), (String)MessageUtil.getMessageByLocale("upload.template.error", LocaleContextHolder.getLocale().toString(), new Object[0]));
        }
    }

    private static List<String> extractHeaders(Map<Integer, String> headMap) {
        LinkedList headerKeys = Lists.newLinkedList();
        headMap.forEach((k, v) -> headerKeys.add(v));
        return headerKeys;
    }

    private String normalizeSheetName(String sheetName) {
        String normalizedName = ExcelUtil.getSheetNameInParens(sheetName);
        if (MAIN_SHEET_NAME.equals(normalizedName)) {
            normalizedName = this.mainMetadata.getData_name();
        }
        return normalizedName;
    }

    private void initializeFirstSheet() {
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]athenaUser:{}", (Object)JsonUtils.objectToString((Object)athenaUser));
        UploadParamDTO uploadParam = (UploadParamDTO)this.getParam();
        uploadParam.setMasterId(this.masterId);
        uploadParam.setAuthoredUser(uploadParam.getAuthoredUser() == null ? AppAuthContextHolder.getContext().getAuthoredUser() : uploadParam.getAuthoredUser());
        uploadParam.setSecurityToken(uploadParam.getSecurityToken() == null ? AppAuthContextHolder.getContext().getSecurityToken() : uploadParam.getSecurityToken());
        log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]uploadParam:{}", (Object)JsonUtils.objectToString((Object)uploadParam));
        GetActionLocaleResponseDTO getActionLocaleResponseDTO = this.metaDataService.getActionMetaData(uploadParam.getActionId(), athenaUser == null ? uploadParam.getAuthoredUser().getToken() : athenaUser.getToken(), LocaleContextHolder.getLocale().toString());
        this.mainMetadata = this.metaDataService.getMainMetadata(getActionLocaleResponseDTO, uploadParam.getActionInfo());
        if (null == this.mainMetadata) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0091.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
        }
        if (null == uploadParam.getActionInfo()) {
            uploadParam.setActionInfo(new ActionInfoDTO());
        }
        uploadParam.getActionInfo().setSheetRequiredFiled(MapUtil.newHashMap((int)2));
        Map<String, String> metadataMap = this.getMetadataMap(this.mainMetadata);
        this.mainTableKey = metadataMap.get(MAIN_SHEET_NAME);
        this.activityName = this.metaDataService.getActivityNameByActivityId(uploadParam.getActivityId(), uploadParam.getAuthoredUser() == null ? null : uploadParam.getAuthoredUser().getToken());
    }

    private Map<String, Object> processRowData(CellPosition cellPosition, Map<Integer, Object> rawRow, String sheetName, List<String> headers) {
        HashMap result = MapUtil.newHashMap((int)rawRow.size(), (boolean)true);
        Map<String, String> typeMap = this.columnTypeMapping.get(sheetName);
        rawRow.forEach((colIndex, value) -> {
            String header = (String)headers.get((int)colIndex);
            String dataType = (String)typeMap.get(header);
            cellPosition.setColumnIndex(colIndex + 1);
            Object convertedValue = ConverterUtils.convertCellData((String)dataType, (Object)value, (CellPosition)cellPosition);
            result.put(header, convertedValue);
        });
        Set<String> requiredFields = ((UploadParamDTO)this.getParam()).getActionInfo().getSheetRequiredFiled().get(sheetName);
        this.handleEnumColumnNew(result, this.enumMap, headers, requiredFields);
        this.handleNonEnumColumnNew(result, this.nonEnumMap, headers, requiredFields);
        return result;
    }

    private void processBusinessKeys(Map<String, Object> row, AnalysisContext context) {
        Map<String, Object> bkMap = this.extractKeys(row, this.businessKeys, context);
        Map<String, Object> pBkMap = this.extractKeys(row, this.parentBusinessKeys, context);
        row.put("bk", MongoCacheUtils.convertBkIndex(bkMap));
        row.put("pBk", MongoCacheUtils.convertBkIndex(pBkMap));
    }

    private Map<String, Object> extractKeys(Map<String, Object> row, List<String> keys, AnalysisContext context) {
        HashMap result = MapUtil.newHashMap((int)keys.size(), (boolean)true);
        if (CollectionUtils.isEmpty(keys)) {
            return result;
        }
        keys.forEach(key -> {
            if (row.containsKey(key) && !ObjectUtil.hasEmpty((Object[])new Object[]{row.get(key)})) {
                result.put(key, row.get(key));
            }
        });
        return result;
    }

    private void persistData(String sheetName) {
        if (!this.cache.isEmpty()) {
            boolean isMainSheet = this.isMainSheet(sheetName);
            int batchNo = isMainSheet ? this.batchCounter.getAndIncrement() : 0;
            MongoCacheUtils.insertCache(this.cache, (String)this.masterId, (Integer)batchNo, (String)sheetName, (String)this.childDataSourceName);
            if (isMainSheet) {
                this.produceNew(batchNo, this.cache.size(), (UploadParamDTO)this.getParam());
            }
            this.flushCache();
            this.flushResult();
        }
    }

    private void produceNew(int batchNo, int totalDataSize, UploadParamDTO uploadParam) {
        if (null == this.dataEntryTask) {
            String locale;
            this.dataEntryTask = new DataEntryTask();
            String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
            if (securityToken == null) {
                securityToken = uploadParam.getSecurityToken();
            }
            this.dataEntryTask.setLocale((locale = LocaleContextHolder.getLocale().toString()) == null ? "zh_CN" : locale);
            this.dataEntryTask.setKeyList(this.mainMetadata.getField().stream().map(ApiDataFieldLocaleMetadataDTO::getData_name).collect(Collectors.toList()));
            this.dataEntryTask.setMasterId(uploadParam.getMasterId());
            this.dataEntryTask.setActionId(uploadParam.getActionId());
            this.dataEntryTask.setUserToken(securityToken);
            this.dataEntryTask.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser() == null ? uploadParam.getAuthoredUser().getTenantId() : AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            this.dataEntryTask.setTableKey(this.mainTableKey);
            this.dataEntryTask.setActionInfo(uploadParam.getActionInfo());
            this.dataEntryTask.setApplication(uploadParam.getApplication());
            this.dataEntryTask.setActivityId(uploadParam.getActivityId());
            this.dataEntryTask.setFileUrl(uploadParam.getFileUrl());
            this.dataEntryTask.setType("0");
            ArrayList<DataEntryTask.BatchInfo> batchInfos = new ArrayList<DataEntryTask.BatchInfo>();
            batchInfos.add(this.createBatchInfo(batchNo, totalDataSize));
            this.dataEntryTask.setBatchInfos(batchInfos);
        } else {
            this.dataEntryTask.getBatchInfos().add(this.createBatchInfo(batchNo, totalDataSize));
        }
    }

    private DataEntryTask.BatchInfo createBatchInfo(int batchNo, int totalDataSize) {
        DataEntryTask.BatchInfo batchInfo = new DataEntryTask.BatchInfo();
        batchInfo.setBatchNum(batchNo);
        batchInfo.setTotalDataSize(totalDataSize);
        return batchInfo;
    }

    private void flushResult() {
        if (!this.results.isEmpty()) {
            this.results.clear();
        }
    }

    private void flushCache() {
        if (!this.cache.isEmpty()) {
            this.cache.clear();
        }
    }

    private Map<String, String> getMetadataMap(ApiDataFieldLocaleMetadataDTO mainMetadata) {
        HashMap map = MapUtil.newHashMap((int)2);
        String mainKey = mainMetadata.getData_name();
        String mainKeyDescription = mainMetadata.getDescription();
        map.put(MAIN_SHEET_NAME, mainKey);
        map.put(mainKey, mainKeyDescription);
        return map;
    }

    private List<String> getBusinessKeys(List<ApiDataFieldLocaleMetadataDTO> cellTypes) {
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtils.isEmpty(cellTypes)) {
            return keys;
        }
        for (ApiDataFieldLocaleMetadataDTO cellType : cellTypes) {
            if (!cellType.getIs_businesskey()) continue;
            keys.add(cellType.getData_name());
        }
        return keys;
    }

    private Map<String, ApiDataFieldLocaleMetadataDTO> findParentWithBusinessKey(ApiDataFieldLocaleMetadataDTO root, String targetDataName) {
        ApiDataFieldLocaleMetadataDTO recursive = this.findRecursive(root, targetDataName);
        HashMap bkMetadataMap = MapUtil.newHashMap((int)2);
        if (null == recursive || CollectionUtils.isEmpty(recursive.getField())) {
            return bkMetadataMap;
        }
        for (ApiDataFieldLocaleMetadataDTO cellType : recursive.getField()) {
            if (!cellType.getIs_businesskey()) continue;
            bkMetadataMap.put(cellType.getData_name(), cellType);
        }
        return bkMetadataMap;
    }

    private ApiDataFieldLocaleMetadataDTO findRecursive(ApiDataFieldLocaleMetadataDTO current, String targetDataName) {
        if (current == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(current.getField())) {
            for (ApiDataFieldLocaleMetadataDTO child : current.getField()) {
                if (!MetaDataType.OBJECT.getName().equals(child.getData_type())) continue;
                if (targetDataName.equals(child.getData_name())) {
                    return current;
                }
                return this.findRecursive(child, targetDataName);
            }
        }
        return null;
    }

    private String findChildrenWithDataName(ApiDataFieldLocaleMetadataDTO root, String targetDataName) {
        ApiDataFieldLocaleMetadataDTO targetNode = this.findChildrenRecursive(root, targetDataName);
        if (targetNode == null || CollectionUtils.isEmpty(targetNode.getField())) {
            return null;
        }
        for (ApiDataFieldLocaleMetadataDTO child : targetNode.getField()) {
            if (!MetaDataType.OBJECT.getName().equals(child.getData_type())) continue;
            return child.getData_name();
        }
        return null;
    }

    private ApiDataFieldLocaleMetadataDTO findChildrenRecursive(ApiDataFieldLocaleMetadataDTO current, String targetDataName) {
        if (current == null) {
            return null;
        }
        if (MetaDataType.OBJECT.getName().equals(current.getData_type()) && targetDataName.equals(current.getData_name())) {
            return current;
        }
        if (CollectionUtils.isNotEmpty(current.getField())) {
            for (ApiDataFieldLocaleMetadataDTO child : current.getField()) {
                ApiDataFieldLocaleMetadataDTO result;
                if (!MetaDataType.OBJECT.getName().equals(child.getData_type()) || (result = this.findChildrenRecursive(child, targetDataName)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean validateNew(List<ApiDataFieldLocaleMetadataDTO> field, List<String> excelFieldList, List<String> businessKeyList, List<String> errorListHolder) {
        if (CollectionUtils.isEmpty(excelFieldList)) {
            return false;
        }
        List importFieldListMetaData = field.stream().filter(item -> !item.getIs_array()).map(item -> item.getData_name()).collect(Collectors.toList());
        for (String item2 : excelFieldList) {
            if (importFieldListMetaData.contains(item2) || businessKeyList.contains(item2)) continue;
            errorListHolder.add(item2);
        }
        return CollectionUtils.isEmpty(errorListHolder);
    }

    public void initFieldTypeMap(Map<String, MetaDataType> enumMap, Map<String, MetaDataType> nonEnumMap, List<ApiDataFieldLocaleMetadataDTO> field, Map<String, ApiDataFieldLocaleMetadataDTO> parentBKMetadataMap) {
        field.forEach(param -> {
            if (StringUtils.isEmpty((String)param.getEnum_key())) {
                nonEnumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
            } else {
                enumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
            }
        });
        if (MapUtils.isEmpty(parentBKMetadataMap)) {
            return;
        }
        parentBKMetadataMap.forEach((bkName, bkMetadata) -> {
            if (StringUtils.isEmpty((String)bkMetadata.getEnum_key())) {
                nonEnumMap.put((String)bkName, MetaDataType.valueOf((String)bkMetadata.getData_type().toUpperCase()));
            } else {
                enumMap.put((String)bkName, MetaDataType.valueOf((String)bkMetadata.getData_type().toUpperCase()));
            }
        });
    }

    private void handleEnumColumnNew(Map rowData, Map<String, MetaDataType> enumMap, List<String> keyList, Set<String> requiredFields) {
        if (MapUtils.isEmpty(enumMap)) {
            return;
        }
        block13: for (int i = 0; i < keyList.size(); ++i) {
            String cellData;
            String keyName = keyList.get(i);
            MetaDataType metaDataType = enumMap.get(keyList.get(i));
            if (null == metaDataType || null != rowData.get(keyName) && !(rowData.get(keyName) instanceof String)) continue;
            String string = cellData = null == rowData.get(keyName) ? "" : (String)rowData.get(keyName);
            if (StringUtils.isEmpty((String)cellData)) {
                if (!CollectionUtils.isEmpty(requiredFields) && requiredFields.contains(keyName)) continue;
                switch (metaDataType) {
                    case STRING: {
                        rowData.put(keyName, "");
                        break;
                    }
                    case NUMERIC: 
                    case NUMBER: {
                        rowData.put(keyName, EntryConstant.ZERO);
                        break;
                    }
                    case DATE: {
                        rowData.put(keyName, "1900-01-01");
                        break;
                    }
                    case DATETIME: {
                        rowData.put(keyName, "1900-01-01 00:00:00");
                        break;
                    }
                    case TIME: {
                        rowData.put(keyName, "00:00:00");
                        break;
                    }
                    case BOOLEAN: {
                        rowData.put(keyName, EntryConstant.FALSE);
                        break;
                    }
                    default: {
                        rowData.put(keyName, "");
                        break;
                    }
                }
                continue;
            }
            int index = cellData.lastIndexOf(".");
            String code = index > 0 ? cellData.substring(0, index) : cellData;
            switch (metaDataType) {
                case NUMERIC: 
                case NUMBER: {
                    rowData.put(keyName, Integer.parseInt(code));
                    continue block13;
                }
                case STRING: {
                    rowData.put(keyName, code);
                    continue block13;
                }
                case BOOLEAN: {
                    rowData.put(keyName, Boolean.parseBoolean(code));
                    continue block13;
                }
                default: {
                    throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0059.getErrCode(), (String)MessageUtil.getMessage("delivery.enumTypeNotSupport", new Object[0]));
                }
            }
        }
    }

    private void handleNonEnumColumnNew(Map rowData, Map<String, MetaDataType> nonEnumMap, List<String> keyList, Set<String> requiredFields) {
        if (MapUtils.isEmpty(nonEnumMap)) {
            return;
        }
        block8: for (int i = 0; i < keyList.size(); ++i) {
            String cellData;
            String keyName = keyList.get(i);
            MetaDataType metaDataType = nonEnumMap.get(keyList.get(i));
            if (null == metaDataType || null != rowData.get(keyName) && !(rowData.get(keyName) instanceof String)) continue;
            String string = cellData = null == rowData.get(keyName) ? "" : (String)rowData.get(keyName);
            if (!StringUtils.isEmpty((String)cellData) || !CollectionUtils.isEmpty(requiredFields) && requiredFields.contains(keyName)) continue;
            switch (metaDataType) {
                case STRING: {
                    rowData.put(keyName, "");
                    continue block8;
                }
                case NUMERIC: 
                case NUMBER: {
                    rowData.put(keyName, EntryConstant.ZERO);
                    continue block8;
                }
                case DATE: {
                    rowData.put(keyName, "1900-01-01");
                    continue block8;
                }
                case DATETIME: {
                    rowData.put(keyName, "1900-01-01 00:00:00");
                    continue block8;
                }
                case TIME: {
                    rowData.put(keyName, "00:00:00");
                    continue block8;
                }
                case BOOLEAN: {
                    rowData.put(keyName, EntryConstant.FALSE);
                    continue block8;
                }
                default: {
                    rowData.put(keyName, "");
                }
            }
        }
    }

    @Generated
    public AtomicLong getRecordCounter() {
        return this.recordCounter;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getActivityName() {
        return this.activityName;
    }

    @Generated
    public String getMasterId() {
        return this.masterId;
    }

    @Generated
    public DataEntryTask getDataEntryTask() {
        return this.dataEntryTask;
    }
}

