/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import cn.hutool.core.convert.Convert;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.core.ie.IEService;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportTaskTypeEnum;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainTask;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ExportHistoryDataRedisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportHistoryDataRedisService.class);
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    private IEService exportService;

    public Boolean historyStartDownload(Map<String, Object> paramMap) {
        String fileName = "";
        Map historydDataInfoMap = MapUtils.getMap(paramMap, (Object)"historydDataInfo", new HashMap());
        String fileNameParam = MapUtils.getString((Map)historydDataInfoMap, (Object)"fileName", (String)"");
        if (StringUtils.isNotEmpty((String)fileNameParam)) {
            fileName = fileNameParam;
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            fileName = "\u5386\u53f2\u9879\u76ee\u4efb\u52a1_" + sdf.format(new Date());
        }
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setId(SnowflakeIdWorker.getInstance().newId());
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setType("1");
        exportStatistics.setActivityName("{\"default\":\"\u5386\u53f2\u9879\u76ee\u4efb\u52a1\",\"zh_TW\":\"\u6b77\u53f2\u9805\u76ee\u4efb\u52d9\",\"en_US\":\"history project|task\",\"zh_CN\":\"\u5386\u53f2\u9879\u76ee\u4efb\u52a1\"}");
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(fileName);
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        exportStatistics.setExpireTime(DateUtils.addDays((Date)now, (int)ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        exportStatistics.setTotalSize(0);
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setHistoryDownloadBaseDataParam(paramMap);
        Optional.ofNullable(paramMap).map(t -> t.get("defence")).map(Convert::toStr).filter(StringUtils::isNotBlank).ifPresent(exportStatistics::setDefence);
        int insertResult = this.exportStatisticsDomainService.insertByMasterId(exportStatistics);
        if (insertResult == 1) {
            return this.sendExportFileMq(exportFileMsg, exportStatistics);
        }
        return false;
    }

    private Boolean sendExportFileMq(ExportFileMsg exportFileMsg, ExportStatistics exportStatistics) {
        log.info("enter sendExportFileMQ");
        if (Objects.isNull((Object)exportFileMsg)) {
            log.error("exportFileMsg is null");
            return Boolean.FALSE;
        }
        String mainTaskId = JaUUID.UUID19();
        try {
            IERedisMainTask mainTask = new IERedisMainTask();
            mainTask.setMainTaskId(mainTaskId);
            mainTask.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            mainTask.setReceiveTime(new Date());
            mainTask.setTimeOut(JaProperty.getInteger((String)"athena.export.redis-queue.history.timeout", (Integer)3600).intValue());
            exportFileMsg.setTenantId(exportFileMsg.getTenantId());
            exportFileMsg.setMainTaskId(mainTaskId);
            exportFileMsg.setSubTaskId(exportFileMsg.getMasterId());
            exportFileMsg.setBusinessType(IEExportBusinessTypeEnum.HISTORY.getType());
            exportFileMsg.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            exportFileMsg.setTaskClazz(ExportFileMsg.class.getName());
            exportFileMsg.setReceiveTime(new Date());
            exportFileMsg.setTimeOut(JaProperty.getInteger((String)"athena.export.redis-queue.history.timeout", (Integer)3600));
            mainTask.setSubTaskList((List)Lists.newArrayList((Object[])new ExportFileMsg[]{exportFileMsg}));
            this.exportService.submit(mainTask);
            log.info("send msg success mainTaskId:{},masterId:{}", (Object)mainTaskId, (Object)exportFileMsg.getMasterId());
        }
        catch (Exception e) {
            log.error("send msg Exception mainTaskId:{},masterId:{}", new Object[]{mainTaskId, exportFileMsg.getMasterId(), e});
            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            this.exportStatisticsDomainService.updateById(exportStatistics);
        }
        return Boolean.TRUE;
    }
}

