/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetRecordsParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.DMCTokenBean;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.UserStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.AppPermissionUtil;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.DmcService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ErrorHandlerService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsRepositoryFacade;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.ExcelTypeEnum;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportStatisticsPO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExportStatisticsDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportStatisticsDomainService.class);
    @Autowired
    ExportStatisticsRepositoryFacade exportStatisticsRepositoryFacade;
    @Autowired
    ExcelHelper excelHelper;
    @Autowired
    ExcelHelperV2 excelHelperV2;
    @Autowired
    private AppPermissionUtil appPermissionUtil;
    @Autowired
    ExportStatisticsFactory exportStatisticsFactory;
    @Autowired
    @Qualifier(value="rabbitErrorHandlerServiceImpl")
    ErrorHandlerService errorHandlerService;
    @Autowired
    DMCConfig dmcConfig;
    @Autowired
    DMCTokenBean dmcTokenBean;
    @Autowired
    DmcService dmcService;
    private static final String EXCEL_SUFFIX = ".xlsx";

    public int insertByMasterId(ExportStatistics exportStatistics) {
        ExportStatisticsPO exportStatisticsPO = this.exportStatisticsFactory.getImportStatisticsPO(exportStatistics);
        return this.exportStatisticsRepositoryFacade.save(exportStatisticsPO);
    }

    public void updateRetryDownloadState(String masterId) {
        this.exportStatisticsRepositoryFacade.updateRetryDownloadStateById(masterId);
    }

    public ExportStatistics getByMasterId(String masterId) {
        ExportStatisticsPO exportStatisticsPO = this.exportStatisticsRepositoryFacade.getByMasterId(masterId);
        return null == exportStatisticsPO ? null : this.exportStatisticsFactory.getExportStatistics(exportStatisticsPO);
    }

    public void updateById(ExportStatistics exportStatistics) {
        if (null == exportStatistics) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0063.getErrCode(), (String)MessageUtil.getMessage("delivery.dataNotFound", new Object[0]));
        }
        ExportStatisticsPO exportStatisticsPO = this.exportStatisticsFactory.getImportStatisticsPO(exportStatistics);
        this.exportStatisticsRepositoryFacade.updateById(exportStatisticsPO);
    }

    public void update(ExportStatistics exportStatistics) {
        if (null == exportStatistics) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0063.getErrCode(), (String)MessageUtil.getMessage("delivery.dataNotFound", new Object[0]));
        }
        ExportStatisticsPO exportStatisticsPO = this.exportStatisticsFactory.getImportStatisticsPO(exportStatistics);
        this.exportStatisticsRepositoryFacade.updateByStateAndId(exportStatisticsPO, exportStatisticsPO.getId(), ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
    }

    public List<ExportStatistics> getRecordsByUserId(String userId, String tenantId, String locale, GetRecordsParamDTO param) {
        String loc_default = "default";
        List<ExportStatisticsPO> exportStatisticsPOS = this.exportStatisticsRepositoryFacade.getRecordsByUserId(userId, tenantId, param.getGetRecordsNum(), param);
        Integer countRecord = this.exportStatisticsRepositoryFacade.countRecord(userId, tenantId, param);
        exportStatisticsPOS.forEach(e -> e.setQueryPageTotal(countRecord));
        List<ExportStatistics> exportStatisticsList = this.exportStatisticsFactory.getExportStatisticsList(exportStatisticsPOS, locale);
        for (ExportStatistics item : exportStatisticsList) {
            String name;
            if (item.getActivityName() == null) continue;
            Map localeMap = (Map)JsonUtils.jsonToObject((String)item.getActivityName(), Map.class);
            if (!StringUtils.isEmpty((String)locale)) {
                name = null == localeMap.get(locale) ? (String)localeMap.get("default") : (String)localeMap.get(locale);
                item.setActivityName(name);
                continue;
            }
            name = (String)localeMap.get("default");
            item.setActivityName(name);
        }
        return exportStatisticsList;
    }

    public UserStatistics getProcessingNum(String userId, String tenantId, String type, List<String> types) {
        UserStatistics userStatistics = new UserStatistics();
        userStatistics.setUserId(userId);
        List<Object> exportStatisticsPOS = this.exportStatisticsRepositoryFacade.getProcessingRecordsByUserId(userId, tenantId, type, types);
        if (CollectionUtils.isEmpty(exportStatisticsPOS)) {
            userStatistics.setProcessingNum(0);
            return userStatistics;
        }
        if (Objects.nonNull(type) && !"1".equals(type) && !"4".equals(type) || !CollectionUtils.isEmpty(types) && !types.contains("1") && !types.contains("4")) {
            List<String> activityIds = exportStatisticsPOS.stream().map(ExportStatisticsPO::getActivityId).distinct().collect(Collectors.toList());
            List<String> hasPermissionActivityCodeList = this.appPermissionUtil.handleAppPermission(activityIds);
            exportStatisticsPOS = exportStatisticsPOS.stream().filter(x -> hasPermissionActivityCodeList.contains(x.getActivityId())).collect(Collectors.toList());
        }
        userStatistics.setProcessingNum(exportStatisticsPOS.size());
        return userStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleDownloadBaseData(ExportStatistics exportStatistics, List<String> keyList, Map<String, String> headers, Map<String, CellTypeContainer> cellTypeContainerMap, List<Map<String, Object>> tableList, String sheetName) {
        long start;
        MockMultipartFile multipartFile = null;
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            XSSFWorkbook xssfwb = new XSSFWorkbook();
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream();
                xssfwb.write((OutputStream)bos);
            }
            catch (IOException e) {
                log.error("\u8f6c\u6362multipartfile\u5931\u8d25:{}", (Throwable)e);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"\u8f6c\u6362multipartFile\u5931\u8d25:{}", (Throwable)e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        log.error("Exception occurred", (Throwable)e);
                    }
                }
            }
            SXSSFWorkbook sxssfwb = new SXSSFWorkbook(xssfwb, ImportAndExportStatisticsConstants.SXSSFWorkbook_MEMORY_SIZE.intValue());
            int rowIndex = 2;
            List<CellTypeContainer> businessKeyContainer = this.excelHelper.getBusinessKeyContainer(new ArrayList<CellTypeContainer>(cellTypeContainerMap.values()));
            this.excelHelper.createDataExcel(sheetName, exportStatistics.getLocale(), rowIndex, keyList, cellTypeContainerMap, headers, tableList, (Workbook)sxssfwb, businessKeyContainer, 0, null, null);
            start = System.currentTimeMillis();
            outputStream = new ByteArrayOutputStream();
            sxssfwb.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
            multipartFile = new MockMultipartFile("file", exportStatistics.getFileName(), ExcelTypeEnum.XLSX.value(), inputStream);
            outputStream.flush();
            sxssfwb.dispose();
        }
        catch (Exception e) {
            log.error("handleDownloadBaseData fail:{}", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"handleDownloadBaseData fail:{}", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("close outputStream fail:{}", (Throwable)e);
                    log.error("Exception occurred", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("close inputStream fail:{}", (Throwable)e);
                    log.error("Exception occurred", (Throwable)e);
                }
            }
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(exportStatistics.getFileName());
        fileInfo.setDirectoryId(this.dmcConfig.getErrorTableUUID());
        fileInfo.setExpireDate(TimeUtils.format((Date)exportStatistics.getExpireTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        try {
            String string = this.errorHandlerService.upload((MultipartFile)multipartFile, fileInfo);
            return string;
        }
        finally {
            log.info("\u8001\u7248\u672c\u4e0a\u4f20\u6587\u4ef6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
    }

    public String handleDownloadBaseDataV2(SXSSFWorkbook sxssfwb, FileInfo fileInfo) {
        long start = System.currentTimeMillis();
        Path tempFilePath = null;
        try {
            tempFilePath = Paths.get(MessageFormat.format("temp_{0}.xlsx", JaUUID.UUID19()), new String[0]);
            try (OutputStream os = Files.newOutputStream(tempFilePath, new OpenOption[0]);){
                sxssfwb.write(os);
            }
            sxssfwb.dispose();
        }
        catch (Exception e) {
            log.error("handleDownloadBaseData fail:{}", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"handleDownloadBaseData fail:{}", (Throwable)e);
        }
        try {
            fileInfo.setDirectoryId(this.dmcConfig.getErrorTableUUID());
            String e = this.errorHandlerService.uploadFileToHttpServer(new File(String.valueOf(tempFilePath)), fileInfo);
            return e;
        }
        catch (Exception e) {
            log.error("handleDownloadBaseData fail:", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"handleDownloadBaseData fail:{}", (Throwable)e);
        }
        finally {
            try {
                Files.deleteIfExists(tempFilePath);
                log.info("\u4e34\u65f6\u6587\u4ef6\u5df2\u5220\u9664: {}", (Object)tempFilePath);
            }
            catch (IOException e) {
                log.error("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25", (Throwable)e);
            }
            log.info("\u65b0\u7248\u672c\u4e0a\u4f20\u6587\u4ef6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
    }

    public String handleDownloadBaseDataV3(SXSSFWorkbook sxssfwb, ExportStatistics exportStatistics) {
        int rowIndex = 2;
        MockMultipartFile multipartFile = null;
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            sxssfwb.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
            multipartFile = new MockMultipartFile("file", exportStatistics.getFileName(), ExcelTypeEnum.XLSX.value(), inputStream);
            outputStream.flush();
            sxssfwb.dispose();
        }
        catch (Exception e) {
            log.error("handleDownloadBaseData fail:{}", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"handleDownloadBaseData fail:{}", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("close outputStream fail:{}", (Throwable)e);
                    log.error("Exception occurred", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("close inputStream fail:{}", (Throwable)e);
                    log.error("Exception occurred", (Throwable)e);
                }
            }
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(exportStatistics.getFileName());
        fileInfo.setDirectoryId(this.dmcConfig.getErrorTableUUID());
        fileInfo.setExpireDate(TimeUtils.format((Date)exportStatistics.getExpireTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        return this.errorHandlerService.upload((MultipartFile)multipartFile, fileInfo);
    }
}

