/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.dto.migration.abt.api.ExportStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.TenantService;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportBatchRecordPO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportStatisticsPO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExportStatisticsFactory {
    @Autowired
    private ExportBatchRecordMapper exportBatchRecordMapper;
    @Autowired
    private TenantService tenantService;
    private static final List<ExportStatisticsDTO> emptyExportStatisticsDTOList = Collections.emptyList();
    private final List<ExportStatistics> emptyImportStatistics = Collections.emptyList();

    public ExportStatistics getExportStatistics(ExportStatisticsPO exportStatisticsPO) {
        if (null == exportStatisticsPO) {
            return null;
        }
        ExportStatistics exportStatistics = new ExportStatistics();
        BeanUtils.copyProperties((Object)exportStatisticsPO, (Object)exportStatistics);
        return exportStatistics;
    }

    public ExportStatisticsPO getImportStatisticsPO(ExportStatistics exportStatistics) {
        if (null == exportStatistics) {
            return null;
        }
        ExportStatisticsPO exportStatisticsPO = new ExportStatisticsPO();
        BeanUtils.copyProperties((Object)exportStatistics, (Object)exportStatisticsPO);
        return exportStatisticsPO;
    }

    public List<ExportStatistics> getExportStatisticsList(List<ExportStatisticsPO> exportStatisticsPOS, String locale) {
        if (CollectionUtils.isEmpty(exportStatisticsPOS)) {
            return this.emptyImportStatistics;
        }
        LinkedList<ExportStatistics> exportStatisticsList = new LinkedList<ExportStatistics>();
        exportStatisticsPOS.forEach(item -> {
            ExportStatistics exportStatistics = new ExportStatistics();
            BeanUtils.copyProperties((Object)item, (Object)exportStatistics);
            List batchRecordPOList = this.exportBatchRecordMapper.listByMasterId(item.getMasterId(), null);
            ArrayList<ExportBatchRecord> exportBatchRecordList = new ArrayList<ExportBatchRecord>();
            HashMap<String, String> tenantTokenCache = new HashMap<String, String>();
            for (ExportBatchRecordPO po : batchRecordPOList) {
                String proxyToken;
                ExportBatchRecord record = new ExportBatchRecord();
                BeanUtils.copyProperties((Object)po, (Object)record);
                if (StringUtils.isNotBlank((CharSequence)po.getName())) {
                    try {
                        Map nameLocaleMap = (Map)JsonUtils.jsonToObject((String)po.getName(), (TypeReference)new TypeReference<Map<String, String>>(){});
                        String activityName = StringUtils.isNotBlank((CharSequence)locale) ? (String)nameLocaleMap.getOrDefault(locale, nameLocaleMap.get("zh_CN")) : (String)nameLocaleMap.get("zh_CN");
                        record.setActivityName(activityName);
                    }
                    catch (Exception e) {
                        record.setActivityName(po.getName());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(proxyToken = po.getProxyToken()))) {
                    JSONObject jsonObject;
                    String tenantId = po.getTenantId();
                    String token = (String)tenantTokenCache.get(tenantId);
                    if (token == null && !(jsonObject = this.tenantService.queryApiVirtualToken(tenantId)).isEmpty() && jsonObject.containsKey((Object)"token")) {
                        token = jsonObject.getString("token");
                        tenantTokenCache.put(tenantId, token);
                    }
                    if (token != null) {
                        record.setProxyToken(token);
                    }
                }
                exportBatchRecordList.add(record);
            }
            exportStatistics.setExportBatchRecords(exportBatchRecordList);
            exportStatisticsList.add(exportStatistics);
        });
        return exportStatisticsList;
    }

    public static List<ExportStatisticsDTO> exportStatisticsListToDTO(List<ExportStatistics> exportStatisticsList) {
        if (CollectionUtils.isEmpty(exportStatisticsList)) {
            return emptyExportStatisticsDTOList;
        }
        LinkedList<ExportStatisticsDTO> exportStatisticsDTOList = new LinkedList<ExportStatisticsDTO>();
        Date now = new Date();
        exportStatisticsList.forEach(item -> {
            String consumeTime;
            ExportStatisticsDTO exportStatisticsDTO = new ExportStatisticsDTO();
            BeanUtils.copyProperties((Object)item, (Object)exportStatisticsDTO);
            LocalDateTime startTime = exportStatisticsDTO.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDateTime endTime = exportStatisticsDTO.getUpdateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (Objects.nonNull(exportStatisticsDTO.getExpireTime()) && now.after(exportStatisticsDTO.getExpireTime())) {
                exportStatisticsDTO.setFileState(ImportAndExportStatisticsConstants.FILE_STATE_INVALID);
            } else {
                exportStatisticsDTO.setFileState(ImportAndExportStatisticsConstants.FILE_STATE_VALID);
            }
            if (2 == exportStatisticsDTO.getState()) {
                endTime = LocalDateTime.now();
            }
            if ("0".equals(consumeTime = String.valueOf(Duration.between(startTime, endTime).getSeconds()))) {
                consumeTime = "1";
            }
            exportStatisticsDTO.setConsumeTime(consumeTime);
            List<ExportBatchRecord> exportBatchRecords = item.getExportBatchRecords();
            if (!CollectionUtils.isEmpty(exportBatchRecords)) {
                for (ExportBatchRecord batchRecord : exportBatchRecords) {
                    LocalDateTime batchRecordStartTime = batchRecord.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    LocalDateTime batchRecordEndTime = batchRecord.getState() == 2 ? LocalDateTime.now() : batchRecord.getUpdateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    long seconds = Duration.between(batchRecordStartTime, batchRecordEndTime).getSeconds();
                    int batchRecordConsumeTime = (int)Math.max(seconds, 1L);
                    batchRecord.setConsumeTime(String.valueOf(batchRecordConsumeTime));
                    batchRecord.setFileState(exportStatisticsDTO.getFileState());
                }
                exportStatisticsDTO.setExportBatchRecords(exportBatchRecords);
            }
            exportStatisticsDTOList.add(exportStatisticsDTO);
        });
        return exportStatisticsDTOList;
    }

    public static ExportStatisticsDTO exportStatisticsToDTO(ExportStatistics exportStatistics) {
        if (Objects.isNull(exportStatistics)) {
            return new ExportStatisticsDTO();
        }
        ExportStatisticsDTO exportStatisticsDTO = new ExportStatisticsDTO();
        BeanUtils.copyProperties((Object)exportStatistics, (Object)exportStatisticsDTO);
        Date now = new Date();
        if (Objects.nonNull(exportStatisticsDTO.getExpireTime()) && now.after(exportStatisticsDTO.getExpireTime())) {
            exportStatisticsDTO.setFileState(ImportAndExportStatisticsConstants.FILE_STATE_INVALID);
        } else {
            exportStatisticsDTO.setFileState(ImportAndExportStatisticsConstants.FILE_STATE_VALID);
        }
        return exportStatisticsDTO;
    }
}

