/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportBatchRecordPO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Date;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class HistoryProjectTaskServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoryProjectTaskServiceImpl.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    private ExportBatchRecordMapper exportBatchRecordMapper;
    @Autowired
    LockPool lockPool;

    public Boolean startDownloadHistoryData(DownloadHistoryProjectTaskParamDTO paramDTO) {
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setExportParams(JsonUtils.objectToString((Object)paramDTO));
        exportStatistics.setType("4");
        exportStatistics.setActivityName("{\"default\":\"\u5386\u53f2\u9879\u76ee\u4efb\u52a1\",\"zh_TW\":\"\u6b77\u53f2\u9805\u76ee\u4efb\u52d9\",\"en_US\":\"history project|task\",\"zh_CN\":\"\u5386\u53f2\u9879\u76ee\u4efb\u52a1\"}");
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(paramDTO.getFileName());
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        exportStatistics.setExpireTime(DateUtils.addDays((Date)now, (int)ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        exportStatistics.setTotalSize(paramDTO.getList().size());
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setDownloadHistoryProjectTaskParamDTO(paramDTO);
        int insertExportStatistics = this.exportStatisticsDomainService.insertByMasterId(exportStatistics);
        boolean result = false;
        if (insertExportStatistics == 1) {
            for (int i = 0; i < paramDTO.getList().size(); ++i) {
                DownloadHistoryProjectTaskParamDTO.DownloadHistoryProjectTaskSubParamDTO subParamDTO = paramDTO.getList().get(i);
                ExportBatchRecord exportBatchRecord = new ExportBatchRecord();
                exportBatchRecord.setMasterId(exportStatistics.getMasterId());
                exportBatchRecord.setBatchSeq(i);
                exportBatchRecord.setType(subParamDTO.getType());
                exportBatchRecord.setRelate(subParamDTO.getId().toString());
                exportBatchRecord.setExportParams(JsonUtils.objectToString((Object)subParamDTO));
                exportBatchRecord.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
                exportBatchRecord.setCreateTime(now);
                exportBatchRecord.setUpdateTime(now);
                exportBatchRecord.setCode(subParamDTO.getCode());
                exportBatchRecord.setFileName(subParamDTO.getFileName());
                exportBatchRecord.setProxyToken(subParamDTO.getProxyToken());
                exportBatchRecord.setTenantId(subParamDTO.getTenantId());
                exportBatchRecord.setArchiveRouteKey(paramDTO.getArchiveRouteKey());
                exportBatchRecord.setName(subParamDTO.getName());
                exportFileMsg.setExportBatchRecord(exportBatchRecord);
                ExportBatchRecordPO exportBatchRecordPO = new ExportBatchRecordPO();
                BeanUtils.copyProperties((Object)exportBatchRecord, (Object)exportBatchRecordPO);
                int insertExportBatchRecordPO = this.exportBatchRecordMapper.insert((Object)exportBatchRecordPO);
                if (insertExportBatchRecordPO == 1) {
                    exportBatchRecord.setId(exportBatchRecordPO.getId());
                    result = this.sendExportFileMQ(exportStatistics, exportFileMsg);
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean sendExportFileMQ(ExportStatistics exportStatistics, ExportFileMsg exportFileMsg) {
        boolean result;
        String masterId = exportStatistics.getMasterId();
        Integer batchSeq = exportFileMsg.getExportBatchRecord().getBatchSeq();
        log.info("startDownloadHistoryData sendExportFileMQ,masterId:{}", (Object)masterId);
        try {
            this.rabbitTemplate.convertAndSend("AbtExportHistoryProjectTaskDetailExchange", DirectRabbitConfig.EXPORT_HISTORY_PROJECT_TASK_DETAIL_ROUTING_KEY, (Object)JsonUtils.objectToString((Object)((Object)exportFileMsg)));
            result = true;
        }
        catch (Exception e) {
            log.error("startDownloadHistoryData send msg TimeoutException,masterId:" + masterId, (Throwable)e);
            result = false;
        }
        return result;
    }
}

