/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.convert.ImportBatchRecordCovert;
import com.digiwin.athena.abt.application.convert.ImportStatisticsCovert;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ActivityStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.UserStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.AppPermissionUtil;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportBatchRecordRepositoryFacade;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsRepositoryFacade;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.dto.ImportCounters;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportBatchRecordPO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportStatisticsPO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ImportStatisticsDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportStatisticsDomainService.class);
    @Autowired
    ImportStatisticsRepositoryFacade importStatisticsRepositoryFacade;
    @Autowired
    ImportBatchRecordRepositoryFacade importBatchRecordRepositoryFacade;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    ExcelHelper excelHelper;
    @Autowired
    private AppPermissionUtil appPermissionUtil;
    public final String SHEET_NAME = "sheet1";
    private final String EXCEL_SUFFIX = ".xlsx";

    public void insertByMasterId(String activityId, String activityName, String actionId, AuthoredUser athenaUser, String masterId, int i, List<ImportBatchRecord> importBatchRecords) {
        String locale;
        ImportStatisticsPO importStatisticsPO = new ImportStatisticsPO();
        importStatisticsPO.setSucceededNum(Integer.valueOf(0));
        importStatisticsPO.setProcessingNum(Integer.valueOf(i));
        importStatisticsPO.setFailedNum(Integer.valueOf(0));
        importStatisticsPO.setErrorNum(Integer.valueOf(0));
        importStatisticsPO.setMasterId(masterId);
        importStatisticsPO.setActivityId(activityId);
        importStatisticsPO.setActivityName(activityName);
        importStatisticsPO.setActionId(actionId);
        if (!StringUtils.isEmpty((String)MDC.get((String)"routerKey"))) {
            importStatisticsPO.setRouterKey(MDC.get((String)"routerKey"));
        }
        importStatisticsPO.setLocale((locale = LocaleContextHolder.getLocale().toString()) == null ? "zh_CN" : locale);
        importStatisticsPO.setUserId(String.valueOf(athenaUser.getSid()));
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        importStatisticsPO.setUserToken(securityToken);
        Date now = new Date();
        importStatisticsPO.setCreateTime(now);
        importStatisticsPO.setUpdateTime(now);
        List<ImportBatchRecordPO> importBatchRecordPOS = this.importStatisticsFactory.getBatchRecordPOS(importBatchRecords);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        importStatisticsPO.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        importStatisticsPO.setRepublished(Integer.valueOf(0));
        this.importStatisticsRepositoryFacade.save(importStatisticsPO);
        this.importBatchRecordRepositoryFacade.saveBatch(importBatchRecordPOS);
    }

    public void insertByMasterIdNew(UploadParamDTO uploadParam, String activityName, int i, List<ImportBatchRecord> importBatchRecords, Date now) {
        String locale;
        ImportStatisticsPO importStatisticsPO = new ImportStatisticsPO();
        importStatisticsPO.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        importStatisticsPO.setSucceededNum(Integer.valueOf(0));
        importStatisticsPO.setProcessingNum(Integer.valueOf(i));
        importStatisticsPO.setFailedNum(Integer.valueOf(0));
        importStatisticsPO.setErrorNum(Integer.valueOf(0));
        importStatisticsPO.setMasterId(uploadParam.getMasterId());
        importStatisticsPO.setActivityId(uploadParam.getActivityId());
        importStatisticsPO.setActivityName(activityName);
        importStatisticsPO.setActionId(uploadParam.getActionId());
        importStatisticsPO.setFileUrl(uploadParam.getFileUrl());
        if (!StringUtils.isEmpty((String)MDC.get((String)"routerKey"))) {
            importStatisticsPO.setRouterKey(MDC.get((String)"routerKey"));
        }
        importStatisticsPO.setLocale((locale = LocaleContextHolder.getLocale().toString()) == null ? "zh_CN" : locale);
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (athenaUser == null) {
            athenaUser = uploadParam.getAuthoredUser();
        }
        importStatisticsPO.setUserId(String.valueOf(athenaUser.getSid()));
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        if (securityToken == null) {
            securityToken = uploadParam.getSecurityToken();
        }
        importStatisticsPO.setUserToken(securityToken);
        importStatisticsPO.setCreateTime(now);
        importStatisticsPO.setUpdateTime(now);
        List<ImportBatchRecordPO> importBatchRecordPOS = this.importStatisticsFactory.getBatchRecordPOS(importBatchRecords);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        importStatisticsPO.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        importStatisticsPO.setRepublished(Integer.valueOf(0));
        if (null != uploadParam.getActionInfo()) {
            importStatisticsPO.setActionInfo(JsonUtils.objectToString((Object)uploadParam.getActionInfo()));
        }
        this.importStatisticsRepositoryFacade.save(importStatisticsPO);
        this.importBatchRecordRepositoryFacade.saveBatch(importBatchRecordPOS);
    }

    public ImportStatistics getByMasterId(String masterId) {
        ImportStatisticsPO importStatisticsPO = this.importStatisticsRepositoryFacade.getByMasterId(masterId);
        return null == importStatisticsPO ? null : this.importStatisticsFactory.getImportStatistics(importStatisticsPO);
    }

    public void updateById(ImportStatistics importStatistics) {
        if (null == importStatistics) {
            throw new RuntimeException("\u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a");
        }
        ImportStatisticsPO importStatisticsPO = this.importStatisticsFactory.getImportStatisticsPO(importStatistics);
        this.importStatisticsRepositoryFacade.updateById(importStatisticsPO);
    }

    public void updateThisAndBatchRecordsById(ImportStatistics importStatistics) {
        if (null == importStatistics) {
            throw new RuntimeException("\u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a");
        }
        ImportStatisticsPO importStatisticsPO = this.importStatisticsFactory.getImportStatisticsPO(importStatistics);
        List<ImportBatchRecordPO> importBatchRecordPOS = this.importStatisticsFactory.getBatchRecordPOS(importStatistics.getImportBatchRecords());
        this.importStatisticsRepositoryFacade.updateById(importStatisticsPO);
        this.importBatchRecordRepositoryFacade.updateBatch(importBatchRecordPOS);
    }

    public void setRepublishedFlag(String masterId) {
        ImportStatisticsPO importStatisticsPO = this.importStatisticsRepositoryFacade.getByMasterId(masterId);
        if (null == importStatisticsPO) {
            throw new RuntimeException("\u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a");
        }
        importStatisticsPO.setRepublished(Integer.valueOf(1));
        this.importStatisticsRepositoryFacade.updateById(importStatisticsPO);
    }

    public List<ImportStatistics> getRecordsByUserId(String userId, String tenantId, String locale, String activityName, String startTime, String endTime, String type, Integer state, Integer offset, Integer getRecordsNum) {
        String loc_default = "default";
        List<ImportStatisticsPO> importStatisticsPOS = this.importStatisticsRepositoryFacade.getRecordsByUserId(userId, getRecordsNum, activityName, startTime, endTime, type, state, offset);
        Integer countRecord = this.importStatisticsRepositoryFacade.countRecord(userId, activityName, startTime, endTime, type, state);
        importStatisticsPOS.forEach(e -> e.setQueryPageTotal(countRecord));
        List<ImportStatistics> importStatisticsList = this.importStatisticsFactory.getImportStatisticsList(importStatisticsPOS);
        for (ImportStatistics item : importStatisticsList) {
            Map userJsonMap;
            String name;
            if (item.getActivityName() == null) continue;
            Map localeMap = (Map)JsonUtils.jsonToObject((String)item.getActivityName(), Map.class);
            if (!StringUtils.isEmpty((String)locale)) {
                name = null == localeMap.get(locale) ? (String)localeMap.get("default") : (String)localeMap.get(locale);
                item.setActivityName(name);
            } else {
                name = (String)localeMap.get("default");
                item.setActivityName(name);
            }
            if (!StringUtils.isEmpty((String)item.getUserJson()) && !CollectionUtils.isEmpty((Map)(userJsonMap = (Map)JsonUtils.jsonToObject((String)item.getUserJson(), Map.class))) && !StringUtils.isEmpty((String)String.valueOf(userJsonMap.get("tenantId")))) continue;
        }
        return importStatisticsList;
    }

    public UserStatistics getProcessingNum(String userId, String tenantId) {
        UserStatistics userStatistics = new UserStatistics();
        userStatistics.setUserId(userId);
        List<Object> importStatisticsPOS = this.importStatisticsRepositoryFacade.getProcessingRecordsByUserId(userId);
        if (CollectionUtils.isEmpty(importStatisticsPOS)) {
            userStatistics.setProcessingNum(0);
            return userStatistics;
        }
        Iterator<ImportStatisticsPO> importStatisticsIterator = importStatisticsPOS.iterator();
        while (importStatisticsIterator.hasNext()) {
            Map userJsonMap;
            ImportStatisticsPO item = importStatisticsIterator.next();
            if (StringUtils.isEmpty((String)item.getUserJson()) || CollectionUtils.isEmpty((Map)(userJsonMap = (Map)JsonUtils.jsonToObject((String)item.getUserJson(), Map.class))) || StringUtils.isEmpty((String)String.valueOf(userJsonMap.get("tenantId"))) || tenantId.equals(String.valueOf(userJsonMap.get("tenantId")))) continue;
            importStatisticsIterator.remove();
        }
        List<String> activityIds = importStatisticsPOS.stream().map(ImportStatisticsPO::getActivityId).distinct().collect(Collectors.toList());
        List<String> hasPermissionActivityCodeList = this.appPermissionUtil.handleAppPermission(activityIds);
        importStatisticsPOS = importStatisticsPOS.stream().filter(x -> hasPermissionActivityCodeList.contains(x.getActivityId())).collect(Collectors.toList());
        userStatistics.setProcessingNum(importStatisticsPOS.size());
        return userStatistics;
    }

    public ActivityStatistics getActivityStatistics(String activityCode, String userId) {
        List<ImportStatisticsPO> importStatisticsPOS = this.importStatisticsRepositoryFacade.getActivityStatistics(activityCode, userId);
        LinkedList<ImportStatistics> importStatisticsList = new LinkedList<ImportStatistics>();
        if (!CollectionUtils.isEmpty(importStatisticsPOS)) {
            importStatisticsPOS.forEach(item -> {
                ImportStatistics importStatistics = new ImportStatistics();
                BeanUtils.copyProperties((Object)item, (Object)importStatistics);
                importStatisticsList.add(importStatistics);
            });
        }
        ActivityStatistics activityStatistics = new ActivityStatistics();
        activityStatistics.setImportStatisticsList(importStatisticsList);
        return activityStatistics;
    }

    public ImportBatchRecord getBatchRecordByPIdAndSeq(String masterId, int batchNum) {
        ImportBatchRecordPO importBatchRecordPO = this.importBatchRecordRepositoryFacade.selectByPIdAndBatchNum(masterId, batchNum);
        if (null == importBatchRecordPO) {
            throw new RuntimeException("\u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a");
        }
        ImportBatchRecord importBatchRecord = this.importStatisticsFactory.getImportBatchRecord(importBatchRecordPO);
        return importBatchRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] handleDownloadBaseData(String locale, List<String> keyList, Map<String, String> headers, Map<String, CellTypeContainer> cellTypeContainerMap, List<Map<String, Object>> tableList, String sheetName) throws UnsupportedEncodingException {
        byte[] fileBytes = new byte[]{};
        XSSFWorkbook wb = new XSSFWorkbook();
        int rowIndex = 2;
        List<CellTypeContainer> businessKeyContainer = this.excelHelper.getBusinessKeyContainer(new ArrayList<CellTypeContainer>(cellTypeContainerMap.values()));
        this.excelHelper.createDataExcel(sheetName, locale, rowIndex, keyList, cellTypeContainerMap, headers, tableList, (Workbook)wb, businessKeyContainer, 0, null, null);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            wb.write((OutputStream)bos);
            byte[] byArray = fileBytes = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5f02\u5e38\u6570\u636e\u5199\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (null != wb) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
        return fileBytes;
    }

    private String getSHEET_NAME() {
        return null;
    }

    @Transactional
    public void saveImportStatisticsAndRecord(UploadParamDTO uploadParam, String activityName, int processingNum, List<ImportBatchRecord> importBatchRecords, Date createTime) {
        if (CollectionUtils.isEmpty(importBatchRecords)) {
            return;
        }
        List<ImportBatchRecordPO> importBatchRecordPOS = ImportBatchRecordCovert.INSTANCE.toPo(importBatchRecords);
        ImportStatisticsPO importStatisticsPO = new ImportStatisticsPO();
        importStatisticsPO.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        importStatisticsPO.setSucceededNum(Integer.valueOf(0));
        importStatisticsPO.setProcessingNum(Integer.valueOf(processingNum));
        importStatisticsPO.setFailedNum(Integer.valueOf(0));
        importStatisticsPO.setErrorNum(Integer.valueOf(0));
        importStatisticsPO.setMasterId(uploadParam.getMasterId());
        importStatisticsPO.setActivityId(uploadParam.getActivityId());
        importStatisticsPO.setActivityName(activityName);
        importStatisticsPO.setActionId(uploadParam.getActionId());
        importStatisticsPO.setFileUrl(uploadParam.getFileUrl());
        importStatisticsPO.setFileUid(uploadParam.getFileUid());
        String locale = LocaleContextHolder.getLocale().toString();
        importStatisticsPO.setLocale(locale == null ? "zh_CN" : locale);
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (athenaUser == null) {
            athenaUser = uploadParam.getAuthoredUser();
        }
        importStatisticsPO.setRouterKey(athenaUser.getTenantId());
        importStatisticsPO.setUserId(String.valueOf(athenaUser.getSid()));
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        if (securityToken == null) {
            securityToken = uploadParam.getSecurityToken();
        }
        importStatisticsPO.setUserToken(securityToken);
        importStatisticsPO.setCreateTime(createTime);
        importStatisticsPO.setUpdateTime(createTime);
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        importStatisticsPO.setUserJson(JsonUtils.objectToString((Object)simpleUser));
        importStatisticsPO.setRepublished(Integer.valueOf(0));
        if (null != uploadParam.getActionInfo()) {
            importStatisticsPO.setActionInfo(JsonUtils.objectToString((Object)uploadParam.getActionInfo()));
        }
        this.importStatisticsRepositoryFacade.save(importStatisticsPO);
        this.importBatchRecordRepositoryFacade.saveBatch(importBatchRecordPOS);
    }

    @Transactional
    public void updateImportStatisticsAndRecord(String masterId, DataEntryTask dataEntryTask) {
        ImportStatistics importStatistics = this.getByMasterId(masterId);
        if (null == importStatistics) {
            throw new RuntimeException("\u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a");
        }
        List<DataEntryTask.BatchInfo> batchInfos = dataEntryTask.getBatchInfos();
        Date now = new Date();
        ArrayList<ImportBatchRecord> importBatchRecords = new ArrayList<ImportBatchRecord>();
        batchInfos.forEach(item -> {
            ImportBatchRecord importBatchRecord = this.getBatchRecordByPIdAndSeq(masterId, item.getBatchNum());
            importStatistics.setSucceededNum(importStatistics.getSucceededNum() + item.getTotalDataSize() - item.getTotalDataSize());
            importStatistics.setFailedNum(importStatistics.getFailedNum() + item.getTotalDataSize());
            importStatistics.setProcessingNum(importStatistics.getProcessingNum() - item.getTotalDataSize());
            importStatistics.setUpdateTime(now);
            importBatchRecord.setHandleFlag(1);
            importBatchRecord.setUpdateTime(now);
            importBatchRecords.add(importBatchRecord);
        });
        ImportStatisticsPO importStatisticsPO = this.importStatisticsFactory.getImportStatisticsPO(importStatistics);
        this.importStatisticsRepositoryFacade.updateById(importStatisticsPO);
        List<ImportBatchRecordPO> batchRecordPOS = this.importStatisticsFactory.getBatchRecordPOS(importBatchRecords);
        this.importBatchRecordRepositoryFacade.updateBatch(batchRecordPOS);
    }

    public ImportStatistics queryImportStatisticsByMasterId(String masterId) {
        ImportStatisticsPO po = this.importStatisticsRepositoryFacade.getByMasterId(masterId);
        ImportStatistics stats = ImportStatisticsCovert.INSTANCE.to(po);
        if (stats == null) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{}", (Object)masterId);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage("delivery.dataNotFound", new Object[0]));
        }
        return stats;
    }

    public List<ImportBatchRecord> queryImportBatchRecordsByMasterId(String masterId) {
        List<ImportBatchRecordPO> pos = this.importBatchRecordRepositoryFacade.selectListByPId(masterId);
        List<ImportBatchRecord> records = ImportBatchRecordCovert.INSTANCE.toDto(pos);
        if (CollectionUtils.isEmpty(records)) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6279\u6b21\u6570\u636emasterId:{}", (Object)masterId);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage("delivery.dataNotFound", new Object[0]));
        }
        return records;
    }

    public ImportStatistics queryImportStatisticsByFileUid(String fileUid) {
        List<ImportStatisticsPO> po = this.importStatisticsRepositoryFacade.queryImportStatisticsByFileUid(fileUid);
        if (CollectionUtils.isEmpty(po)) {
            return null;
        }
        return ImportStatisticsCovert.INSTANCE.to(po.get(0));
    }

    @Transactional
    public void updateImportDb(ImportStatistics importStatistics, List<ImportBatchRecord> importBatchRecords, ImportCounters counters) {
        if (null == importStatistics) {
            log.error("\u5f53\u524d\u5bfc\u5165\u8bb0\u5f55\u4e3a\u7a7a");
            return;
        }
        Date now = new Date();
        importStatistics.setFailedUrl(counters.getFailUrl());
        importStatistics.setProcessingNum(counters.getProcessingNum());
        importStatistics.setFailedNum(counters.getFailedNum());
        importStatistics.setErrorNum(counters.getErrorNum());
        importStatistics.setSucceededNum(counters.getSucceededNum());
        importStatistics.setUpdateTime(now);
        this.importStatisticsRepositoryFacade.updateById(ImportStatisticsCovert.INSTANCE.to(importStatistics));
        if (CollectionUtils.isEmpty(importBatchRecords)) {
            return;
        }
        for (ImportBatchRecord record : importBatchRecords) {
            record.setHandleFlag(1);
            record.setUpdateTime(now);
        }
        List batchSeqs = importBatchRecords.stream().map(ImportBatchRecord::getBatchSeq).collect(Collectors.toList());
        log.info("\u6b64\u6b21\u66f4\u65b0\u72b6\u6001\u7684\u6279\u6b21\uff1a{}", batchSeqs);
        this.importBatchRecordRepositoryFacade.updateBatch(ImportBatchRecordCovert.INSTANCE.toPo(importBatchRecords));
    }
}

