/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ActionInfoDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DapResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadTemplateDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ExportHeaderRespDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionResponseLocaleRequestDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.MultiLanguageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.validation.DataValidation;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.validation.DataValidationEnum;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.ValidatorLoader;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.dto.Dictionary;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MetaDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaDataService.class);
    @Resource
    RestTemplate restTemplate;
    @Autowired
    ExcelHelper excelHelper;
    @Value(value="${themeMap.uri}")
    private String knowledgeGraphUrl;
    private final String HEADER_KEY = "key";
    private final String HEADER_NAME = "name";
    private final String METADATA_URL = "/restful/service/knowledgegraph/Action/Metadata?actionId={actionId}";
    private final String DICT_BATCH_URL = "/restful/service/knowledgegraph/Dict/FindDictByKeyList";
    private final String DICT_URL = "/restful/service/knowledgegraph/Dict/DictByKey?key={key}";
    private final String FILE_EXIST_URL = "/restful/service/knowledgegraph/File/FileId?key={key}&version={version}";
    private final String TEMPLATE_DOWNLOAD_URL = "/restful/service/knowledgegraph/File/DownloadTemplate?fileId={fileId}";
    private final String PRODUCT_NAME_URL = "/restful/service/knowledgegraph/Action/ProductName?serviceName={serviceName}";
    private final String ACTIVITY_NAME_URL = "/restful/service/knowledgegraph/task/activityNamesByCode?activityCode={activityCode}";

    public boolean validate(GetActionLocaleResponseDTO getActionLocaleResponseDTO, List<List<Object>> data, List<String> keyList, List<List> errorListHolder) {
        List<String> importFieldListMetaData = this.transformToImportFieldList(getActionLocaleResponseDTO);
        List<String> excelFieldList = this.getImportFieldListFromExcel(data);
        Iterator<String> it = excelFieldList.iterator();
        while (it.hasNext()) {
            String item = it.next();
            if (!importFieldListMetaData.contains(item)) continue;
            keyList.add(item);
            importFieldListMetaData.remove(item);
            it.remove();
        }
        if (!importFieldListMetaData.isEmpty()) {
            errorListHolder.add(importFieldListMetaData);
            return false;
        }
        return true;
    }

    public boolean validateBody(String bodyKey, Set<String> businessKeySet, GetActionLocaleResponseDTO getActionLocaleResponseDTO, List<List<Object>> data, List<String> keyList, List<List> errorListHolder) {
        HashSet<String> businessKeySetCopy = new HashSet<String>(businessKeySet);
        List<String> importFieldListMetaData = this.transformBodyToImportFieldList(bodyKey, getActionLocaleResponseDTO);
        List<String> excelFieldList = this.getImportFieldListFromExcel(data);
        Iterator<String> it = excelFieldList.iterator();
        while (it.hasNext()) {
            String item = it.next();
            if (!importFieldListMetaData.contains(item) && !businessKeySetCopy.contains(item)) continue;
            keyList.add(item);
            importFieldListMetaData.remove(item);
            businessKeySetCopy.remove(item);
            it.remove();
        }
        if (importFieldListMetaData.isEmpty() && businessKeySetCopy.isEmpty()) {
            return true;
        }
        errorListHolder.add(importFieldListMetaData);
        errorListHolder.add(new ArrayList<String>(businessKeySetCopy));
        return false;
    }

    private List<String> getImportFieldListFromExcel(List<List<Object>> data) {
        List<Object> headers = data.get(1);
        LinkedList<String> headerList = new LinkedList<String>();
        headers.forEach(item -> {
            if (item instanceof String) {
                headerList.add((String)item);
            }
        });
        return headerList;
    }

    public boolean validateNew(ApiDataFieldLocaleMetadataDTO cellTypeContainer, List<String> excelFieldList, List<String> businessKeyList, List<String> errorListHolder) {
        if (CollectionUtils.isEmpty(excelFieldList)) {
            return false;
        }
        List importFieldListMetaData = cellTypeContainer.getField().stream().filter(item -> !item.getIs_array()).map(item -> item.getData_name()).collect(Collectors.toList());
        for (String item2 : excelFieldList) {
            if (importFieldListMetaData.contains(item2) || businessKeyList.contains(item2)) continue;
            errorListHolder.add(item2);
        }
        return CollectionUtils.isEmpty(errorListHolder);
    }

    private List<String> transformBodyToImportFieldList(String bodyKey, GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getRequest().getParameters().get(0);
        if (null == apiDataFieldLocaleMetadataDTO) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0092.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
        }
        List bodyApiDataFieldLocaleMetadataDTO = apiDataFieldLocaleMetadataDTO.getField().stream().filter(item -> item.getData_name().equals(bodyKey)).collect(Collectors.toList());
        if (1 != bodyApiDataFieldLocaleMetadataDTO.size()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0093.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
        }
        return ((ApiDataFieldLocaleMetadataDTO)bodyApiDataFieldLocaleMetadataDTO.get(0)).getField().stream().filter(item -> !item.getIs_array()).map(item -> item.getData_name()).collect(Collectors.toList());
    }

    private List<String> transformToImportFieldList(GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getRequest().getParameters().get(0);
        if (null == apiDataFieldLocaleMetadataDTO) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0091.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
        }
        return apiDataFieldLocaleMetadataDTO.getField().stream().filter(item -> !item.getIs_array()).map(item -> item.getData_name()).collect(Collectors.toList());
    }

    public List<Map> validateByBatch(DataEntryTask dataEntryTask, List<CellTypeContainer> cellTypes) {
        if (null == dataEntryTask.getActionInfo() || MapUtils.isEmpty(dataEntryTask.getActionInfo().getSheetRequiredFiled())) {
            return new LinkedList<Map>();
        }
        return this.doValidateData(dataEntryTask.getTableKey(), dataEntryTask.getDataList(), dataEntryTask, cellTypes);
    }

    private List<Map> doValidateData(String dataKey, List<Map> rowDataList, DataEntryTask dataEntryTask, List<CellTypeContainer> cellTypes) {
        Map<String, Set<String>> sheetRequiredFiled = dataEntryTask.getActionInfo().getSheetRequiredFiled();
        Map<String, CellTypeContainer> cellTypeContainerMap = cellTypes.stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, item -> item));
        ArrayList<Map> errorRowDataList = new ArrayList<Map>();
        Set<String> requiredFiled = sheetRequiredFiled.get(dataKey);
        for (Map rowData : rowDataList) {
            LinkedHashMap rowDataErrorMsg = new LinkedHashMap();
            Boolean parentHasError = Boolean.FALSE;
            Boolean sonHasError = Boolean.FALSE;
            block1: for (Map.Entry cellEntry : rowData.entrySet()) {
                List<Map> sonErrorDataList;
                CellTypeContainer cellType = cellTypeContainerMap.get(cellEntry.getKey());
                if (cellEntry.getValue() instanceof List && !CollectionUtils.isEmpty(sonErrorDataList = this.doValidateData((String)cellEntry.getKey(), (List)cellEntry.getValue(), dataEntryTask, cellType.getChildren()))) {
                    sonHasError = Boolean.TRUE;
                    rowDataErrorMsg.put(cellEntry.getKey(), sonErrorDataList);
                }
                String errorMsg = null;
                for (DataValidationEnum dataValidationEnum : DataValidationEnum.values()) {
                    DataValidation dataValidation = DataValidationEnum.getDataValidation(dataValidationEnum.getType());
                    if (DataValidationEnum.REQUIRED.getType().equals(dataValidationEnum.getType())) {
                        errorMsg = dataValidation.validate(requiredFiled, cellEntry, dataEntryTask.getLocale());
                        if (!StringUtils.isNotEmpty((String)errorMsg)) continue;
                        parentHasError = Boolean.TRUE;
                        rowDataErrorMsg.put((String)cellEntry.getKey() + "_error_msg", errorMsg);
                        continue block1;
                    }
                    if (DataValidationEnum.FORMAT.getType().equals(dataValidationEnum.getType())) {
                        errorMsg = dataValidation.validate(cellType, cellEntry, dataEntryTask.getLocale());
                        if (!StringUtils.isNotEmpty((String)errorMsg)) continue;
                        parentHasError = Boolean.TRUE;
                        rowDataErrorMsg.put((String)cellEntry.getKey() + "_error_msg", errorMsg);
                        continue block1;
                    }
                    log.error("DataValidationEnum is wrong, dataValidationEnum:{}", (Object)dataValidationEnum);
                }
            }
            if (!parentHasError.booleanValue() && !sonHasError.booleanValue()) continue;
            LinkedHashMap errorRow = new LinkedHashMap();
            errorRow.putAll(rowData);
            errorRow.putAll(rowDataErrorMsg);
            errorRowDataList.add(errorRow);
        }
        return errorRowDataList;
    }

    private Boolean isEmpty(Set<String> requiredFiled, Map.Entry<String, Object> cellEntry) {
        if (CollectionUtils.isEmpty(requiredFiled) || !requiredFiled.contains(cellEntry.getKey())) {
            return false;
        }
        if (null == cellEntry.getValue()) {
            return true;
        }
        if (cellEntry.getValue() instanceof String) {
            return ((String)cellEntry.getValue()).trim().isEmpty();
        }
        return false;
    }

    public String getProductNameBySecurityToken(String token, String serviceName, String securityToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        headers.add("security-token", securityToken);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serviceName", serviceName);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/ProductName?serviceName={serviceName}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            String productName = (String)((DapResponse)result.getBody()).getResponse();
            return productName;
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0104.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
    }

    public String getProductName(String token, String serviceName) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serviceName", serviceName);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/ProductName?serviceName={serviceName}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            String productName = (String)((DapResponse)result.getBody()).getResponse();
            return productName;
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0094.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
    }

    public GetActionLocaleResponseDTO getActionMetaDataBySecurityToken(String actionId, String token, String locale, String securityToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        headers.add("security-token", securityToken);
        if (!StringUtils.isEmpty((String)locale)) {
            headers.add("locale", locale);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("actionId", actionId);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/Metadata?actionId={actionId}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            Map dtoMap = (Map)((DapResponse)result.getBody()).getResponse();
            String str = JsonUtils.objectToString((Object)dtoMap);
            GetActionLocaleResponseDTO getActionLocaleResponseDTO = (GetActionLocaleResponseDTO)JsonUtils.jsonToObject((String)str, GetActionLocaleResponseDTO.class);
            return getActionLocaleResponseDTO;
        }
        String errorCode = ErrorCodeEnum.NUM_500_0105.getErrCode();
        throw BusinessException.create((String)errorCode, (String)("\u8c03\u7528" + this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/Metadata?actionId=" + actionId + "\u672a\u627e\u5230\u5143\u6570\u636e"));
    }

    public GetActionLocaleResponseDTO getActionMetaData(String actionId, String token, String locale) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        if (!StringUtils.isEmpty((String)locale)) {
            headers.add("locale", locale);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("actionId", actionId);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/Metadata?actionId={actionId}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            Map dtoMap = (Map)((DapResponse)result.getBody()).getResponse();
            String str = JsonUtils.objectToString((Object)dtoMap);
            GetActionLocaleResponseDTO getActionLocaleResponseDTO = (GetActionLocaleResponseDTO)JsonUtils.jsonToObject((String)str, GetActionLocaleResponseDTO.class);
            return getActionLocaleResponseDTO;
        }
        String errorCode = ErrorCodeEnum.NUM_500_0105.getErrCode();
        throw BusinessException.create((String)errorCode, (String)("\u8c03\u7528" + this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/Metadata?actionId=" + actionId + "\u672a\u627e\u5230\u5143\u6570\u636e"));
    }

    public List<Dictionary> getDictByKeyBySecurityToken(String key, String token, String securityToken, String locale) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        if (!StringUtils.isEmpty((String)locale)) {
            headers.add("locale", locale);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", key);
        HttpEntity entity = new HttpEntity(parameters, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Dict/DictByKey?key={key}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            List dtoMap = (List)((DapResponse)result.getBody()).getResponse();
            String str = JsonUtils.objectToString((Object)dtoMap);
            List dictionaries = JsonUtils.jsonToListObject((String)str, Dictionary.class);
            return dictionaries;
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0097.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
    }

    public List<Dictionary> getDictByKey(String key, String token, String locale) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        if (!StringUtils.isEmpty((String)locale)) {
            headers.add("locale", locale);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", key);
        HttpEntity entity = new HttpEntity(parameters, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Dict/DictByKey?key={key}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            List dtoMap = (List)((DapResponse)result.getBody()).getResponse();
            String str = JsonUtils.objectToString((Object)dtoMap);
            List dictionaries = JsonUtils.jsonToListObject((String)str, Dictionary.class);
            return dictionaries;
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0098.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
    }

    public Map<String, List<Dictionary>> getDictByKeyList(List<String> keyList, String token, String securityToken, String locale) {
        if (CollectionUtils.isEmpty(keyList)) {
            return Collections.EMPTY_MAP;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        if (!StringUtils.isEmpty((String)securityToken)) {
            headers.add("security-token", securityToken);
        }
        if (!StringUtils.isEmpty((String)locale)) {
            headers.add("locale", locale);
        }
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("keyList", keyList);
        HttpEntity entity = new HttpEntity(parameters, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.postForEntity(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Dict/FindDictByKeyList", (Object)entity, DapResponse.class, new Object[0]);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            Map dtoMap = (Map)((DapResponse)result.getBody()).getResponse();
            if (CollectionUtils.isEmpty((Map)dtoMap)) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0096.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
            }
            String str = JsonUtils.objectToString((Object)dtoMap);
            Map dictionaryMaps = (Map)JsonUtils.jsonToObject((String)str, Map.class);
            return dictionaryMaps;
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0096.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
    }

    public GetActionLocaleResponseDTO getActionMetaDataBySecurityToken(String actionId, String token, String securityToken) {
        return this.getActionMetaDataBySecurityToken(actionId, token, "", securityToken);
    }

    public GetActionLocaleResponseDTO getActionMetaData(String actionId, String token) {
        return this.getActionMetaData(actionId, token, "");
    }

    public String getTableKey(GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        return getActionLocaleResponseDTO.getRequest().getParameters().get(0).getData_name();
    }

    public Boolean useHasNext(GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        if (Objects.isNull(getActionLocaleResponseDTO) || Objects.isNull(getActionLocaleResponseDTO.getRequest())) {
            return false;
        }
        List<ApiDataFieldLocaleMetadataDTO> parameters = getActionLocaleResponseDTO.getRequest().getParameters();
        for (ApiDataFieldLocaleMetadataDTO item : parameters) {
            if (!item.getData_name().equals("use_has_next")) continue;
            return true;
        }
        return false;
    }

    public List<Map> getHeaders(String actionId, String userToken, String locale) {
        GetActionLocaleResponseDTO getActionLocaleResponseDTO = this.getActionMetaData(actionId, userToken, locale);
        return this.getHeaders(getActionLocaleResponseDTO);
    }

    public List<Map> getHeaders(GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getRequest().getParameters().get(0);
        LinkedList<Map> headers = new LinkedList<Map>();
        apiDataFieldLocaleMetadataDTO.getField().forEach(item -> {
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("key", item.getData_name());
            header.put("name", item.getDescription());
            headers.add(header);
        });
        return headers;
    }

    public Map<String, String> getHeaderMap(ApiDataFieldLocaleMetadataDTO mainMetadata) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        mainMetadata.getField().forEach(item -> headerMap.put(item.getData_name(), item.getDescription()));
        return headerMap;
    }

    public Map<String, String> getResponseHeaders(GetActionLocaleResponseDTO getActionLocaleResponseDTO, List<String> keyList) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        apiDataFieldLocaleMetadataDTO.getField().forEach(item -> {
            keyList.add(item.getData_name());
            headerMap.put(item.getData_name(), item.getDescription());
        });
        return headerMap;
    }

    public List<String> getResponseBKList(GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        LinkedList<String> keyList = new LinkedList<String>();
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        apiDataFieldLocaleMetadataDTO.getField().forEach(item -> {
            if (item.getIs_businesskey()) {
                keyList.add(item.getData_name());
            }
        });
        return keyList;
    }

    public List<String> getResponseBodyKeyList(GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        LinkedList<String> keyList = new LinkedList<String>();
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        apiDataFieldLocaleMetadataDTO.getField().forEach(item -> {
            if (item.getIs_array()) {
                keyList.add(item.getData_name());
            }
        });
        return keyList;
    }

    public List<Map> getHeaders(String actionId, String userToken) {
        return this.getHeaders(actionId, userToken, "");
    }

    public String getActivityNameByActivityId(String activityId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token == null ? AppAuthContextHolder.getContext().getAuthoredUser().getToken() : token);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityCode", activityId);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/task/activityNamesByCode?activityCode={activityCode}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            Map dtoMap = (Map)((DapResponse)result.getBody()).getResponse();
            return JsonUtils.objectToString((Object)dtoMap);
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0103.getErrCode(), (String)("\u8c03\u7528" + this.knowledgeGraphUrl + "/restful/service/knowledgegraph/task/activityNamesByCode?activityCode=" + activityId + "\u83b7\u53d6\u6d3b\u52a8\u540d\u79f0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e"));
    }

    public ExportHeaderRespDTO getTableHeader(String actionId, String token, String locale) {
        GetActionLocaleResponseDTO metadataDTO = this.getActionMetaDataBySecurityToken(actionId, token, locale, token);
        GetActionLocaleResponseDTO getActionLocaleResponseDTO = this.getActionMetaData(actionId, token, locale);
        ApiDataFieldLocaleMetadataDTO mainMetadata = this.getMainMetadata(getActionLocaleResponseDTO, null);
        ArrayList<String> keyList = new ArrayList<String>();
        Map<String, String> headers = this.getResponseHeaders(metadataDTO, keyList);
        List<ExportHeaderRespDTO.Cell> cells = headers.entrySet().stream().map(entry -> {
            ExportHeaderRespDTO.Cell cellDTO = new ExportHeaderRespDTO.Cell();
            cellDTO.setKeyName((String)entry.getKey());
            cellDTO.setKeyDescription((String)entry.getValue());
            return cellDTO;
        }).collect(Collectors.toList());
        ExportHeaderRespDTO responseDTO = new ExportHeaderRespDTO();
        responseDTO.setMainKey(mainMetadata.getData_name());
        responseDTO.setCell(cells);
        return responseDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downloadTemplate(String actionId, String token, String locale, DownloadTemplateDTO downloadTemplateDTO) {
        byte[] fileBytes = new byte[]{};
        String templateFileId = this.getTemplateFileId(actionId, locale);
        if (!StringUtils.isEmpty((String)templateFileId)) {
            fileBytes = this.downloadByTemplateFileId(templateFileId);
            return fileBytes;
        }
        GetActionLocaleResponseDTO getActionLocaleResponseDTO = this.getActionMetaData(actionId, token, locale);
        ApiDataFieldLocaleMetadataDTO mainMetadata = this.getMainMetadata(getActionLocaleResponseDTO, downloadTemplateDTO.getActionInfo());
        List<CellTypeContainer> cellTypes = this.getCellTypeContainers(mainMetadata.getField(), token, null, locale, 1);
        List<CellTypeContainer> businessKeyContainer = this.getBusinessKeyContainer(cellTypes);
        XSSFWorkbook wb = new XSSFWorkbook();
        String mainKey = mainMetadata.getData_name();
        String mainKeyDescription = mainMetadata.getDescription();
        XSSFSheet sheet = wb.createSheet(ExcelHelper.getSheetName(mainKey, mainKeyDescription, true));
        Map<String, Object> annotation = this.getAnnotation(downloadTemplateDTO.getActionInfo());
        this.createSheetHeader(wb, (Sheet)sheet, businessKeyContainer, cellTypes, locale, downloadTemplateDTO.getRequiredFields(), annotation);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            wb.write((OutputStream)bos);
            fileBytes = bos.toByteArray();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (null != wb) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
        return fileBytes;
    }

    private Map<String, Object> getAnnotation(ActionInfoDTO actionInfo) {
        Map<String, Object> annotation = new HashMap<String, Object>();
        if (null != actionInfo && MapUtils.isNotEmpty(actionInfo.getAnnotation())) {
            annotation = actionInfo.getAnnotation();
        }
        return annotation;
    }

    public ApiDataFieldLocaleMetadataDTO getMainMetadata(GetActionLocaleResponseDTO getActionLocaleResponseDTO, ActionInfoDTO actionInfo) {
        if (getActionLocaleResponseDTO == null) {
            log.error("getActionLocaleResponseDTO is null!");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0092.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
        }
        String targetFieldName = Optional.ofNullable(actionInfo).map(ActionInfoDTO::getTargetField).orElse("");
        return this.getMainRequestMetadataField(getActionLocaleResponseDTO.getRequest(), targetFieldName);
    }

    public ApiDataFieldLocaleMetadataDTO getMainRequestMetadataField(GetActionResponseLocaleRequestDTO request, String targetFieldName) throws BusinessException {
        Optional<ApiDataFieldLocaleMetadataDTO> metadataDTOOptional;
        if (null == request || CollectionUtils.isEmpty(request.getParameters())) {
            return null;
        }
        List<ApiDataFieldLocaleMetadataDTO> parameters = request.getParameters();
        if (StringUtils.isNotBlank((String)targetFieldName) && (metadataDTOOptional = parameters.stream().filter(metadataDTO -> metadataDTO.getData_name().equals(targetFieldName.trim())).findFirst()).isPresent()) {
            return metadataDTOOptional.get();
        }
        Optional<ApiDataFieldLocaleMetadataDTO> mOptional = parameters.stream().filter(metadataDTO -> metadataDTO.getData_type().equals(MetaDataType.OBJECT.getName())).findFirst();
        if (mOptional.isPresent()) {
            return mOptional.get();
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0091.getErrCode(), (String)MessageUtil.getMessage("basedata.metaDataStructError", new Object[0]));
    }

    private void createChildSheet(XSSFWorkbook wb, List<CellTypeContainer> businessKeyContainer, CellTypeContainer cellTypeContainerMain, String locale, Set<String> requiredFields, Map<String, Object> childAnnotation) {
        String mainKey = cellTypeContainerMain.getKeyName();
        String mainKeyDescription = cellTypeContainerMain.getKeyDescription();
        XSSFSheet sheet = wb.createSheet(ExcelHelper.getSheetName(mainKey, mainKeyDescription, false));
        List cellTypes = cellTypeContainerMain.getChildren();
        HashSet<String> currentRequiredFields = new HashSet();
        currentRequiredFields = this.reBuildRequiredFields(cellTypes, requiredFields);
        List<CellTypeContainer> childBusinessKeyContainerList = this.getBusinessKeyContainer(cellTypes);
        this.excelHelper.addBkContainer(cellTypes, businessKeyContainer);
        this.createSheetHeader(wb, (Sheet)sheet, childBusinessKeyContainerList, cellTypes, locale, currentRequiredFields, childAnnotation);
    }

    private void createSheetHeader(XSSFWorkbook wb, Sheet sheet, List<CellTypeContainer> businessKeyContainer, List<CellTypeContainer> cellTypes, String locale, Set<String> requiredFields, Map<String, Object> annotation) {
        XSSFDataFormat fmt = wb.createDataFormat();
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        langName = StringUtils.isEmpty((String)langName) ? "zh_CN" : StringUtils.replaceChars((String)langName, (char)'-', (char)'_');
        int index = 0;
        for (int i = 0; i < cellTypes.size(); ++i) {
            String annotationStr = "";
            MetaDataType metaDataType = cellTypes.get(i).getProtoType();
            CellTypeContainer cellTypeContainer = cellTypes.get(i);
            XSSFCellStyle cellStyle = wb.createCellStyle();
            switch (metaDataType) {
                case STRING: {
                    annotationStr = this.getAnnotationStr(annotation, cellTypeContainer, langName);
                    if (null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0 || StringUtils.isNotEmpty((String)annotationStr)) {
                        int max = null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0 ? cellTypeContainer.getPrecision()[0] : Integer.MAX_VALUE;
                        ExcelUtil.excelRuleStringLengthWithAnnotation(locale, sheet, 0, max, 2, 65536, index, index, annotationStr);
                    }
                    cellStyle.setDataFormat(fmt.getFormat("@"));
                    sheet.setDefaultColumnStyle(index, (CellStyle)cellStyle);
                    break;
                }
                case NUMBER: {
                    annotationStr = this.getAnnotationStr(annotation, cellTypeContainer, langName);
                    ExcelUtil.excelRuleIsNumberWithAnnotation(locale, sheet, 2, 65536, index, index, annotationStr);
                    break;
                }
                case DATE: {
                    annotationStr = this.getAnnotationStr(annotation, cellTypeContainer, langName);
                    cellStyle.setDataFormat(fmt.getFormat(cellTypeContainer.getDateFormat()));
                    sheet.setDefaultColumnStyle(index, (CellStyle)cellStyle);
                    ExcelUtil.excelRuleDateFormatWithAnnotation(locale, sheet, "1720-01-01", "", cellTypeContainer.getDateFormat(), 2, 65536, index, index, annotationStr);
                    break;
                }
                case OBJECT: {
                    if (cellTypeContainer.getArray().booleanValue()) {
                        if (!CollectionUtils.isEmpty(businessKeyContainer)) {
                            Map childAnnotation = MapUtils.getMap(annotation, (Object)cellTypeContainer.getKeyName(), new HashMap());
                            this.createChildSheet(wb, businessKeyContainer, cellTypeContainer, locale, requiredFields, childAnnotation);
                        }
                        --index;
                    }
                    if (null == cellTypeContainer.getListEnum() || cellTypeContainer.getListEnum().length == 0) break;
                    annotationStr = this.getAnnotationStr(annotation, cellTypeContainer, langName);
                    ExcelUtil.excelRuleSelectWithAnnotation(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index, annotationStr);
                    break;
                }
                case BOOLEAN: {
                    annotationStr = this.getAnnotationStr(annotation, cellTypeContainer, langName);
                    ExcelUtil.excelRuleSelectWithAnnotation(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index, annotationStr);
                    break;
                }
                case ENUM: {
                    if (null == cellTypeContainer.getListEnum() || cellTypeContainer.getListEnum().length == 0) break;
                    annotationStr = this.getAnnotationStr(annotation, cellTypeContainer, langName);
                    ExcelUtil.excelEnumRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index, annotationStr);
                    break;
                }
            }
            ++index;
        }
        Row headRow1 = sheet.createRow(0);
        Row headRow2 = sheet.createRow(1);
        index = 0;
        for (int i = 0; i < cellTypes.size(); ++i) {
            if (cellTypes.get(i).getArray().booleanValue()) continue;
            Cell cell1 = headRow1.createCell(index);
            Cell cell2 = headRow2.createCell(index);
            if (!CollectionUtils.isEmpty(requiredFields) && requiredFields.contains(cellTypes.get(i).getKeyName())) {
                cell1.setCellValue((RichTextString)ExcelUtil.addRequiredMark(wb, cellTypes.get(i).getKeyDescription(), (Font)wb.getFontAt(cell1.getCellStyle().getFontIndex())));
                cell2.setCellValue(cellTypes.get(i).getKeyName());
            } else {
                cell1.setCellValue(cellTypes.get(i).getKeyDescription());
                cell2.setCellValue(cellTypes.get(i).getKeyName());
            }
            ++index;
        }
    }

    private String getAnnotationStr(Map<String, Object> annotation, CellTypeContainer cellTypeContainer, String langName) {
        Map annotationMap = MapUtils.getMap(annotation, (Object)cellTypeContainer.getKeyName(), new HashMap());
        String annotationValue = MapUtils.getString((Map)annotationMap, (Object)langName, (String)"");
        if (StringUtils.isNotEmpty((String)annotationValue) && annotationValue.length() > 150) {
            annotationValue = annotationValue.substring(0, 150);
        }
        return annotationValue;
    }

    private List<CellTypeContainer> getBusinessKeyContainer(List<CellTypeContainer> cellTypes) {
        LinkedList<CellTypeContainer> cellTypeContainers = new LinkedList<CellTypeContainer>();
        for (CellTypeContainer cellType : cellTypes) {
            if (!cellType.getBusinessKey().booleanValue()) continue;
            cellTypeContainers.add(cellType);
        }
        return cellTypeContainers;
    }

    private Set<String> reBuildRequiredFields(List<CellTypeContainer> cellTypes, Set<String> requiredFields) {
        HashSet<String> resultSet = new HashSet<String>(requiredFields);
        if (CollectionUtils.isEmpty(cellTypes)) {
            return resultSet;
        }
        for (CellTypeContainer cellTypeContainer : cellTypes) {
            if (!"true".equals(cellTypeContainer.getRequired())) continue;
            resultSet.add(cellTypeContainer.getKeyName());
        }
        return resultSet;
    }

    private byte[] downloadByTemplateFileId(String fileId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("token", token);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("fileId", fileId);
        HttpEntity entity = new HttpEntity(parameters, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/File/DownloadTemplate?fileId={fileId}", HttpMethod.GET, entity, byte[].class, parameters);
        if (null != result && null != result.getBody()) {
            return (byte[])result.getBody();
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0118.getErrCode());
    }

    private String getTemplateFileId(String actionId, String locale) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("token", token);
        if (StringUtils.isEmpty((String)locale)) {
            return null;
        }
        headers.add("locale", locale);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", actionId + "&" + locale);
        parameters.put("version", "1.0");
        HttpEntity entity = new HttpEntity(parameters, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/File/FileId?key={key}&version={version}", HttpMethod.GET, entity, DapResponse.class, parameters);
        return (String)((DapResponse)result.getBody()).getResponse();
    }

    public List<CellTypeContainer> getCellTypeContainers(List<ApiDataFieldLocaleMetadataDTO> field, String token, String securityToken, String locale, int depth) {
        LinkedList<CellTypeContainer> cellTypes = new LinkedList<CellTypeContainer>();
        List<String> keyList = field.stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).collect(Collectors.toList());
        keyList.removeAll(Collections.singleton(null));
        Map<String, List<Dictionary>> dictionaryMap = this.getDictByKeyList(keyList, token, securityToken, locale);
        field.forEach(item -> {
            CellTypeContainer cellTypeContainer;
            switch (MetaDataType.valueOf((String)item.getData_type().toUpperCase())) {
                case NUMBER: 
                case NUMERIC: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(dictionaryMap.get(item.getEnum_key())), Dictionary.class);
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer.setProtoType(MetaDataType.NUMERIC);
                    cellTypeContainer.setCellType(CellType.NUMERIC);
                    int[] precision = this.parsePrecision((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setPrecision(precision);
                    break;
                }
                case DATE: 
                case DATETIME: 
                case TIME: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.DATE);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String dateFormat = this.parseDateFormat((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setDateFormat(dateFormat);
                    break;
                }
                case STRING: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(dictionaryMap.get(item.getEnum_key())), Dictionary.class);
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.STRING);
                    cellTypeContainer.setCellType(CellType.STRING);
                    int[] precision = this.parsePrecision((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setPrecision(precision);
                    break;
                }
                case OBJECT: {
                    cellTypeContainer = new CellTypeContainer();
                    if (item.getIs_array()) {
                        cellTypeContainer.setChildren(this.getCellTypeContainers(item.getField(), token, securityToken, locale, depth + 1));
                    }
                    cellTypeContainer.setProtoType(MetaDataType.OBJECT);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String[] listEnum = this.parseListEnum((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setListEnum(listEnum);
                    break;
                }
                case BOOLEAN: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(dictionaryMap.get(item.getEnum_key())), Dictionary.class);
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer.setProtoType(MetaDataType.BOOLEAN);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String[] listEnum = this.parseBooleanListEnum();
                    cellTypeContainer.setListEnum(listEnum);
                    break;
                }
                default: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setCellType(CellType.STRING);
                }
            }
            cellTypeContainer.setRequired(item.getRequired());
            cellTypeContainer.setBusinessKey(Boolean.valueOf(item.getIs_businesskey()));
            cellTypeContainer.setArray(Boolean.valueOf(item.getIs_array()));
            cellTypeContainer.setKeyName(item.getData_name());
            cellTypeContainer.setKeyDescription(item.getDescription());
            cellTypes.add(cellTypeContainer);
        });
        return cellTypes;
    }

    private String[] parseListEnum(List<Dictionary> dictionaries) {
        List<String> select = dictionaries.stream().map(d -> d.getCode() + "." + d.getValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(select)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0100.getErrCode(), (String)"\u4e0b\u62c9\u5b57\u5178\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return select.toArray(new String[0]);
    }

    public Map<String, CellTypeContainer> getResponseCellTypeContainersBySecurityToken(GetActionLocaleResponseDTO getActionLocaleResponseDTO, String token, String securityToken, String locale) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        if (Objects.isNull(apiDataFieldLocaleMetadataDTO) || CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTO.getField())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0101.getErrCode(), (String)"\u5143\u6570\u636e\u51fa\u53c2\u4e3a\u7a7a");
        }
        List keyList = apiDataFieldLocaleMetadataDTO.getField().stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).collect(Collectors.toList());
        keyList.removeAll(Collections.singleton(null));
        List<ApiDataFieldLocaleMetadataDTO> fields = apiDataFieldLocaleMetadataDTO.getField();
        List<CellTypeContainer> cellTypeContainers = this.getCellTypeContainers(fields, token, securityToken, locale, 1);
        LinkedHashMap<String, CellTypeContainer> cellTypeContainerMap = new LinkedHashMap<String, CellTypeContainer>();
        cellTypeContainers.forEach(item -> cellTypeContainerMap.put(item.getKeyName(), (CellTypeContainer)item));
        this.parseCellTypeContainerMapDict(cellTypeContainerMap);
        return cellTypeContainerMap;
    }

    public Map<String, CellTypeContainer> getResponseCellTypeContainers(GetActionLocaleResponseDTO getActionLocaleResponseDTO, String token, String locale) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        if (CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTO.getField())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0102.getErrCode(), (String)"\u5143\u6570\u636e\u51fa\u53c2\u4e3a\u7a7a");
        }
        List keyList = apiDataFieldLocaleMetadataDTO.getField().stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).collect(Collectors.toList());
        keyList.removeAll(Collections.singleton(null));
        List<CellTypeContainer> cellTypeContainers = this.getCellTypeContainers(apiDataFieldLocaleMetadataDTO.getField(), token, null, locale, 1);
        Map<String, CellTypeContainer> cellTypeContainerMap = cellTypeContainers.stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, Function.identity()));
        this.parseCellTypeContainerMapDict(cellTypeContainerMap);
        return cellTypeContainerMap;
    }

    private void parseCellTypeContainerMapDict(Map<String, CellTypeContainer> cellTypeContainerMap) {
        cellTypeContainerMap.forEach((k, v) -> {
            if (!CollectionUtils.isEmpty((Collection)v.getDictionaries())) {
                Map<String, String> dictMap = v.getDictionaries().stream().collect(Collectors.toMap(Dictionary::getCode, Dictionary::getValue, (entity1, entity2) -> entity1));
                v.setDictMap(dictMap);
            }
            if (!CollectionUtils.isEmpty((Collection)v.getChildren())) {
                v.getChildren().forEach(item -> {
                    if (!CollectionUtils.isEmpty((Collection)item.getDictionaries())) {
                        Map<String, String> dictMapInner = item.getDictionaries().stream().collect(Collectors.toMap(Dictionary::getCode, Dictionary::getValue, (entity1, entity2) -> entity1));
                        item.setDictMap(dictMapInner);
                    }
                });
            }
        });
    }

    private String[] parseBooleanListEnum() {
        return new String[]{"TRUE", "FALSE"};
    }

    private String[] parseListEnum(ApiDataFieldLocaleMetadataDTO item) {
        return null;
    }

    private String parseDateFormat(ApiDataFieldLocaleMetadataDTO item) {
        String locale;
        MultiLanguageDTO multiLanguageDTO = null;
        if (null == multiLanguageDTO) {
            switch (MetaDataType.valueOf((String)item.getData_type().toUpperCase())) {
                case DATETIME: {
                    return "yyyy-MM-dd HH:mm:ss";
                }
                case TIME: {
                    return "HH:mm:ss";
                }
                case DATE: {
                    return "yyyy-MM-dd";
                }
            }
            return "yyyy-MM-dd";
        }
        switch (locale = LocaleContextHolder.getLocale().toString()) {
            case "zh_TW": {
                return multiLanguageDTO.getZh_TW();
            }
            case "zh_CN": {
                return multiLanguageDTO.getZh_CN();
            }
            case "en_US": {
                return multiLanguageDTO.getEn();
            }
        }
        return multiLanguageDTO.getZh_CN();
    }

    private int[] parsePrecision(ApiDataFieldLocaleMetadataDTO metadataDTO) {
        if (!StringUtils.isEmpty((String)metadataDTO.getPrecision())) {
            String precision = metadataDTO.getPrecision();
            if (StringUtils.isEmpty((String)precision)) {
                return new int[0];
            }
            if (precision.indexOf(",") != -1) {
                String[] values = precision.substring(precision.indexOf("(") + 1, precision.indexOf(")")).split(",");
                if (StringUtils.isEmpty((String)values[0]) || StringUtils.isEmpty((String)values[1]) || "null".equals(values[0]) || "null".equals(values[1])) {
                    return new int[0];
                }
                int[] precisionValue = new int[]{Integer.valueOf(values[0]), Integer.valueOf(values[1])};
                return precisionValue;
            }
            int[] precisionValue = new int[]{Integer.valueOf(precision)};
            return precisionValue;
        }
        return new int[0];
    }

    public void getMetaDataTypeMap(Map<String, MetaDataType> enumMap, Map<String, MetaDataType> nonEnumMap, GetActionLocaleResponseDTO getActionLocaleResponseDTO, String tableKey) {
        List<ApiDataFieldLocaleMetadataDTO> objects = getActionLocaleResponseDTO.getRequest().getParameters();
        objects.forEach(item -> {
            if (item.getData_name().equals(tableKey)) {
                List<ApiDataFieldLocaleMetadataDTO> parameters = item.getField();
                parameters.forEach(param -> {
                    if (StringUtils.isEmpty((String)param.getEnum_key())) {
                        nonEnumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
                    } else {
                        enumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
                    }
                });
            }
        });
    }

    public void getMetaDataTypeMapNew(Map<String, MetaDataType> enumMap, Map<String, MetaDataType> nonEnumMap, ApiDataFieldLocaleMetadataDTO cellTypeContainer, Map<String, ApiDataFieldLocaleMetadataDTO> parentBKMetadataMap) {
        List<ApiDataFieldLocaleMetadataDTO> parameters = cellTypeContainer.getField();
        parameters.forEach(param -> {
            if (StringUtils.isEmpty((String)param.getEnum_key())) {
                nonEnumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
            } else {
                enumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
            }
        });
        if (CollectionUtils.isEmpty(parentBKMetadataMap)) {
            return;
        }
        parentBKMetadataMap.forEach((bkName, bkMetadata) -> {
            if (StringUtils.isEmpty((String)bkMetadata.getEnum_key())) {
                nonEnumMap.put((String)bkName, MetaDataType.valueOf((String)bkMetadata.getData_type().toUpperCase()));
            } else {
                enumMap.put((String)bkName, MetaDataType.valueOf((String)bkMetadata.getData_type().toUpperCase()));
            }
        });
    }

    public void getMetaDataTypeMapNew(Map<String, MetaDataType> enumMap, Map<String, MetaDataType> nonEnumMap, GetActionLocaleResponseDTO getActionLocaleResponseDTO, String tableKey) {
        List<ApiDataFieldLocaleMetadataDTO> objects = getActionLocaleResponseDTO.getRequest().getParameters();
        objects.forEach(item -> {
            if (item.getData_name().equals(tableKey)) {
                List<ApiDataFieldLocaleMetadataDTO> parameters = item.getField();
                parameters.forEach(param -> {
                    if (StringUtils.isEmpty((String)param.getEnum_key())) {
                        nonEnumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
                    } else {
                        enumMap.put(param.getData_name(), MetaDataType.valueOf((String)param.getData_type().toUpperCase()));
                    }
                });
            }
        });
    }

    public void getBodyMetaDataTypeMap(Map<String, MetaDataType> enumMap, Map<String, MetaDataType> nonEnumMap, GetActionLocaleResponseDTO getActionLocaleResponseDTO, String bodyKey, String tableKey) {
        List<ApiDataFieldLocaleMetadataDTO> objects = getActionLocaleResponseDTO.getRequest().getParameters();
        block0: for (ApiDataFieldLocaleMetadataDTO item : objects) {
            if (!item.getData_name().equals(tableKey)) continue;
            List<ApiDataFieldLocaleMetadataDTO> parameters = item.getField();
            for (ApiDataFieldLocaleMetadataDTO param : parameters) {
                if (!param.getData_name().equals(bodyKey)) continue;
                List<ApiDataFieldLocaleMetadataDTO> bodyParameters = param.getField();
                bodyParameters.forEach(bodyParameter -> {
                    if (StringUtils.isEmpty((String)bodyParameter.getEnum_key())) {
                        nonEnumMap.put(bodyParameter.getData_name(), MetaDataType.valueOf((String)bodyParameter.getData_type().toUpperCase()));
                    } else {
                        enumMap.put(bodyParameter.getData_name(), MetaDataType.valueOf((String)bodyParameter.getData_type().toUpperCase()));
                    }
                });
                break block0;
            }
        }
    }

    public void getBodyMetaDataTypeMapCopy(Map<String, MetaDataType> enumMap, Map<String, MetaDataType> nonEnumMap, ApiDataFieldLocaleMetadataDTO bodyFiled) {
        List<ApiDataFieldLocaleMetadataDTO> bodyParameters = bodyFiled.getField();
        bodyParameters.forEach(bodyParameter -> {
            if (StringUtils.isEmpty((String)bodyParameter.getEnum_key())) {
                nonEnumMap.put(bodyParameter.getData_name(), MetaDataType.valueOf((String)bodyParameter.getData_type().toUpperCase()));
            } else {
                enumMap.put(bodyParameter.getData_name(), MetaDataType.valueOf((String)bodyParameter.getData_type().toUpperCase()));
            }
        });
    }

    public List<Map> validateByBatchV2(DataEntryTask dataEntryTask, List<CellTypeContainer> cellTypes, List<Map> rowDataList) {
        if (null == dataEntryTask.getActionInfo() || MapUtils.isEmpty(dataEntryTask.getActionInfo().getSheetRequiredFiled())) {
            return new LinkedList<Map>();
        }
        return this.doValidateDataV2(dataEntryTask.getTableKey(), rowDataList, dataEntryTask, cellTypes);
    }

    public List<CellTypeContainer> getCellTypeContainersV2(List<ApiDataFieldLocaleMetadataDTO> field, String token, String securityToken, String locale, int depth) {
        LinkedList<CellTypeContainer> cellTypes = new LinkedList<CellTypeContainer>();
        List<String> keyList = field.stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).collect(Collectors.toList());
        keyList.removeAll(Collections.singleton(null));
        Map<String, List<Dictionary>> dictionaryMap = this.getDictByKeyList(keyList, token, securityToken, locale);
        field.forEach(item -> {
            CellTypeContainer cellTypeContainer;
            switch (MetaDataType.valueOf((String)item.getData_type().toUpperCase())) {
                case NUMBER: 
                case NUMERIC: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(dictionaryMap.get(item.getEnum_key())), Dictionary.class);
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer.setProtoType(MetaDataType.STRING);
                    cellTypeContainer.setCellType(CellType.STRING);
                    int[] precision = this.parsePrecision((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setPrecision(precision);
                    break;
                }
                case DATETIME: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.DATETIME);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String dateFormat = this.parseDateFormat((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setDateFormat(dateFormat);
                    break;
                }
                case TIME: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.TIME);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String dateFormat = this.parseDateFormat((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setDateFormat(dateFormat);
                    break;
                }
                case DATE: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.DATE);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String dateFormat = this.parseDateFormat((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setDateFormat(dateFormat);
                    break;
                }
                case STRING: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(dictionaryMap.get(item.getEnum_key())), Dictionary.class);
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.STRING);
                    cellTypeContainer.setCellType(CellType.STRING);
                    int[] precision = this.parsePrecision((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setPrecision(precision);
                    break;
                }
                case OBJECT: {
                    cellTypeContainer = new CellTypeContainer();
                    if (item.getIs_array()) {
                        cellTypeContainer.setChildren(this.getCellTypeContainers(item.getField(), token, securityToken, locale, depth + 1));
                    }
                    cellTypeContainer.setProtoType(MetaDataType.OBJECT);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String[] listEnum = this.parseListEnum((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setListEnum(listEnum);
                    break;
                }
                case BOOLEAN: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(dictionaryMap.get(item.getEnum_key())), Dictionary.class);
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer.setProtoType(MetaDataType.BOOLEAN);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String[] listEnum = this.parseBooleanListEnum();
                    cellTypeContainer.setListEnum(listEnum);
                    break;
                }
                default: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setCellType(CellType.STRING);
                }
            }
            cellTypeContainer.setRequired(item.getRequired());
            cellTypeContainer.setBusinessKey(Boolean.valueOf(item.getIs_businesskey()));
            cellTypeContainer.setArray(Boolean.valueOf(item.getIs_array()));
            cellTypeContainer.setKeyName(item.getData_name());
            cellTypeContainer.setKeyDescription(item.getDescription());
            cellTypes.add(cellTypeContainer);
        });
        return cellTypes;
    }

    public Map<String, CellTypeContainer> getResponseCellTypeContainersV2(GetActionLocaleResponseDTO getActionLocaleResponseDTO, String token, String locale) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        if (CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTO.getField())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0102.getErrCode(), (String)"\u5143\u6570\u636e\u51fa\u53c2\u4e3a\u7a7a");
        }
        List keyList = apiDataFieldLocaleMetadataDTO.getField().stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).collect(Collectors.toList());
        keyList.removeAll(Collections.singleton(null));
        List<CellTypeContainer> cellTypeContainers = this.getCellTypeContainersV2(apiDataFieldLocaleMetadataDTO.getField(), token, null, locale, 1);
        Map<String, CellTypeContainer> cellTypeContainerMap = cellTypeContainers.stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, Function.identity()));
        this.parseCellTypeContainerMapDict(cellTypeContainerMap);
        return cellTypeContainerMap;
    }

    private List<Map> doValidateDataV2(String dataKey, List<Map> rowDataList, DataEntryTask dataEntryTask, List<CellTypeContainer> cellTypes) {
        ArrayList<Map> errorRowDataList = new ArrayList<Map>();
        Set<String> requiredFiled = this.getRequiredFields(dataEntryTask, dataKey);
        Map<String, CellTypeContainer> cellTypeContainerMap = this.createCellTypeMap(cellTypes);
        String locale = dataEntryTask.getLocale();
        rowDataList.forEach(rowData -> {
            LinkedHashMap rowDataErrorMsg = new LinkedHashMap();
            boolean parentHasError = false;
            boolean sonHasError = false;
            for (Map.Entry entry : rowData.entrySet()) {
                String errorMsg;
                List<Map> sonErrorDataList;
                CellTypeContainer cellType = (CellTypeContainer)cellTypeContainerMap.get(entry.getKey());
                if (entry.getValue() instanceof List && !CollectionUtils.isEmpty(sonErrorDataList = this.doValidateDataV2((String)entry.getKey(), (List)entry.getValue(), dataEntryTask, cellType.getChildren()))) {
                    sonHasError = true;
                    rowDataErrorMsg.put(entry.getKey(), sonErrorDataList);
                }
                if (!StringUtils.isNotEmpty((String)(errorMsg = ValidatorLoader.valid(entry, requiredFiled, cellType, locale)))) continue;
                parentHasError = true;
                rowDataErrorMsg.put((String)entry.getKey() + "_error_msg", errorMsg);
            }
            if (parentHasError || sonHasError) {
                HashMap errorRow = MapUtil.newHashMap((int)(rowData.size() + rowDataErrorMsg.size()), (boolean)true);
                errorRow.putAll(rowData);
                errorRow.putAll(rowDataErrorMsg);
                errorRowDataList.add(errorRow);
            }
        });
        return errorRowDataList;
    }

    private Set<String> getRequiredFields(DataEntryTask task, String dataKey) {
        return Optional.ofNullable(task.getActionInfo().getSheetRequiredFiled()).map(map -> (Set)map.get(dataKey)).orElse(Collections.emptySet());
    }

    private Map<String, CellTypeContainer> createCellTypeMap(List<CellTypeContainer> cellTypes) {
        return cellTypes.stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, Function.identity(), (existing, replacement) -> existing));
    }
}

