/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.impl;

import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.DMCTokenBean;
import com.digiwin.athena.abt.application.service.abt.migration.inout.DmcService;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.ExcelTypeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    @Resource
    RestTemplate dmcRestTemplate;
    @Autowired
    DMCConfig dmcConfig;
    @Autowired
    DMCTokenBean dmcTokenBean;
    @Value(value="${dmc.uri}")
    private String dmcUrl;
    @Value(value="${athena.auth.appToken}")
    private String appToken;

    @Override
    public void refreshToken() {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.set("digi-middleware-auth-app", this.appToken);
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("username", this.dmcConfig.getUserName());
        reqMap.put("pwdhash", this.dmcConfig.getPassword());
        String url = this.dmcUrl + "/api/dmc/v1/auth/login";
        HttpEntity httpEntity = new HttpEntity(reqMap, (MultiValueMap)header);
        ResponseEntity resMap = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        String token = (String)((Map)resMap.getBody()).get("userToken");
        if (StringUtils.isEmpty((String)token)) {
            throw BusinessException.create((String)ErrorCodeEnum.DMC_V2_LOGIN.getErrCode(), (String)"\u83b7\u53d6token\u5931\u8d25");
        }
        this.dmcTokenBean.setToken(token);
    }

    @Override
    public InputStream getExportFileInputStream(String fileUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        list.add(MediaType.parseMediaType((String)ExcelTypeEnum.XLSX.value()));
        headers.setAccept(list);
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/download/" + fileUrl;
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }
}

