/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetRecordsParamDTO;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsRepositoryFacade;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportStatisticsMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportStatisticsPO;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ExportStatisticsRepositoryImpl
implements ExportStatisticsRepositoryFacade {
    @Autowired
    ExportStatisticsMapper exportStatisticsMapper;

    @Override
    public int save(ExportStatisticsPO exportStatisticsPO) {
        return this.exportStatisticsMapper.insert((Object)exportStatisticsPO);
    }

    @Override
    public ExportStatisticsPO getByMasterId(String masterId) {
        return (ExportStatisticsPO)this.exportStatisticsMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"master_id", (Object)masterId));
    }

    @Override
    public void updateById(ExportStatisticsPO exportStatisticsPO) {
        this.exportStatisticsMapper.updateById((Object)exportStatisticsPO);
    }

    @Override
    public List<ExportStatisticsPO> getRecordsByUserId(String userId, String tenantId, Integer getRecordsNum, GetRecordsParamDTO param) {
        Integer start = (param.getOffset() - 1) * getRecordsNum;
        Integer end = param.getOffset() * getRecordsNum;
        ArrayList types = param.getTypes();
        String type = param.getType();
        if (CollectionUtils.isEmpty(types) && StringUtils.isNotBlank((CharSequence)type)) {
            types = Lists.newArrayList((Object[])new String[]{type});
        }
        List exportStatisticsPOS = this.exportStatisticsMapper.getRecordsByUserId(userId, tenantId, end, param.getState(), (List)types, param.getStartTime(), param.getEndTime(), param.getActivityName(), start, param.getFileName());
        return exportStatisticsPOS;
    }

    @Override
    public Integer countRecord(String userId, String tenantId, GetRecordsParamDTO param) {
        ArrayList types = param.getTypes();
        String type = param.getType();
        if (CollectionUtils.isEmpty(types) && StringUtils.isNotBlank((CharSequence)type)) {
            types = Lists.newArrayList((Object[])new String[]{type});
        }
        return this.exportStatisticsMapper.countRecord(userId, tenantId, param.getState(), (List)types, param.getStartTime(), param.getEndTime(), param.getActivityName());
    }

    @Override
    public List<ExportStatisticsPO> getProcessingRecords() {
        List exportStatisticsPOS = this.exportStatisticsMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"state", (Object)ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING));
        return exportStatisticsPOS;
    }

    @Override
    public List<ExportStatisticsPO> getProcessingRecordsByUserId(String userId, String tenantId, String type, List<String> types) {
        if (CollectionUtils.isEmpty(types) && StringUtils.isNotBlank((CharSequence)type)) {
            types = Lists.newArrayList((Object[])new String[]{type});
        }
        List exportStatisticsPOS = this.exportStatisticsMapper.getProcessingRecordsByUserId(userId, tenantId, ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING, types);
        return exportStatisticsPOS;
    }

    @Override
    public void updateRetryDownloadStateById(String masterId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(ExportStatisticsPO::getMasterId, (Object)masterId)).set(ExportStatisticsPO::getHasBeenReExported, (Object)1);
        JaLog.info((String)" retry export start ", (Object[])new Object[0]);
        this.exportStatisticsMapper.update(null, (Wrapper)wrapper);
        JaLog.info((String)" has been re-exported", (Object[])new Object[0]);
    }

    @Override
    public void updateByStateAndId(ExportStatisticsPO exportStatisticsPO, Long id, Integer state) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(ExportStatisticsPO::getId, (Object)id)).eq(ExportStatisticsPO::getState, (Object)state);
        JaLog.info((String)" retry export start ", (Object[])new Object[0]);
        this.exportStatisticsMapper.update((Object)exportStatisticsPO, (Wrapper)wrapper);
        JaLog.info((String)" has been re-exported", (Object[])new Object[0]);
    }
}

