/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.MidWareResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.DMCTokenBean;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ErrorTable;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ErrorHandlerService;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.ExcelTypeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RabbitErrorHandlerServiceImpl
implements ErrorHandlerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RabbitErrorHandlerServiceImpl.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Resource
    RestTemplate dmcRestTemplate;
    @Autowired
    DMCConfig dmcConfig;
    @Autowired
    DMCTokenBean dmcTokenBean;
    @Autowired
    ExcelHelper excelHelper;
    @Value(value="${dmc.uri}")
    private String dmcUrl;
    @Value(value="${athena.auth.appToken}")
    private String appToken;
    private final String EXCEL_SUFFIX = ".xlsx";
    private final String BASE_URL = this.getClass().getClassLoader().getResource("").getFile();
    private final String PACKAGE_NAME = "importError";
    private final String HEADER_KEY = "key";
    private final String HEADER_NAME = "name";
    private final String SHEET_NAME = "sheet1";

    @Override
    public void handleErrorList(ImportStatistics importStatistics, List<Map> errorTable, boolean createQueueFlag) throws IOException {
        String masterId = importStatistics.getMasterId();
        if (createQueueFlag) {
            try (Channel channel = this.rabbitTemplate.getConnectionFactory().createConnection().createChannel(false);){
                Map arguments = Collections.EMPTY_MAP;
                channel.queueDeclare(masterId, false, false, false, arguments);
                channel.queueBind(masterId, "AbtImportErrorTableExchange", masterId);
            }
            catch (TimeoutException e) {
                log.error("close rabbit channel timeout", (Throwable)e);
            }
        }
        this.rabbitTemplate.convertAndSend("AbtImportErrorTableExchange", masterId, errorTable);
        log.error("sendErrorData for {}", (Object)masterId);
    }

    @Override
    public ErrorTable getErrorTableByMasterId(String mainKeyName, ImportStatistics importStatistics, Map<String, CellTypeContainer> cellTypeContainerMap, List<String> mainKeys) {
        String failedUrl = importStatistics.getFailedUrl();
        String masterId = importStatistics.getMasterId();
        String actionId = importStatistics.getActionId();
        Integer succeededNum = importStatistics.getSucceededNum();
        Integer processingNum = importStatistics.getProcessingNum();
        Integer failedNum = importStatistics.getFailedNum();
        Integer errorNum = importStatistics.getErrorNum();
        Integer republished = importStatistics.getRepublished();
        if (StringUtils.isEmpty((Object)failedUrl)) {
            log.error("\u6587\u4ef6\u4e0d\u5b58\u5728,masterId:{}", (Object)masterId);
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            InputStream inputStream = this.getErrorTableInputStream(failedUrl);
            XSSFWorkbook wb = new XSSFWorkbook(inputStream);
            LinkedList<String> headerKeys = new LinkedList<String>();
            List<Map> headers = this.excelHelper.readHeaders((Workbook)wb, cellTypeContainerMap, headerKeys, mainKeys);
            List<Map> data = this.excelHelper.readRootData((Workbook)wb, mainKeyName, cellTypeContainerMap);
            ErrorTable errorTable = new ErrorTable();
            errorTable.setHeaders(headers);
            errorTable.setData(data);
            errorTable.setActionId(actionId);
            errorTable.setErrorNum(errorNum);
            errorTable.setSucceededNum(succeededNum);
            errorTable.setFailedNum(failedNum);
            errorTable.setProcessingNum(processingNum);
            errorTable.setRepublished(republished);
            return errorTable;
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u9519\u8bef\u6570\u636e\u6587\u6863IO\u5f02\u5e38", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0073.getErrCode(), (String)"IO\u5f02\u5e38");
        }
    }

    private InputStream getErrorTableInputStream(String failedUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        list.add(MediaType.parseMediaType((String)ExcelTypeEnum.XLSX.value()));
        headers.setAccept(list);
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/download/" + failedUrl;
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }

    @Override
    public void downloadErrorTable(ImportStatistics importStatistics, List<Map> headers, Set<String> requiredFields, HttpServletResponse response) {
        Object cell1;
        XSSFWorkbook wb;
        String failedUrl = importStatistics.getFailedUrl();
        if (StringUtils.isEmpty((Object)failedUrl)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0074.getErrCode(), (String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u6587\u6863");
        }
        response.setContentType(ExcelTypeEnum.XLSX.value());
        response.setCharacterEncoding("utf-8");
        String formFileName = this.getFileName(importStatistics);
        response.addHeader("Content-Disposition", "attachment;filename=" + formFileName + ".xlsx");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        InputStream inputStream = this.getErrorTableInputStream(failedUrl);
        try {
            wb = new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0075.getErrCode(), (String)("\u89e3\u6790excel\u5931\u8d25masterid:" + importStatistics.getMasterId()));
        }
        XSSFSheet sheet = wb.getSheetAt(0);
        Row headRow1 = sheet.getRow(0);
        Row headRow2 = sheet.getRow(1);
        Map<Object, Object> headerMap = new HashMap();
        if (!CollectionUtils.isEmpty(headers)) {
            headerMap = headers.stream().collect(Collectors.toMap(s -> (String)s.get("key"), s -> (String)s.get("name")));
        }
        if (!CollectionUtils.isEmpty(headerMap)) {
            for (int i = 0; i < headRow1.getLastCellNum(); ++i) {
                cell1 = headRow1.getCell(i);
                Cell cell2 = headRow2.getCell(i);
                String langVal = (String)headerMap.get(cell2.getStringCellValue());
                String string = langVal = StringUtils.isEmpty((Object)langVal) ? cell1.getStringCellValue() : langVal;
                if (!CollectionUtils.isEmpty(requiredFields) && requiredFields.contains((String)headers.get(i).get("key"))) {
                    cell1.setCellValue((RichTextString)ExcelUtil.addRequiredMark(wb, langVal, (Font)wb.getFontAt(cell1.getCellStyle().getFontIndex())));
                    continue;
                }
                cell1.setCellValue(langVal);
            }
        }
        try {
            ServletOutputStream os = response.getOutputStream();
            cell1 = null;
            try {
                wb.write((OutputStream)os);
                wb.close();
            }
            catch (Throwable throwable) {
                cell1 = throwable;
                throw throwable;
            }
            finally {
                if (os != null) {
                    if (cell1 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)cell1).addSuppressed(throwable);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        catch (IOException e) {
            if (null != wb) {
                try {
                    wb.close();
                }
                catch (IOException ioe) {
                    log.error("\u5173\u95edwb\u5f02\u5e38", (Throwable)ioe);
                }
            }
            log.error("\u5bfc\u51fa\u5f02\u5e38\u6570\u636e\u5199\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    private String getFileName(ImportStatistics importStatistics) {
        String locale;
        JSONObject jsonObject = JSON.parseObject((String)importStatistics.getActivityName());
        String fileName = "";
        switch (locale = importStatistics.getLocale()) {
            case "zh_CN": {
                fileName = jsonObject.getString("default");
                break;
            }
            case "zh_TW": {
                fileName = jsonObject.getString("zh_TW");
                break;
            }
            case "en_US": {
                fileName = jsonObject.getString("en_US");
                break;
            }
            default: {
                fileName = jsonObject.getString("default");
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH_mm_ss");
        String formatTime = simpleDateFormat.format(importStatistics.getCreateTime());
        fileName = fileName + " " + formatTime;
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Exception occurred", (Throwable)e);
        }
        fileName = fileName.replaceAll("\\+", "%20");
        return fileName;
    }

    @Override
    public String onImportFinish(String sheetName, List<String> keyList, Map<String, CellTypeContainer> cellTypeContainerMap, Map<String, String> headers, ImportStatistics importStatistics) {
        log.error("importFinish for {}", (Object)importStatistics.getMasterId());
        int failedNum = importStatistics.getFailedNum();
        String masterId = importStatistics.getMasterId();
        if (0 != failedNum) {
            MultipartFile multipartFile;
            List<Map<String, Object>> errorTable = this.fetchData(masterId, failedNum);
            XSSFWorkbook wb = new XSSFWorkbook();
            int rowIndex = importStatistics.getFailedNum() - errorTable.size() + 2;
            String locale = importStatistics.getLocale();
            List<CellTypeContainer> businessKeyContainer = this.excelHelper.getBusinessKeyContainer(new ArrayList<CellTypeContainer>(cellTypeContainerMap.values()));
            this.excelHelper.createDataExcel(sheetName, locale, rowIndex, keyList, cellTypeContainerMap, headers, errorTable, (Workbook)wb, businessKeyContainer, 0, null, null);
            try {
                multipartFile = this.workbookToMultipartFile((Workbook)wb, importStatistics.getMasterId());
            }
            catch (IOException e) {
                log.error("\u8f6c\u6362multipartfile\u5931\u8d25:{}", (Throwable)e);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"\u8f6c\u6362multipartFile\u5931\u8d25:{}", (Throwable)e);
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDisplayName(importStatistics.getMasterId());
            fileInfo.setDirectoryId(this.dmcConfig.getErrorTableUUID());
            String failedUrl = this.upload(multipartFile, fileInfo);
            this.clearQueue(masterId);
            return failedUrl;
        }
        return "";
    }

    @Override
    public MultipartFile workbookToMultipartFile(Workbook wb, String fileName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        wb.write((OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        MockMultipartFile multipartFile = new MockMultipartFile("file", fileName, ExcelTypeEnum.XLSX.value(), (InputStream)is);
        return multipartFile;
    }

    @Override
    public MultipartFile workbookToZipFile(Workbook wb, String fileName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        wb.write((OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        MockMultipartFile multipartFile = new MockMultipartFile("file", fileName, ExcelTypeEnum.XLSX.value(), (InputStream)is);
        return multipartFile;
    }

    @Override
    public String upload(MultipartFile uploadFile, FileInfo fileInfo) {
        if (Objects.isNull(uploadFile)) {
            log.error("uploadFile is null!");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0078.getErrCode());
        }
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        header.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        header.add("digi-middleware-auth-app", this.appToken);
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)uploadFile.getContentType()));
        fileHeader.setContentDispositionFormData("file", uploadFile.getOriginalFilename());
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        try {
            HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(uploadFile.getBytes()), (MultiValueMap)fileHeader);
            HttpEntity fileInfoEntity = new HttpEntity((Object)fileInfo, (MultiValueMap)fileInfoHeader);
            multiValueMap.add((Object)"file", (Object)fileEntity);
            multiValueMap.add((Object)"fileInfo", (Object)fileInfoEntity);
            String url = this.dmcUrl + "/api/dmc/v2/file/Athena/upload";
            HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)header);
            ResponseEntity postForEntity = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, MidWareResponse.class, new Object[0]);
            MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
            if (midWareResponse.getSuccess().booleanValue()) {
                return (String)((Map)midWareResponse.getData()).get("id");
            }
            log.error("\u8c03\u7528\u4e0a\u4f20api\u5931\u8d25");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0077.getErrCode(), (String)MessageUtil.getMessage("delivery.uploadError2", new Object[0]));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0078.getErrCode(), (String)"", (Throwable)e);
        }
    }

    private List<Map<String, Object>> fetchData(String masterId, int failedNum) {
        ArrayList<Map<String, Object>> errorTable = new ArrayList<Map<String, Object>>(failedNum);
        while (0 < failedNum) {
            Object msgObj = this.rabbitTemplate.receiveAndConvert(masterId, 1000L);
            List errorBatch = new ArrayList();
            if (!Objects.nonNull(msgObj)) {
                log.error("fetchData getRabbitMqMsg is null");
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0115.getErrCode(), (String)"\u62c9\u53d6\u5bfc\u5165\u5f02\u5e38\u6570\u636e\u5931\u8d25:{}");
            }
            errorBatch = (List)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)msgObj), List.class);
            failedNum -= errorBatch.size();
            errorTable.addAll(errorBatch);
        }
        return errorTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue(String masterId) {
        Channel channel = this.rabbitTemplate.getConnectionFactory().createConnection().createChannel(false);
        try {
            channel.queueDelete(masterId);
        }
        catch (IOException e) {
            log.error("\u5220\u9664\u961f\u5217\u5f02\u5e38:{}", (Throwable)e);
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException e) {
                log.error(e.toString());
            }
            catch (TimeoutException e) {
                log.error(e.toString());
            }
        }
    }

    @Override
    public String uploadFileToHttpServer(File file, FileInfo fileInfo) {
        if (Objects.isNull(file)) {
            log.error("uploadFile is null!");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0078.getErrCode());
        }
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        header.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        header.add("digi-middleware-auth-app", this.appToken);
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        try {
            HttpEntity fileInfoEntity = new HttpEntity((Object)fileInfo, (MultiValueMap)fileInfoHeader);
            multiValueMap.add((Object)"file", (Object)new FileSystemResource(file));
            multiValueMap.add((Object)"fileInfo", (Object)fileInfoEntity);
            String url = this.dmcUrl + "/api/dmc/v2/file/Athena/upload";
            HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)header);
            ResponseEntity postForEntity = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, MidWareResponse.class, new Object[0]);
            MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
            if (midWareResponse.getSuccess().booleanValue()) {
                return (String)((Map)midWareResponse.getData()).get("id");
            }
            log.error("\u8c03\u7528\u4e0a\u4f20api\u5931\u8d25");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0077.getErrCode(), (String)MessageUtil.getMessage("delivery.uploadError2", new Object[0]));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0078.getErrCode(), (String)"", (Throwable)e);
        }
    }
}

