/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.Validator;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class AbstractValidator
implements Validator {
    private static final String ERROR_CODE = "upload.miss.filed.error";

    @Override
    public String doValidate(Object data, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        Map.Entry cellEntry = (Map.Entry)data;
        String requiredMsg = this.requiredValidator(cellEntry, requiredFiled, locale);
        if (StringUtils.isNotEmpty((String)requiredMsg)) {
            return requiredMsg;
        }
        return this.formatValidator(requiredFiled, container, locale, cellEntry);
    }

    private String formatValidator(Set<String> requiredFiled, CellTypeContainer container, String locale, Map.Entry<String, Object> cellEntry) {
        String errorMsg = null;
        if (null == container) {
            return errorMsg;
        }
        Object cellValue = cellEntry.getValue();
        if (null == cellValue || cellValue instanceof String && ((String)cellValue).isEmpty()) {
            return errorMsg;
        }
        return this.validate(cellValue, requiredFiled, container, locale);
    }

    public String requiredValidator(Map.Entry<String, Object> cellEntry, Set<String> requiredFiled, String locale) {
        String errorMsg = null;
        if (CollectionUtils.isEmpty(requiredFiled) || !requiredFiled.contains(cellEntry.getKey())) {
            return errorMsg;
        }
        if (null == cellEntry.getValue()) {
            return MessageUtil.getMessageByLocale(ERROR_CODE, locale, new Object[0]);
        }
        if (cellEntry.getValue() instanceof String && ((String)cellEntry.getValue()).trim().isEmpty()) {
            return MessageUtil.getMessageByLocale(ERROR_CODE, locale, new Object[0]);
        }
        return errorMsg;
    }

    public String validate(Object data, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        return null;
    }
}

