/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.AbstractValidator;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class BooleanValidator
extends AbstractValidator {
    private static final String BOOLEAN_VALIDATOR_ERROR_CODE = "excel.select.content.selectCorrect";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && MetaDataType.BOOLEAN.getName().equals(cellTypeContainer.getProtoType().getName());
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        List<String> enumList;
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (!(cellValue instanceof Boolean) && !(enumList = Arrays.asList(container.getListEnum())).contains(cellValue)) {
            superErrorMsg = MessageUtil.getMessageByLocale(BOOLEAN_VALIDATOR_ERROR_CODE, locale, enumList.toString());
        }
        return superErrorMsg;
    }
}

