/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.AbstractValidator;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class EnumValidator
extends AbstractValidator {
    private static final String ENUM_VALIDATOR_ERROR_CODE = "excel.select.content.selectCorrect";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && MetaDataType.ENUM.getName().equals(cellTypeContainer.getProtoType().getName());
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        List<String> enumList;
        List<String> enumCodes;
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (null != container.getListEnum() && container.getListEnum().length != 0 && !(enumCodes = this.getEnumCodes(enumList = Arrays.asList(container.getListEnum()))).contains(cellValue)) {
            superErrorMsg = MessageUtil.getMessageByLocale(ENUM_VALIDATOR_ERROR_CODE, locale, enumList.toString());
        }
        return superErrorMsg;
    }

    private List<String> getEnumCodes(List<String> enumList) {
        ArrayList<String> enumCodes = new ArrayList<String>();
        for (String enumStr : enumList) {
            int index = enumStr.lastIndexOf(".");
            String code = index > 0 ? enumStr.substring(0, index) : enumStr;
            enumCodes.add(code);
        }
        return enumCodes;
    }
}

