/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.AbstractValidator;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import java.util.Set;

public class StringValidator
extends AbstractValidator {
    private static final String STRING_VALIDATOR_ERROR_CODE = "excel.string.content.length";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && MetaDataType.STRING.getName().equals(cellTypeContainer.getProtoType().getName());
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (null != container.getPrecision() && container.getPrecision().length != 0) {
            int max;
            int n = max = null != container.getPrecision() && container.getPrecision().length != 0 ? container.getPrecision()[0] : Integer.MAX_VALUE;
            if (cellValue.toString().length() > max) {
                superErrorMsg = MessageUtil.getMessageByLocale(STRING_VALIDATOR_ERROR_CODE, locale, max);
            }
        }
        return superErrorMsg;
    }
}

