/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.BooleanValidator;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.DateTimeValidator;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.DefaultValidator;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.EnumValidator;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.NumberValidator;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.NumericValidator;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.StringValidator;
import com.digiwin.athena.abt.application.service.abt.migration.inout.validate.Validator;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ValidatorLoader {
    private static List<Validator> validators;

    private static void initAllValidator() {
        validators = new ArrayList<Validator>();
        validators.add(new StringValidator());
        validators.add(new NumberValidator());
        validators.add(new NumericValidator());
        validators.add(new DateTimeValidator());
        validators.add(new DateTimeValidator());
        validators.add(new DateTimeValidator());
        validators.add(new BooleanValidator());
        validators.add(new EnumValidator());
        validators.add(new DefaultValidator());
    }

    public static String valid(Object cellData, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        for (Validator t : validators) {
            if (!t.supportKey(container).booleanValue()) continue;
            return t.doValidate(cellData, requiredFiled, container, locale);
        }
        return null;
    }

    static {
        ValidatorLoader.initAllValidator();
    }
}

