/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LockPool {
    private ConcurrentHashMap<Integer, ReentrantLock> mappedLockPool;
    @Value(value="${data-entry.lock-pool.size:9}")
    private int poolSize;

    @PostConstruct
    public void init() {
        this.mappedLockPool = new ConcurrentHashMap();
        for (int i = 0; i < this.poolSize; ++i) {
            this.mappedLockPool.put(i + 1, new ReentrantLock());
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ReentrantLock getLockById(int id) {
        if (id > this.poolSize) {
            throw new IndexOutOfBoundsException("id cannot be larger than pool size");
        }
        return this.mappedLockPool.get(id);
    }
}

