/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.application.service.abt.migration.sendmsg.TaskOperateSendMsgMqService;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

@Service
public class TaskOperateSendMsgModel
extends EventBaseService
implements EventInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskOperateSendMsgModel.class);
    @Autowired
    private TaskOperateSendMsgMqService taskOperateSendMsgMqService;

    @Override
    public String modelType() {
        return "taskOperateSendMsgModel";
    }

    @Override
    public void distributeMessages(String data) {
        log.info("[taskOperateSendMsg] distributeMessages, data = {}", (Object)data);
        this.rabbitTemplate.convertAndSend("athena.event.message", "athena.event.task.operate.send.msg", (Object)data);
    }

    @Override
    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.task.operate.send.msg", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.task.operate.send.msg"})}, concurrency="#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('athena.event.task.operate.send.msg')}")
    @RabbitRetry(beforeHandler="ptmMqBeforeHandler", successHander="ptmMqSuccessHandler", failureHandler="ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="retry-count", required=false) Integer retryCount) {
        log.info("[taskOperateSendMsg] consumeMessage, queue = {}, data = {}", (Object)"athena.event.task.operate.send.msg", (Object)data);
        super.receiveOrder(data, "athena.event.task.operate.send.msg", channel, tag, retryCount);
    }

    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        try {
            AuthoredUser user = super.getUser(mqMessageDTO);
            log.info("[taskOperateSendMsg] start, param = {}", (Object)data);
            LogDto logDto = new LogDto("\u3010taskOperateSendMsg\u3011\u4efb\u52a1\u64cd\u4f5c\u6d88\u606f\u5f00\u59cb\u5904\u7406\uff0c\u6d88\u606f\u7c7b\u578b\uff1a" + mqMessageDTO.getType().getValue(), user.getTenantId() + ";" + mqMessageDTO.getType().getValue());
            log.info(logDto.toString());
            if (EventMqTypeEnum.backlog.equals((Object)mqMessageDTO.getType())) {
                log.info("[taskOperateSendMsg] task overdue , param = {}", (Object)data);
                this.taskOperateSendMsgMqService.processBacklogOverDueMessage(data, user);
            } else if (EventMqTypeEnum.dataConsistency.equals((Object)mqMessageDTO.getType())) {
                log.info("[taskOperateSendMsg] task add , param = {}", (Object)data);
                this.taskOperateSendMsgMqService.processWorkItemAddMessage(data, user);
            }
        }
        catch (Exception e) {
            log.warn("SendMessageNoticeModel error");
        }
    }
}

