/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmProjectChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmTaskChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.ptm.PtmProjectTransformService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCard;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.mq.retry.exception.RetryMQException;
import com.google.common.eventbus.AsyncEventBus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BacklogMqttService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BacklogMqttService.class);
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private PtmTransformService ptmTransformService;
    @Autowired
    private PtmProjectTransformService ptmProjectTransformService;
    @Autowired
    private AsyncEventBus localEventBus;

    public void processMessage(String data, AuthoredUser user) {
        log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529emqtt\u6d88\u606f_\u5f00\u59cb");
        PtmBacklogMessageDTO backlogMessageDTO = (PtmBacklogMessageDTO)JsonUtils.jsonToObject((String)data, PtmBacklogMessageDTO.class);
        if (this.checkBacklogMsg(backlogMessageDTO)) {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529emqtt\u6d88\u606f_\u7ed3\u675f");
            return;
        }
        PtmBacklogMessageDTO.Backlog ptmBacklog = backlogMessageDTO.getData().getBacklog();
        try {
            PtmProjectCard projectCard = this.commonPtmTransformService.getProjectInfo(ptmBacklog.getProjectCardId());
            ProjectCardDTO projectCardDTO = this.ptmProjectTransformService.translateProjectCardForMQTT(projectCard, ptmBacklog.getPerformerId());
            PtmProjectChangeEvent ptmProjectChangeEvent = new PtmProjectChangeEvent();
            ptmProjectChangeEvent.setProject(projectCardDTO);
            ptmProjectChangeEvent.setOperation(PtmMqOperation.CHANGE);
            ptmProjectChangeEvent.setAuthoredUser(user);
            ptmProjectChangeEvent.setPtmMqType(backlogMessageDTO.getType());
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5165\u53c2:ptmProjectChangeEvent={}", (Object)JSON.toJSONString((Object)ptmProjectChangeEvent));
            this.localEventBus.post((Object)ptmProjectChangeEvent);
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u7ed3\u675f");
            log.info("\u3010processProjectCardMessage-projectCardDTO\u3011\uff1a{}", (Object)projectCardDTO);
        }
        catch (Exception ex) {
            if (ex instanceof RetryMQException) {
                throw ex;
            }
            log.warn("processProjectCardMessage-projectCardDTO:{}", (Throwable)ex);
        }
        try {
            PtmBacklog backlogNew = this.commonPtmTransformService.getBacklogForCard(ptmBacklog.getBacklogId());
            backlogNew.setHide(this.convertHidden(ptmBacklog.getHidden()));
            log.info("\u3010processBacklogMessage-backlog\u3011\uff1a{}", (Object)JsonUtils.objectToString((Object)backlogNew));
            TaskCardDTO taskCardDTO = this.ptmTransformService.translateBacklogForMQTT(backlogNew);
            PtmTaskChangeEvent ptmTaskChangeEvent = new PtmTaskChangeEvent();
            ptmTaskChangeEvent.setOperation(backlogMessageDTO.getOperation());
            ptmTaskChangeEvent.setAuthoredUser(user);
            ptmTaskChangeEvent.setTaskCardDTO(taskCardDTO);
            ptmTaskChangeEvent.setTaskDefCode(ptmBacklog.getTaskDefCode());
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u5165\u53c2:ptmTaskChangeEvent={}", (Object)JSON.toJSONString((Object)ptmTaskChangeEvent));
            this.localEventBus.post((Object)ptmTaskChangeEvent);
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u7ed3\u675f");
            log.info("\u3010processBacklogMessage-taskCardDTO\u3011\uff1a{}", (Object)taskCardDTO);
        }
        catch (Exception ex) {
            log.warn("processBacklogMessage-taskCardDTO:{}", (Throwable)ex);
        }
        log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529emqtt\u6d88\u606f_\u7ed3\u675f");
    }

    public boolean checkBacklogMsg(PtmBacklogMessageDTO message) {
        PtmBacklogMessageDTO.Backlog backlog = message.getData().getBacklog();
        if (PtmMqOperation.CLOSE.equals((Object)message.getOperation()) && null == backlog.getBacklogId()) {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_\u5173\u95ed\u64cd\u4f5c_backlogId\u4e3a\u7a7a:message={}", (Object)JSON.toJSONString((Object)message));
            return true;
        }
        return false;
    }

    private Integer convertHidden(Boolean hidden) {
        if (null == hidden) {
            return 0;
        }
        return hidden != false ? 1 : 0;
    }
}

