/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.application.service.abt.migration.mqtt.BacklogMqttService;
import com.digiwin.athena.abt.application.service.abt.migration.mqtt.ProjectCardMqttService;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

@Service
public class EventProjectCardMqttMessageModel
extends EventBaseService
implements EventInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProjectCardMqttMessageModel.class);
    @Autowired
    private BacklogMqttService backlogMqttService;
    @Autowired
    private ProjectCardMqttService projectCardMqttService;

    @Override
    public String modelType() {
        return "cardMqttModel";
    }

    @Override
    public void distributeMessages(String data) {
        this.rabbitTemplate.convertAndSend("athena.event.message", "athena.event.card.mqtt", (Object)data);
    }

    @Override
    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.card.mqtt", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.card.mqtt"})}, concurrency="#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('athena.event.card.mqtt')}")
    @RabbitRetry(beforeHandler="ptmMqBeforeHandler", successHander="ptmMqSuccessHandler", failureHandler="ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="retry-count", required=false) Integer retryCount) {
        super.receiveOrder(data, "athena.event.card.mqtt", channel, tag, retryCount);
    }

    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        AuthoredUser user = super.getUser(mqMessageDTO);
        LogDto logDto = new LogDto("\u3010cardMqttModel\u3011\u5904\u7406\u7fa4\u804a\u6d88\u606f\uff0c\u6d88\u606f\u7c7b\u578b\uff1a" + mqMessageDTO.getType().getValue(), user.getTenantId() + ";" + mqMessageDTO.getType().getValue());
        log.info(logDto.toString());
        if (EventMqTypeEnum.backlog.equals((Object)mqMessageDTO.getType())) {
            this.backlogMqttService.processMessage(data, user);
        } else if (EventMqTypeEnum.projectCard.equals((Object)mqMessageDTO.getType())) {
            this.projectCardMqttService.processMessage(data, user);
        }
    }
}

