/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmProjectChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.ptm.PtmProjectTransformService;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmProjectCardMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCard;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.eventbus.AsyncEventBus;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectCardMqttService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectCardMqttService.class);
    @Autowired
    private PtmProjectCardMapper ptmProjectCardMapper;
    @Autowired
    private PtmProjectTransformService ptmProjectTransformService;
    @Autowired
    private AsyncEventBus localEventBus;

    public void processMessage(String data, AuthoredUser user) {
        PtmProjectCardMessageDTO message = (PtmProjectCardMessageDTO)JsonUtils.jsonToObject((String)data, PtmProjectCardMessageDTO.class);
        PtmProjectCardDataDTO cardDataDTO = message.getData();
        PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
        try {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_mqtt_\u7ed3\u675f\u5f00\u59cb\uff0ccardDTO\uff1a{}", (Object)data);
            PtmProjectCard projectCard = (PtmProjectCard)this.ptmProjectCardMapper.selectById((Serializable)cardDTO.getId());
            ProjectCardDTO projectCardDTO = this.ptmProjectTransformService.translateProjectCardForMQTT(projectCard, cardDTO.getPersonInCharge());
            PtmProjectChangeEvent ptmProjectChangeEvent = new PtmProjectChangeEvent();
            ptmProjectChangeEvent.setProject(projectCardDTO);
            ptmProjectChangeEvent.setOperation(message.getOperation());
            ptmProjectChangeEvent.setAuthoredUser(user);
            ptmProjectChangeEvent.setPtmMqType(message.getType());
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5165\u53c2:ptmProjectChangeEvent={}", (Object)JSON.toJSONString((Object)ptmProjectChangeEvent));
            this.localEventBus.post((Object)ptmProjectChangeEvent);
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u7ed3\u675f");
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_mqtt_\u7ed3\u675f");
        }
        catch (Exception ex) {
            log.warn("processProjectCardMessage-projectCardDTO:{}", (Throwable)ex);
        }
    }
}

