/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmProjectChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmMqType;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BacklogBatchQueryBusinessDataService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.ProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.PageCode;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.VerifyAppPermissionEnum;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionReq;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionResp;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PtmProjectChangedSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmProjectChangedSubscriber.class);
    public static final String TASK_ON_OFF = "taskOnOff";
    public static final String TASK_ON_OFF_V2 = "taskOnOffV2";
    @Autowired
    private AimService aimService;
    @Autowired
    private UserService userService;
    @Autowired
    protected EocService eocService;
    @Autowired
    private AtmcService atmcService;
    @Autowired
    private ProjectHandleService projectHandleService;
    @Autowired
    private BacklogBatchQueryBusinessDataService backlogBatchQueryBusinessDataService;
    @Autowired
    private PtmService ptmService;

    @Subscribe
    @AllowConcurrentEvents
    public void handleEvent(PtmProjectChangeEvent event) {
        try {
            log.info("\u3010PtmProjectChangedSubscriber-event\u3011\uff1a{}", (Object)event);
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private void processEvent(PtmProjectChangeEvent event) throws JsonProcessingException {
        ProjectCardDTO projectCardDTO = event.getProject();
        if (projectCardDTO == null) {
            return;
        }
        AuthoredUser authoredUser = event.getAuthoredUser();
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        LogDto logDto = new LogDto("PTM\u9879\u76ee\u6709\u53d8\u66f4,\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361\uff0c\u9879\u76ee\u5361id:" + projectCardDTO.getId(), authoredUser.getTenantId() == null ? "" : authoredUser.getTenantId() + ";" + projectCardDTO.getId());
        log.info(logDto.toString());
        this.sendProjectChangeMessageToClient(event.getOperation(), projectCardDTO, projectCardDTO.getPersonInCharge(), authoredUser, event.getPtmMqType());
    }

    public void sendProjectChangeMessageToClient(PtmMqOperation operation, ProjectCardDTO projectCardDTO, String targetUserId, AuthoredUser authoredUser, EventMqTypeEnum ptmMqType) throws JsonProcessingException {
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u5165\u53c2:operation={},projectCardDTO={}", (Object)JSON.toJSONString((Object)operation), (Object)JSON.toJSONString((Object)projectCardDTO));
        } else {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u5165\u53c2:operation={},projectCardDTO={}", (Object)JSON.toJSONString((Object)operation), (Object)JSON.toJSONString((Object)projectCardDTO));
        }
        VerifyAppPermissionResp resp = this.verifyAppPermission(projectCardDTO.getId(), targetUserId);
        if (null != resp) {
            projectCardDTO.setAppCode(resp.getAppCode());
            projectCardDTO.setAppName(resp.getAppName());
            projectCardDTO.setHasAppPermission(resp.getHasAppPermission());
        }
        if (this.atmcService.verifyConfig(TASK_ON_OFF, "true").booleanValue() || this.atmcService.verifyConfig(TASK_ON_OFF_V2, "true").booleanValue()) {
            if (PtmMqType.projectCard.equals(ptmMqType)) {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884caddDataFieldsV2");
            } else {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884caddDataFieldsV2");
            }
            this.projectHandleService.addDataFieldsV2(Collections.singletonList(projectCardDTO), authoredUser, "project-card");
        }
        this.backlogBatchQueryBusinessDataService.setBusinessMessageForProject(Collections.singletonList(projectCardDTO), authoredUser, PageCode.PROJECT_CARD.getValue());
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884csetBusinessMessageForProject");
        } else {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884csetBusinessMessageForProject");
        }
        ArrayList<Long> projectCards = new ArrayList<Long>();
        projectCards.add(projectCardDTO.getId());
        List<PtmProjectCardITraceDTO> traceList = this.ptmService.queryProjectCardTrace(projectCards, targetUserId);
        if (CollectionUtils.isNotEmpty(traceList)) {
            PtmProjectCardITraceDTO traceDTO = traceList.get(0);
            this.setSourceInfo(projectCardDTO, traceDTO);
        }
        MessageDO messageDO = new MessageDO();
        messageDO.setJsonContent(this.parseMessageJsonContent(projectCardDTO, targetUserId, authoredUser.getTenantId(), authoredUser.getToken()));
        if (BooleanUtils.isTrue((Boolean)projectCardDTO.getReassign()) || BooleanUtils.isTrue((Boolean)projectCardDTO.getHandover())) {
            messageDO.setCategory(PtmMqOperation.ADD.getValue());
        } else {
            messageDO.setCategory(operation.getMqttCategory());
        }
        messageDO.setSendDate(LocalDateTime.now());
        messageDO.setGid(UUID.randomUUID().toString());
        messageDO.setTenantId(authoredUser.getTenantId());
        messageDO.setUserId(targetUserId);
        messageDO.setType("Project");
        ArrayList<String> users = new ArrayList<String>();
        users.add(targetUserId);
        this.aimService.sendMessageToClient(authoredUser.getToken(), authoredUser.getTenantId(), users, messageDO);
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884caim\u7528\u6237\u901a\u77e5");
        } else {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884caim\u7528\u6237\u901a\u77e5");
        }
        log.info("\u3010PtmProjectChangedSubscriber\u3011projectCardId\uff1a{}\uff0ctoken\uff1a{}\uff0ctenantId\uff1a{}\uff0cusers\uff1a{}\uff0cmessage\uff1a{}", new Object[]{projectCardDTO.getId(), authoredUser.getToken(), authoredUser.getTenantId(), users, JsonUtils.objectToString((Object)messageDO)});
        ProxyUserResp proxyUserResp = this.eocService.getProxyUser(projectCardDTO.getPersonInCharge(), authoredUser.getToken());
        if (proxyUserResp != null && proxyUserResp.getUserId() != null) {
            VerifyAppPermissionResp proxyResp = this.verifyAppPermission(projectCardDTO.getId(), proxyUserResp.getUserId());
            if (null != resp) {
                projectCardDTO.setAppCode(proxyResp.getAppCode());
                projectCardDTO.setAppCode(proxyResp.getAppName());
                projectCardDTO.setHasAppPermission(proxyResp.getHasAppPermission());
            }
            projectCardDTO.setIsOwner(false);
            messageDO.setJsonContent(this.parseMessageJsonContent(projectCardDTO, proxyUserResp.getUserId(), authoredUser.getTenantId(), authoredUser.getToken()));
            users.clear();
            users.add(proxyUserResp.getUserId());
            LogDto logDtoProxy = new LogDto("\u8bf7\u6c42aim\u53d1\u9001\u65b0\u6d88\u606f\u7ed9\u4ee3\u7406\u7528\u6237", authoredUser.getTenantId());
            log.info(logDtoProxy.toString());
            this.aimService.sendMessageToClient(authoredUser.getToken(), authoredUser.getTenantId(), users, messageDO);
            if (PtmMqType.projectCard.equals(ptmMqType)) {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884caim\u4ee3\u7406\u7528\u6237\u901a\u77e5");
            } else {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectChangeEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u6267\u884caim\u4ee3\u7406\u7528\u6237\u901a\u77e5");
            }
            log.info("\u3010PtmProjectChangedSubscriber\u3011projectCardId\uff1a{}\uff0ctoken\uff1a{}\uff0ctenantId\uff1a{}\uff0cusers\uff1a{}\uff0cmessage\uff1a{}", new Object[]{projectCardDTO.getId(), authoredUser.getToken(), authoredUser.getTenantId(), users, messageDO});
        }
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_\u9879\u76ee\u5361\u6d88\u606f_event\u53d1\u9001_PtmProjectCardEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u7ed3\u675f");
        } else {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmProjectCardEvent_\u5b9e\u65f6\u5237\u65b0\u9879\u76ee\u5361_\u7ed3\u675f");
        }
    }

    private void setSourceInfo(ProjectCardDTO projectCardDTO, PtmProjectCardITraceDTO traceDTO) {
        projectCardDTO.setOldPerformerId(traceDTO.getOldPerformerId());
        projectCardDTO.setOldPerformerName(traceDTO.getOldPerformerName());
        if (null != traceDTO.getCreateTime()) {
            projectCardDTO.setCreateTime(traceDTO.getCreateTime());
        }
        Integer type = traceDTO.getType();
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                projectCardDTO.setReassign(true);
                break;
            }
            case 3: {
                projectCardDTO.setHandover(true);
                break;
            }
        }
    }

    private String parseMessageJsonContent(ProjectCardDTO projectCardDTO, String receiverUserId, String tenantId, String token) throws JsonProcessingException {
        if (StringUtils.isBlank((String)projectCardDTO.getWithName()) && StringUtils.isBlank((String)projectCardDTO.getProjectDefWithName())) {
            return JsonUtils.createObjectMapper().writeValueAsString((Object)projectCardDTO);
        }
        String lang = this.getUserLang(token, receiverUserId, tenantId);
        log.info("\u53d1\u9001mqtt\u6d88\u606f\u901a\u77e5\u5ba2\u6237\u65b0\u589e\u9879\u76ee\u5361\u83b7\u53d6\u7528\u6237\u8bed\u8a00\u522b\u662f\uff1auserId: {}, tenantId: {}, lang: {}", new Object[]{receiverUserId, tenantId, lang});
        if (StringUtils.isNotBlank((String)lang)) {
            Map map = (Map)JsonUtils.createObjectMapper().convertValue((Object)projectCardDTO, (TypeReference)new TypeReference<Map<Object, Object>>(){});
            map.put("withName", null);
            map.put("projectDefWithName", null);
            map.put("name", MessageUtils.getMessageByLanguage((Object)projectCardDTO.getWithName(), (String)lang));
            map.put("projectName", MessageUtils.getMessageByLanguage((Object)projectCardDTO.getProjectDefWithName(), (String)lang));
            return JsonUtils.createObjectMapper().writeValueAsString((Object)map);
        }
        return JsonUtils.createObjectMapper().writeValueAsString((Object)projectCardDTO);
    }

    private String getUserLang(String token, String userId, String tenantId) {
        String lang;
        try {
            lang = this.userService.getUserLangNameByUserId(userId, tenantId, token);
        }
        catch (Exception ex) {
            log.info("\u53d1\u9001mqtt\u6d88\u606f\u901a\u77e5\u5ba2\u6237\u65b0\u589e\u9879\u76ee\u5361\u83b7\u53d6\u7528\u6237\u8bed\u8a00\u522b\u53d1\u751f\u5f02\u5e38\uff0cuserId: {}, tenantId: {}, ex:", new Object[]{userId, tenantId, ex});
            lang = null;
        }
        return lang;
    }

    private VerifyAppPermissionResp verifyAppPermission(Long ptmProjectCardId, String userId) {
        VerifyAppPermissionReq req = new VerifyAppPermissionReq();
        req.setType(VerifyAppPermissionEnum.PROJECT.getValue());
        req.setBusinessId(ptmProjectCardId);
        req.setUserId(userId);
        return this.atmcService.verifyAppPermission(req);
    }
}

