/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmTaskChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BacklogBatchQueryBusinessDataService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.PageCode;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.VerifyAppPermissionEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmTaskCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionReq;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionResp;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.RetryableAction;
import com.digiwin.athena.appcore.util.RetryableOperationToolkit;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PtmTaskChangedSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmTaskChangedSubscriber.class);
    public static final String TASK_ON_OFF = "taskOnOff";
    public static final String TASK_ON_OFF_V2 = "taskOnOffV2";
    public static final String TASK_CARD_WHITE_LIST = "taskCardWhiteList";
    @Autowired
    private AimService aimService;
    @Autowired
    private UserService userService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    protected EocService eocService;
    @Autowired
    private AtmcService atmcService;
    @Autowired
    private BacklogBatchQueryBusinessDataService backlogBatchQueryBusinessDataService;
    @Autowired
    private PtmService ptmService;

    @Subscribe
    @AllowConcurrentEvents
    public void activityStartedHandle(PtmTaskChangeEvent event) {
        try {
            log.info("\u3010PtmTaskChangedSubscriber-event\u3011\uff1a{}", (Object)JsonUtils.objectToString((Object)event));
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
        try {
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private void processEvent(final PtmTaskChangeEvent event) {
        log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u5165\u53c2:event={}", (Object)JSON.toJSONString((Object)event));
        final TaskCardDTO taskCardDTO = event.getTaskCardDTO();
        if (taskCardDTO == null) {
            return;
        }
        int maxRetryTimes = 5;
        RetryableOperationToolkit.operate((int)maxRetryTimes, (RetryableAction)new RetryableAction<PtmBacklog>(){

            public PtmBacklog active(int retryTime) {
                return (PtmBacklog)PtmTaskChangedSubscriber.this.ptmBacklogMapper.selectById((Serializable)Long.valueOf(taskCardDTO.getBacklogId()));
            }

            public boolean needRetry(PtmBacklog ptmBacklog) {
                if (ptmBacklog != null) {
                    PtmTaskChangedSubscriber.this.sendAppMsg(event);
                    return false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    log.warn("\u3010PtmTaskChangedSubscriber\u3011exception:{}", (Throwable)e);
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                log.info("\u3010PtmTaskChangedSubscriber\u3011 has no ptmBacklog mysqlData:{}", (Object)event.getTaskCardDTO().getBacklogId());
                return true;
            }
        });
        log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u7ed3\u675f");
    }

    private String parseMessageJsonContent(TaskCardDTO taskCardDTO, String receiverUserId, String tenantId, String token) throws JsonProcessingException {
        if (StringUtils.isBlank((String)taskCardDTO.getWithName())) {
            return JsonUtils.createObjectMapper().writeValueAsString((Object)taskCardDTO);
        }
        String lang = null;
        try {
            lang = this.userService.getUserLangNameByUserId(receiverUserId, tenantId, token);
        }
        catch (Exception ex) {
            log.info("\u53d1\u9001mqtt\u6d88\u606f\u901a\u77e5\u5ba2\u6237\u65b0\u589e\u4efb\u52a1\u5361\u83b7\u53d6\u7528\u6237\u8bed\u8a00\u522b\u53d1\u751f\u5f02\u5e38\uff0cuserId: {}, tenantId: {}, ex:", new Object[]{receiverUserId, tenantId, ex});
            lang = null;
        }
        if (StringUtils.isNotBlank((String)lang)) {
            Map map = (Map)JsonUtils.createObjectMapper().convertValue((Object)taskCardDTO, (TypeReference)new TypeReference<Map<Object, Object>>(){});
            map.put("withName", null);
            map.put("tmActivityWithName", null);
            map.put("name", MessageUtils.getMessageByLanguage((Object)taskCardDTO.getWithName(), (String)lang));
            map.put("tmActivityName", MessageUtils.getMessageByLanguage((Object)taskCardDTO.getTmActivityWithName(), (String)lang));
            return JsonUtils.createObjectMapper().writeValueAsString((Object)map);
        }
        return JsonUtils.createObjectMapper().writeValueAsString((Object)taskCardDTO);
    }

    private void sendAppMsg(PtmTaskChangeEvent event) {
        try {
            TaskCardDTO taskCardDTO = event.getTaskCardDTO();
            this.sendTaskChangeMessageToClient(event.getOperation(), taskCardDTO, taskCardDTO.getOwnerUserId(), event.getAuthoredUser());
        }
        catch (JsonProcessingException e) {
            throw AtmcErrorCodeEnum.ATMC_JSON_PROCESSING_EX.getBusinessException();
        }
    }

    public void sendTaskChangeMessageToClient(PtmMqOperation operation, TaskCardDTO taskCardDTO, String targetUserId, AuthoredUser authoredUser) throws JsonProcessingException {
        log.info("init taskCard Data: {}", (Object)taskCardDTO);
        VerifyAppPermissionResp resp = this.getAppPermission(taskCardDTO.getBacklogId(), targetUserId);
        Map<Object, Object> dataFieldsMap = new HashMap();
        Boolean taskCardWhiteList = this.atmcService.verifyConfig(TASK_CARD_WHITE_LIST, taskCardDTO.getTenantId());
        Boolean authoreUsertaskCardWhiteList = this.atmcService.verifyConfig(TASK_CARD_WHITE_LIST, authoredUser.getTenantId());
        Boolean taskOnOff = this.atmcService.verifyConfig(TASK_ON_OFF, "true");
        Boolean taskOnOffV2 = this.atmcService.verifyConfig(TASK_ON_OFF_V2, "true");
        if (taskCardWhiteList.booleanValue() || taskOnOff.booleanValue()) {
            try {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u83b7\u53d6\u4efb\u52a1\u5361\u914d\u7f6e_\u5165\u53c2:backlogId={},tmActivityId={}", (Object)taskCardDTO.getBacklogId(), (Object)taskCardDTO.getTmActivityId());
                dataFieldsMap = this.backlogBatchQueryBusinessDataService.addDataFieldsByBacklogId(taskCardDTO.getBacklogId(), taskCardDTO.getTmActivityId(), AppAuthContextHolder.getContext().getAuthoredUser());
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u83b7\u53d6\u4efb\u52a1\u5361\u914d\u7f6e_\u51fa\u53c2:dataFieldsMap={}", (Object)JSON.toJSONString(dataFieldsMap));
                log.info("\u3010processBacklogMessage-dataFieldsMap\u3011\uff1a{}", dataFieldsMap);
                Map data = (Map)dataFieldsMap.get(taskCardDTO.getBacklogId());
                taskCardDTO.setGroup((Map)data.get("group"));
                taskCardDTO.setLabels((List)data.get("label"));
                taskCardDTO.setColumns((List)data.get("columns"));
                taskCardDTO.setOrder((Map)data.get("order"));
            }
            catch (Exception e) {
                log.error("get business data failure: {}, :{}", (Object)e.getMessage(), (Object)taskCardDTO.getBacklogId());
            }
        }
        if (null != resp) {
            taskCardDTO.setAppCode(resp.getAppCode());
            taskCardDTO.setAppName(resp.getAppName());
            taskCardDTO.setHasAppPermission(resp.getHasAppPermission());
        }
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        String tenantId = StringUtils.isNotEmpty((String)taskCardDTO.getTargetTenantId()) ? taskCardDTO.getTargetTenantId() : taskCardDTO.getTenantId();
        log.info(" processed taskCard Data: {}", (Object)taskCardDTO);
        boolean flag = false;
        if (authoreUsertaskCardWhiteList.booleanValue()) {
            flag = true;
            try {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8865\u5145\u4efb\u52a1\u5361\u914d\u7f6e_\u5165\u53c2:taskCardDTO={}", (Object)JSON.toJSONString((Object)taskCardDTO));
                this.backlogBatchQueryBusinessDataService.addDataFields(Collections.singletonList(taskCardDTO), authoredUser);
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8865\u5145\u4efb\u52a1\u5361\u914d\u7f6e_\u51fa\u53c2:taskCardDTO={}", (Object)JSON.toJSONString((Object)taskCardDTO));
            }
            catch (Exception ex) {
                log.error("add data fields failure: {}, :{}", (Object)ex.getMessage(), (Object)taskCardDTO.getBacklogId());
            }
        }
        if (!authoreUsertaskCardWhiteList.booleanValue() && taskOnOff.booleanValue()) {
            flag = true;
            try {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8865\u5145\u4efb\u52a1\u5361\u914d\u7f6e_\u5165\u53c2:taskCardDTO={}", (Object)JSON.toJSONString((Object)taskCardDTO));
                this.backlogBatchQueryBusinessDataService.addDataFields(Collections.singletonList(taskCardDTO), authoredUser);
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8865\u5145\u4efb\u52a1\u5361\u914d\u7f6e_\u51fa\u53c2:taskCardDTO={}", (Object)JSON.toJSONString((Object)taskCardDTO));
            }
            catch (Exception ex) {
                log.error("add data fields failure: {}, :{}", (Object)ex.getMessage(), (Object)taskCardDTO.getBacklogId());
            }
        }
        if (!flag && taskOnOffV2.booleanValue()) {
            try {
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8865\u5145\u4efb\u52a1\u5361\u914d\u7f6eV2_\u5165\u53c2:taskCardDTO={},pageCode={}", (Object)JSON.toJSONString((Object)taskCardDTO), (Object)"task-card");
                this.backlogBatchQueryBusinessDataService.addDataFieldsV2(Collections.singletonList(taskCardDTO), authoredUser, "task-card");
                log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8865\u5145\u4efb\u52a1\u5361\u914d\u7f6eV2_\u51fa\u53c2:taskCardDTO={}", (Object)JSON.toJSONString((Object)taskCardDTO));
            }
            catch (Exception ex) {
                log.error("add data fieldsV2 failure: {}, :{}", (Object)ex.getMessage(), (Object)taskCardDTO.getBacklogId());
            }
        }
        try {
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8bbe\u7f6eBusinessMessage_\u5165\u53c2:taskCardDTO={},pageCode={}", (Object)JSON.toJSONString((Object)taskCardDTO), (Object)"task-card");
            this.backlogBatchQueryBusinessDataService.setBusinessMessage(taskCardDTO, authoredUser, PageCode.TASK_CARD.getValue());
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u8bbe\u7f6eBusinessMessage_\u51fa\u53c2:taskCardDTO={}", (Object)JSON.toJSONString((Object)taskCardDTO));
        }
        catch (Exception ex) {
            log.error("set business message failure: {}, :{}", (Object)ex.getMessage(), (Object)taskCardDTO.getBacklogId());
        }
        ArrayList<Long> taskCards = new ArrayList<Long>();
        taskCards.add(taskCardDTO.getBacklogId());
        List<PtmTaskCardITraceDTO> traceList = this.ptmService.queryTaskCardTrace(taskCards, authoredUser.getUserId());
        if (CollectionUtils.isNotEmpty(traceList)) {
            PtmTaskCardITraceDTO traceDTO = traceList.get(0);
            this.setSourceInfo(taskCardDTO, traceDTO);
        }
        MessageDO messageDO = new MessageDO();
        messageDO.setJsonContent(this.parseMessageJsonContent(taskCardDTO, targetUserId, tenantId, authoredUser.getToken()));
        messageDO.setCategory(operation.getMqttCategory());
        messageDO.setSendDate(LocalDateTime.now());
        messageDO.setGid(UUID.randomUUID().toString());
        messageDO.setTenantId(tenantId);
        messageDO.setUserId(targetUserId);
        messageDO.setType("Task");
        messageDO.setSubType(taskCardDTO.getTmActivityId());
        ArrayList<String> users = new ArrayList<String>();
        users.add(targetUserId);
        log.info(" messageDo data: {}", (Object)messageDO);
        log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u53d1\u9001\u6d88\u606f\u7ed9\u7528\u6237_\u5165\u53c2:token={}, tenantId={}, userIdList={}, message={}", new Object[]{authoredUser.getToken(), tenantId, users, messageDO});
        this.aimService.sendMessageToClient(authoredUser.getToken(), tenantId, users, messageDO);
        log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u53d1\u9001\u6d88\u606f\u7ed9\u7528\u6237_\u7ed3\u675f");
        log.info("\u3010PtmTaskChangedSubscriber-sendmqtt-1\u3011backlogId\uff1a{}\uff0ctoken\uff1a{}\uff0ctenantId\uff1a{}\uff0cusers\uff1a{}\uff0cmessage\uff1a{}", new Object[]{taskCardDTO.getBacklogId(), authoredUser.getToken(), tenantId, users, JsonUtils.objectToString((Object)messageDO)});
        ProxyUserResp proxyUserResp = this.eocService.getProxyUser(taskCardDTO.getOwnerUserId(), authoredUser.getToken());
        if (proxyUserResp != null && proxyUserResp.getUserId() != null) {
            VerifyAppPermissionResp proxyResp = this.getAppPermission(taskCardDTO.getBacklogId(), proxyUserResp.getUserId());
            if (null != resp) {
                taskCardDTO.setAppCode(proxyResp.getAppCode());
                taskCardDTO.setAppName(proxyResp.getAppName());
                taskCardDTO.setHasAppPermission(proxyResp.getHasAppPermission());
            }
            taskCardDTO.setIsOwner(false);
            users.clear();
            users.add(proxyUserResp.getUserId());
            messageDO.setJsonContent(this.parseMessageJsonContent(taskCardDTO, proxyUserResp.getUserId(), tenantId, authoredUser.getToken()));
            LogDto logDto = new LogDto("\u8bf7\u6c42aim\u53d1\u9001\u65b0\u6d88\u606f\u7ed9\u4ee3\u7406\u7528\u6237", tenantId);
            log.info(logDto.toString());
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u53d1\u9001\u6d88\u606f\u7ed9\u4ee3\u7406\u4eba_\u5165\u53c2:token={}, tenantId={}, userIdList={}, message={}", new Object[]{authoredUser.getToken(), tenantId, users, messageDO});
            this.aimService.sendMessageToClient(authoredUser.getToken(), tenantId, users, messageDO);
            log.debug("\u63a5\u6536ptm\u6d88\u606f_\u5904\u7406\u6d88\u606f_PTM\u5f85\u529e\u6d88\u606f_event\u53d1\u9001_PtmTaskChangeEvent_\u53d1\u9001MQTT\u6d88\u606f_\u53d1\u9001\u6d88\u606f\u7ed9\u4ee3\u7406\u4eba_\u7ed3\u675f");
            log.info("\u3010PtmTaskChangedSubscriber-sendmqtt-2\u3011backlogId\uff1a{}\uff0c{}\uff0ctenantId\uff1a{}\uff0cusers\uff1a{}\uff0cmessage\uff1a{}", new Object[]{taskCardDTO.getBacklogId(), authoredUser.getToken(), tenantId, users, messageDO});
        }
    }

    private void setSourceInfo(TaskCardDTO taskCardDTO, PtmTaskCardITraceDTO traceDTO) {
        taskCardDTO.setOldPerformerId(traceDTO.getOldPerformerId());
        taskCardDTO.setOldPerformerName(traceDTO.getOldPerformerName());
        if (null != traceDTO.getCreateTime()) {
            taskCardDTO.setCreateTime(traceDTO.getCreateTime());
        }
        Integer type = traceDTO.getType();
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                taskCardDTO.setReassign(true);
                break;
            }
            case 2: {
                taskCardDTO.setReexecute(true);
                break;
            }
            case 3: {
                taskCardDTO.setReexecute(true);
                break;
            }
            case 4: {
                taskCardDTO.setAddTask(true);
                break;
            }
            case 9: {
                taskCardDTO.setRecall(true);
                break;
            }
            case 10: {
                taskCardDTO.setApprovalStateCode("handover");
                break;
            }
        }
    }

    private VerifyAppPermissionResp getAppPermission(Long backlogId, String userId) {
        VerifyAppPermissionReq req = new VerifyAppPermissionReq();
        req.setType(VerifyAppPermissionEnum.TASK.getValue());
        req.setBusinessId(backlogId);
        req.setUserId(userId);
        return this.atmcService.verifyAppPermission(req);
    }
}

