/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardDetailDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmSolveTask;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmTaskCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.TaskActivityItemVO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.TenantTokenService;
import com.digiwin.athena.abt.application.utils.SummaryMessagesUtils;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.abt.core.meta.enums.ActivityState;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.PtmBacklogTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.core.meta.enums.TmTaskCategoryEnum;
import com.digiwin.athena.abt.core.meta.enums.WorkitemCreateType;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmProjectCardMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.ActivityDataBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.BacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmBacklogItemBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmMergeBacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmProcess;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCard;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class CommonPtmTransformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonPtmTransformService.class);
    @Autowired
    private PtmService ptmService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private TenantTokenService tenantTokenService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private PtmProjectCardMapper ptmProjectCardMapper;

    public boolean enablePTM() {
        return StringUtils.isNotBlank((String)this.envProperties.getPtmUri());
    }

    public Backlog translateBacklogById(Long backlogId) {
        Long workItemId;
        PtmWorkItemRecordBO workItemRecordDTO;
        if (!this.enablePTM()) {
            return null;
        }
        List<Object> backlogList = this.ptmService.getBacklogByBacklogId(backlogId);
        if (CollectionUtils.isEmpty(backlogList) && (workItemRecordDTO = this.ptmService.getWorkItemRecord(workItemId = backlogId)) != null) {
            backlogList = this.ptmService.getBacklogByBacklogId(workItemRecordDTO.getBacklogId());
            backlogList = backlogList.stream().filter(x -> Objects.equals(x.getWorkItemId(), workItemId)).collect(Collectors.toList());
        }
        Backlog backlog = null;
        PtmBacklog ptmBacklog = this.commonPtmTransformService.getBacklogByIdFromDb(backlogId);
        if (CollectionUtils.isNotEmpty(backlogList)) {
            PtmBacklogRecordDTO backlogRecord;
            String performerId;
            PtmBacklogItemBO ptmBacklogItemBO = backlogList.get(0);
            String string = performerId = Objects.nonNull(ptmBacklog) && StringUtils.isNotBlank((String)ptmBacklog.getPerformerId()) ? ptmBacklog.getPerformerId() : ptmBacklogItemBO.getPerformerId();
            if ((Objects.isNull(ptmBacklog) || PtmBacklogTypeEnum.isReplyAssistOrCrossTenantBacklogType((Integer)ptmBacklog.getType())) && Objects.nonNull(backlogRecord = this.ptmService.getBacklogRecord(backlogId))) {
                performerId = backlogRecord.getPerformerId();
            }
            backlog = Backlog.builder().id(ptmBacklogItemBO.getBacklogId()).name(ptmBacklogItemBO.getTaskName()).endTime(ptmBacklogItemBO.getPlanEndTime()).startTime(ptmBacklogItemBO.getCreateTime()).performerId(performerId).importance(Optional.ofNullable(ptmBacklog).map(PtmBacklog::getFavorite).orElse(0)).content(ptmBacklogItemBO.getTaskDefName()).contentWithName(ptmBacklogItemBO.getTaskDefWithName()).withName(ptmBacklogItemBO.getTaskWithName()).activityCode(ptmBacklogItemBO.getTaskDefCode()).taskId(ptmBacklogItemBO.getTaskId()).build();
            log.info("\u4f7f\u7528\u4efb\u52a1\u5f15\u64ce\u6570\u636e");
            return backlog;
        }
        if (ptmBacklog != null) {
            backlog = Backlog.builder().id(ptmBacklog.getBacklogId()).name(ptmBacklog.getTaskName()).endTime(ptmBacklog.getPlanEndTime()).startTime(ptmBacklog.getCreateTime()).performerId(ptmBacklog.getPerformerId()).importance(ptmBacklog.getFavorite()).content(ptmBacklog.getTaskDefName()).contentWithName(ptmBacklog.getTaskDefWithName()).activityCode(ptmBacklog.getTaskDefCode()).taskId(ptmBacklog.getTaskId()).build();
            log.info("\u4f7f\u7528\u5e73\u53f0\u5e93\u4efb\u52a1\u4fe1\u606f");
            return backlog;
        }
        return null;
    }

    public PtmBacklog getBacklogByIdFromDb(Long backlogId) {
        return (PtmBacklog)this.ptmBacklogMapper.selectById((Serializable)backlogId);
    }

    public BacklogBO selectBacklogForCard(Long backlogId) {
        BacklogBO result = null;
        if (!this.enablePTM()) {
            return result;
        }
        List<Object> backlogList = this.ptmService.getBacklogByBacklogId(backlogId);
        PtmBacklog ptmOverdueBacklog = null;
        if (CollectionUtils.isEmpty(backlogList)) {
            Long workItemId;
            PtmWorkItemRecordBO workItemRecordDTO;
            ptmOverdueBacklog = this.ptmBacklogMapper.selectOverdueById(backlogId);
            if (ptmOverdueBacklog != null) {
                backlogList = this.ptmService.getBacklogByBacklogId(ptmOverdueBacklog.getOverdueBacklogId());
            }
            if (CollectionUtils.isEmpty(backlogList) && (workItemRecordDTO = this.ptmService.getWorkItemRecord(workItemId = backlogId)) != null) {
                backlogList = this.ptmService.getBacklogByBacklogId(workItemRecordDTO.getBacklogId());
                backlogList = backlogList.stream().filter(x -> Objects.equals(x.getWorkItemId(), workItemId)).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty(backlogList)) {
            PtmBacklogItemBO ptmBacklog = backlogList.get(0);
            PtmTaskRecordBO ptmTaskRecord = this.ptmService.getTaskRecord(ptmBacklog.getTaskId(), null);
            PtmProjectRecordBO ptmProjectRecord = this.ptmService.getProjectRecord(ptmTaskRecord.getProjectId());
            result = BacklogBO.builder().id(backlogId).tmTaskId(ptmProjectRecord.getProjectDefCode()).tmActivityId(ptmTaskRecord.getTaskDefCode()).tmPattern(ptmTaskRecord.getTaskDefPattern()).tmCategory(ptmTaskRecord.getTaskDefCategory()).summaryLayoutCacheText(null).overdueWorkitemId(Long.valueOf(0L)).approvalState(null).tmActivityName(ptmTaskRecord.getTaskDefName()).dataFrom("PTM").build();
            if (ptmOverdueBacklog != null) {
                result.setId(ptmOverdueBacklog.getBacklogId());
                result.setOverdueWorkitemId(ptmOverdueBacklog.getOverdueBacklogId());
            } else {
                PtmBacklog backlog = this.commonPtmTransformService.getBacklogByIdFromDb(backlogId);
                if (backlog != null) {
                    result.setApprovalState(backlog.getApprovalState());
                    if (StringUtils.isNotBlank((String)result.getApprovalState())) {
                        result.setApprovalState(GlobalConstant.backlogStatusMap.getOrDefault(result.getApprovalState(), ""));
                    }
                }
            }
        }
        return result;
    }

    public List<ActivityDataBO> getActivityDataByBacklogId(Long backlogId, List<Long> workItemIds, Boolean isHistory, PtmWorkItemRecordBO ptmWorkItemRecordBO) {
        PtmBacklog ptmBacklog;
        ArrayList<ActivityDataBO> result = new ArrayList<ActivityDataBO>();
        if (!this.enablePTM()) {
            return result;
        }
        List<Object> backlogItemList = new ArrayList();
        PtmBacklog overdueBacklog = this.ptmBacklogMapper.selectOverdueById(backlogId);
        PtmBacklog dataUniformityBacklog = null;
        if (overdueBacklog != null) {
            backlogId = overdueBacklog.getOverdueBacklogId();
        } else {
            dataUniformityBacklog = this.ptmBacklogMapper.selectDataUniformityById(backlogId);
            if (dataUniformityBacklog != null) {
                backlogId = dataUniformityBacklog.getSourceBacklogId();
            }
        }
        backlogItemList = this.ptmService.getBacklogByBacklogId(backlogId);
        if (CollectionUtils.isEmpty(backlogItemList)) {
            Long workitemId = backlogId;
            ArrayList<PtmBacklog> backlogList = this.ptmBacklogMapper.selectByWorkItemId(backlogId);
            if (CollectionUtils.isEmpty((Collection)backlogList)) {
                PtmWorkItemRecordBO workItemRecordDTO;
                PtmWorkItemRecordBO ptmWorkItemRecordBO2 = workItemRecordDTO = Objects.nonNull(ptmWorkItemRecordBO) ? ptmWorkItemRecordBO : this.ptmService.getWorkItemRecord(backlogId);
                if (workItemRecordDTO != null) {
                    backlogList = new ArrayList<PtmBacklog>();
                    ptmBacklog = new PtmBacklog();
                    ptmBacklog.setBacklogId(workItemRecordDTO.getBacklogId());
                    backlogList.add(ptmBacklog);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)backlogList)) {
                backlogId = ((PtmBacklog)backlogList.get(0)).getBacklogId();
                backlogItemList = this.ptmService.getBacklogByBacklogId(backlogId);
                backlogItemList = backlogItemList.stream().filter(x -> {
                    if (CollectionUtils.isNotEmpty((Collection)workItemIds)) {
                        return workItemIds.contains(x.getWorkItemId());
                    }
                    return Objects.equals(x.getWorkItemId(), workitemId);
                }).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty(backlogItemList)) {
            PtmBacklog ptmBacklogSelf = this.commonPtmTransformService.getBacklogByIdFromDb(backlogId);
            PtmBacklogRecordDTO ptmBacklogRecord = this.ptmService.getBacklogRecord(backlogId);
            List<PtmTaskCardDataDTO> taskCardDataList = this.ptmService.getTaskDataByBacklogId(backlogId, "");
            if (null == ptmBacklogSelf) {
                ptmBacklogSelf = this.buildPtmBacklog(ptmBacklogRecord);
            }
            ptmBacklog = ptmBacklogSelf;
            if (null == isHistory || BooleanUtils.isFalse((Boolean)isHistory)) {
                isHistory = BooleanUtils.isTrue((Boolean)ptmBacklogRecord.getClosed());
            }
            Map<Long, PtmMergeBacklogBO> mergeBacklogDTOMap = this.dealBacklogData(backlogItemList.stream().map(PtmBacklogItemBO::getBacklogId).collect(Collectors.toList()), isHistory);
            PtmBacklog finalDataUniformityBacklog = dataUniformityBacklog;
            List<PtmTaskRecordBO> ptmTaskRecordList = this.ptmService.getTaskRecordByTaskIds(backlogItemList.stream().map(PtmBacklogItemBO::getTaskId).distinct().collect(Collectors.toList()));
            Map<Long, PtmTaskRecordBO> ptmTaskRecordMap = ptmTaskRecordList.stream().collect(Collectors.toMap(PtmTaskRecordBO::getId, v -> v, (p1, p2) -> p1));
            List<PtmActivityRecordDTO> ptmActivityRecordList = this.ptmService.getActivityRecordByActivityIds(backlogItemList.stream().map(PtmBacklogItemBO::getActivityId).distinct().collect(Collectors.toList()));
            Map<Long, PtmActivityRecordDTO> ptmActivityRecordMap = ptmActivityRecordList.stream().collect(Collectors.toMap(PtmActivityRecordDTO::getId, v -> v, (p1, p2) -> p1));
            List<PtmProjectRecordBO> ptmProjectRecordList = this.ptmService.getProjectRecordByProjectIds(backlogItemList.stream().map(PtmBacklogItemBO::getProjectId).distinct().collect(Collectors.toList()));
            Map<Long, PtmProjectRecordBO> ptmProjectRecordMap = ptmProjectRecordList.stream().collect(Collectors.toMap(PtmProjectRecordBO::getId, v -> v, (p1, p2) -> p1));
            List<PtmWorkItemRecordBO> workItemRecordList = this.ptmService.getWorkItemRecordByWorkItemIds(backlogItemList.stream().map(PtmBacklogItemBO::getWorkItemId).distinct().collect(Collectors.toList()));
            Map<Long, PtmWorkItemRecordBO> ptmWorkItemRecordMap = workItemRecordList.stream().collect(Collectors.toMap(PtmWorkItemRecordBO::getId, v -> v, (p1, p2) -> p1));
            List<Object> ptmSolveTasks = new ArrayList();
            BacklogBO backlogBO = this.selectBacklogForCard(backlogId);
            if (backlogBO != null && org.springframework.util.StringUtils.pathEquals((String)TmTaskCategoryEnum.SOLVE.getValue(), (String)backlogBO.getTmCategory())) {
                ptmSolveTasks = this.ptmService.getSolveTaskListV2(backlogId);
            }
            ArrayList finalPtmSolveTasks = ptmSolveTasks;
            backlogItemList.forEach(bl -> {
                PtmTaskCardDataDTO td;
                PtmTaskRecordBO ptmTaskRecord = (PtmTaskRecordBO)ptmTaskRecordMap.get(bl.getTaskId());
                PtmActivityRecordDTO ptmActivityRecord = (PtmActivityRecordDTO)ptmActivityRecordMap.get(bl.getActivityId());
                PtmProjectRecordBO ptmProjectRecord = (PtmProjectRecordBO)ptmProjectRecordMap.get(bl.getProjectId());
                PtmWorkItemRecordBO ptmWorkItemRecord = (PtmWorkItemRecordBO)ptmWorkItemRecordMap.get(bl.getWorkItemId());
                PtmMergeBacklogBO ptmMergeBacklogBO = (PtmMergeBacklogBO)mergeBacklogDTOMap.get(ptmBacklogRecord.getId());
                ActivityDataBO activityDataBO = ActivityDataBO.builder().bpmActivitySqlId(ptmTaskRecord.getId()).bpmData(null).bpmStateData(null).tmActivityId(ptmTaskRecord.getTaskDefCode()).tmPattern(ptmTaskRecord.getTaskDefPattern()).tmCategory(ptmTaskRecord.getTaskDefCategory()).bpmActivityType(ptmTaskRecord.getBpmnType()).bpmActivityId(ptmActivityRecord.getBpmActivityId()).performerIds(null).processSerialNumber(ptmProjectRecord.getProcessSerialNumber()).backlogId(ptmBacklogRecord.getId()).backlogName(ptmTaskRecord.getTaskName()).targetTenantId(ptmBacklog.getTargetTenantId()).performerId(ptmWorkItemRecord.getPerformerId()).performerName(ptmWorkItemRecord.getPerformerName()).readCount(ptmBacklog.getReadCount()).startTime(ptmTaskRecord.getCreateTime()).planEndTime(ptmTaskRecord.getPlanEndTime()).endTime(bl.getClosedTime()).taskId(ptmBacklogRecord.getProjectId()).tmTaskId(ptmProjectRecord.getProjectDefCode()).chargeId(ptmProjectRecord.getPersonInCharge()).chargeName(ptmProjectRecord.getPersonInChargeName()).tenantId(ptmProjectRecord.getTenantId()).businessUnit(JsonUtils.objectToString((Object)ptmTaskRecord.getBusinessUnit())).taskStartTime(ptmProjectRecord.getStartTime()).taskEndTime(ptmProjectRecord.getEndTime()).taskName(ptmProjectRecord.getProjectName()).tmActivityName(ptmTaskRecord.getTaskDefName()).finishedActionId(ptmBacklog.getClosed() != false ? ptmBacklog.getActionId() : null).tmShowFlow(Boolean.valueOf(false)).stepId(ptmActivityRecord.getId()).taskSourceIds(ptmProjectRecord.getSourceIds()).stepSignReason(ptmActivityRecord.getSignReason()).approvalState(ptmBacklog.getApprovalState()).backlogClosed(Boolean.valueOf(ptmBacklog.getClosed() != false || bl.getClosed() != false)).merge(ptmBacklogRecord.getMerge()).proxyToken(StringUtils.isNotBlank((String)ptmTaskRecord.getProxyToken()) ? ptmTaskRecord.getProxyToken() : ptmProjectRecord.getProxyToken()).processCreateTime(ptmProjectRecord.getCreateTime()).compositionId("").overdueWorkitemId(Long.valueOf(0L)).workItemId(ptmWorkItemRecord.getId()).taskUid(ptmTaskRecord.getBpmTaskUid()).preTaskUid(null).stepState(ptmActivityRecord.getState()).stepSubState(ptmActivityRecord.getSubState()).traceId(ptmProjectRecord.getTraceId()).eocName(StringUtils.isNotBlank((String)bl.getEocCode()) ? bl.getEocName() : ptmProjectRecord.getEocName()).dataFrom("PTM").ptmBacklogId(ptmBacklogRecord.getId()).ptmWorkItemId(ptmWorkItemRecord.getId()).ptmActivityId(ptmWorkItemRecord.getActivityId()).type(SummaryMessagesUtils.translateBacklogType(ptmBacklog.getType())).sourceWorkitemId(ptmBacklog.getSourceBacklogId()).merge(ptmBacklog.getMerge()).backlogPerformId(ptmBacklog.getPerformerId()).createdFlag(bl.getCreatedFlag()).build();
                if (ptmBacklog.getMerge().booleanValue() && ptmMergeBacklogBO != null) {
                    activityDataBO.setPlanEndTimeMin(ptmMergeBacklogBO.getPlanEndTimeMin());
                    activityDataBO.setPlanEndTimeMax(ptmMergeBacklogBO.getPlanEndTimeMax());
                }
                if (StringUtils.isNotBlank((String)ptmProjectRecord.getProxyToken()) || StringUtils.isNotBlank((String)ptmTaskRecord.getProxyToken())) {
                    if (!StringUtils.equals((String)ptmProjectRecord.getTenantId(), (String)ptmBacklog.getTargetTenantId())) {
                        activityDataBO.setProxyToken(this.tenantTokenService.queryVirtualToken(ptmProjectRecord.getTenantId()));
                    } else {
                        activityDataBO.setProxyToken(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                    }
                } else {
                    activityDataBO.setProxyToken(null);
                }
                BpmActivityWorkitem bpmWorkitem = SummaryMessagesUtils.translatePtmWorkItem(ptmBacklog, ptmWorkItemRecord);
                activityDataBO.setWorkitemList(JsonUtils.objectToString(Arrays.asList(bpmWorkitem)));
                Optional<PtmTaskCardDataDTO> taskData = taskCardDataList.stream().filter(t -> {
                    if (BooleanUtils.isTrue((Boolean)bl.getCreatedFlag())) {
                        return Objects.equals(bl.getWorkItemId(), t.getWorkItemId());
                    }
                    return Objects.equals(t.getTaskId(), ptmTaskRecord.getId());
                }).findFirst();
                if (taskData.isPresent() && (td = taskData.get()).getData() != null) {
                    Map stateData;
                    activityDataBO.setBpmData(JsonUtils.objectToString((Object)td.getData()));
                    if (CollectionUtils.isNotEmpty((Collection)finalPtmSolveTasks) && MapUtils.isNotEmpty((Map)(stateData = this.getStateData(td.getData(), finalPtmSolveTasks, ptmActivityRecord, ptmWorkItemRecord)))) {
                        activityDataBO.setBpmStateData(JsonUtils.objectToString((Object)stateData));
                    }
                }
                if (overdueBacklog != null) {
                    activityDataBO.setBacklogId(overdueBacklog.getBacklogId());
                    activityDataBO.setPtmBacklogId(overdueBacklog.getBacklogId());
                    activityDataBO.setPtmWorkItemId(overdueBacklog.getBacklogId());
                    activityDataBO.setWorkItemId(overdueBacklog.getBacklogId());
                    activityDataBO.setOverdueWorkitemId(overdueBacklog.getOverdueBacklogId());
                    activityDataBO.setBacklogClosed(overdueBacklog.getClosed());
                    activityDataBO.setReadCount(overdueBacklog.getReadCount());
                    activityDataBO.setPerformerId(overdueBacklog.getPerformerId());
                    activityDataBO.setPrePerformerName(overdueBacklog.getPerformerName());
                    bpmWorkitem.setId(overdueBacklog.getBacklogId());
                    bpmWorkitem.setOverdueWorkitemId(overdueBacklog.getOverdueBacklogId());
                    activityDataBO.setWorkitemList(JsonUtils.objectToString(Arrays.asList(bpmWorkitem)));
                }
                if (finalDataUniformityBacklog != null) {
                    activityDataBO.setType(finalDataUniformityBacklog.getType());
                    activityDataBO.setSourceWorkitemId(finalDataUniformityBacklog.getSourceBacklogId());
                }
                if (null != ptmProjectRecord.getData()) {
                    activityDataBO.setProjectBpmData(JsonUtils.objectToString((Object)ptmProjectRecord.getData()));
                }
                result.add(activityDataBO);
            });
        }
        return result;
    }

    public PtmBacklog buildPtmBacklog(PtmBacklogRecordDTO ptmBacklogRecord) {
        PtmWorkItemRecordBO ptmWorkItemRecord = this.ptmService.getWorkItemRecord(ptmBacklogRecord.getWorkItemId());
        PtmBacklog ptmBacklog = new PtmBacklog();
        ptmBacklog.setBacklogId(ptmBacklogRecord.getId());
        ptmBacklog.setTargetTenantId(ptmBacklogRecord.getTenantId());
        ptmBacklog.setReadCount(Integer.valueOf(0));
        ptmBacklog.setClosed(ptmBacklogRecord.getClosed());
        ptmBacklog.setApprovalState(this.getApprovalState(ptmWorkItemRecord.getCreateType()));
        ptmBacklog.setMerge(ptmBacklogRecord.getMerge());
        return ptmBacklog;
    }

    public String getApprovalState(Integer createType) {
        if (Objects.equals(createType, WorkitemCreateType.REASSIGN.getValue())) {
            return "reassign";
        }
        if (Objects.equals(createType, WorkitemCreateType.ADDTASK.getValue())) {
            return "add-task";
        }
        if (Objects.equals(createType, WorkitemCreateType.REEXECUTE.getValue())) {
            return "reexecute";
        }
        if (Objects.equals(createType, WorkitemCreateType.REAPPROVAL.getValue())) {
            return "reapproval";
        }
        if (Objects.equals(createType, WorkitemCreateType.HANDOVER.getValue())) {
            return "handover";
        }
        if (Objects.equals(createType, WorkitemCreateType.RECALL.getValue())) {
            return "recall";
        }
        return null;
    }

    public Map<Long, PtmMergeBacklogBO> dealBacklogData(List<Long> backlogIdList, Boolean history) {
        if (history == null) {
            history = false;
        }
        if (CollectionUtils.isEmpty(backlogIdList)) {
            return new HashMap<Long, PtmMergeBacklogBO>();
        }
        List<PtmBacklogItemBO> ptmBacklogItemBOList = this.ptmService.getBacklogByBacklogIds(backlogIdList);
        if (CollectionUtils.isEmpty(ptmBacklogItemBOList)) {
            return null;
        }
        Map<Long, List<PtmBacklogItemBO>> ptmBacklogItemMap = ptmBacklogItemBOList.stream().collect(Collectors.groupingBy(PtmBacklogItemBO::getBacklogId));
        HashMap<Long, PtmMergeBacklogBO> resultMap = new HashMap<Long, PtmMergeBacklogBO>();
        for (Map.Entry<Long, List<PtmBacklogItemBO>> entry : ptmBacklogItemMap.entrySet()) {
            Long backlogId = entry.getKey();
            List<PtmBacklogItemBO> itemDTOList = entry.getValue();
            List planEndTimeList = null;
            planEndTimeList = history != false ? itemDTOList.stream().sorted(Comparator.comparing(PtmBacklogItemBO::getPlanEndTime)).map(PtmBacklogItemBO::getPlanEndTime).collect(Collectors.toList()) : itemDTOList.stream().filter(item -> !this.isWorkItemClosed(item.getState())).sorted(Comparator.comparing(PtmBacklogItemBO::getPlanEndTime)).map(PtmBacklogItemBO::getPlanEndTime).collect(Collectors.toList());
            List pendingList = itemDTOList.stream().filter(item -> !this.isWorkItemClosed(item.getState())).collect(Collectors.toList());
            PtmMergeBacklogBO ptmMergeBacklogBO = new PtmMergeBacklogBO();
            ptmMergeBacklogBO.setBacklogId(backlogId);
            ptmMergeBacklogBO.setTaskName(itemDTOList.get(0).getTaskName());
            if (CollectionUtils.isNotEmpty(planEndTimeList)) {
                ptmMergeBacklogBO.setPlanEndTimeMin((LocalDateTime)planEndTimeList.get(0));
                ptmMergeBacklogBO.setPlanEndTimeMax((LocalDateTime)planEndTimeList.get(planEndTimeList.size() - 1));
            }
            ptmMergeBacklogBO.setClosed(Boolean.valueOf(CollectionUtils.isEmpty(pendingList)));
            resultMap.put(backlogId, ptmMergeBacklogBO);
        }
        return resultMap;
    }

    private Map getStateData(Map taskData, List<PtmSolveTask> ptmSolveTasks, PtmActivityRecordDTO ptmActivityRecord, PtmWorkItemRecordBO ptmWorkItemRecord) {
        if (CollectionUtils.isEmpty(ptmSolveTasks)) {
            return new HashMap();
        }
        Long ptmWorkItemId = ptmWorkItemRecord.getId();
        List<String> unitKeys = ptmSolveTasks.get(0).getUniKeys();
        String dataKeys = ptmSolveTasks.get(0).getUniKeys().stream().collect(Collectors.joining(";"));
        HashMap<String, Object> stateData = new HashMap<String, Object>();
        stateData.put("dataKeys", dataKeys);
        stateData.put("originalQueryVariableName", "ptm_abnormal_data");
        ArrayList originalQueryVariables = new ArrayList();
        stateData.put("ptm_abnormal_data", originalQueryVariables);
        ptmSolveTasks.forEach(ptmSolveTask -> {
            if (ptmSolveTask.getData() != null) {
                ptmSolveTask.getData().forEach(dataItem -> {
                    if (ptmWorkItemId.equals(ptmSolveTask.getOriginalWorkItemId())) {
                        String serialNumber = ptmSolveTask.getSerialNumber();
                        HashMap<String, Object> instance = new HashMap<String, Object>();
                        instance.put("taskUid", ptmSolveTask.getTaskUid());
                        instance.put("processSerialNumber", serialNumber);
                        instance.put("tmActivityIds", new ArrayList());
                        instance.put("solveTaskId", ptmActivityRecord.getTaskId());
                        instance.put("solveBpmActivityId", ptmActivityRecord.getBpmActivityId());
                        instance.put("solveBpmActivityName", ptmActivityRecord.getBpmActivityName());
                        instance.put("bpmActivityId", ptmSolveTask.getTaskDefCode());
                        instance.put("bpmActivityName", ptmSolveTask.getTaskName());
                        instance.put("solveWorkItemId", ptmWorkItemRecord.getId());
                        instance.put("state", ptmSolveTask.getState());
                        Integer index = SummaryMessagesUtils.withinStateData(originalQueryVariables, dataItem, unitKeys);
                        List<HashMap<String, Object>> processInstances = new ArrayList<HashMap<String, Object>>();
                        if (index >= 0) {
                            processInstances = (List)((Map)originalQueryVariables.get(index)).get("processInstances");
                        }
                        processInstances.add(instance);
                        dataItem.put("processInstances", processInstances);
                        dataItem.put("state", ptmSolveTask.getState());
                        originalQueryVariables.add(dataItem);
                    }
                });
            }
        });
        return stateData;
    }

    public String getExecuteComment(Long backlogId) {
        if (!this.enablePTM()) {
            return null;
        }
        BpmActivityWorkitem bpmActivityWorkitem = this.getReapprovalInfoById(backlogId);
        if (bpmActivityWorkitem != null && StringUtils.isNotBlank((String)bpmActivityWorkitem.getComment())) {
            return bpmActivityWorkitem.getComment();
        }
        return null;
    }

    public BpmActivityWorkitem getReapprovalInfoById(long backlogId) {
        return this.getReapprovalInfoById(backlogId, null);
    }

    public BpmActivityWorkitem getReapprovalInfoById(long backlogId, PtmWorkItemRecordBO ptmWorkItemRecordBO) {
        BpmActivityWorkitem result = null;
        Long workItemRecordBackLogId = Objects.nonNull(ptmWorkItemRecordBO) ? ptmWorkItemRecordBO.getBacklogId() : null;
        PtmBacklog ptmBacklog = this.getBacklogForCard(backlogId, workItemRecordBackLogId);
        if (ptmBacklog == null) {
            return result;
        }
        Map<Long, TaskActivityItemVO> taskActivityItemVOMap = this.getReapprovalInfoMapById(backlogId, ptmBacklog, ptmWorkItemRecordBO);
        if (MapUtils.isEmpty(taskActivityItemVOMap)) {
            return result;
        }
        TaskActivityItemVO taskActivityItemVO = taskActivityItemVOMap.get(ptmBacklog.getWorkItemId());
        if (taskActivityItemVO != null) {
            result = BpmActivityWorkitem.builder().performerName(taskActivityItemVO.getPerformerName()).closedTime(taskActivityItemVO.getClosedTime()).comment(taskActivityItemVO.getComment()).state(taskActivityItemVO.getState()).subState(taskActivityItemVO.getSubState()).groupId(Long.valueOf(0L)).build();
        }
        return result;
    }

    public Map<Long, TaskActivityItemVO> getReapprovalInfoMapById(long backlogId, PtmBacklog ptmBacklog, PtmWorkItemRecordBO ptmWorkItemRecordBO) {
        Map<Long, TaskActivityItemVO> result = null;
        if (!this.enablePTM()) {
            return result;
        }
        if (ptmBacklog == null) {
            Long workItemRecordBackLogId = Objects.nonNull(ptmWorkItemRecordBO) ? ptmWorkItemRecordBO.getBacklogId() : null;
            ptmBacklog = this.getBacklogForCard(backlogId, workItemRecordBackLogId);
        }
        if (ptmBacklog == null) {
            return result;
        }
        PtmTaskRecordBO ptmTaskRecordBO = this.ptmService.getTaskRecord(ptmBacklog.getTaskId(), null);
        if (Objects.isNull(ptmTaskRecordBO)) {
            throw AtmcErrorCodeEnum.PTM_QUERY_PTM_GET_TASK_RECORD.getBusinessExceptionWithArgs(new Object[]{ptmBacklog.getTaskId()});
        }
        if (SummaryMessagesUtils.isApprovalTask(ptmTaskRecordBO.getTaskDefPattern(), ptmTaskRecordBO.getTaskDefCategory()).booleanValue()) {
            result = this.ptmService.getReExecuteWorkItemByBacklogId(0, backlogId, ptmTaskRecordBO.getTaskDefCode());
        } else {
            PtmProjectCard projectCard = this.commonPtmTransformService.getProjectInfo(ptmBacklog.getProjectCardId());
            if (Objects.isNull(projectCard)) {
                throw AtmcErrorCodeEnum.PTM_QUERY_PTM_PROJECT_CARD_RETURN_EMPTY.getBusinessExceptionWithArgs(new Object[]{ptmBacklog.getProjectCardId()});
            }
            String targetApproveActivity = this.themeMapService.getActivityTargetCode(projectCard.getProjectCode(), ptmTaskRecordBO.getTaskDefCode(), TmPageName.TASK_CARD_NAME.getValue());
            result = this.ptmService.getReExecuteWorkItemByBacklogId(1, backlogId, targetApproveActivity);
        }
        return result;
    }

    public PtmBacklog getBacklogForCard(Long backlogId, Long workItemRecordBackLogId) {
        PtmBacklog result = null;
        if (!this.enablePTM()) {
            return result;
        }
        List<Object> backlogList = this.ptmService.getBacklogByBacklogId(backlogId);
        PtmWorkItemRecordBO workItemRecordDTO = null;
        if (CollectionUtils.isEmpty(backlogList)) {
            Long workItemId = backlogId;
            if (Objects.isNull(workItemRecordBackLogId)) {
                workItemRecordDTO = this.ptmService.getWorkItemRecord(workItemId);
                Long l = workItemRecordBackLogId = Objects.nonNull(workItemRecordDTO) ? workItemRecordDTO.getBacklogId() : null;
            }
            if (Objects.nonNull(workItemRecordBackLogId)) {
                backlogList = this.ptmService.getBacklogByBacklogId(workItemRecordBackLogId);
                backlogList = backlogList.stream().filter(x -> Objects.equals(x.getWorkItemId(), workItemId)).collect(Collectors.toList());
            }
        }
        PtmBacklog backlog = this.commonPtmTransformService.getBacklogByIdFromDb(backlogId);
        if (CollectionUtils.isEmpty(backlogList)) {
            return backlog;
        }
        if (backlog != null && backlog.getType().compareTo(0) != 0) {
            return backlog;
        }
        PtmBacklogItemBO ptmBacklog = backlogList.get(0);
        PtmTaskRecordBO ptmTaskRecord = this.ptmService.getTaskRecord(ptmBacklog.getTaskId(), null);
        PtmProjectRecordBO ptmProjectRecord = this.ptmService.getProjectRecord(ptmTaskRecord.getProjectId());
        result = PtmBacklog.builder().backlogId(ptmBacklog.getBacklogId()).createTime(ptmBacklog.getCreateTime()).closedTime(ptmBacklog.getClosedTime()).closed(ptmBacklog.getClosed()).projectCardId(ptmProjectRecord.getProjectCardId()).projectId(ptmProjectRecord.getId()).taskId(ptmBacklog.getTaskId()).performerId(ptmBacklog.getPerformerId()).performerName(ptmBacklog.getPerformerName()).activityId(ptmBacklog.getActivityId()).workItemId(ptmBacklog.getWorkItemId()).planEndTime(ptmBacklog.getPlanEndTime()).taskDefCode(ptmBacklog.getTaskDefCode()).taskName(ptmBacklog.getTaskName()).taskWithName(ptmBacklog.getTaskWithName()).taskDefName(ptmBacklog.getTaskDefName()).taskDefWithName(ptmBacklog.getTaskDefWithName()).eocCode(ptmBacklog.getEocCode()).eocName(ptmBacklog.getEocName()).eocType(ptmBacklog.getEocType()).build();
        if (StringUtils.isNotBlank((String)ptmBacklog.getName())) {
            result.setTaskName(ptmBacklog.getName());
        }
        if (StringUtils.isNotBlank((String)ptmBacklog.getWithName())) {
            result.setTaskWithName(ptmBacklog.getWithName());
        }
        if (backlog != null) {
            result.setPerformerId(backlog.getPerformerId());
            result.setPerformerName(backlog.getPerformerName());
            result.setTenantId(backlog.getTenantId());
            result.setTenantName(backlog.getTenantName());
            result.setTargetTenantId(backlog.getTargetTenantId());
            result.setFavorite(backlog.getFavorite());
            result.setCreateDate(backlog.getCreateDate());
            result.setModifyDate(backlog.getModifyDate());
            result.setReadCount(backlog.getReadCount());
            result.setOverdueBacklogId(backlog.getOverdueBacklogId());
            result.setType(backlog.getType());
            result.setMerge(backlog.getMerge());
            result.setSourceBacklogId(backlog.getSourceBacklogId());
            result.setSubmitId(backlog.getSubmitId());
            result.setCreateDate(backlog.getCreateDate());
            result.setModifyDate(backlog.getModifyDate());
            result.setActionId(backlog.getActionId());
        } else {
            result.setCreateDate(LocalDateTime.now());
            result.setModifyDate(LocalDateTime.now());
        }
        this.buildDeletionField(result, workItemRecordDTO);
        return result;
    }

    public PtmProjectCard getProjectInfo(Long projectId) {
        PtmProjectCard result = null;
        if (!this.enablePTM()) {
            return result;
        }
        PtmProjectCardRecordDTO ptmProjectCardRecordDTO = this.ptmService.getProjectCardRecord(projectId);
        PtmProjectCard ptmProjectCard = (PtmProjectCard)this.ptmProjectCardMapper.selectById((Serializable)projectId);
        if (ptmProjectCardRecordDTO == null) {
            return ptmProjectCard;
        }
        if (ptmProjectCard == null) {
            ptmProjectCard = new PtmProjectCard();
        }
        result = PtmProjectCard.builder().id(ptmProjectCardRecordDTO.getId()).projectCode(ptmProjectCardRecordDTO.getProjectDefCode()).projectName(ptmProjectCardRecordDTO.getProjectName()).tenantId(ptmProjectCardRecordDTO.getTenantId()).tenantName(ptmProjectCardRecordDTO.getTargetName()).personInCharge(ptmProjectCardRecordDTO.getPersonInCharge()).personInChargeName(ptmProjectCardRecordDTO.getPersonInChargeName()).startTime(ptmProjectCardRecordDTO.getStartTime()).endTime(ptmProjectCardRecordDTO.getEndTime()).completedReport(ptmProjectCardRecordDTO.getCompletedReport()).state(ptmProjectCardRecordDTO.getState()).readCount(ptmProjectCard.getReadCount()).favorite(ptmProjectCard.getFavorite()).targetId(ptmProjectCard.getTargetId()).targetName(ptmProjectCard.getTargetName()).engineType(ptmProjectCard.getEngineType()).closedTime(ptmProjectCardRecordDTO.getClosedTime()).name(ptmProjectCardRecordDTO.getProjectName()).submitId(ptmProjectCard.getSubmitId()).hide(ptmProjectCard.getHide()).build();
        result.setCreateDate(ptmProjectCard.getCreateDate() != null ? ptmProjectCard.getCreateDate() : LocalDateTime.now());
        result.setModifyDate(ptmProjectCard.getModifyDate() != null ? ptmProjectCard.getModifyDate() : LocalDateTime.now());
        return result;
    }

    private void buildDeletionField(PtmBacklog ptmBacklog, PtmWorkItemRecordBO workItemRecordDTO) {
        if (StringUtils.isEmpty((String)ptmBacklog.getApprovalState())) {
            boolean hasAlreadyKnowItemRecord = Objects.nonNull(workItemRecordDTO) && Objects.nonNull(ptmBacklog) && ptmBacklog.getWorkItemId().equals(workItemRecordDTO.getId());
            PtmWorkItemRecordBO ptmWorkItemRecord = hasAlreadyKnowItemRecord ? workItemRecordDTO : this.ptmService.getWorkItemRecord(ptmBacklog.getWorkItemId());
            ptmBacklog.setApprovalState(this.commonPtmTransformService.getApprovalState(ptmWorkItemRecord.getCreateType()));
        }
    }

    private boolean isWorkItemClosed(Integer state) {
        return Objects.nonNull(state) && state >= ActivityState.COMPLETED.getCode();
    }

    public PtmBacklog getBacklogForCard(Long backlogId) {
        return this.getBacklogForCard(backlogId, null);
    }

    public Task getTask(Long projectCardId) {
        if (!this.enablePTM()) {
            return null;
        }
        PtmProjectCardDetailDTO projectCardDetailDTO = this.ptmService.getProjectCardDetail(projectCardId);
        if (projectCardDetailDTO != null) {
            Task task = Task.builder().id(projectCardDetailDTO.getId()).mainTaskId(projectCardDetailDTO.getId()).projectName(projectCardDetailDTO.getProjectDefName()).name(projectCardDetailDTO.getProjectCardName()).startTime(projectCardDetailDTO.getStartTime()).endTime(projectCardDetailDTO.getEndTime()).createTime(projectCardDetailDTO.getCreateTime()).personInCharge(projectCardDetailDTO.getPersonInCharge()).personInChargeName(projectCardDetailDTO.getPersonInChargeName()).tmTaskId(projectCardDetailDTO.getProjectDefCode()).tenantId(projectCardDetailDTO.getTenantId()).build();
            return task;
        }
        return null;
    }

    public List<BpmProcess> getProjectByProjectCardId(Long projectCardId) {
        ArrayList<BpmProcess> result = new ArrayList<BpmProcess>();
        if (!this.enablePTM()) {
            return result;
        }
        PtmProjectCardDetailDTO projectCardDetailDTO = this.ptmService.getProjectCardDetail(projectCardId);
        if (projectCardDetailDTO != null && CollectionUtils.isNotEmpty(projectCardDetailDTO.getProjects())) {
            projectCardDetailDTO.getProjects().forEach(p -> {
                PtmProjectRecordBO ptmProjectRecord = this.ptmService.getProjectRecord(p.getProjectId());
                BpmProcess bpmProcess = BpmProcess.builder().processSerialNumber(ptmProjectRecord.getProcessSerialNumber()).data(JSONObject.fromObject((Object)ptmProjectRecord.getData())).businessUnit(JSONObject.fromObject((Object)ptmProjectRecord.getBusinessUnit())).proxyToken(ptmProjectRecord.getProxyToken()).tmTaskId(ptmProjectRecord.getProjectDefCode()).build();
                result.add(bpmProcess);
            });
        }
        return result;
    }

    public List<ActivityDataBO> getActivityDataByBacklogId(List<Map<String, Object>> list, Boolean isHistory, boolean isAllQuery) {
        List<Long> backlogIds = list.stream().map(e -> (Long)e.get("backlogId")).collect(Collectors.toList());
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("ptm server");
        List<PtmBacklogItemBO> backlogItemList = this.ptmService.getBacklogByBacklogIds(backlogIds);
        ArrayList<ActivityDataBO> result = new ArrayList<ActivityDataBO>();
        List<PtmBacklogRecordDTO> backlogRecordByBacklogIds = this.ptmService.getBacklogRecordByBacklogIds(backlogIds);
        Map<Long, PtmBacklogRecordDTO> ptmBacklogRecordDTOMap = backlogRecordByBacklogIds.stream().collect(Collectors.toMap(PtmBacklogRecordDTO::getId, v -> v, (p1, p2) -> p1));
        List<PtmTaskCardDataDTO> taskCardDataList = this.ptmService.getTaskDataByBacklogIds(list, "data", isAllQuery ? "true" : "false");
        stopWatch.stop();
        stopWatch.start("ptm batch data");
        Map<Long, PtmTaskCardDataDTO> taskCardDataDTOMap = isAllQuery ? taskCardDataList.stream().collect(Collectors.toMap(p -> p.getWorkItemId(), p -> p, (p1, p2) -> p1)) : taskCardDataList.stream().collect(Collectors.toMap(p -> p.getBacklogId(), p -> p, (p1, p2) -> p1));
        List backlogList = this.ptmBacklogMapper.selectBatchIds(backlogIds);
        Map<Long, PtmBacklog> ptmBacklogMap = backlogList.stream().collect(Collectors.toMap(PtmBacklog::getBacklogId, v -> v, (p1, p2) -> p1));
        List<PtmTaskRecordBO> ptmTaskRecordList = this.ptmService.getTaskRecordByTaskIds(backlogItemList.stream().map(PtmBacklogItemBO::getTaskId).distinct().collect(Collectors.toList()));
        Map<Long, PtmTaskRecordBO> ptmTaskRecordMap = ptmTaskRecordList.stream().collect(Collectors.toMap(PtmTaskRecordBO::getId, v -> v, (p1, p2) -> p1));
        List<PtmActivityRecordDTO> ptmActivityRecordList = this.ptmService.getActivityRecordByActivityIds(backlogItemList.stream().map(PtmBacklogItemBO::getActivityId).distinct().collect(Collectors.toList()));
        Map<Long, PtmActivityRecordDTO> ptmActivityRecordMap = ptmActivityRecordList.stream().collect(Collectors.toMap(PtmActivityRecordDTO::getId, v -> v, (p1, p2) -> p1));
        List<PtmProjectRecordBO> ptmProjectRecordList = this.ptmService.getProjectRecordByProjectIds(backlogItemList.stream().map(PtmBacklogItemBO::getProjectId).distinct().collect(Collectors.toList()));
        Map<Long, PtmProjectRecordBO> ptmProjectRecordMap = ptmProjectRecordList.stream().collect(Collectors.toMap(PtmProjectRecordBO::getId, v -> v, (p1, p2) -> p1));
        List<PtmWorkItemRecordBO> workItemRecordList = this.ptmService.getWorkItemRecordByWorkItemIds(backlogItemList.stream().map(PtmBacklogItemBO::getWorkItemId).distinct().collect(Collectors.toList()));
        Map<Long, PtmWorkItemRecordBO> ptmWorkItemRecordMap = workItemRecordList.stream().collect(Collectors.toMap(PtmWorkItemRecordBO::getId, v -> v, (p1, p2) -> p1));
        backlogItemList.forEach(bl -> {
            PtmBacklogRecordDTO ptmBacklogRecord = (PtmBacklogRecordDTO)ptmBacklogRecordDTOMap.get(bl.getBacklogId());
            PtmBacklog ptmBacklog = (PtmBacklog)ptmBacklogMap.get(bl.getBacklogId());
            if (ptmBacklog == null) {
                ptmBacklog = this.buildPtmBacklog(ptmBacklogRecord);
            }
            PtmTaskRecordBO ptmTaskRecord = (PtmTaskRecordBO)ptmTaskRecordMap.get(bl.getTaskId());
            PtmActivityRecordDTO ptmActivityRecord = (PtmActivityRecordDTO)ptmActivityRecordMap.get(bl.getActivityId());
            PtmProjectRecordBO ptmProjectRecord = (PtmProjectRecordBO)ptmProjectRecordMap.get(bl.getProjectId());
            PtmWorkItemRecordBO ptmWorkItemRecord = (PtmWorkItemRecordBO)ptmWorkItemRecordMap.get(bl.getWorkItemId());
            ActivityDataBO activityDataBO = ActivityDataBO.builder().bpmActivitySqlId(ptmTaskRecord.getId()).tmActivityId(ptmTaskRecord.getTaskDefCode()).tmPattern(ptmTaskRecord.getTaskDefPattern()).tmCategory(ptmTaskRecord.getTaskDefCategory()).bpmActivityType(ptmTaskRecord.getBpmnType()).bpmActivityId(ptmActivityRecord.getBpmActivityId()).backlogName(ptmTaskRecord.getTaskName()).targetTenantId(ptmBacklog.getTargetTenantId()).performerId(ptmWorkItemRecord.getPerformerId()).performerName(ptmWorkItemRecord.getPerformerName()).readCount(ptmBacklog.getReadCount()).startTime(ptmTaskRecord.getCreateTime()).planEndTime(ptmTaskRecord.getPlanEndTime()).endTime(bl.getClosedTime()).taskId(ptmBacklogRecord.getProjectId()).tmTaskId(ptmProjectRecord.getProjectDefCode()).chargeId(ptmProjectRecord.getPersonInCharge()).processSerialNumber(ptmProjectRecord.getProcessSerialNumber()).chargeName(ptmProjectRecord.getPersonInChargeName()).tenantId(ptmProjectRecord.getTenantId()).businessUnit(JsonUtils.objectToString((Object)ptmTaskRecord.getBusinessUnit())).taskStartTime(ptmProjectRecord.getStartTime()).taskEndTime(ptmProjectRecord.getEndTime()).taskName(ptmProjectRecord.getProjectName()).tmActivityName(ptmTaskRecord.getTaskDefName()).finishedActionId(ptmBacklog.getClosed() != false ? ptmBacklog.getActionId() : null).tmShowFlow(Boolean.valueOf(false)).stepId(ptmActivityRecord.getId()).taskSourceIds(ptmProjectRecord.getSourceIds()).stepSignReason(ptmActivityRecord.getSignReason()).approvalState(ptmBacklog.getApprovalState()).backlogClosed(Boolean.valueOf(ptmBacklog.getClosed() != false || bl.getClosed() != false)).merge(ptmBacklogRecord.getMerge()).proxyToken(StringUtils.isNotBlank((String)ptmTaskRecord.getProxyToken()) ? ptmTaskRecord.getProxyToken() : ptmProjectRecord.getProxyToken()).processCreateTime(ptmProjectRecord.getCreateTime()).compositionId("").overdueWorkitemId(Long.valueOf(0L)).workItemId(ptmWorkItemRecord.getId()).taskUid(ptmTaskRecord.getBpmTaskUid()).preTaskUid(null).stepState(ptmActivityRecord.getState()).stepSubState(ptmActivityRecord.getSubState()).traceId(ptmProjectRecord.getTraceId()).eocName(ptmProjectRecord.getEocName()).dataFrom("PTM").ptmBacklogId(ptmBacklogRecord.getId()).ptmWorkItemId(ptmWorkItemRecord.getId()).ptmActivityId(ptmWorkItemRecord.getActivityId()).type(SummaryMessagesUtils.translateBacklogType(ptmBacklog.getType())).sourceWorkitemId(ptmBacklog.getSourceBacklogId()).merge(ptmBacklog.getMerge()).backlogPerformId(ptmBacklog.getPerformerId()).backlogId(bl.getBacklogId()).build();
            if (isAllQuery) {
                if (taskCardDataDTOMap.get(bl.getWorkItemId()) != null) {
                    activityDataBO.setBpmData(JsonUtils.objectToString((Object)((PtmTaskCardDataDTO)taskCardDataDTOMap.get(bl.getWorkItemId())).getData()));
                }
            } else if (taskCardDataDTOMap.get(bl.getBacklogId()) != null) {
                activityDataBO.setBpmData(JsonUtils.objectToString((Object)((PtmTaskCardDataDTO)taskCardDataDTOMap.get(bl.getBacklogId())).getData()));
            }
            result.add(activityDataBO);
        });
        stopWatch.stop();
        log.info(" query data from ptmservice :{}", (Object)stopWatch.prettyPrint());
        return result;
    }
}

