/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmDataConsistencyMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.TaskWorkItemMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmSpecialBacklogDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.TaskWorkitemMessageHandler;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.ActivityUtils;
import com.digiwin.athena.abt.application.utils.BacklogAbstractUtil;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskWorkitemMessageMapper;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PtmMqCardMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmMqCardMessageService.class);
    public static final String PTM_BACKLOG = "ptmBacklog";
    public static final String ADD = "add";
    public static final String PTM_PROJECT = "ptmProject";
    @Autowired
    private TaskWorkitemMessageHandler taskWorkitemMessageHandler;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    private TaskWorkitemMessageMapper taskWorkitemMessageMapper;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private BacklogAbstractUtil backlogAbstractUtil;

    public void processSpecialBacklogMessage(AuthoredUser user, String data) {
        PtmBacklogMessageDTO backlogMessageDTO = (PtmBacklogMessageDTO)JsonUtils.jsonToObject((String)data, PtmBacklogMessageDTO.class);
        PtmBacklogMessageDTO.Backlog backlog = backlogMessageDTO.getData().getBacklog();
        LogDto logDto = new LogDto("\u4fdd\u5b58\u8f85\u52a9\u6267\u884c\u8005\u3001\u8de8\u79df\u6237\u7684\u4efb\u52a1\u5361\u7684\u6458\u8981\u3001\u8d44\u8baf\u548c\u641c\u7d22\u6570\u636e\u5f00\u59cb\uff0c\u5361\u7247id\uff1a" + backlog.getBacklogId(), user.getTenantId() + ";" + backlog.getBacklogId());
        log.info(logDto.toString());
        if (backlog != null && this.ptmBacklogMapper.selectById((Serializable)backlog.getBacklogId()) == null) {
            throw BusinessException.create((String)"backlog is null");
        }
        if (!PtmMqOperation.ADD.equals((Object)backlogMessageDTO.getOperation())) {
            return;
        }
        if (backlog != null && (backlog.getType() == 1 || backlog.getType() == 2)) {
            log.info("PTM-saveSpecialBacklogMessage-backlog:{}", (Object)backlog);
            TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
            model.setCardType(PTM_BACKLOG);
            model.setWorkItemId(backlog.getWorkItemId());
            model.setCardId(backlog.getBacklogId());
            model.setActivityId(backlog.getActivityId());
            model.setTenantId(backlog.getTenantId());
            model.setAuthoredUser(user);
            log.info("PTM-saveSpecialBacklogMessage-model:{}", (Object)model);
            this.taskWorkitemMessageHandler.process(model);
        }
    }

    public void processProjectCardMessage(AuthoredUser user, String data) {
        PtmProjectCardMessageDTO ptmProjectCardMessageDTO = (PtmProjectCardMessageDTO)JsonUtils.jsonToObject((String)data, PtmProjectCardMessageDTO.class);
        PtmProjectCardDataDTO cardDataDTO = ptmProjectCardMessageDTO.getData();
        PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
        LogDto logDto = new LogDto("\u5904\u7406\u9879\u76ee\u5361\u6458\u8981\u3001\u8d44\u8baf\u548c\u641c\u7d22\u6570\u636e\u5f00\u59cb\uff0c\u5361\u7247id\uff1a" + cardDTO.getId(), user.getTenantId() + ";" + cardDTO.getId());
        log.info(logDto.toString());
        TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
        model.setCardId(cardDTO.getId());
        model.setCardType(PTM_PROJECT);
        model.setAuthoredUser(user);
        this.taskWorkitemMessageHandler.process(model);
    }

    public void processCardMessage(AuthoredUser user, String data) {
        PtmDataConsistencyMessageDTO message = ActivityUtils.convertPtmDataConsistencyMsg(data);
        try {
            PtmDataConsistencyMessageDTO.MqData mqData = message.getData();
            List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = mqData.getWorkItem();
            log.info("PTM-saveBacklogMessage-workItem:{}", workItemList);
            if (CollectionUtils.isNotEmpty(workItemList)) {
                PtmDataConsistencyMessageDTO.WorkItem workItem = workItemList.get(0);
                LogDto logDto = new LogDto("\u5904\u7406\u4efb\u52a1\u5361\u6458\u8981\u3001\u8d44\u8baf\u548c\u641c\u7d22\u6570\u636e\u5f00\u59cb\uff0c\u5361\u7247id\uff1a" + workItem.getBacklogId(), user.getTenantId() + ";" + workItem.getBacklogId());
                log.info(logDto.toString());
                if (BooleanUtils.isTrue((Boolean)mqData.getMinSplit()) && workItemList.size() > 1) {
                    log.info("\u5904\u7406\u6700\u5c0f\u5316\u591a\u4e2a\u4ee3\u529e\u4e8b\u9879\u751f\u6210\u6458\u8981\u5f00\u59cb");
                    this.processMinCardMessage(user, workItemList);
                    log.info("\u5904\u7406\u6700\u5c0f\u5316\u591a\u4e2a\u4ee3\u529e\u4e8b\u9879\u751f\u6210\u6458\u8981\u7ed3\u675f");
                    return;
                }
                TaskWorkItemMessageDTO model = this.createWorkItemMsg(user, workItem, null);
                log.info("PTM-saveBacklogMessage-model:{}", (Object)model);
                this.taskWorkitemMessageHandler.process(model);
                log.info("PTM-saveSpecialBacklogMessageByWorkitem-workItem:{}", (Object)workItem);
                this.saveSpecialBacklogMessageByWorkitem(user, workItem, null);
            }
        }
        catch (Exception e) {
            log.warn("PtmMqCardMessageServiceImpl-error:{}", (Object)e.getMessage());
        }
    }

    private void processMinCardMessage(AuthoredUser user, List<PtmDataConsistencyMessageDTO.WorkItem> workItemList) {
        HashMap backLogToWorkItemList = Maps.newHashMap();
        for (PtmDataConsistencyMessageDTO.WorkItem workItem : workItemList) {
            List workItems = backLogToWorkItemList.computeIfAbsent(workItem.getBacklogId(), e -> new ArrayList());
            workItems.add(workItem);
        }
        backLogToWorkItemList.forEach((k, v) -> {
            PtmDataConsistencyMessageDTO.WorkItem workItem = (PtmDataConsistencyMessageDTO.WorkItem)v.get(0);
            List<Long> workItemIds = v.stream().map(PtmDataConsistencyMessageDTO.WorkItem::getId).collect(Collectors.toList());
            TaskWorkItemMessageDTO model = this.createWorkItemMsg(user, workItem, workItemIds);
            log.info("PTM-saveBacklogMessage-model:{}", (Object)model);
            this.taskWorkitemMessageHandler.process(model);
            this.saveSpecialBacklogMessageByWorkitem(user, workItem, workItemIds);
        });
    }

    private TaskWorkItemMessageDTO createWorkItemMsg(AuthoredUser user, PtmDataConsistencyMessageDTO.WorkItem workItem, List<Long> workItemIds) {
        TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
        model.setCardType(PTM_BACKLOG);
        model.setWorkItemId(workItem.getId());
        model.setWorkItemIds(workItemIds);
        model.setCardId(workItem.getBacklogId());
        model.setAuthoredUser(user);
        model.setActivityId(workItem.getActivityId());
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSpecialBacklogMessageByWorkitem(AuthoredUser user, PtmDataConsistencyMessageDTO.WorkItem workItem, List<Long> workItemIds) {
        AppAuthContext appAuthContext = new AppAuthContext();
        appAuthContext.setAuthoredUser(user);
        AppAuthContextHolder.setContext((AppAuthContext)appAuthContext);
        List<Object> specialBacklogList = new ArrayList();
        try {
            log.info("PTM-saveSpecialBacklogMessageByWorkitem-work_item_id:{}, user:{}", (Object)workItem.getId(), (Object)JsonUtils.objectToString((Object)user));
            specialBacklogList = this.ptmService.getSpecialBacklog(Collections.singletonList(workItem.getId()));
            log.info("PTM-saveSpecialBacklogMessageByWorkitem-ptmBacklogList:{}", specialBacklogList);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            AppAuthContextHolder.clearContext();
            LocaleContextHolder.resetLocaleContext();
        }
        if (CollectionUtils.isEmpty(specialBacklogList)) {
            return;
        }
        for (PtmSpecialBacklogDTO ptmSpecialBacklogDTO : specialBacklogList) {
            TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
            model.setCardType(PTM_BACKLOG);
            model.setWorkItemId(workItem.getId());
            model.setWorkItemIds(workItemIds);
            model.setCardId(ptmSpecialBacklogDTO.getBacklogId());
            model.setTenantId(ptmSpecialBacklogDTO.getTenantId());
            model.setAuthoredUser(user);
            log.info("PTM-saveSpecialBacklogMessageByWorkitem-model:{}", (Object)model);
            this.taskWorkitemMessageHandler.process(model);
        }
    }

    public void processFlowMessage(AuthoredUser user, String data) {
        try {
            TaskWorkItemMessageDTO model = (TaskWorkItemMessageDTO)JsonUtils.jsonToObject((String)data, TaskWorkItemMessageDTO.class);
            model.setAuthoredUser(user);
            log.info("FLOW-processFlowMessage-model:{}", (Object)model);
            String cardId = String.valueOf(model.getCardId() == null ? 0L : model.getCardId());
            LogDto logDto = new LogDto("\u5904\u7406\u6d41\u7a0b\u5f15\u64ce\u4efb\u52a1\u5361\u6458\u8981\u3001\u8d44\u8baf\u548c\u641c\u7d22\u6570\u636e\u5f00\u59cb\uff0c\u5361\u7247id\uff1a" + cardId, user.getTenantId() + ";" + cardId);
            log.info(logDto.toString());
            this.taskWorkitemMessageHandler.process(model);
        }
        catch (Exception e) {
            log.warn("FLOW-processFlowMessage-error:{}", (Object)e.getMessage());
        }
    }

    public void removeCloseBusinessMessage(AuthoredUser user, String data, EventListenerDTO mqMessageDTO) {
        try {
            if (!PtmMqOperation.CLOSE.equals((Object)mqMessageDTO.getOperation())) {
                return;
            }
            this.removeBusinessMessageInner(user, data, mqMessageDTO);
        }
        catch (Exception e) {
            log.warn("RemoveCloseBusinessMessage fail: {}", (Object)ExceptionUtil.getSimpleMessage((Throwable)e));
        }
    }

    private void removeBusinessMessageInner(AuthoredUser user, String data, EventListenerDTO mqMessageDTO) {
        EventMqTypeEnum type = mqMessageDTO.getType();
        if (EventMqTypeEnum.projectCard.equals((Object)type)) {
            String pageCode = TmPageName.PROJECT_CARD_NAME.getValue();
            PtmProjectCardMessageDTO ptmProjectCardMessageDTO = (PtmProjectCardMessageDTO)JsonUtils.jsonToObject((String)data, PtmProjectCardMessageDTO.class);
            PtmProjectCardDataDTO cardDataDTO = ptmProjectCardMessageDTO.getData();
            PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
            this.backlogAbstractUtil.removeBusinessMessage(Lists.newArrayList((Object[])new Long[]{cardDTO.getId()}), user.getTenantId(), pageCode);
        } else if (EventMqTypeEnum.backlog.equals((Object)type)) {
            String pageCode = TmPageName.TASK_CARD_NAME.getValue();
            PtmDataConsistencyMessageDTO message = ActivityUtils.convertPtmDataConsistencyMsg(data);
            PtmDataConsistencyMessageDTO.MqData mqData = message.getData();
            List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = mqData.getWorkItem();
            if (CollectionUtils.isEmpty(workItemList)) {
                HashSet<Long> cardIds = new HashSet<Long>();
                for (PtmDataConsistencyMessageDTO.WorkItem workItem : workItemList) {
                    cardIds.add(workItem.getBacklogId());
                }
                this.backlogAbstractUtil.removeBusinessMessage(cardIds, user.getTenantId(), pageCode);
            }
        }
    }
}

