/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.service.abt.migration.ptm;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.EventFlowBacklogGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmBacklogCreateGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmMqTaskMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectCardGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmTaskDeleteGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectMessageDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.PtmBacklogCreateGroupHandler;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.PtmProjectCardCreateGroupHandler;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.PtmProjectCardDeleteGroupHandler;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.PtmProjectUpdateImHandler;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.PtmTaskDeleteGroupHandler;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivity;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmMqGroupTeamService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmMqGroupTeamService.class);
    @Autowired
    private PtmTaskDeleteGroupHandler ptmTaskDeleteGroupHandler;
    @Autowired
    private PtmProjectCardDeleteGroupHandler ptmProjectCardDeleteGroupHandler;
    @Autowired
    private PtmProjectCardCreateGroupHandler ptmProjectCardCreateGroupHandler;
    @Autowired
    private PtmBacklogCreateGroupHandler ptmBacklogCreateGroupHandler;
    @Autowired
    private PtmProjectUpdateImHandler ptmProjectUpdateImHandler;
    @Autowired
    private TeamMemberService teamMemberService;
    @Autowired
    private ImService imService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    private BacklogMapper backlogMapper;

    public void processTaskDeleteGroupMessage(String data, AuthoredUser user) {
        PtmMqTaskMessageDTO message = (PtmMqTaskMessageDTO)JsonUtils.jsonToObject((String)data, PtmMqTaskMessageDTO.class);
        PtmMqTaskMessageDTO.Task task = message.getData().getTask();
        LogDto logDto = new LogDto("\u5904\u7406\u5220\u9664\u7fa4\u804a\u6d88\u606f\uff0ctaskId\uff1a" + task.getId(), user.getTenantId() + ";" + task.getId());
        log.info(logDto.toString());
        PtmTaskDeleteGroupDTO model = new PtmTaskDeleteGroupDTO();
        BeanUtils.copyProperties((Object)task, (Object)model);
        model.setOperation(message.getOperation());
        model.setAuthoredUser(user);
        this.ptmTaskDeleteGroupHandler.process(model);
    }

    public void processProjectCardGroupMessage(String data, AuthoredUser user) {
        PtmProjectCardMessageDTO message = (PtmProjectCardMessageDTO)JsonUtils.jsonToObject((String)data, PtmProjectCardMessageDTO.class);
        PtmProjectCardDataDTO cardDataDTO = message.getData();
        PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
        String cardId = String.valueOf(cardDTO == null ? 0L : cardDTO.getId());
        LogDto logDto = new LogDto("\u5904\u7406\u9879\u76ee\u5361\u7fa4\u804a\u6d88\u606f\uff0c\u9879\u76ee\u5361id\uff1a" + cardId, user.getTenantId() + ";" + cardId);
        log.info(logDto.toString());
        PtmProjectCardGroupDTO model = new PtmProjectCardGroupDTO();
        BeanUtils.copyProperties((Object)cardDTO, (Object)model);
        model.setAuthoredUser(user);
        model.setOperation(message.getOperation());
        model.setProject(cardDataDTO.getProject());
        model.setRelatedUsers(cardDataDTO.getRelatedUsers());
        model.setImBusinessKey(cardDataDTO.getImBusinessKey());
        if (PtmMqOperation.CLOSE.equals((Object)message.getOperation())) {
            this.ptmProjectCardDeleteGroupHandler.process(model);
        } else if (PtmMqOperation.ADD.equals((Object)message.getOperation())) {
            this.ptmProjectCardCreateGroupHandler.process(model);
        }
    }

    public void processTaskCreateGroupMessage(String data, AuthoredUser user) {
        PtmBacklogMessageDTO message = (PtmBacklogMessageDTO)JsonUtils.jsonToObject((String)data, PtmBacklogMessageDTO.class);
        PtmBacklogMessageDTO.Backlog ptmBacklog = message.getData().getBacklog();
        String backlogId = String.valueOf(ptmBacklog.getBacklogId() == null ? 0L : ptmBacklog.getBacklogId());
        LogDto logDto = new LogDto("\u5904\u7406\u521b\u5efa\u7fa4\u804a\u6d88\u606f\uff0c\u5f85\u529eid\uff1a" + backlogId, user.getTenantId() + ";" + backlogId);
        log.info(logDto.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)ptmBacklog.getTaskId());
        boolean canCreateTaskTeam = this.ptmBacklogMapper.selectCount((Wrapper)queryWrapper) <= 1L;
        PtmBacklogCreateGroupDTO model = new PtmBacklogCreateGroupDTO();
        BeanUtils.copyProperties((Object)ptmBacklog, (Object)model);
        model.setAuthoredUser(user);
        model.setCanCreateTaskTeam(canCreateTaskTeam);
        model.setOperation(message.getOperation());
        this.ptmBacklogCreateGroupHandler.process(model);
    }

    public void processFlowProjectCardGroupMessage(String data, AuthoredUser user) {
        PtmProjectCardGroupDTO message = (PtmProjectCardGroupDTO)JsonUtils.jsonToObject((String)data, PtmProjectCardGroupDTO.class);
        if (PtmMqOperation.CLOSE.equals((Object)message.getOperation())) {
            this.removeFlowProjectCardGroup(user, message);
        } else if (PtmMqOperation.ADD.equals((Object)message.getOperation())) {
            this.createFlowProjectCardGroup(user, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFlowProjectCardGroup(AuthoredUser user, PtmProjectCardGroupDTO message) {
        log.info("\u3010createFlowProjectCardGroup\u3011\uff1a{}", (Object)message);
        try {
            AppAuthContextHolder.clearContext();
            Task task = Task.builder().id(message.getId()).mainTaskId(message.getMainTaskId()).name(message.getName()).startTime(message.getStartTime()).endTime(message.getEndTime()).personInCharge(message.getPersonInCharge()).build();
            if (Boolean.FALSE.equals(message.getHasMainTask())) {
                this.teamMemberService.createTaskTeam(task, user, message.getRelatedUsers(), message.getBusinessKey());
            } else {
                this.teamMemberService.updateTeamMemberByFlow(task, user, message.getRelatedUsers());
            }
        }
        catch (Exception ex) {
            log.warn("\u6d41\u7a0b\u5f15\u64ce\u9879\u76ee\u5361\u521b\u5efa\u65f6,\u521b\u5efaIM\u9879\u76ee\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), message});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFlowProjectCardGroup(AuthoredUser user, PtmProjectCardGroupDTO message) {
        log.info("\u3010removeFlowProjectCardGroup\u3011\uff1a{}", (Object)message);
        try {
            List bpmActivityIdIdList;
            AppAuthContextHolder.clearContext();
            this.imService.removeTeam(message.getId().toString(), 1, user);
            log.info("\u89e3\u6563\u9879\u76ee\u7fa4\u65f6\u89e3\u6563pcc\u4efb\u52a1\u7fa4\uff1a{}", (Object)message.getBusinessKey());
            if (StringUtils.isNotEmpty((String)message.getBusinessKey())) {
                this.imService.removeTeamByParam("", 2, "", message.getBusinessKey(), user);
            }
            if (CollUtil.isNotEmpty((Collection)(bpmActivityIdIdList = this.backlogMapper.selectByBpmProcessSqlId(message.getBpmProcessId().longValue())))) {
                for (String bpmActivityId : bpmActivityIdIdList) {
                    this.imService.removeTeam(bpmActivityId, 2, user);
                }
            }
            LogDto logDto = new LogDto("\u6d41\u7a0b\u5f15\u64ce\u9879\u76ee\u5361\u7ed3\u675f\u65f6,\u89e3\u6563IM\u9879\u76ee\u7fa4\u6210\u529f\uff0c\u6d41\u7a0bid" + message.getBpmProcessId(), user.getTenantId() + ";" + message.getBpmProcessId());
            log.info(logDto.toString());
        }
        catch (Exception ex) {
            log.warn("\u6d41\u7a0b\u5f15\u64ce\u9879\u76ee\u5361\u7ed3\u675f\u65f6,\u89e3\u6563IM\u9879\u76ee\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), message});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    public void processFlowBacklogGroupMessage(String data, AuthoredUser user) {
        EventFlowBacklogGroupDTO model = (EventFlowBacklogGroupDTO)JsonUtils.jsonToObject((String)data, EventFlowBacklogGroupDTO.class);
        if (PtmMqOperation.CLOSE.equals((Object)model.getOperation())) {
            this.removeFlowBacklogGroup(user, model);
        } else if (PtmMqOperation.ADD.equals((Object)model.getOperation())) {
            this.createFlowBacklogGroup(user, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFlowBacklogGroup(AuthoredUser user, EventFlowBacklogGroupDTO model) {
        log.info("\u3010createFlowBacklogGroup\u3011\uff1a{}", (Object)model);
        try {
            AppAuthContextHolder.clearContext();
            if (model.getNeedCreateTeam().booleanValue()) {
                this.teamMemberService.addBpmActivityTeamMember(user, model.getBpmActivitySqlId(), model.getWorkitemList().stream().map(BpmActivityWorkitem::getPerformerId).collect(Collectors.toList()));
            } else {
                BpmActivity bpmActivity = new BpmActivity();
                bpmActivity.setId(model.getBpmActivitySqlId());
                bpmActivity.setTmActivityName(model.getTmActivityName());
                bpmActivity.setPlanEndTime(model.getPlanEndTime());
                this.teamMemberService.createBpmActivityTeam(bpmActivity, model.getIsBpmActivityStepEmpty(), model.getWorkitemList(), user, model.getRelatedUserList(), model.getIsExternal(), model.getPlan(), model.getTenantSid(), model.getTenantName(), model.getBusinessKey());
            }
        }
        catch (Exception ex) {
            log.warn("\u6d41\u7a0b\u5f15\u64ce\u4efb\u52a1\u5361\u521b\u5efa\u65f6,\u521b\u5efaIM\u9879\u76ee\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), model});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFlowBacklogGroup(AuthoredUser user, EventFlowBacklogGroupDTO model) {
        log.info("\u3010removeFlowBacklogGroup\u3011\uff1a{}", (Object)model);
        try {
            AppAuthContextHolder.clearContext();
            Map teamMap = null;
            if (StringUtils.isNotEmpty((String)model.getBusinessKey())) {
                teamMap = this.imService.getTeamInfo(user, model.getBusinessKey(), ImTeamType.TaskTeam.getValue(), "pcc");
            }
            if (teamMap != null) {
                String cardIds;
                String string = cardIds = teamMap.get("cardIds") != null ? teamMap.get("cardIds").toString() : "";
                if (StringUtils.isNotEmpty((String)cardIds)) {
                    List cardIdsList = Stream.of(cardIds.split(",")).collect(Collectors.toList());
                    String bpmActivityId = String.valueOf(model.getBpmActivitySqlId());
                    cardIdsList.remove(bpmActivityId);
                    String newCardIds = Joiner.on((String)",").join(cardIdsList);
                    String tId = teamMap.get("tId").toString();
                    this.imService.updateTeamInfo(user, tId, newCardIds);
                    LogDto logDto = new LogDto("\u6d41\u7a0b\u5f15\u64ce\u4efb\u52a1\u5361\u7ed3\u675f\u65f6,\u66f4\u65b0IM\u9879\u76ee\u7fa4\u6210\u529f\uff0cbpmActivitySqlId" + model.getBpmActivitySqlId(), user.getTenantId() + ";" + model.getBpmActivitySqlId());
                    log.info(logDto.toString());
                }
            } else {
                this.imService.removeTeam(model.getBpmActivitySqlId().toString(), ImTeamType.TaskTeam.getValue(), user);
                LogDto logDto = new LogDto("\u6d41\u7a0b\u5f15\u64ce\u4efb\u52a1\u5361\u7ed3\u675f\u65f6,\u89e3\u6563IM\u9879\u76ee\u7fa4\u6210\u529f\uff0cbpmActivitySqlId" + model.getBpmActivitySqlId(), user.getTenantId() + ";" + model.getBpmActivitySqlId());
                log.info(logDto.toString());
            }
        }
        catch (Exception ex) {
            log.warn("\u6d41\u7a0b\u5f15\u64ce\u4efb\u52a1\u5361\u7ed3\u675f\u65f6,\u89e3\u6563IM\u9879\u76ee\u7fa4 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), model});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    public void processProjectGroupMessage(String data, AuthoredUser user) {
        PtmProjectMessageDTO message = (PtmProjectMessageDTO)JsonUtils.jsonToObject((String)data, PtmProjectMessageDTO.class);
        PtmProjectDTO projectDTO = message.getData().getProject();
        LogDto logDto = new LogDto("\u5904\u7406\u9879\u76ee\u7fa4\u804a\u6d88\u606f\uff0c\u9879\u76eeid\uff1a" + projectDTO.getId(), user.getTenantId() + projectDTO.getId());
        log.info(logDto.toString());
        PtmProjectGroupDTO model = new PtmProjectGroupDTO();
        model.setAuthoredUser(user);
        model.setOperation(message.getOperation());
        model.setRelatedUsers(message.getData().getRelatedUsers());
        model.setProject(projectDTO);
        this.ptmProjectUpdateImHandler.process(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlowProjectGroupMessage(String data, AuthoredUser user) {
        PtmProjectCardGroupDTO message = (PtmProjectCardGroupDTO)JsonUtils.jsonToObject((String)data, PtmProjectCardGroupDTO.class);
        log.info("\u3010FlowProjectGroup\u3011\uff1a{}", (Object)message);
        try {
            AppAuthContextHolder.clearContext();
            Task task = Task.builder().id(message.getId()).build();
            this.teamMemberService.transferTaskMemeber(user, task, message.getRelatedUsers());
            LogDto logDto = new LogDto("\u6d41\u7a0b\u5f15\u64ce\u9879\u76ee\u6dfb\u52a0\u7fa4\u6210\u5458\u6210\u529f\uff1a" + message.getMainTaskId(), user.getTenantId() + message.getMainTaskId());
            log.info(logDto.toString());
        }
        catch (Exception ex) {
            log.warn("\u6d41\u7a0b\u5f15\u64ce\u9879\u76ee\u6dfb\u52a0\u7fa4\u6210\u5458 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), message});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }
}

